/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import com.microstar.xml.HandlerBase;
import java.io.StringReader;
import java.util.Stack;
import org.gjt.sp.jedit.pluginmgr.PluginList;
import org.gjt.sp.util.Log;

class PluginListHandler
extends HandlerBase {
    private String path;
    private PluginList pluginList;
    private PluginList.PluginSet pluginSet;
    private String pluginSetEntry;
    private PluginList.Plugin plugin;
    private String jar;
    private String author;
    private PluginList.Branch branch;
    private boolean obsolete;
    private String version;
    private String date;
    private String download;
    private int downloadSize;
    private String downloadSource;
    private int downloadSourceSize;
    private int size;
    private String depWhat;
    private String depFrom;
    private String depTo;
    private String depPlugin;
    private String name;
    private String description;
    private Stack stateStack;

    PluginListHandler(PluginList pluginList, String path) {
        this.pluginList = pluginList;
        this.path = path;
        this.stateStack = new Stack();
    }

    public Object resolveEntity(String publicId, String systemId) {
        if ("plugins.dtd".equals(systemId)) {
            return new StringReader("<!-- -->");
        }
        return null;
    }

    public void attribute(String aname, String value, boolean isSpecified) {
        aname = aname == null ? null : aname.intern();
        String string = value = value == null ? null : value.intern();
        if (aname == "NAME") {
            this.name = value;
        } else if (aname == "JAR") {
            this.jar = value;
        } else if (aname == "VERSION") {
            this.version = value;
        } else if (aname == "DATE") {
            this.date = value;
        } else if (aname == "OBSOLETE") {
            this.obsolete = "TRUE".equals(value);
        } else if (aname == "WHAT") {
            this.depWhat = value;
        } else if (aname == "FROM") {
            this.depFrom = value;
        } else if (aname == "TO") {
            this.depTo = value;
        } else if (aname == "PLUGIN") {
            this.depPlugin = value;
        } else if (aname == "SIZE") {
            this.size = Integer.parseInt(value);
            if (this.size == 0) {
                Log.log(7, this, "SIZE = 0");
            }
        }
    }

    public void doctypeDecl(String name, String publicId, String systemId) throws Exception {
        if ("PLUGINS".equals(name)) {
            return;
        }
        Log.log(9, this, this.path + ": DOCTYPE must be PLUGINS");
    }

    public void charData(char[] c, int off, int len) {
        String tag = this.peekElement();
        String text = new String(c, off, len);
        if (tag == "DESCRIPTION") {
            this.description = text;
        } else if (tag == "PLUGIN_SET_ENTRY") {
            this.pluginSetEntry = text;
        } else if (tag == "AUTHOR") {
            this.author = this.author != null && this.author.length() != 0 ? this.author + ", " + text : text;
        } else if (tag == "DOWNLOAD") {
            this.download = text;
        } else if (tag == "DOWNLOAD_SOURCE") {
            this.downloadSource = text;
        }
    }

    public void startElement(String tag) {
        if ((tag = this.pushElement(tag)) == "PLUGIN_SET") {
            this.description = null;
            this.pluginSet = new PluginList.PluginSet();
            this.pluginSet.name = this.name;
        } else if (tag == "PLUGIN") {
            this.description = null;
            this.author = null;
            this.branch = null;
            this.plugin = new PluginList.Plugin();
        } else if (tag == "BRANCH") {
            this.download = null;
            this.branch = new PluginList.Branch();
        } else if (tag == "DOWNLOAD") {
            this.downloadSize = this.size;
        } else if (tag == "DOWNLOAD_SOURCE") {
            this.downloadSourceSize = this.size;
        }
    }

    public void endElement(String tag) {
        if (tag == null) {
            return;
        }
        tag = tag.intern();
        this.popElement();
        if (tag == "PLUGIN_SET") {
            this.pluginList.addPluginSet(this.pluginSet);
            this.pluginSet = null;
            this.pluginSetEntry = null;
        } else if (tag == "PLUGIN_SET_ENTRY") {
            this.pluginSet.plugins.addElement(this.pluginSetEntry);
            this.pluginSetEntry = null;
        } else if (tag == "PLUGIN") {
            this.plugin.jar = this.jar;
            this.plugin.name = this.name;
            this.plugin.author = this.author;
            this.plugin.description = this.description;
            this.pluginList.addPlugin(this.plugin);
            this.jar = null;
            this.name = null;
            this.author = null;
        } else if (tag == "BRANCH") {
            this.branch.version = this.version;
            this.branch.date = this.date;
            this.branch.download = this.download;
            this.branch.downloadSize = this.downloadSize;
            this.branch.downloadSource = this.downloadSource;
            this.branch.downloadSourceSize = this.downloadSourceSize;
            this.branch.obsolete = this.obsolete;
            this.plugin.branches.addElement(this.branch);
            this.version = null;
            this.download = null;
            this.obsolete = false;
        } else if (tag == "DEPEND") {
            PluginList.Dependency dep = new PluginList.Dependency(this.depWhat, this.depFrom, this.depTo, this.depPlugin);
            this.branch.deps.addElement(dep);
            this.depWhat = null;
            this.depFrom = null;
            this.depTo = null;
            this.depPlugin = null;
        }
    }

    public void startDocument() {
        try {
            this.pushElement(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void endDocument() {
        this.pluginList.finished();
    }

    private String pushElement(String name) {
        name = name == null ? null : name.intern();
        this.stateStack.push(name);
        return name;
    }

    private String peekElement() {
        return (String)this.stateStack.peek();
    }

    private String popElement() {
        return (String)this.stateStack.pop();
    }
}

