/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import com.microstar.xml.XmlException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.options.GlobalOptions;
import org.gjt.sp.jedit.options.PluginOptions;
import org.gjt.sp.jedit.pluginmgr.InstallPanel;
import org.gjt.sp.jedit.pluginmgr.ManagePanel;
import org.gjt.sp.jedit.pluginmgr.PluginList;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.WorkRequest;

public class PluginManager
extends JFrame
implements EBComponent {
    private static PluginManager instance;
    private JTabbedPane tabPane;
    private JButton done;
    private JButton mgrOptions;
    private JButton pluginOptions;
    private InstallPanel installer;
    private InstallPanel updater;
    private ManagePanel manager;
    private PluginList pluginList;
    private boolean queuedUpdate;
    private boolean downloadingPluginList;

    public static PluginManager getInstance() {
        return instance;
    }

    public void dispose() {
        GUIUtilities.saveGeometry(this, "plugin-manager");
        instance = null;
        EditBus.removeFromBus(this);
        super.dispose();
    }

    public void handleMessage(EBMessage message) {
        if (message instanceof PropertiesChanged) {
            this.pluginList = null;
            this.updatePluginList();
            if (this.tabPane.getSelectedIndex() != 0) {
                this.installer.updateModel();
                this.updater.updateModel();
            }
        } else if (message instanceof PluginUpdate && !this.queuedUpdate) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PluginManager.this.queuedUpdate = false;
                    PluginManager.this.manager.update();
                }
            });
            this.queuedUpdate = true;
        }
    }

    public static void showPluginManager(Frame frame) {
        if (instance != null) {
            instance.toFront();
            return;
        }
        instance = new PluginManager();
    }

    public void ok() {
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    public PluginList getPluginList() {
        return this.pluginList;
    }

    private PluginManager() {
        super(jEdit.getProperty("plugin-manager.title"));
        EditBus.addToBus(this);
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        this.tabPane = new JTabbedPane();
        this.manager = new ManagePanel(this);
        this.tabPane.addTab(jEdit.getProperty("manage-plugins.title"), this.manager);
        this.updater = new InstallPanel(this, true);
        this.tabPane.addTab(jEdit.getProperty("update-plugins.title"), this.updater);
        this.installer = new InstallPanel(this, false);
        this.tabPane.addTab(jEdit.getProperty("install-plugins.title"), this.installer);
        content.add("Center", this.tabPane);
        this.tabPane.addChangeListener(new ListUpdater());
        Box buttons = new Box(0);
        ActionHandler al = new ActionHandler();
        this.mgrOptions = new JButton(jEdit.getProperty("plugin-manager.mgr-options"));
        this.mgrOptions.addActionListener(al);
        this.pluginOptions = new JButton(jEdit.getProperty("plugin-manager.plugin-options"));
        this.pluginOptions.addActionListener(al);
        this.done = new JButton(jEdit.getProperty("plugin-manager.done"));
        this.done.addActionListener(al);
        buttons.add(Box.createGlue());
        buttons.add(this.mgrOptions);
        buttons.add(Box.createHorizontalStrut(6));
        buttons.add(this.pluginOptions);
        buttons.add(Box.createHorizontalStrut(6));
        buttons.add(this.done);
        buttons.add(Box.createGlue());
        this.getRootPane().setDefaultButton(this.done);
        content.add("South", buttons);
        this.setDefaultCloseOperation(2);
        this.setIconImage(GUIUtilities.getPluginIcon());
        this.pack();
        GUIUtilities.loadGeometry(this, "plugin-manager");
        this.setVisible(true);
    }

    private void updatePluginList() {
        if (jEdit.getSettingsDirectory() == null && jEdit.getJEditHome() == null) {
            GUIUtilities.error(this, "no-settings", null);
            return;
        }
        if (this.pluginList != null || this.downloadingPluginList) {
            return;
        }
        final Exception[] exception = new Exception[1];
        VFSManager.runInWorkThread(new WorkRequest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    PluginManager.this.downloadingPluginList = true;
                    this.setStatus(jEdit.getProperty("plugin-manager.list-download"));
                    PluginManager.this.pluginList = new PluginList();
                }
                catch (Exception e) {
                    exception[0] = e;
                }
                finally {
                    PluginManager.this.downloadingPluginList = false;
                }
            }
        });
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                if (exception[0] instanceof XmlException) {
                    XmlException xe = (XmlException)exception[0];
                    int line = xe.getLine();
                    String path = jEdit.getProperty("plugin-manager.export-url");
                    String message = xe.getMessage();
                    Log.log(9, this, path + ":" + line + ": " + message);
                    Object[] pp = new String[]{path, String.valueOf(line), message};
                    GUIUtilities.error(PluginManager.this, "plugin-list.xmlerror", pp);
                } else if (exception[0] != null) {
                    Exception e = exception[0];
                    Log.log(9, this, e);
                    Object[] pp = new String[]{e.toString()};
                    String ok = jEdit.getProperty("common.ok");
                    String proxyButton = jEdit.getProperty("plugin-list.ioerror.proxy-servers");
                    int retVal = JOptionPane.showOptionDialog(PluginManager.this, jEdit.getProperty("plugin-list.ioerror.message", pp), jEdit.getProperty("plugin-list.ioerror.title"), 0, 0, null, new Object[]{proxyButton, ok}, ok);
                    if (retVal == 0) {
                        new GlobalOptions((Frame)PluginManager.this, "firewall");
                    }
                }
            }
        });
    }

    class ListUpdater
    implements ChangeListener {
        ListUpdater() {
        }

        public void stateChanged(ChangeEvent e) {
            Component selected = PluginManager.this.tabPane.getSelectedComponent();
            if (selected == PluginManager.this.installer || selected == PluginManager.this.updater) {
                PluginManager.this.updatePluginList();
                PluginManager.this.installer.updateModel();
                PluginManager.this.updater.updateModel();
            } else if (selected == PluginManager.this.manager) {
                PluginManager.this.manager.update();
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == PluginManager.this.done) {
                PluginManager.this.ok();
            } else if (source == PluginManager.this.mgrOptions) {
                new GlobalOptions((Frame)PluginManager.this, "plugin-manager");
            } else if (source == PluginManager.this.pluginOptions) {
                new PluginOptions(PluginManager.this);
            }
        }
    }
}

