/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginManagerProgress;
import org.gjt.sp.util.Log;

class Roster {
    private static File downloadDir;
    private List operations = new ArrayList();
    private List toLoad = new ArrayList();

    Roster() {
    }

    void addRemove(String plugin) {
        this.addOperation(new Remove(plugin));
    }

    void addInstall(String installed, String url, String installDirectory, int size) {
        this.addOperation(new Install(installed, url, installDirectory, size));
    }

    public Operation getOperation(int i) {
        return (Operation)this.operations.get(i);
    }

    int getOperationCount() {
        return this.operations.size();
    }

    boolean isEmpty() {
        return this.operations.size() == 0;
    }

    void performOperationsInWorkThread(PluginManagerProgress progress) {
        for (int i = 0; i < this.operations.size(); ++i) {
            Operation op = (Operation)this.operations.get(i);
            op.runInWorkThread(progress);
            progress.done();
            if (!Thread.interrupted()) continue;
            return;
        }
    }

    void performOperationsInAWTThread(Component comp) {
        PluginJAR plugin;
        String pluginName;
        int i;
        for (i = 0; i < this.operations.size(); ++i) {
            Operation op = (Operation)this.operations.get(i);
            op.runInAWTThread(comp);
        }
        for (i = 0; i < this.toLoad.size(); ++i) {
            pluginName = (String)this.toLoad.get(i);
            if (jEdit.getPluginJAR(pluginName) != null) {
                Log.log(7, this, "Already loaded: " + pluginName);
                continue;
            }
            jEdit.addPluginJAR(pluginName);
        }
        for (i = 0; i < this.toLoad.size(); ++i) {
            pluginName = (String)this.toLoad.get(i);
            plugin = jEdit.getPluginJAR(pluginName);
            if (plugin == null) continue;
            plugin.checkDependencies();
        }
        for (i = 0; i < this.toLoad.size(); ++i) {
            pluginName = (String)this.toLoad.get(i);
            plugin = jEdit.getPluginJAR(pluginName);
            if (plugin == null) continue;
            plugin.activatePluginIfNecessary();
        }
    }

    private void addOperation(Operation op) {
        for (int i = 0; i < this.operations.size(); ++i) {
            if (!this.operations.get(i).equals(op)) continue;
            return;
        }
        this.operations.add(op);
    }

    private static String getDownloadDir() {
        if (downloadDir == null) {
            String settings = jEdit.getSettingsDirectory();
            if (settings == null) {
                settings = System.getProperty("user.home");
            }
            downloadDir = new File(MiscUtilities.constructPath(settings, "PluginManager.download"));
            downloadDir.mkdirs();
        }
        return downloadDir.getPath();
    }

    class Install
    extends Operation {
        int size;
        private String installed;
        private String url;
        private String installDirectory;
        private String path;

        Install(String installed, String url, String installDirectory, int size) {
            if (url == null) {
                throw new NullPointerException();
            }
            this.installed = installed;
            this.url = url;
            this.installDirectory = installDirectory;
            this.size = size;
        }

        public int getMaximum() {
            return this.size;
        }

        public void runInWorkThread(PluginManagerProgress progress) {
            String fileName = MiscUtilities.getFileName(this.url);
            this.path = this.download(progress, fileName, this.url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void runInAWTThread(Component comp) {
            block28: {
                if (this.path == null) {
                    return;
                }
                if (this.installed != null) {
                    new Remove(this.installed).runInAWTThread(comp);
                }
                ZipFile zipFile = null;
                zipFile = new ZipFile(this.path);
                Enumeration<? extends ZipEntry> e = zipFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    String name = entry.getName().replace('/', File.separatorChar);
                    File file = new File(this.installDirectory, name);
                    if (entry.isDirectory()) {
                        file.mkdirs();
                        continue;
                    }
                    new File(file.getParent()).mkdirs();
                    this.copy(null, zipFile.getInputStream(entry), new FileOutputStream(file), false);
                    if (!file.getName().toLowerCase().endsWith(".jar")) continue;
                    Roster.this.toLoad.add(file.getPath());
                }
                Object var8_11 = null;
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException io2) {
                    Log.log(9, this, io2);
                }
                if (jEdit.getBooleanProperty("plugin-manager.deleteDownloads")) {
                    new File(this.path).delete();
                }
                break block28;
                {
                    catch (InterruptedIOException iio) {
                        Object var8_12 = null;
                        try {
                            if (zipFile != null) {
                                zipFile.close();
                            }
                        }
                        catch (IOException io2) {
                            Log.log(9, this, io2);
                        }
                        if (jEdit.getBooleanProperty("plugin-manager.deleteDownloads")) {
                            new File(this.path).delete();
                        }
                        break block28;
                    }
                    catch (IOException io) {
                        Log.log(9, this, io);
                        Object[] args = new String[]{io.getMessage()};
                        GUIUtilities.error(null, "ioerror", args);
                        Object var8_13 = null;
                        try {
                            if (zipFile != null) {
                                zipFile.close();
                            }
                        }
                        catch (IOException io2) {
                            Log.log(9, this, io2);
                        }
                        if (jEdit.getBooleanProperty("plugin-manager.deleteDownloads")) {
                            new File(this.path).delete();
                        }
                        break block28;
                    }
                    catch (Exception e2) {
                        Log.log(9, this, e2);
                        Object var8_14 = null;
                        try {
                            if (zipFile != null) {
                                zipFile.close();
                            }
                        }
                        catch (IOException io2) {
                            Log.log(9, this, io2);
                        }
                        if (jEdit.getBooleanProperty("plugin-manager.deleteDownloads")) {
                            new File(this.path).delete();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var8_15 = null;
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                    catch (IOException io2) {
                        Log.log(9, this, io2);
                    }
                    if (jEdit.getBooleanProperty("plugin-manager.deleteDownloads")) {
                        new File(this.path).delete();
                    }
                    throw throwable;
                }
            }
        }

        public boolean equals(Object o) {
            return o instanceof Install && ((Install)o).url.equals(this.url);
        }

        private String download(PluginManagerProgress progress, String fileName, String url) {
            try {
                URLConnection conn = new URL(url).openConnection();
                String path = MiscUtilities.constructPath(Roster.getDownloadDir(), fileName);
                if (!this.copy(progress, conn.getInputStream(), new FileOutputStream(path), true)) {
                    return null;
                }
                return path;
            }
            catch (InterruptedIOException iio) {
                return null;
            }
            catch (IOException io) {
                Log.log(9, this, io);
                SwingUtilities.invokeLater(new Runnable(this, io){
                    private final /* synthetic */ IOException val$io;
                    private final /* synthetic */ Install this$1;
                    {
                        this.this$1 = this$1;
                        this.val$io = val$io;
                    }

                    public void run() {
                        Object[] args = new String[]{this.val$io.getMessage()};
                        GUIUtilities.error(null, "ioerror", args);
                    }
                });
                return null;
            }
            catch (Exception e) {
                Log.log(9, this, e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean copy(PluginManagerProgress progress, InputStream in, OutputStream out, boolean canStop) throws Exception {
            in = new BufferedInputStream(in);
            out = new BufferedOutputStream(out);
            try {
                int count;
                byte[] buf = new byte[4096];
                int copied = 0;
                while ((count = in.read(buf, 0, buf.length)) != -1) {
                    copied += count;
                    if (progress != null) {
                        progress.setValue(copied);
                    }
                    out.write(buf, 0, count);
                    if (!canStop || !Thread.interrupted()) continue;
                    in.close();
                    out.close();
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                in.close();
                out.close();
            }
            return true;
        }
    }

    class Remove
    extends Operation {
        private String plugin;

        Remove(String plugin) {
            this.plugin = plugin;
        }

        public void runInAWTThread(Component comp) {
            PluginJAR jar = jEdit.getPluginJAR(this.plugin);
            if (jar != null) {
                this.unloadPluginJAR(jar);
                String cachePath = jar.getCachePath();
                if (cachePath != null) {
                    new File(cachePath).delete();
                }
            }
            Roster.this.toLoad.remove(this.plugin);
            File jarFile = new File(this.plugin);
            File srcFile = new File(this.plugin.substring(0, this.plugin.length() - 4));
            Log.log(5, this, "Deleting " + jarFile);
            boolean ok = jarFile.delete();
            if (srcFile.exists()) {
                ok &= this.deleteRecursively(srcFile);
            }
            if (!ok) {
                Object[] args = new String[]{this.plugin};
                GUIUtilities.error(comp, "plugin-manager.remove-failed", args);
            }
        }

        private void unloadPluginJAR(PluginJAR jar) {
            String[] dependents = jar.getDependentPlugins();
            for (int i = 0; i < dependents.length; ++i) {
                PluginJAR _jar = jEdit.getPluginJAR(dependents[i]);
                if (_jar == null) continue;
                Roster.this.toLoad.add(dependents[i]);
                this.unloadPluginJAR(_jar);
            }
            jEdit.removePluginJAR(jar, false);
        }

        public boolean equals(Object o) {
            return o instanceof Remove && ((Remove)o).plugin.equals(this.plugin);
        }

        private boolean deleteRecursively(File file) {
            Log.log(5, this, "Deleting " + file + " recursively");
            boolean ok = true;
            if (file.isDirectory()) {
                String path = file.getPath();
                String[] children = file.list();
                for (int i = 0; i < children.length; ++i) {
                    ok &= this.deleteRecursively(new File(path, children[i]));
                }
            }
            return ok &= file.delete();
        }
    }

    static abstract class Operation {
        Operation() {
        }

        public void runInWorkThread(PluginManagerProgress progress) {
        }

        public void runInAWTThread(Component comp) {
        }

        public int getMaximum() {
            return 0;
        }
    }
}

