/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import javax.swing.SwingUtilities;
import javax.swing.text.Segment;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.HyperSearchResult;
import org.gjt.sp.jedit.search.HyperSearchResults;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchFileSet;
import org.gjt.sp.jedit.search.SearchMatcher;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.CharIndexedSegment;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.WorkRequest;
import org.gjt.sp.util.WorkThread;

class HyperSearchRequest
extends WorkRequest {
    private View view;
    private SearchMatcher matcher;
    private HyperSearchResults results;
    private DefaultMutableTreeNode rootSearchNode;
    private Selection[] selection;
    private String searchString;

    public HyperSearchRequest(View view, SearchMatcher matcher, HyperSearchResults results, Selection[] selection) {
        this.view = view;
        this.matcher = matcher;
        this.results = results;
        this.searchString = SearchAndReplace.getSearchString();
        this.rootSearchNode = new DefaultMutableTreeNode(this.searchString);
        this.selection = selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block10: {
            this.setStatus(jEdit.getProperty("hypersearch-status"));
            SearchFileSet fileset = SearchAndReplace.getSearchFileSet();
            String[] files = fileset.getFiles(this.view);
            if (files == null || files.length == 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GUIUtilities.error(HyperSearchRequest.this.view, "empty-fileset", null);
                        HyperSearchRequest.this.results.searchDone(HyperSearchRequest.this.rootSearchNode);
                    }
                });
                return;
            }
            this.setProgressMaximum(fileset.getFileCount(this.view));
            long lastStatusTime = 0L;
            try {
                if (this.selection != null) {
                    Buffer buffer = this.view.getBuffer();
                    this.searchInSelection(buffer);
                    break block10;
                }
                int current = 0;
                for (int i = 0; i < files.length; ++i) {
                    Buffer buffer;
                    String file = files[i];
                    ++current;
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - lastStatusTime > 250L) {
                        this.setProgressValue(current);
                        lastStatusTime = currentTime;
                    }
                    if ((buffer = jEdit.openTemporary(null, null, file, false)) == null) continue;
                    this.doHyperSearch(buffer);
                }
            }
            catch (Exception e) {
                Log.log(9, this, e);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SearchAndReplace.handleError(HyperSearchRequest.this.view, e);
                    }
                });
                VFSManager.runInAWTThread(new Runnable(){

                    public void run() {
                        HyperSearchRequest.this.results.searchDone(HyperSearchRequest.this.rootSearchNode);
                    }
                });
            }
            catch (WorkThread.Abort a) {
                VFSManager.runInAWTThread(new /* invalid duplicate definition of identical inner class */);
                {
                    catch (Throwable throwable) {
                        VFSManager.runInAWTThread(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
            }
        }
        VFSManager.runInAWTThread(new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int searchInSelection(Buffer buffer) throws Exception {
        this.setAbortable(false);
        int resultCount = 0;
        try {
            buffer.readLock();
            for (int i = 0; i < this.selection.length; ++i) {
                Selection s = this.selection[i];
                if (s instanceof Selection.Rect) {
                    for (int j = s.getStartLine(); j <= s.getEndLine(); ++j) {
                        resultCount += this.doHyperSearch(buffer, s.getStart(buffer, j), s.getEnd(buffer, j));
                    }
                    continue;
                }
                resultCount += this.doHyperSearch(buffer, s.getStart(), s.getEnd());
            }
        }
        finally {
            buffer.readUnlock();
        }
        this.setAbortable(true);
        return resultCount;
    }

    private int doHyperSearch(Buffer buffer) throws Exception {
        return this.doHyperSearch(buffer, 0, buffer.getLength());
    }

    private int doHyperSearch(Buffer buffer, int start, int end) throws Exception {
        this.setAbortable(false);
        DefaultMutableTreeNode bufferNode = new DefaultMutableTreeNode(buffer.getPath());
        int resultCount = this.doHyperSearch(buffer, start, end, bufferNode);
        if (resultCount != 0) {
            this.rootSearchNode.insert(bufferNode, this.rootSearchNode.getChildCount());
        }
        this.setAbortable(true);
        return resultCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doHyperSearch(Buffer buffer, int start, int end, DefaultMutableTreeNode bufferNode) {
        int resultCount = 0;
        try {
            buffer.readLock();
            boolean endOfLine = buffer.getLineEndOffset(buffer.getLineOfOffset(end)) - 1 == end;
            Segment text = new Segment();
            int offset = start;
            HyperSearchResult lastResult = null;
            int counter = 0;
            while (true) {
                boolean startOfLine = buffer.getLineStartOffset(buffer.getLineOfOffset(offset)) == offset;
                buffer.getText(offset, end - offset, text);
                SearchMatcher.Match match = this.matcher.nextMatch(new CharIndexedSegment(text, false), startOfLine, endOfLine, counter == 0, false);
                if (match == null) {
                    break;
                }
                int newLine = buffer.getLineOfOffset(offset + match.start);
                if (lastResult == null || lastResult.line != newLine) {
                    lastResult = new HyperSearchResult(buffer, newLine);
                    bufferNode.add(new DefaultMutableTreeNode(lastResult, false));
                }
                lastResult.addOccur(offset + match.start, offset + match.end);
                offset += match.end;
                ++resultCount;
                ++counter;
            }
        }
        finally {
            buffer.readUnlock();
        }
        return resultCount;
    }
}

