/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import javax.swing.text.Position;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;

public class HyperSearchResult {
    public String path;
    public Buffer buffer;
    public int line;
    public String str;
    public Occur occur;
    public int occurCount;

    public Buffer getBuffer() {
        if (this.buffer == null) {
            this.buffer = jEdit.openFile(null, this.path);
        }
        return this.buffer;
    }

    public Selection[] getSelection() {
        if (this.buffer == null) {
            return null;
        }
        Selection[] returnValue = new Selection[this.occurCount];
        Occur o = this.occur;
        int i = 0;
        while (o != null) {
            Selection.Range s = new Selection.Range(o.startPos.getOffset(), o.endPos.getOffset());
            returnValue[i++] = s;
            o = o.next;
        }
        return returnValue;
    }

    public void goTo(final View view) {
        if (this.buffer == null) {
            this.buffer = jEdit.openFile(null, this.path);
        }
        if (this.buffer == null) {
            return;
        }
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                Selection[] s = HyperSearchResult.this.getSelection();
                if (s == null) {
                    return;
                }
                EditPane pane = view.goToBuffer(HyperSearchResult.this.buffer);
                JEditTextArea textArea = pane.getTextArea();
                if (textArea.isMultipleSelectionEnabled()) {
                    textArea.addToSelection(s);
                } else {
                    textArea.setSelection(s);
                }
                textArea.moveCaretPosition(HyperSearchResult.this.occur.endPos.getOffset());
            }
        });
    }

    public String toString() {
        return this.str;
    }

    HyperSearchResult(Buffer buffer, int line) {
        this.path = buffer.getPath();
        if (!buffer.isTemporary()) {
            this.bufferOpened(buffer);
        }
        this.line = line;
        this.str = line + 1 + ": " + buffer.getLineText(line).replace('\t', ' ').trim();
    }

    void bufferOpened(Buffer buffer) {
        this.buffer = buffer;
        Occur o = this.occur;
        while (o != null) {
            o.bufferOpened();
            o = o.next;
        }
    }

    void bufferClosed() {
        this.buffer = null;
        Occur o = this.occur;
        while (o != null) {
            o.bufferClosed();
            o = o.next;
        }
    }

    void addOccur(int start, int end) {
        Occur o = new Occur(start, end);
        o.next = this.occur;
        this.occur = o;
        ++this.occurCount;
    }

    boolean pathEquals(String path) {
        return path.equals(MiscUtilities.resolveSymlinks(this.path));
    }

    public class Occur {
        public int start;
        public int end;
        public Position startPos;
        public Position endPos;
        public Occur next;

        Occur(int start, int end) {
            this.start = start;
            this.end = end;
            if (HyperSearchResult.this.buffer != null && !HyperSearchResult.this.buffer.isTemporary()) {
                this.bufferOpened();
            }
        }

        void bufferOpened() {
            this.startPos = HyperSearchResult.this.buffer.createPosition(Math.min(HyperSearchResult.this.buffer.getLength(), this.start));
            this.endPos = HyperSearchResult.this.buffer.createPosition(Math.min(HyperSearchResult.this.buffer.getLength(), this.end));
        }

        void bufferClosed() {
            this.start = this.startPos.getOffset();
            this.end = this.endPos.getOffset();
            this.endPos = null;
            this.startPos = null;
        }
    }
}

