/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Abbrevs;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.SelectLineRange;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.textarea.ChunkCache;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.Gutter;
import org.gjt.sp.jedit.textarea.ScrollListener;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.StructureMatcher;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.util.Log;

public class JEditTextArea
extends JComponent {
    public Exception trace;
    public static int NO_SCROLL = 0;
    public static int NORMAL_SCROLL = 1;
    public static int ELECTRIC_SCROLL = 2;
    Segment lineSegment;
    MouseHandler mouseHandler;
    ChunkCache chunkCache;
    DisplayManager displayManager;
    boolean bufferChanging;
    int maxHorizontalScrollWidth;
    String wrap;
    boolean hardWrap;
    float tabSize;
    int charWidth;
    int maxLineLen;
    boolean scrollBarsInitialized;
    Vector selection;
    Point returnValue;
    boolean lastLinePartial;
    private static final String CENTER = "center";
    private static final String RIGHT = "right";
    private static final String LEFT = "left";
    private static final String BOTTOM = "bottom";
    private static final String TOP = "top";
    private static Timer caretTimer = new Timer(500, new CaretBlinker());
    private static Timer structureTimer;
    private static JEditTextArea focusedComponent;
    private View view;
    private Gutter gutter;
    private TextAreaPainter painter;
    private JPopupMenu popup;
    private boolean popupEnabled;
    private EventListenerList listenerList;
    private MutableCaretEvent caretEvent;
    private boolean caretBlinks;
    private boolean blink;
    private int physLastLine;
    private int screenLastLine;
    private int visibleLines;
    private int electricScroll;
    private int horizontalOffset;
    private boolean quickCopy;
    private Box verticalBox;
    private JScrollBar vertical;
    private JScrollBar horizontal;
    private Buffer buffer;
    private int caret;
    private int caretLine;
    private int caretScreenLine;
    private List structureMatchers;
    private StructureMatcher.Match match;
    private int magicCaret;
    private boolean multi;
    private boolean overwrite;
    private boolean rectangularSelectionMode;
    private boolean dndEnabled;
    private Method dndCallback;
    private boolean dndInProgress;
    private boolean queuedCaretUpdate;
    private boolean queuedScrollToElectric;
    private boolean queuedFireCaretEvent;
    static /* synthetic */ Class class$org$gjt$sp$jedit$textarea$ScrollListener;
    static /* synthetic */ Class class$javax$swing$event$CaretListener;

    public JEditTextArea(View view) {
        this.enableEvents(12L);
        this.view = view;
        this.selection = new Vector();
        this.chunkCache = new ChunkCache(this);
        this.painter = new TextAreaPainter(this);
        this.gutter = new Gutter(view, this);
        this.listenerList = new EventListenerList();
        this.caretEvent = new MutableCaretEvent();
        this.blink = true;
        this.lineSegment = new Segment();
        this.returnValue = new Point();
        this.structureMatchers = new LinkedList();
        this.structureMatchers.add(new StructureMatcher.BracketMatcher());
        this.setLayout(new ScrollLayout());
        this.add(CENTER, this.painter);
        this.add(LEFT, this.gutter);
        this.verticalBox = new Box(0);
        this.vertical = new JScrollBar(1);
        this.verticalBox.add(this.vertical);
        this.vertical.setRequestFocusEnabled(false);
        this.add(RIGHT, this.verticalBox);
        this.horizontal = new JScrollBar(0);
        this.add(BOTTOM, this.horizontal);
        this.horizontal.setRequestFocusEnabled(false);
        this.horizontal.setValues(0, 0, 0, 0);
        if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
            this.setBorder(new TextAreaBorder());
            this.vertical.putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
            this.horizontal.putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        }
        this.vertical.addAdjustmentListener(new AdjustHandler());
        this.horizontal.addAdjustmentListener(new AdjustHandler());
        this.mouseHandler = new MouseHandler();
        this.painter.addMouseListener(this.mouseHandler);
        this.painter.addMouseMotionListener(this.mouseHandler);
        this.addFocusListener(new FocusHandler());
        focusedComponent = this;
        this.popupEnabled = true;
    }

    public void dispose() {
        DisplayManager.textAreaDisposed(this);
    }

    public View getView() {
        return this.view;
    }

    public final TextAreaPainter getPainter() {
        return this.painter;
    }

    public final Gutter getGutter() {
        return this.gutter;
    }

    public DisplayManager getDisplayManager() {
        return this.displayManager;
    }

    public final boolean isCaretBlinkEnabled() {
        return this.caretBlinks;
    }

    public void setCaretBlinkEnabled(boolean caretBlinks) {
        this.caretBlinks = caretBlinks;
        if (!caretBlinks) {
            this.blink = false;
        }
        if (this.buffer != null) {
            this.invalidateLine(this.caretLine);
        }
    }

    public final int getElectricScroll() {
        return this.electricScroll;
    }

    public final void setElectricScroll(int electricScroll) {
        this.electricScroll = electricScroll;
    }

    public final boolean isQuickCopyEnabled() {
        return this.quickCopy;
    }

    public final void setQuickCopyEnabled(boolean quickCopy) {
        this.quickCopy = quickCopy;
    }

    public final Buffer getBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBuffer(Buffer buffer) {
        if (this.buffer == buffer) {
            return;
        }
        try {
            this.bufferChanging = true;
            if (this.buffer != null) {
                this.selectNone();
                this.caretScreenLine = 0;
                this.caret = 0;
                this.caretLine = 0;
                this.match = null;
            }
            this.buffer = buffer;
            this.chunkCache.setBuffer(buffer);
            this.propertiesChanged();
            if (this.displayManager != null) {
                DisplayManager.releaseDisplayManager(this.displayManager);
            }
            this.displayManager = DisplayManager.getDisplayManager(buffer, this);
            this.displayManager.init();
            if (!buffer.isLoaded()) {
                this.updateScrollBars();
            }
            this.repaint();
            this.fireScrollEvent(true);
        }
        finally {
            this.bufferChanging = false;
        }
    }

    public final boolean isEditable() {
        return this.buffer.isEditable();
    }

    public Method getDragAndDropCallback() {
        return this.dndCallback;
    }

    public void setDragAndDropCallback(Method meth) {
        this.dndCallback = meth;
    }

    public boolean isDragInProgress() {
        return this.dndInProgress;
    }

    public void setDragInProgress(boolean dndInProgress) {
        this.dndInProgress = dndInProgress;
    }

    public boolean isDragEnabled() {
        return this.dndEnabled;
    }

    public void setDragEnabled(boolean dndEnabled) {
        this.dndEnabled = dndEnabled;
    }

    public final int getFirstLine() {
        return this.displayManager.firstLine.scrollLine + this.displayManager.firstLine.skew;
    }

    public void setFirstLine(int firstLine) {
        int oldFirstLine;
        int max;
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "setFirstLine() from " + this.getFirstLine() + " to " + firstLine);
        }
        if (firstLine > (max = this.displayManager.getScrollLineCount() - this.visibleLines + (this.lastLinePartial ? 1 : 0))) {
            firstLine = max;
        }
        if (firstLine < 0) {
            firstLine = 0;
        }
        if (firstLine == (oldFirstLine = this.getFirstLine())) {
            return;
        }
        this.trace = new Exception();
        if (firstLine >= oldFirstLine + this.visibleLines) {
            this.displayManager.firstLine.scrollDown(firstLine - oldFirstLine);
            this.chunkCache.invalidateAll();
        } else if (firstLine <= oldFirstLine - this.visibleLines) {
            this.displayManager.firstLine.scrollUp(oldFirstLine - firstLine);
            this.chunkCache.invalidateAll();
        } else if (firstLine > oldFirstLine) {
            this.displayManager.firstLine.scrollDown(firstLine - oldFirstLine);
            this.chunkCache.scrollDown(firstLine - oldFirstLine);
        } else if (firstLine < oldFirstLine) {
            this.displayManager.firstLine.scrollUp(oldFirstLine - firstLine);
            this.chunkCache.scrollUp(oldFirstLine - firstLine);
        }
        this.displayManager._notifyScreenLineChanges();
        this.repaint();
        this.fireScrollEvent(true);
    }

    public final int getFirstPhysicalLine() {
        return this.displayManager.firstLine.physicalLine;
    }

    public void setFirstPhysicalLine(int physFirstLine) {
        this.setFirstPhysicalLine(physFirstLine, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFirstPhysicalLine(int physFirstLine, int skew) {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "setFirstPhysicalLine(" + physFirstLine + "," + skew + ")");
        }
        int amount = physFirstLine - this.displayManager.firstLine.physicalLine;
        int oldFirstLine = this.getFirstLine();
        if (amount == 0) {
            if ((skew -= this.displayManager.firstLine.skew) < 0) {
                this.displayManager.firstLine.scrollUp(-skew);
            } else {
                if (skew <= 0) return;
                this.displayManager.firstLine.scrollDown(skew);
            }
        } else if (amount > 0) {
            this.displayManager.firstLine.physDown(amount, skew);
        } else if (amount < 0) {
            this.displayManager.firstLine.physUp(-amount, skew);
        }
        int firstLine = this.getFirstLine();
        if (firstLine != oldFirstLine) {
            if (firstLine >= oldFirstLine + this.visibleLines || firstLine <= oldFirstLine - this.visibleLines) {
                this.chunkCache.invalidateAll();
            } else if (firstLine > oldFirstLine) {
                this.chunkCache.scrollDown(firstLine - oldFirstLine);
            } else if (firstLine < oldFirstLine) {
                this.chunkCache.scrollUp(oldFirstLine - firstLine);
            }
        }
        this.displayManager._notifyScreenLineChanges();
        this.repaint();
        this.fireScrollEvent(true);
    }

    public final int getLastPhysicalLine() {
        return this.physLastLine;
    }

    public final int getVisibleLines() {
        return this.visibleLines;
    }

    public final int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public void setHorizontalOffset(int horizontalOffset) {
        if (horizontalOffset > 0) {
            horizontalOffset = 0;
        }
        if (horizontalOffset == this.horizontalOffset) {
            return;
        }
        this.horizontalOffset = horizontalOffset;
        if (horizontalOffset != this.horizontal.getValue()) {
            this.updateScrollBars();
        }
        this.painter.repaint();
        this.fireScrollEvent(false);
    }

    public void scrollUpLine() {
        this.setFirstLine(this.getFirstLine() - 1);
    }

    public void scrollUpPage() {
        this.setFirstLine(this.getFirstLine() - this.getVisibleLines() + (this.lastLinePartial ? 1 : 0));
    }

    public void scrollDownLine() {
        this.setFirstLine(this.getFirstLine() + 1);
    }

    public void scrollDownPage() {
        this.setFirstLine(this.getFirstLine() + this.getVisibleLines() - (this.lastLinePartial ? 1 : 0));
    }

    public void scrollToCaret(boolean doElectricScroll) {
        this.scrollTo(this.caretLine, this.caret - this.buffer.getLineStartOffset(this.caretLine), doElectricScroll);
    }

    public void scrollTo(int offset, boolean doElectricScroll) {
        int line = this.buffer.getLineOfOffset(offset);
        this.scrollTo(line, offset - this.buffer.getLineStartOffset(line), doElectricScroll);
    }

    public void scrollTo(int line, int offset, boolean doElectricScroll) {
        int _electricScroll;
        int extraEndVirt;
        int lineLength;
        if (Debug.SCROLL_TO_DEBUG) {
            Log.log(1, this, "scrollTo(), lineCount=" + this.getLineCount());
        }
        if (offset > (lineLength = this.buffer.getLineLength(line))) {
            extraEndVirt = this.charWidth * (offset - lineLength);
            offset = lineLength;
        } else {
            extraEndVirt = 0;
        }
        int n = _electricScroll = doElectricScroll && this.visibleLines - 1 > this.electricScroll * 2 ? this.electricScroll : 0;
        if (this.visibleLines <= 1) {
            if (Debug.SCROLL_TO_DEBUG) {
                Log.log(1, this, "visibleLines <= 0");
            }
            this.setFirstPhysicalLine(line, _electricScroll);
            return;
        }
        int screenLine = this.chunkCache.getScreenLineOfOffset(line, offset);
        int visibleLines = this.getVisibleLines();
        if (screenLine == -1) {
            if (Debug.SCROLL_TO_DEBUG) {
                Log.log(1, this, "screenLine == -1");
            }
            ChunkCache.LineInfo[] infos = this.chunkCache.getLineInfosForPhysicalLine(line);
            int subregion = this.chunkCache.getSubregionOfOffset(offset, infos);
            int prevLine = this.displayManager.getPrevVisibleLine(this.getFirstPhysicalLine());
            int nextLine = this.displayManager.getNextVisibleLine(this.getLastPhysicalLine());
            if (line == this.getFirstPhysicalLine()) {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, line + " == " + this.getFirstPhysicalLine());
                }
                this.setFirstPhysicalLine(line, subregion - _electricScroll);
            } else if (line == prevLine) {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, line + " == " + prevLine);
                }
                this.setFirstPhysicalLine(prevLine, subregion - _electricScroll);
            } else if (line == this.getLastPhysicalLine()) {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, line + " == " + this.getLastPhysicalLine());
                }
                this.setFirstPhysicalLine(line, subregion + _electricScroll - visibleLines + (this.lastLinePartial ? 2 : 1));
            } else if (line == nextLine) {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, line + " == " + nextLine);
                }
                this.setFirstPhysicalLine(nextLine, subregion + this.electricScroll - visibleLines + (this.lastLinePartial ? 2 : 1));
            } else {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, "neither");
                    Log.log(1, this, "Last physical line is " + this.getLastPhysicalLine());
                }
                this.setFirstPhysicalLine(line, subregion - visibleLines / 2);
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, "Last physical line is " + this.getLastPhysicalLine());
                }
            }
        } else if (screenLine < _electricScroll) {
            if (Debug.SCROLL_TO_DEBUG) {
                Log.log(1, this, "electric up");
            }
            this.setFirstLine(this.getFirstLine() - _electricScroll + screenLine);
        } else if (screenLine > visibleLines - _electricScroll - (this.lastLinePartial ? 2 : 1)) {
            if (Debug.SCROLL_TO_DEBUG) {
                Log.log(1, this, "electric down");
            }
            this.setFirstLine(this.getFirstLine() + _electricScroll - visibleLines + screenLine + (this.lastLinePartial ? 2 : 1));
        }
        if (!this.displayManager.isLineVisible(line)) {
            return;
        }
        Point point = this.offsetToXY(line, offset, this.returnValue);
        if (point == null) {
            Log.log(9, this, "BUG: screenLine=" + screenLine + ",visibleLines=" + visibleLines + ",physicalLine=" + line + ",firstPhysicalLine=" + this.getFirstPhysicalLine() + ",lastPhysicalLine=" + this.getLastPhysicalLine());
        }
        point.x += extraEndVirt;
        if (point.x < 0) {
            this.setHorizontalOffset(this.horizontalOffset - point.x + this.charWidth + 5);
        } else if (point.x >= this.painter.getWidth() - this.charWidth - 5) {
            this.setHorizontalOffset(this.horizontalOffset + (this.painter.getWidth() - point.x) - this.charWidth - 5);
        }
    }

    public final void addScrollListener(ScrollListener listener) {
        this.listenerList.add(class$org$gjt$sp$jedit$textarea$ScrollListener == null ? (class$org$gjt$sp$jedit$textarea$ScrollListener = JEditTextArea.class$("org.gjt.sp.jedit.textarea.ScrollListener")) : class$org$gjt$sp$jedit$textarea$ScrollListener, listener);
    }

    public final void removeScrollListener(ScrollListener listener) {
        this.listenerList.remove(class$org$gjt$sp$jedit$textarea$ScrollListener == null ? (class$org$gjt$sp$jedit$textarea$ScrollListener = JEditTextArea.class$("org.gjt.sp.jedit.textarea.ScrollListener")) : class$org$gjt$sp$jedit$textarea$ScrollListener, listener);
    }

    public int getPhysicalLineOfScreenLine(int screenLine) {
        return this.chunkCache.getLineInfo((int)screenLine).physicalLine;
    }

    public int getScreenLineOfOffset(int offset) {
        int line = this.buffer.getLineOfOffset(offset);
        return this.chunkCache.getScreenLineOfOffset(line, offset -= this.buffer.getLineStartOffset(line));
    }

    public int getScreenLineStartOffset(int line) {
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(line);
        if (lineInfo.physicalLine == -1) {
            return -1;
        }
        return this.buffer.getLineStartOffset(lineInfo.physicalLine) + lineInfo.offset;
    }

    public int getScreenLineEndOffset(int line) {
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(line);
        if (lineInfo.physicalLine == -1) {
            return -1;
        }
        return this.buffer.getLineStartOffset(lineInfo.physicalLine) + lineInfo.offset + lineInfo.length;
    }

    public int xyToOffset(int x, int y) {
        return this.xyToOffset(x, y, true);
    }

    public int xyToOffset(int x, int y, boolean round) {
        FontMetrics fm = this.painter.getFontMetrics();
        int height = fm.getHeight();
        int line = y / height;
        if (line < 0 || line >= this.visibleLines) {
            return -1;
        }
        return this.xToScreenLineOffset(line, x, round);
    }

    public int xToScreenLineOffset(int screenLine, int x, boolean round) {
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(screenLine);
        if (lineInfo.physicalLine == -1) {
            return this.getLineEndOffset(this.displayManager.getLastVisibleLine()) - 1;
        }
        int offset = Chunk.xToOffset(lineInfo.chunks, x - this.horizontalOffset, round);
        if (offset == -1 || offset == lineInfo.offset + lineInfo.length) {
            offset = lineInfo.offset + lineInfo.length - 1;
        }
        return this.getLineStartOffset(lineInfo.physicalLine) + offset;
    }

    public Point offsetToXY(int offset) {
        int line = this.buffer.getLineOfOffset(offset);
        Point retVal = new Point();
        return this.offsetToXY(line, offset -= this.buffer.getLineStartOffset(line), retVal);
    }

    public Point offsetToXY(int line, int offset, Point retVal) {
        if (!this.displayManager.isLineVisible(line)) {
            return null;
        }
        int screenLine = this.chunkCache.getScreenLineOfOffset(line, offset);
        if (screenLine == -1) {
            return null;
        }
        FontMetrics fm = this.painter.getFontMetrics();
        retVal.y = screenLine * fm.getHeight();
        ChunkCache.LineInfo info = this.chunkCache.getLineInfo(screenLine);
        retVal.x = (int)((float)this.horizontalOffset + Chunk.offsetToX(info.chunks, offset));
        return retVal;
    }

    public void invalidateScreenLineRange(int start, int end) {
        if (!this.buffer.isLoaded()) {
            return;
        }
        if (start > end) {
            int tmp = end;
            end = start;
            start = tmp;
        }
        if (this.chunkCache.needFullRepaint()) {
            end = this.visibleLines;
        }
        FontMetrics fm = this.painter.getFontMetrics();
        int y = start * fm.getHeight();
        int height = (end - start + 1) * fm.getHeight();
        this.painter.repaint(0, y, this.painter.getWidth(), height);
        this.gutter.repaint(0, y, this.gutter.getWidth(), height);
    }

    public void invalidateLine(int line) {
        if (!(this.isShowing() && this.buffer.isLoaded() && line >= this.getFirstPhysicalLine() && line <= this.physLastLine && this.displayManager.isLineVisible(line))) {
            return;
        }
        int startLine = -1;
        int endLine = -1;
        for (int i = 0; i < this.visibleLines; ++i) {
            ChunkCache.LineInfo info = this.chunkCache.getLineInfo(i);
            if ((info.physicalLine >= line || info.physicalLine == -1) && startLine == -1) {
                startLine = i;
            }
            if ((info.physicalLine < line || !info.lastSubregion) && info.physicalLine != -1) continue;
            endLine = i;
            break;
        }
        if (this.chunkCache.needFullRepaint() || endLine == -1) {
            endLine = this.visibleLines;
        }
        this.invalidateScreenLineRange(startLine, endLine);
    }

    public void invalidateLineRange(int start, int end) {
        if (!this.isShowing() || !this.buffer.isLoaded()) {
            return;
        }
        if (end < start) {
            int tmp = end;
            end = start;
            start = tmp;
        }
        if (end < this.getFirstPhysicalLine() || start > this.getLastPhysicalLine()) {
            return;
        }
        int startScreenLine = -1;
        int endScreenLine = -1;
        for (int i = 0; i < this.visibleLines; ++i) {
            ChunkCache.LineInfo info = this.chunkCache.getLineInfo(i);
            if ((info.physicalLine >= start || info.physicalLine == -1) && startScreenLine == -1) {
                startScreenLine = i;
            }
            if ((info.physicalLine < end || !info.lastSubregion) && info.physicalLine != -1) continue;
            endScreenLine = i;
            break;
        }
        if (startScreenLine == -1) {
            startScreenLine = 0;
        }
        if (this.chunkCache.needFullRepaint() || endScreenLine == -1) {
            endScreenLine = this.visibleLines;
        }
        this.invalidateScreenLineRange(startScreenLine, endScreenLine);
    }

    public void invalidateSelectedLines() {
        this.invalidateLine(this.caretLine);
        for (int i = 0; i < this.selection.size(); ++i) {
            Selection s = (Selection)this.selection.elementAt(i);
            this.invalidateLineRange(s.startLine, s.endLine);
        }
    }

    public final int getBufferLength() {
        return this.buffer.getLength();
    }

    public final int getLineCount() {
        return this.buffer.getLineCount();
    }

    public final int getLineOfOffset(int offset) {
        return this.buffer.getLineOfOffset(offset);
    }

    public int getLineStartOffset(int line) {
        return this.buffer.getLineStartOffset(line);
    }

    public int getLineEndOffset(int line) {
        return this.buffer.getLineEndOffset(line);
    }

    public int getLineLength(int line) {
        return this.buffer.getLineLength(line);
    }

    public final String getText(int start, int len) {
        return this.buffer.getText(start, len);
    }

    public final void getText(int start, int len, Segment segment) {
        this.buffer.getText(start, len, segment);
    }

    public final String getLineText(int lineIndex) {
        return this.buffer.getLineText(lineIndex);
    }

    public final void getLineText(int lineIndex, Segment segment) {
        this.buffer.getLineText(lineIndex, segment);
    }

    public String getText() {
        return this.buffer.getText(0, this.buffer.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text) {
        try {
            this.buffer.beginCompoundEdit();
            this.buffer.remove(0, this.buffer.getLength());
            this.buffer.insert(0, text);
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    public final void selectAll() {
        this.setSelection(new Selection.Range(0, this.buffer.getLength()));
        this.moveCaretPosition(this.buffer.getLength(), true);
    }

    public void selectLine() {
        int caretLine = this.getCaretLine();
        int start = this.getLineStartOffset(caretLine);
        int end = this.getLineEndOffset(caretLine) - 1;
        Selection.Range s = new Selection.Range(start, end);
        if (this.multi) {
            this.addToSelection(s);
        } else {
            this.setSelection(s);
        }
        this.moveCaretPosition(end);
    }

    public void selectParagraph() {
        int start;
        int caretLine = this.getCaretLine();
        if (this.getLineLength(caretLine) == 0) {
            this.getToolkit().beep();
            return;
        }
        int end = caretLine;
        for (start = caretLine; start >= 0 && this.getLineLength(start) != 0; --start) {
        }
        while (end < this.getLineCount() && this.getLineLength(end) != 0) {
            ++end;
        }
        int selectionStart = this.getLineStartOffset(start + 1);
        int selectionEnd = this.getLineEndOffset(end - 1) - 1;
        Selection.Range s = new Selection.Range(selectionStart, selectionEnd);
        if (this.multi) {
            this.addToSelection(s);
        } else {
            this.setSelection(s);
        }
        this.moveCaretPosition(selectionEnd);
    }

    public void selectWord() {
        int line = this.getCaretLine();
        int lineStart = this.getLineStartOffset(line);
        int offset = this.getCaretPosition() - lineStart;
        if (this.getLineLength(line) == 0) {
            return;
        }
        String lineText = this.getLineText(line);
        String noWordSep = this.buffer.getStringProperty("noWordSep");
        if (offset == this.getLineLength(line)) {
            --offset;
        }
        int wordStart = TextUtilities.findWordStart(lineText, offset, noWordSep);
        int wordEnd = TextUtilities.findWordEnd(lineText, offset + 1, noWordSep);
        Selection.Range s = new Selection.Range(lineStart + wordStart, lineStart + wordEnd);
        if (this.multi) {
            this.addToSelection(s);
        } else {
            this.setSelection(s);
        }
        this.moveCaretPosition(lineStart + wordEnd);
    }

    public Selection selectToMatchingBracket(int position, boolean quickCopy) {
        int bracket;
        int positionLine = this.buffer.getLineOfOffset(position);
        int lineOffset = position - this.buffer.getLineStartOffset(positionLine);
        if (this.getLineLength(positionLine) != 0 && (bracket = TextUtilities.findMatchingBracket(this.buffer, positionLine, Math.max(0, lineOffset - 1))) != -1) {
            Selection.Range s;
            if (bracket < position) {
                if (!quickCopy) {
                    this.moveCaretPosition(position, false);
                }
                s = new Selection.Range(bracket, position);
            } else {
                if (!quickCopy) {
                    this.moveCaretPosition(bracket + 1, false);
                }
                s = new Selection.Range(position - 1, bracket + 1);
            }
            if (!this.multi && !quickCopy) {
                this.selectNone();
            }
            this.addToSelection(s);
            return s;
        }
        return null;
    }

    public void selectToMatchingBracket() {
        this.selectToMatchingBracket(this.caret, false);
    }

    public void selectBlock() {
        char c;
        int start;
        int end;
        String openBrackets = "([{";
        String closeBrackets = ")]}";
        Selection s = this.getSelectionAtOffset(this.caret);
        if (s == null) {
            start = end = this.caret;
        } else {
            start = s.start;
            end = s.end;
        }
        String text = this.getText(0, this.buffer.getLength());
        int count = 1;
        char openBracket = '\u0000';
        char closeBracket = '\u0000';
        if (start == 0) {
            this.getToolkit().beep();
            return;
        }
        while (--start > 0) {
            c = text.charAt(start);
            int index = openBrackets.indexOf(c);
            if (index != -1) {
                if (--count != 0) continue;
                openBracket = c;
                closeBracket = closeBrackets.charAt(index);
                break;
            }
            if (closeBrackets.indexOf(c) == -1) continue;
            ++count;
        }
        count = 1;
        if (openBracket == '\u0000') {
            this.getToolkit().beep();
            return;
        }
        do {
            if ((c = text.charAt(end)) == closeBracket) {
                if (--count != 0) continue;
                ++end;
                break;
            }
            if (c != openBracket) continue;
            ++count;
        } while (++end < this.buffer.getLength());
        s = new Selection.Range(start, end);
        if (this.multi) {
            this.addToSelection(s);
        } else {
            this.setSelection(s);
        }
        this.moveCaretPosition(end);
    }

    public boolean lineInStructureScope(int line) {
        if (this.match == null) {
            return false;
        }
        if (this.match.startLine < this.caretLine) {
            return line >= this.match.startLine && line <= this.caretLine;
        }
        return line <= this.match.endLine && line >= this.caretLine;
    }

    public final void invertSelection() {
        Selection[] newSelection = new Selection[this.selection.size() + 1];
        int lastOffset = 0;
        for (int i = 0; i < this.selection.size(); ++i) {
            Selection s = (Selection)this.selection.elementAt(i);
            newSelection[i] = new Selection.Range(lastOffset, s.getStart());
            lastOffset = s.getEnd();
        }
        newSelection[this.selection.size()] = new Selection.Range(lastOffset, this.buffer.getLength());
        this.setSelection(newSelection);
    }

    public int getSelectionCount() {
        return this.selection.size();
    }

    public Selection[] getSelection() {
        Object[] sel = new Selection[this.selection.size()];
        this.selection.copyInto(sel);
        return sel;
    }

    public void selectNone() {
        this.setSelection((Selection)null);
    }

    public void setSelection(Selection[] selection) {
        this.invalidateSelectedLines();
        this.selection.removeAllElements();
        if (selection != null) {
            for (int i = 0; i < selection.length; ++i) {
                this._addToSelection(selection[i]);
            }
        }
        this.fireCaretEvent();
    }

    public void setSelection(Selection selection) {
        this.invalidateSelectedLines();
        this.selection.removeAllElements();
        if (selection != null) {
            this._addToSelection(selection);
        }
        this.fireCaretEvent();
    }

    public void addToSelection(Selection[] selection) {
        if (selection != null) {
            for (int i = 0; i < selection.length; ++i) {
                this._addToSelection(selection[i]);
            }
        }
        this.invalidateLine(this.caretLine);
        this.fireCaretEvent();
    }

    public void addToSelection(Selection selection) {
        this._addToSelection(selection);
        this.invalidateLine(this.caretLine);
        this.fireCaretEvent();
    }

    public Selection getSelectionAtOffset(int offset) {
        if (this.selection != null) {
            for (int i = 0; i < this.selection.size(); ++i) {
                Selection s = (Selection)this.selection.elementAt(i);
                if (offset < s.start || offset > s.end) continue;
                return s;
            }
        }
        return null;
    }

    public void removeFromSelection(Selection sel) {
        this.selection.removeElement(sel);
        this.invalidateLineRange(sel.startLine, sel.endLine);
        this.invalidateLine(this.caretLine);
        this.fireCaretEvent();
    }

    public void removeFromSelection(int offset) {
        Selection sel = this.getSelectionAtOffset(offset);
        if (sel == null) {
            return;
        }
        this.selection.removeElement(sel);
        this.invalidateLineRange(sel.startLine, sel.endLine);
        this.invalidateLine(this.caretLine);
        this.fireCaretEvent();
    }

    public void resizeSelection(int offset, int end, int extraEndVirt, boolean rect) {
        Selection newSel;
        Selection s = this.getSelectionAtOffset(offset);
        if (s != null) {
            this.invalidateLineRange(s.startLine, s.endLine);
            this.selection.removeElement(s);
        }
        boolean reversed = false;
        if (end < offset) {
            int tmp = offset;
            offset = end;
            end = tmp;
            reversed = true;
        }
        if (rect) {
            Selection.Rect rectSel = new Selection.Rect(offset, end);
            if (reversed) {
                rectSel.extraStartVirt = extraEndVirt;
            } else {
                rectSel.extraEndVirt = extraEndVirt;
            }
            newSel = rectSel;
        } else {
            newSel = new Selection.Range(offset, end);
        }
        this._addToSelection(newSel);
        this.fireCaretEvent();
    }

    public void extendSelection(int offset, int end) {
        this.extendSelection(offset, end, 0, 0);
    }

    public void extendSelection(int offset, int end, int extraStartVirt, int extraEndVirt) {
        Selection s = this.getSelectionAtOffset(offset);
        if (s != null) {
            this.invalidateLineRange(s.startLine, s.endLine);
            this.selection.removeElement(s);
            if (offset == s.start) {
                offset = end;
                end = s.end;
            } else if (offset == s.end) {
                offset = s.start;
            }
        }
        if (end < offset) {
            int tmp = end;
            end = offset;
            offset = tmp;
        }
        if (this.rectangularSelectionMode) {
            s = new Selection.Rect(offset, end);
            ((Selection.Rect)s).extraStartVirt = extraStartVirt;
            ((Selection.Rect)s).extraEndVirt = extraEndVirt;
        } else {
            s = new Selection.Range(offset, end);
        }
        this._addToSelection(s);
        this.fireCaretEvent();
        if (this.rectangularSelectionMode && extraEndVirt != 0) {
            int line = this.getLineOfOffset(end);
            this.scrollTo(line, this.getLineLength(line) + extraEndVirt, false);
        }
    }

    public String getSelectedText(Selection s) {
        StringBuffer buf = new StringBuffer();
        s.getText(this.buffer, buf);
        return buf.toString();
    }

    public String getSelectedText(String separator) {
        if (this.selection.size() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.selection.size(); ++i) {
            if (i != 0) {
                buf.append(separator);
            }
            ((Selection)this.selection.elementAt(i)).getText(this.buffer, buf);
        }
        return buf.toString();
    }

    public String getSelectedText() {
        return this.getSelectedText("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedText(Selection s, String selectedText) {
        if (!this.isEditable()) {
            throw new InternalError("Text component read only");
        }
        try {
            this.buffer.beginCompoundEdit();
            this.moveCaretPosition(s.setText(this.buffer, selectedText));
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    public void setSelectedText(String selectedText) {
        this.setSelectedText(selectedText, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedText(String selectedText, boolean moveCaret) {
        if (!this.isEditable()) {
            throw new InternalError("Text component read only");
        }
        Selection[] selection = this.getSelection();
        if (selection.length == 0) {
            this.buffer.insert(this.caret, selectedText);
        } else {
            try {
                int newCaret = -1;
                this.buffer.beginCompoundEdit();
                for (int i = 0; i < selection.length; ++i) {
                    newCaret = selection[i].setText(this.buffer, selectedText);
                }
                if (moveCaret) {
                    this.moveCaretPosition(newCaret);
                }
            }
            finally {
                this.buffer.endCompoundEdit();
            }
        }
        this.selectNone();
    }

    public int[] getSelectedLines() {
        Integer line;
        if (this.selection.size() == 0) {
            return new int[]{this.caretLine};
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < this.selection.size(); ++i) {
            Selection s = (Selection)this.selection.elementAt(i);
            int endLine = s.end == this.getLineStartOffset(s.endLine) ? s.endLine - 1 : s.endLine;
            for (int j = s.startLine; j <= endLine; ++j) {
                line = new Integer(j);
                set.add(line);
            }
        }
        int[] returnValue = new int[set.size()];
        int i = 0;
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            line = (Integer)iter.next();
            returnValue[i++] = line;
        }
        return returnValue;
    }

    public void showSelectLineRangeDialog() {
        new SelectLineRange(this.view);
    }

    public void addStructureMatcher(StructureMatcher matcher) {
        this.structureMatchers.add(matcher);
    }

    public void removeStructureMatcher(StructureMatcher matcher) {
        this.structureMatchers.remove(matcher);
    }

    public StructureMatcher.Match getStructureMatch() {
        return this.match;
    }

    public final void blinkCaret() {
        if (this.caretBlinks) {
            this.blink = !this.blink;
            this.invalidateLine(this.caretLine);
        } else {
            this.blink = true;
        }
    }

    public void centerCaret() {
        int offset = this.getScreenLineStartOffset(this.visibleLines / 2);
        if (offset == -1) {
            this.getToolkit().beep();
        } else {
            this.setCaretPosition(offset);
        }
    }

    public void setCaretPosition(int newCaret) {
        this.invalidateSelectedLines();
        this.selection.removeAllElements();
        this.moveCaretPosition(newCaret, true);
    }

    public void setCaretPosition(int newCaret, boolean doElectricScroll) {
        this.invalidateSelectedLines();
        this.selection.removeAllElements();
        this.moveCaretPosition(newCaret, doElectricScroll);
    }

    public void moveCaretPosition(int newCaret) {
        this.moveCaretPosition(newCaret, true);
    }

    public void moveCaretPosition(int newCaret, boolean doElectricScroll) {
        this.moveCaretPosition(newCaret, doElectricScroll ? ELECTRIC_SCROLL : NORMAL_SCROLL);
    }

    public void moveCaretPosition(int newCaret, int scrollMode) {
        if (newCaret < 0 || newCaret > this.buffer.getLength()) {
            throw new IllegalArgumentException("caret out of bounds: " + newCaret);
        }
        if (this.match != null) {
            if (this.caretLine < this.match.startLine) {
                this.invalidateLineRange(this.caretLine, this.match.endLine);
            } else {
                this.invalidateLineRange(this.match.startLine, this.caretLine);
            }
            this.match = null;
        }
        if (this.caret == newCaret) {
            if (scrollMode == NORMAL_SCROLL) {
                this.finishCaretUpdate(false, false);
            } else if (scrollMode == ELECTRIC_SCROLL) {
                this.finishCaretUpdate(true, false);
            }
        } else {
            int newCaretLine = this.getLineOfOffset(newCaret);
            this.magicCaret = -1;
            if (this.caretLine == newCaretLine) {
                if (this.caretScreenLine != -1) {
                    this.invalidateScreenLineRange(this.caretScreenLine, this.caretScreenLine);
                }
            } else {
                int newCaretScreenLine = this.chunkCache.getScreenLineOfOffset(newCaretLine, newCaret - this.buffer.getLineStartOffset(newCaretLine));
                if (this.caretScreenLine == -1) {
                    this.invalidateScreenLineRange(newCaretScreenLine, newCaretScreenLine);
                } else {
                    this.invalidateScreenLineRange(this.caretScreenLine, newCaretScreenLine);
                }
                this.caretScreenLine = newCaretScreenLine;
            }
            this.caret = newCaret;
            this.caretLine = newCaretLine;
            if (scrollMode == NORMAL_SCROLL) {
                this.finishCaretUpdate(false, true);
            } else if (scrollMode == ELECTRIC_SCROLL) {
                this.finishCaretUpdate(true, true);
            }
        }
    }

    public int getCaretPosition() {
        return this.caret;
    }

    public int getCaretLine() {
        return this.caretLine;
    }

    public int getMagicCaretPosition() {
        if (this.magicCaret == -1) {
            this.magicCaret = this.chunkCache.subregionOffsetToX(this.caretLine, this.caret - this.getLineStartOffset(this.caretLine));
        }
        return this.magicCaret;
    }

    public void setMagicCaretPosition(int magicCaret) {
        this.magicCaret = magicCaret;
    }

    public final void addCaretListener(CaretListener listener) {
        this.listenerList.add(class$javax$swing$event$CaretListener == null ? (class$javax$swing$event$CaretListener = JEditTextArea.class$("javax.swing.event.CaretListener")) : class$javax$swing$event$CaretListener, listener);
    }

    public final void removeCaretListener(CaretListener listener) {
        this.listenerList.remove(class$javax$swing$event$CaretListener == null ? (class$javax$swing$event$CaretListener = JEditTextArea.class$("javax.swing.event.CaretListener")) : class$javax$swing$event$CaretListener, listener);
    }

    public void goToNextBracket(boolean select) {
        int newCaret = -1;
        if (this.caret != this.buffer.getLength()) {
            String text = this.getText(this.caret, this.buffer.getLength() - this.caret - 1);
            block3: for (int i = 0; i < text.length(); ++i) {
                switch (text.charAt(i)) {
                    case ')': 
                    case ']': 
                    case '}': {
                        newCaret = this.caret + i + 1;
                        break block3;
                    }
                    default: {
                        continue block3;
                    }
                }
            }
        }
        if (newCaret == -1) {
            this.getToolkit().beep();
        } else {
            if (select) {
                this.extendSelection(this.caret, newCaret);
            } else if (!this.multi) {
                this.selectNone();
            }
            this.moveCaretPosition(newCaret);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void goToNextCharacter(boolean select) {
        int newCaret;
        int extraEndVirt;
        int extraStartVirt;
        block17: {
            block19: {
                Selection s;
                block18: {
                    s = this.getSelectionAtOffset(this.caret);
                    if (!select && s instanceof Selection.Range) {
                        if (!this.multi) {
                            this.setCaretPosition(s.end);
                            return;
                        }
                        if (this.caret != s.end) {
                            this.moveCaretPosition(s.end);
                            return;
                        }
                    }
                    if (s instanceof Selection.Rect) {
                        extraStartVirt = ((Selection.Rect)s).extraStartVirt;
                        extraEndVirt = ((Selection.Rect)s).extraEndVirt;
                    } else {
                        extraStartVirt = 0;
                        extraEndVirt = 0;
                    }
                    newCaret = this.caret;
                    if (this.caret != this.buffer.getLength()) break block18;
                    if (select && (this.rectangularSelectionMode || s instanceof Selection.Rect)) {
                        if (s != null && this.caret == s.start) {
                            ++extraStartVirt;
                            break block17;
                        } else {
                            ++extraEndVirt;
                        }
                        break block17;
                    } else {
                        this.getToolkit().beep();
                        return;
                    }
                }
                if (this.caret != this.getLineEndOffset(this.caretLine) - 1) break block19;
                if (select && (this.rectangularSelectionMode || s instanceof Selection.Rect)) {
                    if (s != null && this.caret == s.start) {
                        ++extraStartVirt;
                        break block17;
                    } else {
                        ++extraEndVirt;
                    }
                    break block17;
                } else {
                    int line = this.displayManager.getNextVisibleLine(this.caretLine);
                    if (line == -1) {
                        this.getToolkit().beep();
                        return;
                    }
                    newCaret = this.getLineStartOffset(line);
                }
                break block17;
            }
            newCaret = this.caret + 1;
        }
        if (select) {
            this.extendSelection(this.caret, newCaret, extraStartVirt, extraEndVirt);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToNextLine(boolean select) {
        Selection s = this.getSelectionAtOffset(this.caret);
        boolean rectSelect = s == null ? this.rectangularSelectionMode : s instanceof Selection.Rect;
        int magic = this.getMagicCaretPosition();
        int newCaret = this.chunkCache.getBelowPosition(this.caretLine, this.caret - this.buffer.getLineStartOffset(this.caretLine), magic + 1, rectSelect && select);
        if (newCaret == -1) {
            int end = this.getLineEndOffset(this.caretLine) - 1;
            if (this.caret == end) {
                this.getToolkit().beep();
                return;
            }
            newCaret = end;
        }
        if (select) {
            int extraEndVirt;
            int extraStartVirt;
            RectParams params = this.getRectParams(this.caret, newCaret);
            if (params == null) {
                extraStartVirt = 0;
                extraEndVirt = 0;
            } else {
                extraStartVirt = params.extraStartVirt;
                extraEndVirt = params.extraEndVirt;
                newCaret = params.newCaret;
            }
            this.extendSelection(this.caret, newCaret, extraStartVirt, extraEndVirt);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
        this.setMagicCaretPosition(magic);
    }

    public void goToNextMarker(boolean select) {
        Vector markers = this.buffer.getMarkers();
        if (markers.size() == 0) {
            this.getToolkit().beep();
            return;
        }
        Marker marker = null;
        for (int i = 0; i < markers.size(); ++i) {
            Marker _marker = (Marker)markers.get(i);
            if (_marker.getPosition() <= this.caret) continue;
            marker = _marker;
            break;
        }
        if (marker == null) {
            marker = (Marker)markers.get(0);
        }
        if (select) {
            this.extendSelection(this.caret, marker.getPosition());
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(marker.getPosition());
    }

    public void goToNextPage(boolean select) {
        int newCaret;
        this.scrollToCaret(false);
        int magic = this.getMagicCaretPosition();
        if (this.caretLine < this.displayManager.getFirstVisibleLine()) {
            this.caretLine = this.displayManager.getNextVisibleLine(this.caretLine);
        }
        if (this.getFirstLine() + this.getVisibleLines() >= this.displayManager.getScrollLineCount()) {
            int lastVisibleLine = this.displayManager.getLastVisibleLine();
            newCaret = this.getLineEndOffset(lastVisibleLine) - 1;
        } else {
            int caretScreenLine = this.getScreenLineOfOffset(this.caret);
            this.scrollDownPage();
            newCaret = this.xToScreenLineOffset(caretScreenLine, magic, true);
        }
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret, false);
        this.setMagicCaretPosition(magic);
    }

    public void goToNextParagraph(boolean select) {
        int lineNo = this.getCaretLine();
        int newCaret = this.getBufferLength();
        boolean foundBlank = false;
        block3: for (int i = lineNo + 1; i < this.getLineCount(); ++i) {
            if (!this.displayManager.isLineVisible(i)) continue;
            this.getLineText(i, this.lineSegment);
            block4: for (int j = 0; j < this.lineSegment.count; ++j) {
                switch (this.lineSegment.array[this.lineSegment.offset + j]) {
                    case '\t': 
                    case ' ': {
                        continue block4;
                    }
                    default: {
                        if (!foundBlank) continue block3;
                        newCaret = this.getLineStartOffset(i);
                        break block3;
                    }
                }
            }
            foundBlank = true;
        }
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToNextWord(boolean select) {
        this.goToNextWord(select, false);
    }

    public void goToNextWord(boolean select, boolean eatWhitespace) {
        String lineText;
        int lineStart = this.getLineStartOffset(this.caretLine);
        int newCaret = this.caret - lineStart;
        if (newCaret == (lineText = this.getLineText(this.caretLine)).length()) {
            int nextLine = this.displayManager.getNextVisibleLine(this.caretLine);
            if (nextLine == -1) {
                this.getToolkit().beep();
                return;
            }
            newCaret = this.getLineStartOffset(nextLine);
        } else {
            String noWordSep = this.buffer.getStringProperty("noWordSep");
            newCaret = TextUtilities.findWordEnd(lineText, newCaret + 1, noWordSep, true, eatWhitespace);
            newCaret += lineStart;
        }
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToPrevBracket(boolean select) {
        String text = this.getText(0, this.caret);
        int newCaret = -1;
        block3: for (int i = this.getCaretPosition() - 1; i >= 0; --i) {
            switch (text.charAt(i)) {
                case '(': 
                case '[': 
                case '{': {
                    newCaret = i;
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        if (newCaret == -1) {
            this.getToolkit().beep();
        } else {
            if (select) {
                this.extendSelection(this.caret, newCaret);
            } else if (!this.multi) {
                this.selectNone();
            }
            this.moveCaretPosition(newCaret);
        }
    }

    public void goToPrevCharacter(boolean select) {
        Selection s = this.getSelectionAtOffset(this.caret);
        if (!select && s instanceof Selection.Range) {
            if (this.multi) {
                if (this.caret != s.start) {
                    this.moveCaretPosition(s.start);
                    return;
                }
            } else {
                this.setCaretPosition(s.start);
                return;
            }
        }
        int extraStartVirt = 0;
        int extraEndVirt = 0;
        int newCaret = this.caret;
        if (select && this.caret == this.getLineEndOffset(this.caretLine) - 1) {
            if (s instanceof Selection.Rect) {
                extraStartVirt = ((Selection.Rect)s).extraStartVirt;
                extraEndVirt = ((Selection.Rect)s).extraEndVirt;
                if (this.caret == s.start) {
                    if (extraStartVirt == 0) {
                        newCaret = this.caret - 1;
                    } else {
                        --extraStartVirt;
                    }
                } else if (extraEndVirt == 0) {
                    newCaret = this.caret - 1;
                } else {
                    --extraEndVirt;
                }
            } else {
                newCaret = this.caret - 1;
            }
        } else if (this.caret == this.getLineStartOffset(this.caretLine)) {
            int line = this.displayManager.getPrevVisibleLine(this.caretLine);
            if (line == -1) {
                this.getToolkit().beep();
                return;
            }
            newCaret = this.getLineEndOffset(line) - 1;
        } else {
            newCaret = this.caret - 1;
        }
        if (select) {
            this.extendSelection(this.caret, newCaret, extraStartVirt, extraEndVirt);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToPrevLine(boolean select) {
        Selection s = this.getSelectionAtOffset(this.caret);
        boolean rectSelect = s == null ? this.rectangularSelectionMode : s instanceof Selection.Rect;
        int magic = this.getMagicCaretPosition();
        int newCaret = this.chunkCache.getAbovePosition(this.caretLine, this.caret - this.buffer.getLineStartOffset(this.caretLine), magic + 1, rectSelect && select);
        if (newCaret == -1) {
            int start = this.getLineStartOffset(this.caretLine);
            if (this.caret == start) {
                this.getToolkit().beep();
                return;
            }
            newCaret = start;
        }
        if (select) {
            int extraEndVirt;
            int extraStartVirt;
            RectParams params = this.getRectParams(this.caret, newCaret);
            if (params == null) {
                extraStartVirt = 0;
                extraEndVirt = 0;
            } else {
                extraStartVirt = params.extraStartVirt;
                extraEndVirt = params.extraEndVirt;
                newCaret = params.newCaret;
            }
            this.extendSelection(this.caret, newCaret, extraStartVirt, extraEndVirt);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
        this.setMagicCaretPosition(magic);
    }

    public void goToPrevMarker(boolean select) {
        Vector markers = this.buffer.getMarkers();
        if (markers.size() == 0) {
            this.getToolkit().beep();
            return;
        }
        Marker marker = null;
        for (int i = markers.size() - 1; i >= 0; --i) {
            Marker _marker = (Marker)markers.elementAt(i);
            if (_marker.getPosition() >= this.caret) continue;
            marker = _marker;
            break;
        }
        if (marker == null) {
            marker = (Marker)markers.get(markers.size() - 1);
        }
        if (select) {
            this.extendSelection(this.caret, marker.getPosition());
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(marker.getPosition());
    }

    public void goToPrevPage(boolean select) {
        int newCaret;
        this.scrollToCaret(false);
        int magic = this.getMagicCaretPosition();
        if (this.caretLine < this.displayManager.getFirstVisibleLine()) {
            this.caretLine = this.displayManager.getNextVisibleLine(this.caretLine);
        }
        if (this.getFirstLine() == 0) {
            int firstVisibleLine = this.displayManager.getFirstVisibleLine();
            newCaret = this.getLineStartOffset(firstVisibleLine);
        } else {
            int caretScreenLine = this.getScreenLineOfOffset(this.caret);
            this.scrollUpPage();
            newCaret = this.xToScreenLineOffset(caretScreenLine, magic, true);
        }
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret, false);
        this.setMagicCaretPosition(magic);
    }

    public void goToPrevParagraph(boolean select) {
        int lineNo = this.caretLine;
        int newCaret = 0;
        boolean foundBlank = false;
        block3: for (int i = lineNo - 1; i >= 0; --i) {
            if (!this.displayManager.isLineVisible(i)) continue;
            this.getLineText(i, this.lineSegment);
            block4: for (int j = 0; j < this.lineSegment.count; ++j) {
                switch (this.lineSegment.array[this.lineSegment.offset + j]) {
                    case '\t': 
                    case ' ': {
                        continue block4;
                    }
                    default: {
                        if (!foundBlank) continue block3;
                        newCaret = this.getLineEndOffset(i) - 1;
                        break block3;
                    }
                }
            }
            foundBlank = true;
        }
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToPrevWord(boolean select) {
        this.goToPrevWord(select, false);
    }

    public void goToPrevWord(boolean select, boolean eatWhitespace) {
        int lineStart = this.getLineStartOffset(this.caretLine);
        int newCaret = this.caret - lineStart;
        String lineText = this.getLineText(this.caretLine);
        if (newCaret == 0) {
            if (lineStart == 0) {
                this.getToolkit().beep();
                return;
            }
            int prevLine = this.displayManager.getPrevVisibleLine(this.caretLine);
            if (prevLine == -1) {
                this.getToolkit().beep();
                return;
            }
            newCaret = this.getLineEndOffset(prevLine) - 1;
        } else {
            String noWordSep = this.buffer.getStringProperty("noWordSep");
            newCaret = TextUtilities.findWordStart(lineText, newCaret - 1, noWordSep, true, eatWhitespace);
            newCaret += lineStart;
        }
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void smartHome(boolean select) {
        Macros.Recorder recorder = this.view.getMacroRecorder();
        switch (this.view.getInputHandler().getLastActionCount()) {
            case 1: {
                if (recorder != null) {
                    recorder.record("textArea.goToStartOfWhiteSpace(" + select + ");");
                }
                this.goToStartOfWhiteSpace(select);
                break;
            }
            case 2: {
                if (recorder != null) {
                    recorder.record("textArea.goToStartOfLine(" + select + ");");
                }
                this.goToStartOfLine(select);
                break;
            }
            default: {
                if (recorder != null) {
                    recorder.record("textArea.goToFirstVisibleLine(" + select + ");");
                }
                this.goToFirstVisibleLine(select);
            }
        }
    }

    public void smartEnd(boolean select) {
        Macros.Recorder recorder = this.view.getMacroRecorder();
        switch (this.view.getInputHandler().getLastActionCount()) {
            case 1: {
                if (recorder != null) {
                    recorder.record("textArea.goToEndOfWhiteSpace(" + select + ");");
                }
                this.goToEndOfWhiteSpace(select);
                break;
            }
            case 2: {
                if (recorder != null) {
                    recorder.record("textArea.goToEndOfLine(" + select + ");");
                }
                this.goToEndOfLine(select);
                break;
            }
            default: {
                if (recorder != null) {
                    recorder.record("textArea.goToLastVisibleLine(" + select + ");");
                }
                this.goToLastVisibleLine(select);
            }
        }
    }

    public void goToStartOfLine(boolean select) {
        Selection s = this.getSelectionAtOffset(this.caret);
        int line = select || s == null ? this.caretLine : s.startLine;
        int newCaret = this.getLineStartOffset(line);
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToEndOfLine(boolean select) {
        Selection s = this.getSelectionAtOffset(this.caret);
        int line = select || s == null ? this.caretLine : s.endLine;
        int newCaret = this.getLineEndOffset(line) - 1;
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToStartOfWhiteSpace(boolean select) {
        int offset;
        int line;
        Selection s = this.getSelectionAtOffset(this.caret);
        if (select || s == null) {
            line = this.caretLine;
            offset = this.caret - this.buffer.getLineStartOffset(line);
        } else {
            line = s.startLine;
            offset = s.start - this.buffer.getLineStartOffset(line);
        }
        int firstIndent = this.chunkCache.getSubregionStartOffset(line, offset);
        if (firstIndent == this.getLineStartOffset(line)) {
            firstIndent = MiscUtilities.getLeadingWhiteSpace(this.getLineText(line));
            if (firstIndent == this.getLineLength(line)) {
                firstIndent = 0;
            }
            firstIndent += this.getLineStartOffset(line);
        }
        if (select) {
            this.extendSelection(this.caret, firstIndent);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(firstIndent);
    }

    public void goToEndOfWhiteSpace(boolean select) {
        int offset;
        int line;
        Selection s = this.getSelectionAtOffset(this.caret);
        if (select || s == null) {
            line = this.caretLine;
            offset = this.caret - this.getLineStartOffset(line);
        } else {
            line = s.endLine;
            offset = s.end - this.getLineStartOffset(line);
        }
        int lastIndent = this.chunkCache.getSubregionEndOffset(line, offset);
        if (lastIndent == this.getLineEndOffset(line)) {
            lastIndent = this.getLineLength(line) - MiscUtilities.getTrailingWhiteSpace(this.getLineText(line));
            if (lastIndent == 0) {
                lastIndent = this.getLineLength(line);
            }
            lastIndent += this.getLineStartOffset(line);
        } else {
            --lastIndent;
        }
        if (select) {
            this.extendSelection(this.caret, lastIndent);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(lastIndent);
    }

    public void goToFirstVisibleLine(boolean select) {
        int firstVisibleLine = this.getFirstLine() == 0 ? 0 : this.electricScroll;
        int firstVisible = this.getScreenLineStartOffset(firstVisibleLine);
        if (firstVisible == -1) {
            firstVisible = this.getLineStartOffset(this.displayManager.getFirstVisibleLine());
        }
        if (select) {
            this.extendSelection(this.caret, firstVisible);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(firstVisible);
    }

    public void goToLastVisibleLine(boolean select) {
        int lastVisible;
        if (this.getFirstLine() + this.visibleLines >= this.displayManager.getScrollLineCount()) {
            lastVisible = this.getLineEndOffset(this.displayManager.getLastVisibleLine()) - 1;
        } else {
            lastVisible = this.visibleLines - this.electricScroll - 1;
            if (this.lastLinePartial) {
                --lastVisible;
            }
            if (lastVisible < 0) {
                lastVisible = 0;
            }
            if ((lastVisible = this.getScreenLineEndOffset(lastVisible) - 1) == -1) {
                lastVisible = this.getLineEndOffset(this.displayManager.getLastVisibleLine()) - 1;
            }
        }
        if (select) {
            this.extendSelection(this.caret, lastVisible);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(lastVisible);
    }

    public void goToBufferStart(boolean select) {
        int start = this.buffer.getLineStartOffset(this.displayManager.getFirstVisibleLine());
        if (select) {
            this.extendSelection(this.caret, start);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(start);
    }

    public void goToBufferEnd(boolean select) {
        int end = this.buffer.getLineEndOffset(this.displayManager.getLastVisibleLine()) - 1;
        if (select) {
            this.extendSelection(this.caret, end);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(end);
    }

    public void goToMatchingBracket() {
        int dot;
        int bracket;
        if (this.getLineLength(this.caretLine) != 0 && (bracket = TextUtilities.findMatchingBracket(this.buffer, this.caretLine, Math.max(0, (dot = this.caret - this.getLineStartOffset(this.caretLine)) - 1))) != -1) {
            this.selectNone();
            this.moveCaretPosition(bracket + 1, false);
            return;
        }
        this.getToolkit().beep();
    }

    public void showGoToLineDialog() {
        String line = GUIUtilities.input(this.view, "goto-line", null);
        if (line == null) {
            return;
        }
        try {
            int lineNumber = Integer.parseInt(line) - 1;
            this.setCaretPosition(this.getLineStartOffset(lineNumber));
        }
        catch (Exception e) {
            this.getToolkit().beep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userInput(char ch) {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (ch == ' ' && Abbrevs.getExpandOnInput() && Abbrevs.expandAbbrev(this.view, false)) {
            return;
        }
        if (ch == '\t') {
            if (this.selection.size() == 1) {
                Selection sel = (Selection)this.selection.elementAt(0);
                if (sel instanceof Selection.Rect || sel.startLine == sel.endLine && (sel.start != this.buffer.getLineStartOffset(sel.startLine) || sel.end != this.buffer.getLineEndOffset(sel.startLine) - 1)) {
                    this.insertTab();
                } else {
                    this.shiftIndentRight();
                }
            } else if (this.selection.size() != 0) {
                this.shiftIndentRight();
            } else {
                this.insertTab();
            }
            return;
        }
        String indentOpenBrackets = (String)this.buffer.getProperty("indentOpenBrackets");
        String indentCloseBrackets = (String)this.buffer.getProperty("indentCloseBrackets");
        boolean indent = indentCloseBrackets != null && indentCloseBrackets.indexOf(ch) != -1 || indentOpenBrackets != null && indentOpenBrackets.indexOf(ch) != -1;
        String str = String.valueOf(ch);
        Selection[] selection = this.getSelection();
        if (selection.length != 0) {
            for (int i = 0; i < selection.length; ++i) {
                Selection s = selection[i];
                this.setSelectedText(s, str);
            }
            return;
        }
        if (ch == ' ') {
            if (this.doWordWrap(true)) {
                return;
            }
        } else {
            this.doWordWrap(false);
        }
        try {
            int caretLineEnd;
            if (this.overwrite || indent) {
                this.buffer.beginCompoundEdit();
            }
            if (this.overwrite && (caretLineEnd = this.getLineEndOffset(this.caretLine)) - this.caret > 1) {
                this.buffer.remove(this.caret, 1);
            }
            this.buffer.insert(this.caret, str);
            if (indent) {
                this.buffer.indentLine(this.caretLine, true);
            }
        }
        finally {
            if (this.overwrite || indent) {
                this.buffer.endCompoundEdit();
            }
        }
    }

    public final boolean isOverwriteEnabled() {
        return this.overwrite;
    }

    public final void setOverwriteEnabled(boolean overwrite) {
        this.blink = true;
        caretTimer.restart();
        this.overwrite = overwrite;
        this.invalidateLine(this.caretLine);
        if (this.view.getStatus() != null) {
            this.view.getStatus().updateMiscStatus();
        }
    }

    public final void toggleOverwriteEnabled() {
        this.setOverwriteEnabled(!this.overwrite);
        if (this.view.getStatus() != null) {
            this.view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.overwrite-changed", new Integer[]{new Integer(this.overwrite ? 1 : 0)}));
        }
    }

    public void backspace() {
        this.delete(false);
    }

    public void backspaceWord() {
        this.backspaceWord(false);
    }

    public void backspaceWord(boolean eatWhitespace) {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.selection.size() != 0) {
            this.setSelectedText("");
            return;
        }
        int lineStart = this.getLineStartOffset(this.caretLine);
        int _caret = this.caret - lineStart;
        String lineText = this.getLineText(this.caretLine);
        if (_caret == 0) {
            if (lineStart == 0) {
                this.getToolkit().beep();
                return;
            }
            --_caret;
        } else {
            String noWordSep = this.buffer.getStringProperty("noWordSep");
            _caret = TextUtilities.findWordStart(lineText, _caret - 1, noWordSep, true, eatWhitespace);
        }
        this.buffer.remove(_caret + lineStart, this.caret - (_caret + lineStart));
    }

    public void delete() {
        this.delete(true);
    }

    public void deleteToEndOfLine() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.remove(this.caret, this.getLineEndOffset(this.caretLine) - this.caret - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLine() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        int start = this.getLineStartOffset(this.caretLine);
        int end = this.getLineEndOffset(this.caretLine);
        int x = this.chunkCache.subregionOffsetToX(this.caretLine, this.caret - start);
        try {
            if (end > this.buffer.getLength()) {
                if (start != 0) {
                    --start;
                }
                --end;
            }
            this.buffer.beginCompoundEdit();
            this.buffer.remove(start, end - start);
        }
        finally {
            this.buffer.endCompoundEdit();
        }
        int lastLine = this.displayManager.getLastVisibleLine();
        if (this.caretLine == lastLine) {
            int offset = this.chunkCache.xToSubregionOffset(lastLine, 0, x, true);
            this.setCaretPosition(this.buffer.getLineStartOffset(lastLine) + offset);
        } else {
            int offset = this.chunkCache.xToSubregionOffset(this.caretLine, 0, x, true);
            this.setCaretPosition(start + offset);
        }
    }

    public void deleteParagraph() {
        int j;
        int i;
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        int start = 0;
        int end = this.buffer.getLength();
        block6: for (i = this.caretLine - 1; i >= 0; --i) {
            this.getLineText(i, this.lineSegment);
            block7: for (j = 0; j < this.lineSegment.count; ++j) {
                switch (this.lineSegment.array[this.lineSegment.offset + j]) {
                    case '\t': 
                    case ' ': {
                        continue block7;
                    }
                    default: {
                        continue block6;
                    }
                }
            }
            start = this.getLineStartOffset(i);
            break;
        }
        block8: for (i = this.caretLine + 1; i < this.getLineCount(); ++i) {
            this.getLineText(i, this.lineSegment);
            block9: for (j = 0; j < this.lineSegment.count; ++j) {
                switch (this.lineSegment.array[this.lineSegment.offset + j]) {
                    case '\t': 
                    case ' ': {
                        continue block9;
                    }
                    default: {
                        continue block8;
                    }
                }
            }
            end = this.getLineEndOffset(i) - 1;
            break;
        }
        this.buffer.remove(start, end - start);
    }

    public void deleteToStartOfLine() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.remove(this.getLineStartOffset(this.caretLine), this.caret - this.getLineStartOffset(this.caretLine));
    }

    public void deleteWord() {
        this.deleteWord(false);
    }

    public void deleteWord(boolean eatWhitespace) {
        String lineText;
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.selection.size() != 0) {
            this.setSelectedText("");
            return;
        }
        int lineStart = this.getLineStartOffset(this.caretLine);
        int _caret = this.caret - lineStart;
        if (_caret == (lineText = this.getLineText(this.caretLine)).length()) {
            if (lineStart + _caret == this.buffer.getLength()) {
                this.getToolkit().beep();
                return;
            }
            ++_caret;
        } else {
            String noWordSep = this.buffer.getStringProperty("noWordSep");
            _caret = TextUtilities.findWordEnd(lineText, _caret + 1, noWordSep, true, eatWhitespace);
        }
        this.buffer.remove(this.caret, _caret + lineStart - this.caret);
    }

    public final boolean isMultipleSelectionEnabled() {
        return this.multi;
    }

    public final void toggleMultipleSelectionEnabled() {
        this.setMultipleSelectionEnabled(!this.multi);
        if (this.view.getStatus() != null) {
            this.view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.multi-changed", new Integer[]{new Integer(this.multi ? 1 : 0)}));
        }
    }

    public final void setMultipleSelectionEnabled(boolean multi) {
        this.multi = multi;
        if (this.view.getStatus() != null) {
            this.view.getStatus().updateMiscStatus();
        }
        this.painter.repaint();
    }

    public final boolean isRectangularSelectionEnabled() {
        return this.rectangularSelectionMode;
    }

    public final void toggleRectangularSelectionEnabled() {
        this.setRectangularSelectionEnabled(!this.rectangularSelectionMode);
        if (this.view.getStatus() != null) {
            this.view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.rect-select-changed", new Integer[]{new Integer(this.rectangularSelectionMode ? 1 : 0)}));
        }
    }

    public final void setRectangularSelectionEnabled(boolean rectangularSelectionMode) {
        this.rectangularSelectionMode = rectangularSelectionMode;
        if (this.view.getStatus() != null) {
            this.view.getStatus().updateMiscStatus();
        }
        this.painter.repaint();
    }

    public void goToMarker(char shortcut, boolean select) {
        Marker marker = this.buffer.getMarker(shortcut);
        if (marker == null) {
            this.getToolkit().beep();
            return;
        }
        int pos = marker.getPosition();
        if (select) {
            this.extendSelection(this.caret, pos);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(pos);
    }

    public void addMarker() {
        Selection[] selection = this.getSelection();
        for (int i = 0; i < selection.length; ++i) {
            Selection s = selection[i];
            if (s.startLine != s.endLine && s.startLine != this.caretLine) {
                this.buffer.addMarker('\u0000', s.start);
            }
            if (s.endLine == this.caretLine) continue;
            this.buffer.addMarker('\u0000', s.end);
        }
        this.buffer.addOrRemoveMarker('\u0000', this.caret);
    }

    public void swapMarkerAndCaret(char shortcut) {
        Marker marker = this.buffer.getMarker(shortcut);
        if (marker == null) {
            this.getToolkit().beep();
            return;
        }
        int caret = this.getCaretPosition();
        this.setCaretPosition(marker.getPosition());
        this.buffer.addMarker(shortcut, caret);
    }

    public void goToParentFold() {
        int line = -1;
        int level = this.buffer.getFoldLevel(this.caretLine);
        for (int i = this.caretLine - 1; i >= 0; --i) {
            if (this.buffer.getFoldLevel(i) >= level) continue;
            line = i;
            break;
        }
        if (line == -1) {
            this.getToolkit().beep();
            return;
        }
        int magic = this.getMagicCaretPosition();
        int newCaret = this.buffer.getLineStartOffset(line) + this.chunkCache.xToSubregionOffset(line, 0, magic + 1, true);
        if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
        this.setMagicCaretPosition(magic);
    }

    public void goToNextFold(boolean select) {
        int nextFold = -1;
        for (int i = this.caretLine + 1; i < this.buffer.getLineCount(); ++i) {
            if (!this.buffer.isFoldStart(i) || !this.displayManager.isLineVisible(i)) continue;
            nextFold = i;
            break;
        }
        if (nextFold == -1) {
            this.getToolkit().beep();
            return;
        }
        int magic = this.getMagicCaretPosition();
        int newCaret = this.buffer.getLineStartOffset(nextFold) + this.chunkCache.xToSubregionOffset(nextFold, 0, magic + 1, true);
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
        this.setMagicCaretPosition(magic);
    }

    public void goToPrevFold(boolean select) {
        int prevFold = -1;
        for (int i = this.caretLine - 1; i >= 0; --i) {
            if (!this.buffer.isFoldStart(i) || !this.displayManager.isLineVisible(i)) continue;
            prevFold = i;
            break;
        }
        if (prevFold == -1) {
            this.getToolkit().beep();
            return;
        }
        int magic = this.getMagicCaretPosition();
        int newCaret = this.buffer.getLineStartOffset(prevFold) + this.chunkCache.xToSubregionOffset(prevFold, 0, magic + 1, true);
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
        this.setMagicCaretPosition(magic);
    }

    public void collapseFold() {
        int x = this.chunkCache.subregionOffsetToX(this.caretLine, this.caret - this.getLineStartOffset(this.caretLine));
        this.displayManager.collapseFold(this.caretLine);
        if (this.displayManager.isLineVisible(this.caretLine)) {
            return;
        }
        int line = this.displayManager.getPrevVisibleLine(this.caretLine);
        if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(this.buffer.getLineStartOffset(line) + this.chunkCache.xToSubregionOffset(line, 0, x, true));
    }

    public void expandFold(boolean fully) {
        int x = this.chunkCache.subregionOffsetToX(this.caretLine, this.caret - this.getLineStartOffset(this.caretLine));
        int line = this.displayManager.expandFold(this.caretLine, fully);
        if (!fully && line != -1) {
            if (!this.multi) {
                this.selectNone();
            }
            this.moveCaretPosition(this.getLineStartOffset(line) + this.chunkCache.xToSubregionOffset(line, 0, x, true));
        }
    }

    public void selectFold() {
        this.selectFold(this.caretLine);
    }

    public void selectFold(int line) {
        int[] lines = this.buffer.getFoldAtLine(line);
        int newCaret = this.getLineEndOffset(lines[1]) - 1;
        Selection.Range s = new Selection.Range(this.getLineStartOffset(lines[0]), newCaret);
        if (this.multi) {
            this.addToSelection(s);
        } else {
            this.setSelection(s);
        }
        this.moveCaretPosition(newCaret);
    }

    public void narrowToFold() {
        int[] lines = this.buffer.getFoldAtLine(this.caretLine);
        if (lines[0] == 0 && lines[1] == this.buffer.getLineCount() - 1) {
            this.getToolkit().beep();
        } else {
            this.displayManager.narrow(lines[0], lines[1]);
        }
    }

    public void narrowToSelection() {
        if (this.selection.size() != 1) {
            this.getToolkit().beep();
            return;
        }
        Selection sel = (Selection)this.selection.elementAt(0);
        this.displayManager.narrow(sel.getStartLine(), sel.getEndLine());
        this.selectNone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitFold() {
        String end;
        String start;
        if (!this.buffer.getStringProperty("folding").equals("explicit")) {
            GUIUtilities.error(this.view, "folding-not-explicit", null);
            return;
        }
        String lineComment = this.buffer.getContextSensitiveProperty(this.caret, "lineComment");
        String commentStart = this.buffer.getContextSensitiveProperty(this.caret, "commentStart");
        String commentEnd = this.buffer.getContextSensitiveProperty(this.caret, "commentEnd");
        if (lineComment != null) {
            start = lineComment + "{{{ \n";
            end = lineComment + "}}}";
        } else if (commentStart != null && commentEnd != null) {
            start = commentStart + "{{{  " + commentEnd + "\n";
            end = commentStart + "}}}" + commentEnd;
        } else {
            start = "{{{ \n";
            end = "}}}";
        }
        try {
            this.buffer.beginCompoundEdit();
            if (this.selection.size() == 0) {
                String line = this.buffer.getLineText(this.caretLine);
                String whitespace = line.substring(0, MiscUtilities.getLeadingWhiteSpace(line));
                int loc = this.caret + start.length() - 1;
                start = start + whitespace;
                this.buffer.insert(this.caret, start);
                this.buffer.insert(this.caret, end);
                this.moveCaretPosition(loc, false);
            } else {
                int loc = -1;
                for (int i = 0; i < this.selection.size(); ++i) {
                    Selection s = (Selection)this.selection.elementAt(i);
                    String line = this.buffer.getLineText(s.startLine);
                    String whitespace = line.substring(0, MiscUtilities.getLeadingWhiteSpace(line));
                    loc = s.start + start.length() - 1;
                    this.buffer.insert(s.start, start + whitespace);
                    if (s.end == this.buffer.getLineStartOffset(s.endLine)) {
                        this.buffer.insert(s.end, end);
                        continue;
                    }
                    this.buffer.insert(s.end, " " + end);
                }
                this.setCaretPosition(loc, false);
            }
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineComment() {
        String comment = this.buffer.getContextSensitiveProperty(this.caret, "lineComment");
        if (!this.buffer.isEditable() || comment == null || comment.length() == 0) {
            this.getToolkit().beep();
            return;
        }
        comment = comment + ' ';
        this.buffer.beginCompoundEdit();
        int[] lines = this.getSelectedLines();
        try {
            for (int i = 0; i < lines.length; ++i) {
                String text = this.getLineText(lines[i]);
                this.buffer.insert(this.getLineStartOffset(lines[i]) + MiscUtilities.getLeadingWhiteSpace(text), comment);
            }
        }
        finally {
            this.buffer.endCompoundEdit();
        }
        this.selectNone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rangeComment() {
        String commentStart = this.buffer.getContextSensitiveProperty(this.caret, "commentStart");
        String commentEnd = this.buffer.getContextSensitiveProperty(this.caret, "commentEnd");
        if (!this.buffer.isEditable() || commentStart == null || commentEnd == null || commentStart.length() == 0 || commentEnd.length() == 0) {
            this.getToolkit().beep();
            return;
        }
        commentStart = commentStart + ' ';
        commentEnd = ' ' + commentEnd;
        try {
            this.buffer.beginCompoundEdit();
            Selection[] selection = this.getSelection();
            if (selection.length == 0) {
                int oldCaret = this.caret;
                this.buffer.insert(this.caret, commentStart);
                this.buffer.insert(this.caret, commentEnd);
                this.setCaretPosition(oldCaret + commentStart.length());
            }
            for (int i = 0; i < selection.length; ++i) {
                Selection s = selection[i];
                if (s instanceof Selection.Range) {
                    this.buffer.insert(s.start, commentStart);
                    this.buffer.insert(s.end, commentEnd);
                    continue;
                }
                if (!(s instanceof Selection.Rect)) continue;
                Selection.Rect rect = (Selection.Rect)s;
                int start = rect.getStartColumn(this.buffer);
                int end = rect.getEndColumn(this.buffer);
                for (int j = s.startLine; j <= s.endLine; ++j) {
                    this.buffer.insertAtColumn(j, end, commentEnd);
                    this.buffer.insertAtColumn(j, start, commentStart);
                }
            }
            this.selectNone();
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatParagraph() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.maxLineLen <= 0) {
            GUIUtilities.error(this.view, "format-maxlinelen", null);
            return;
        }
        Selection[] selection = this.getSelection();
        if (selection.length != 0) {
            this.buffer.beginCompoundEdit();
            for (int i = 0; i < selection.length; ++i) {
                Selection s = selection[i];
                this.setSelectedText(s, TextUtilities.format(this.getSelectedText(s), this.maxLineLen, this.buffer.getTabSize()));
            }
            this.buffer.endCompoundEdit();
        } else {
            int j;
            int i;
            int lineNo = this.getCaretLine();
            int start = 0;
            int end = this.buffer.getLength();
            block10: for (i = lineNo - 1; i >= 0; --i) {
                this.getLineText(i, this.lineSegment);
                block11: for (j = 0; j < this.lineSegment.count; ++j) {
                    switch (this.lineSegment.array[this.lineSegment.offset + j]) {
                        case '\t': 
                        case ' ': {
                            continue block11;
                        }
                        default: {
                            continue block10;
                        }
                    }
                }
                start = this.getLineEndOffset(i);
                break;
            }
            block12: for (i = lineNo + 1; i < this.getLineCount(); ++i) {
                this.getLineText(i, this.lineSegment);
                block13: for (j = 0; j < this.lineSegment.count; ++j) {
                    switch (this.lineSegment.array[this.lineSegment.offset + j]) {
                        case '\t': 
                        case ' ': {
                            continue block13;
                        }
                        default: {
                            continue block12;
                        }
                    }
                }
                end = this.getLineStartOffset(i) - 1;
                break;
            }
            try {
                this.buffer.beginCompoundEdit();
                String text = this.buffer.getText(start, end - start);
                this.buffer.remove(start, end - start);
                this.buffer.insert(start, TextUtilities.format(text, this.maxLineLen, this.buffer.getTabSize()));
            }
            finally {
                this.buffer.endCompoundEdit();
            }
        }
    }

    public void spacesToTabs() {
        Selection[] selection = this.getSelection();
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.beginCompoundEdit();
        if (selection.length == 0) {
            this.setText(TextUtilities.spacesToTabs(this.getText(), this.buffer.getTabSize()));
        } else {
            for (int i = 0; i < selection.length; ++i) {
                Selection s = selection[i];
                this.setSelectedText(s, TextUtilities.spacesToTabs(this.getSelectedText(s), this.buffer.getTabSize()));
            }
        }
        this.buffer.endCompoundEdit();
    }

    public void tabsToSpaces() {
        Selection[] selection = this.getSelection();
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.beginCompoundEdit();
        if (selection.length == 0) {
            this.setText(TextUtilities.tabsToSpaces(this.getText(), this.buffer.getTabSize()));
        } else {
            for (int i = 0; i < selection.length; ++i) {
                Selection s = selection[i];
                this.setSelectedText(s, TextUtilities.tabsToSpaces(this.getSelectedText(s), this.buffer.getTabSize()));
            }
        }
        this.buffer.endCompoundEdit();
    }

    public void toUpperCase() {
        Selection[] selection = this.getSelection();
        if (!this.buffer.isEditable() || selection.length == 0) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.beginCompoundEdit();
        for (int i = 0; i < selection.length; ++i) {
            Selection s = selection[i];
            this.setSelectedText(s, this.getSelectedText(s).toUpperCase());
        }
        this.buffer.endCompoundEdit();
    }

    public void toLowerCase() {
        Selection[] selection = this.getSelection();
        if (!this.buffer.isEditable() || selection.length == 0) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.beginCompoundEdit();
        for (int i = 0; i < selection.length; ++i) {
            Selection s = selection[i];
            this.setSelectedText(s, this.getSelectedText(s).toLowerCase());
        }
        this.buffer.endCompoundEdit();
    }

    public void removeTrailingWhiteSpace() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.removeTrailingWhiteSpace(this.getSelectedLines());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertEnterAndIndent() {
        if (!this.isEditable()) {
            this.getToolkit().beep();
        } else {
            try {
                this.buffer.beginCompoundEdit();
                this.setSelectedText("\n");
                this.buffer.indentLine(this.caretLine, true);
            }
            finally {
                this.buffer.endCompoundEdit();
            }
        }
    }

    public void insertTabAndIndent() {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.selection.size() == 0) {
            int whiteSpace;
            String text = this.buffer.getLineText(this.caretLine);
            int start = this.buffer.getLineStartOffset(this.caretLine);
            if (this.caret - start <= (whiteSpace = MiscUtilities.getLeadingWhiteSpace(text)) && this.buffer.indentLine(this.caretLine, false)) {
                return;
            }
        }
        this.userInput('\t');
    }

    public void indentSelectedLines() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.indentLines(this.getSelectedLines());
            this.selectNone();
        }
    }

    public void shiftIndentLeft() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.shiftIndentLeft(this.getSelectedLines());
        }
    }

    public void shiftIndentRight() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.shiftIndentRight(this.getSelectedLines());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinLines() {
        int end = this.getLineEndOffset(this.caretLine);
        if (!this.buffer.isEditable() || end > this.buffer.getLength()) {
            this.getToolkit().beep();
            return;
        }
        try {
            this.buffer.beginCompoundEdit();
            this.buffer.remove(end - 1, MiscUtilities.getLeadingWhiteSpace(this.buffer.getLineText(this.caretLine + 1)) + 1);
            this.buffer.insert(end - 1, " ");
        }
        finally {
            this.buffer.endCompoundEdit();
        }
        this.setCaretPosition(end - 1);
    }

    public void showWordCountDialog() {
        String selection = this.getSelectedText();
        if (selection != null) {
            this.doWordCount(this.view, selection);
            return;
        }
        this.doWordCount(this.view, this.buffer.getText(0, this.buffer.getLength()));
    }

    public boolean isRightClickPopupEnabled() {
        return this.popupEnabled;
    }

    public void setRightClickPopupEnabled(boolean popupEnabled) {
        this.popupEnabled = popupEnabled;
    }

    public final JPopupMenu getRightClickPopup() {
        return this.popup;
    }

    public final void setRightClickPopup(JPopupMenu popup) {
        this.popup = popup;
    }

    public void handlePopupTrigger(MouseEvent evt) {
        if (this.popup.isVisible()) {
            this.popup.setVisible(false);
        } else {
            int x = evt.getX();
            int y = evt.getY();
            int dragStart = this.xyToOffset(x, y, !this.painter.isBlockCaretEnabled() && !this.isOverwriteEnabled());
            if (this.getSelectionCount() == 0 || this.multi) {
                this.moveCaretPosition(dragStart, false);
            }
            GUIUtilities.showPopupMenu(this.popup, this.painter, x, y);
        }
    }

    public void addLeftOfScrollBar(Component comp) {
        this.verticalBox.add(comp, this.verticalBox.getComponentCount() - 1);
    }

    public void removeLeftOfScrollBar(Component comp) {
        this.verticalBox.remove(comp);
    }

    public void addNotify() {
        super.addNotify();
        ToolTipManager.sharedInstance().registerComponent(this.painter);
        ToolTipManager.sharedInstance().registerComponent(this.gutter);
        this.recalculateVisibleLines();
        if (this.buffer.isLoaded()) {
            this.recalculateLastPhysicalLine();
        }
        this.propertiesChanged();
    }

    public void removeNotify() {
        super.removeNotify();
        ToolTipManager.sharedInstance().unregisterComponent(this.painter);
        ToolTipManager.sharedInstance().unregisterComponent(this.gutter);
        if (focusedComponent == this) {
            focusedComponent = null;
        }
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean getFocusCycleRoot() {
        return true;
    }

    public void processKeyEvent(KeyEvent evt) {
        this.view.processKeyEvent(evt, 1);
        if (!evt.isConsumed()) {
            super.processKeyEvent(evt);
        }
    }

    public void addTopComponent(Component comp) {
        this.add(TOP, comp);
    }

    public void removeTopComponent(Component comp) {
        this.remove(comp);
    }

    public void propertiesChanged() {
        int maxLineLen;
        if (this.buffer == null) {
            return;
        }
        int _tabSize = this.buffer.getTabSize();
        char[] foo = new char[_tabSize];
        for (int i = 0; i < foo.length; ++i) {
            foo[i] = 32;
        }
        this.tabSize = this.painter.getStringWidth(new String(foo));
        this.charWidth = (int)Math.round(this.painter.getFont().getStringBounds(foo, 0, 1, this.painter.getFontRenderContext()).getWidth());
        boolean invalidateCachedScreenLineCounts = false;
        String wrap = this.buffer.getStringProperty("wrap");
        if (!wrap.equals(this.wrap)) {
            this.wrap = wrap;
            this.hardWrap = wrap.equals("hard");
            if (this.displayManager != null && !this.bufferChanging) {
                this.displayManager.firstLine.callReset = true;
                this.displayManager.scrollLineCount.callReset = true;
            }
            invalidateCachedScreenLineCounts = true;
        }
        if ((maxLineLen = this.buffer.getIntegerProperty("maxLineLen", 0)) != this.maxLineLen) {
            this.maxLineLen = maxLineLen;
            if (this.displayManager != null && !this.bufferChanging) {
                this.displayManager.firstLine.callReset = true;
                this.displayManager.scrollLineCount.callReset = true;
            }
            invalidateCachedScreenLineCounts = true;
        }
        if (invalidateCachedScreenLineCounts) {
            this.buffer.invalidateCachedScreenLineCounts();
        }
        this.chunkCache.invalidateAll();
        if (this.displayManager != null && !this.bufferChanging) {
            this.displayManager.updateWrapSettings();
            this.displayManager._notifyScreenLineChanges();
        }
        this.gutter.repaint();
        this.painter.repaint();
    }

    public final int getSelectionStart() {
        if (this.selection.size() != 1) {
            return this.caret;
        }
        return ((Selection)this.selection.elementAt(0)).getStart();
    }

    public int getSelectionStart(int line) {
        if (this.selection.size() != 1) {
            return this.caret;
        }
        return ((Selection)this.selection.elementAt(0)).getStart(this.buffer, line);
    }

    public final int getSelectionStartLine() {
        if (this.selection.size() != 1) {
            return this.caret;
        }
        return ((Selection)this.selection.elementAt(0)).getStartLine();
    }

    public final void setSelectionStart(int selectionStart) {
        this.select(selectionStart, this.getSelectionEnd(), true);
    }

    public final int getSelectionEnd() {
        if (this.selection.size() != 1) {
            return this.caret;
        }
        return ((Selection)this.selection.elementAt(0)).getEnd();
    }

    public int getSelectionEnd(int line) {
        if (this.selection.size() != 1) {
            return this.caret;
        }
        return ((Selection)this.selection.elementAt(0)).getEnd(this.buffer, line);
    }

    public final int getSelectionEndLine() {
        if (this.selection.size() != 1) {
            return this.caret;
        }
        return ((Selection)this.selection.elementAt(0)).getEndLine();
    }

    public final void setSelectionEnd(int selectionEnd) {
        this.select(this.getSelectionStart(), selectionEnd, true);
    }

    public final int getMarkPosition() {
        Selection s = this.getSelectionAtOffset(this.caret);
        if (s == null) {
            return this.caret;
        }
        if (s.start == this.caret) {
            return s.end;
        }
        if (s.end == this.caret) {
            return s.start;
        }
        return this.caret;
    }

    public final int getMarkLine() {
        if (this.selection.size() != 1) {
            return this.caretLine;
        }
        Selection s = (Selection)this.selection.elementAt(0);
        if (s.start == this.caret) {
            return s.endLine;
        }
        if (s.end == this.caret) {
            return s.startLine;
        }
        return this.caretLine;
    }

    public void select(int start, int end) {
        this.select(start, end, true);
    }

    public void select(int start, int end, boolean doElectricScroll) {
        int newEnd;
        int newStart;
        this.selectNone();
        if (start < end) {
            newStart = start;
            newEnd = end;
        } else {
            newStart = end;
            newEnd = start;
        }
        this.setSelection(new Selection.Range(newStart, newEnd));
        this.moveCaretPosition(end, doElectricScroll);
    }

    public boolean isSelectionRectangular() {
        Selection s = this.getSelectionAtOffset(this.caret);
        if (s == null) {
            return false;
        }
        return s instanceof Selection.Rect;
    }

    final boolean isCaretVisible() {
        return this.blink && this.hasFocus();
    }

    final boolean isStructureHighlightVisible() {
        return this.match != null && this.hasFocus() && this.displayManager.isLineVisible(this.match.startLine) && this.displayManager.isLineVisible(this.match.endLine);
    }

    void updateMaxHorizontalScrollWidth() {
        int max = this.chunkCache.getMaxHorizontalScrollWidth();
        if (max != this.maxHorizontalScrollWidth) {
            this.maxHorizontalScrollWidth = max;
            this.horizontal.setValues(Math.max(0, Math.min(this.maxHorizontalScrollWidth + this.charWidth - this.painter.getWidth(), -this.horizontalOffset)), this.painter.getWidth(), 0, this.maxHorizontalScrollWidth + this.charWidth);
        }
    }

    void recalculateVisibleLines() {
        if (this.painter == null) {
            return;
        }
        int height = this.painter.getHeight();
        int lineHeight = this.painter.getFontMetrics().getHeight();
        if (lineHeight == 0) {
            this.visibleLines = 0;
        } else if (height <= 0) {
            this.visibleLines = 0;
            this.lastLinePartial = false;
        } else {
            this.visibleLines = height / lineHeight;
            boolean bl = this.lastLinePartial = height % lineHeight != 0;
            if (this.lastLinePartial) {
                ++this.visibleLines;
            }
        }
        this.chunkCache.recalculateVisibleLines();
        if (this.displayManager != null && this.buffer != null && this.buffer.isLoaded()) {
            this.setFirstLine(this.getFirstLine());
        }
        this.updateScrollBars();
    }

    void foldStructureChanged() {
        this.chunkCache.invalidateAll();
        this.recalculateLastPhysicalLine();
        this.repaint();
    }

    void updateScrollBars() {
        if (this.buffer == null) {
            return;
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "updateScrollBars(), slc=" + this.displayManager.getScrollLineCount());
        }
        if (this.vertical != null && this.visibleLines != 0) {
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "Vertical ok");
            }
            int lineCount = this.displayManager.getScrollLineCount();
            int firstLine = this.getFirstLine();
            int visible = this.visibleLines - (this.lastLinePartial ? 1 : 0);
            this.vertical.setValues(firstLine, visible, 0, lineCount);
            this.vertical.setUnitIncrement(2);
            this.vertical.setBlockIncrement(visible);
        }
        int width = this.painter.getWidth();
        if (this.horizontal != null && width != 0) {
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "Horizontal ok");
            }
            this.painter.repaint();
            this.horizontal.setValue(-this.horizontalOffset);
            this.horizontal.setUnitIncrement(this.painter.getFontMetrics().charWidth('w'));
            this.horizontal.setBlockIncrement(width / 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _finishCaretUpdate() {
        if (!this.queuedCaretUpdate) {
            return;
        }
        try {
            this.blink = true;
            caretTimer.restart();
            if (!this.displayManager.isLineVisible(this.caretLine)) {
                if (this.caretLine < this.displayManager.getFirstVisibleLine() || this.caretLine > this.displayManager.getLastVisibleLine()) {
                    int collapseFolds = this.buffer.getIntegerProperty("collapseFolds", 0);
                    if (collapseFolds != 0) {
                        this.displayManager.expandFolds(collapseFolds);
                        this.displayManager.expandFold(this.caretLine, false);
                    } else {
                        this.displayManager.expandAllFolds();
                    }
                } else {
                    this.displayManager.expandFold(this.caretLine, false);
                }
            }
            this.scrollToCaret(this.queuedScrollToElectric);
            this.updateBracketHighlightWithDelay();
            if (this.queuedFireCaretEvent) {
                this.fireCaretEvent();
            }
        }
        finally {
            this.queuedFireCaretEvent = false;
            this.queuedScrollToElectric = false;
            this.queuedCaretUpdate = false;
        }
    }

    int[] getSelectionStartAndEnd(int screenLine, int physicalLine, Selection s) {
        int x2;
        int x1;
        int start = this.getScreenLineStartOffset(screenLine);
        int end = this.getScreenLineEndOffset(screenLine);
        if (end <= s.start || start > s.end) {
            return null;
        }
        int selStartScreenLine = this.displayManager.isLineVisible(s.startLine) ? this.getScreenLineOfOffset(s.start) : -1;
        int selEndScreenLine = this.displayManager.isLineVisible(s.endLine) ? this.getScreenLineOfOffset(s.end) : -1;
        int lineStart = this.buffer.getLineStartOffset(physicalLine);
        if (s instanceof Selection.Rect) {
            start -= lineStart;
            end -= lineStart;
            Selection.Rect rect = (Selection.Rect)s;
            int _start = rect.getStartColumn(this.buffer);
            int _end = rect.getEndColumn(this.buffer);
            int lineLen = this.buffer.getLineLength(physicalLine);
            int[] total = new int[1];
            int rectStart = this.buffer.getOffsetOfVirtualColumn(physicalLine, _start, total);
            if (rectStart == -1) {
                x1 = (_start - total[0]) * this.charWidth;
                rectStart = lineLen;
            } else {
                x1 = 0;
            }
            int rectEnd = this.buffer.getOffsetOfVirtualColumn(physicalLine, _end, total);
            if (rectEnd == -1) {
                x2 = (_end - total[0]) * this.charWidth;
                rectEnd = lineLen;
            } else {
                x2 = 0;
            }
            if (end <= rectStart || start > rectEnd) {
                return null;
            }
            x1 = rectStart < start ? 0 : x1 + this.offsetToXY((int)physicalLine, (int)rectStart, (Point)this.returnValue).x;
            x2 = rectEnd > end ? this.getWidth() : x2 + this.offsetToXY((int)physicalLine, (int)rectEnd, (Point)this.returnValue).x;
        } else if (selStartScreenLine == selEndScreenLine && selStartScreenLine != -1) {
            x1 = this.offsetToXY((int)physicalLine, (int)(s.start - lineStart), (Point)this.returnValue).x;
            x2 = this.offsetToXY((int)physicalLine, (int)(s.end - lineStart), (Point)this.returnValue).x;
        } else if (screenLine == selStartScreenLine) {
            x1 = this.offsetToXY((int)physicalLine, (int)(s.start - lineStart), (Point)this.returnValue).x;
            x2 = this.getWidth();
        } else if (screenLine == selEndScreenLine) {
            x1 = 0;
            x2 = this.offsetToXY((int)physicalLine, (int)(s.end - lineStart), (Point)this.returnValue).x;
        } else {
            x1 = 0;
            x2 = this.getWidth();
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (x2 < 0) {
            x2 = 0;
        }
        if (x1 == x2) {
            // empty if block
        }
        return new int[]{x1, ++x2};
    }

    boolean insideSelection(int x, int y) {
        int offset = this.xyToOffset(x, y);
        Selection s = this.getSelectionAtOffset(offset);
        if (s == null) {
            return false;
        }
        int screenLine = this.getScreenLineOfOffset(offset);
        if (screenLine == -1) {
            return false;
        }
        int[] selectionStartAndEnd = this.getSelectionStartAndEnd(screenLine, this.buffer.getLineOfOffset(offset), s);
        if (selectionStartAndEnd == null) {
            return false;
        }
        return x >= selectionStartAndEnd[0] && x <= selectionStartAndEnd[1];
    }

    private void startDragAndDrop(InputEvent evt, boolean copy) {
        try {
            this.dndCallback.invoke(null, this, evt, new Boolean(copy));
        }
        catch (Exception e) {
            Log.log(9, this, e);
        }
    }

    private void _addToSelection(Selection addMe) {
        if (addMe.start > addMe.end) {
            throw new IllegalArgumentException(addMe.start + " > " + addMe.end);
        }
        if (addMe.start == addMe.end) {
            if (addMe instanceof Selection.Range) {
                return;
            }
            if (addMe instanceof Selection.Rect && ((Selection.Rect)addMe).extraEndVirt == 0) {
                return;
            }
        }
        for (int i = 0; i < this.selection.size(); ++i) {
            Selection s = (Selection)this.selection.elementAt(i);
            if (!s.overlaps(addMe)) continue;
            addMe.start = Math.min(s.start, addMe.start);
            addMe.end = Math.max(s.end, addMe.end);
            this.selection.removeElement(s);
            --i;
        }
        addMe.startLine = this.getLineOfOffset(addMe.start);
        addMe.endLine = this.getLineOfOffset(addMe.end);
        boolean added = false;
        for (int i = 0; i < this.selection.size(); ++i) {
            Selection s = (Selection)this.selection.elementAt(i);
            if (addMe.start >= s.start) continue;
            this.selection.insertElementAt(addMe, i);
            added = true;
            break;
        }
        if (!added) {
            this.selection.addElement(addMe);
        }
        this.invalidateLineRange(addMe.startLine, addMe.endLine);
    }

    private void finishCaretUpdate(boolean doElectricScroll, boolean fireCaretEvent) {
        this.queuedScrollToElectric |= doElectricScroll;
        this.queuedFireCaretEvent |= fireCaretEvent;
        if (this.queuedCaretUpdate) {
            return;
        }
        this.queuedCaretUpdate = true;
        if (!this.buffer.isTransactionInProgress()) {
            this._finishCaretUpdate();
        }
    }

    private void fireCaretEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; --i) {
            if (listeners[i] != (class$javax$swing$event$CaretListener == null ? JEditTextArea.class$("javax.swing.event.CaretListener") : class$javax$swing$event$CaretListener)) continue;
            try {
                ((CaretListener)listeners[i + 1]).caretUpdate(this.caretEvent);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, t);
            }
        }
    }

    private void fireScrollEvent(boolean vertical) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; --i) {
            if (listeners[i] != (class$org$gjt$sp$jedit$textarea$ScrollListener == null ? JEditTextArea.class$("org.gjt.sp.jedit.textarea.ScrollListener") : class$org$gjt$sp$jedit$textarea$ScrollListener)) continue;
            try {
                if (vertical) {
                    ((ScrollListener)listeners[i + 1]).scrolledVertically(this);
                    continue;
                }
                ((ScrollListener)listeners[i + 1]).scrolledHorizontally(this);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, t);
            }
        }
    }

    private void insertTab() {
        int tabSize = this.buffer.getTabSize();
        if (this.buffer.getBooleanProperty("noTabs")) {
            int lineStart = this.getLineStartOffset(this.caretLine);
            String line = this.getText(lineStart, this.caret - lineStart);
            int pos = 0;
            block3: for (int i = 0; i < line.length(); ++i) {
                switch (line.charAt(pos)) {
                    case '\t': {
                        pos = 0;
                        continue block3;
                    }
                    default: {
                        if (++pos < tabSize) continue block3;
                        pos = 0;
                    }
                }
            }
            this.setSelectedText(MiscUtilities.createWhiteSpace(tabSize - pos, 0));
        } else {
            this.setSelectedText("\t");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean doWordWrap(boolean spaceInserted) {
        void var12_13;
        boolean returnValue;
        int insertNewLineAt;
        int caretPos;
        if (!this.hardWrap || this.maxLineLen <= 0) {
            return false;
        }
        this.buffer.getLineText(this.caretLine, this.lineSegment);
        int start = this.getLineStartOffset(this.caretLine);
        int end = this.getLineEndOffset(this.caretLine);
        int len = end - start - 1;
        for (int i = caretPos = this.caret - start; i < len; ++i) {
            char ch = this.lineSegment.array[this.lineSegment.offset + i];
            if (ch == ' ' || ch == '\t') continue;
            return false;
        }
        int tabSize = this.buffer.getTabSize();
        String wordBreakChars = this.buffer.getStringProperty("wordBreakChars");
        int lastInLine = 0;
        int logicalLength = 0;
        int lastWordOffset = -1;
        boolean lastWasSpace = true;
        for (int i = 0; i < caretPos; ++i) {
            char ch = this.lineSegment.array[this.lineSegment.offset + i];
            if (ch == '\t') {
                logicalLength += tabSize - logicalLength % tabSize;
                if (lastWasSpace || logicalLength > this.maxLineLen) continue;
                lastInLine = i;
                lastWordOffset = i;
                lastWasSpace = true;
                continue;
            }
            if (ch == ' ') {
                if (lastWasSpace || ++logicalLength > this.maxLineLen + 1) continue;
                lastInLine = i;
                lastWordOffset = i;
                lastWasSpace = true;
                continue;
            }
            if (wordBreakChars != null && wordBreakChars.indexOf(ch) != -1) {
                if (lastWasSpace || ++logicalLength > this.maxLineLen) continue;
                lastInLine = i;
                lastWordOffset = i;
                lastWasSpace = true;
                continue;
            }
            lastInLine = i;
            ++logicalLength;
            lastWasSpace = false;
        }
        if (spaceInserted && logicalLength == this.maxLineLen && lastInLine == caretPos - 1) {
            insertNewLineAt = caretPos;
            returnValue = true;
        } else if (logicalLength >= this.maxLineLen && lastWordOffset != -1) {
            insertNewLineAt = lastWordOffset;
            returnValue = false;
        } else {
            return false;
        }
        try {
            void var13_14;
            this.buffer.beginCompoundEdit();
            this.buffer.insert(start + var13_14, "\n");
            this.buffer.indentLine(this.caretLine, true);
        }
        finally {
            this.buffer.endCompoundEdit();
        }
        return (boolean)var12_13;
    }

    private void doWordCount(View view, String text) {
        char[] chars = text.toCharArray();
        int characters = chars.length;
        int words = characters == 0 ? 0 : 1;
        int lines = 1;
        boolean word = false;
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\n': 
                case '\r': {
                    ++lines;
                }
                case '\t': 
                case ' ': {
                    if (!word) continue block4;
                    ++words;
                    word = false;
                    continue block4;
                }
                default: {
                    word = true;
                }
            }
        }
        if (!word) {
            --words;
        }
        Object[] args = new Object[]{new Integer(characters), new Integer(words), new Integer(lines)};
        GUIUtilities.message(view, "wordcount", args);
    }

    private void updateBracketHighlightWithDelay() {
        structureTimer.stop();
        structureTimer.start();
    }

    private void updateStructureHighlight() {
        if (!this.painter.isStructureHighlightEnabled() && !this.gutter.isStructureHighlightEnabled()) {
            return;
        }
        Iterator iter = this.structureMatchers.iterator();
        while (iter.hasNext()) {
            StructureMatcher matcher = (StructureMatcher)iter.next();
            this.match = matcher.getMatch(this);
            if (this.match == null) continue;
            break;
        }
        if (this.match != null) {
            if (this.caretLine < this.match.startLine) {
                this.invalidateLineRange(this.caretLine, this.match.endLine);
            } else {
                this.invalidateLineRange(this.match.startLine, this.caretLine);
            }
            if (!this.displayManager.isLineVisible(this.match.startLine) || this.chunkCache.getScreenLineOfOffset(this.match.startLine, this.match.start - this.getLineStartOffset(this.match.startLine)) == -1) {
                this.showStructureStatusMessage(this.match.startLine < this.caretLine);
            }
        }
    }

    private void showStructureStatusMessage(boolean backward) {
        String text = this.buffer.getLineText(this.match.startLine).trim();
        if (backward && this.match.startLine != 0 && text.length() == 1) {
            switch (text.charAt(0)) {
                case '(': 
                case ')': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    text = this.buffer.getLineText(this.match.startLine - 1).trim() + " " + text;
                }
            }
        }
        text = text.replace('\t', ' ');
        this.view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.bracket", new Object[]{new Integer(this.match.startLine + 1), text}));
    }

    void recalculateLastPhysicalLine() {
        int oldScreenLastLine = this.screenLastLine;
        for (int i = this.visibleLines - 1; i >= 0; --i) {
            ChunkCache.LineInfo info = this.chunkCache.getLineInfo(i);
            if (info.physicalLine == -1) continue;
            this.physLastLine = info.physicalLine;
            this.screenLastLine = i;
            break;
        }
        this.invalidateScreenLineRange(oldScreenLastLine, this.screenLastLine);
    }

    /*
     * WARNING - void declaration
     */
    private RectParams getRectParams(int caret, int newCaret) {
        void var4_4;
        int virtualWidth;
        Selection s = this.getSelectionAtOffset(caret);
        if (s instanceof Selection.Rect) {
            virtualWidth = caret == s.end ? this.buffer.getVirtualWidth(s.endLine, s.end - this.getLineStartOffset(s.endLine)) + ((Selection.Rect)s).extraEndVirt : this.buffer.getVirtualWidth(s.startLine, s.start - this.getLineStartOffset(s.startLine)) + ((Selection.Rect)s).extraStartVirt;
        } else if (this.rectangularSelectionMode) {
            virtualWidth = this.buffer.getVirtualWidth(this.caretLine, caret - this.buffer.getLineStartOffset(this.caretLine));
        } else {
            return null;
        }
        int newLine = this.getLineOfOffset(newCaret);
        int[] totalVirtualWidth = new int[1];
        int newOffset = this.buffer.getOffsetOfVirtualColumn(newLine, (int)var4_4, totalVirtualWidth);
        if (newOffset == -1) {
            void extraVirt = var4_4 - totalVirtualWidth[0];
            newCaret = this.getLineEndOffset(newLine) - 1;
            boolean bias = s == null ? newCaret < caret : (s.start == caret ? newCaret <= s.end : (s.end == caret ? newCaret <= s.start : false));
            RectParams returnValue = bias ? new RectParams((int)extraVirt, 0, newCaret) : new RectParams(0, (int)extraVirt, newCaret);
            return returnValue;
        }
        return new RectParams(0, 0, this.getLineStartOffset(newLine) + newOffset);
    }

    private void delete(boolean forward) {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.selection.size() != 0) {
            Selection[] selections = this.getSelection();
            for (int i = 0; i < selections.length; ++i) {
                Selection s = selections[i];
                if (s instanceof Selection.Rect) {
                    Selection.Rect r = (Selection.Rect)s;
                    int startColumn = r.getStartColumn(this.buffer);
                    if (startColumn == r.getEndColumn(this.buffer)) {
                        if (!forward && startColumn == 0) {
                            this.getToolkit().beep();
                            continue;
                        }
                        this.tallCaretDelete(r, forward);
                        continue;
                    }
                    this.setSelectedText(s, null);
                    continue;
                }
                this.setSelectedText(s, null);
            }
        } else if (forward) {
            if (this.caret == this.buffer.getLength()) {
                this.getToolkit().beep();
                return;
            }
            this.buffer.remove(this.caret, 1);
        } else {
            if (this.caret == 0) {
                this.getToolkit().beep();
                return;
            }
            this.buffer.remove(this.caret - 1, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tallCaretDelete(Selection.Rect s, boolean forward) {
        try {
            this.buffer.beginCompoundEdit();
            int[] width = new int[1];
            int startCol = s.getStartColumn(this.buffer);
            int startLine = s.startLine;
            int endLine = s.endLine;
            for (int i = startLine; i <= endLine; ++i) {
                int offset = this.buffer.getOffsetOfVirtualColumn(i, startCol, width);
                if (offset == -1) {
                    if (width[0] == startCol) {
                        offset = this.getLineLength(i);
                    } else {
                        if (i != startLine || forward) continue;
                        this.shiftTallCaretLeft(s);
                        continue;
                    }
                }
                offset += this.buffer.getLineStartOffset(i);
                if (forward) {
                    if (offset == this.buffer.getLineEndOffset(i) - 1) continue;
                    this.buffer.remove(offset, 1);
                    continue;
                }
                this.buffer.remove(offset - 1, 1);
            }
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    private void shiftTallCaretLeft(Selection.Rect s) {
        this.removeFromSelection(s);
        this.addToSelection(new Selection.Rect(this.buffer, s.getStartLine(), s.getStartColumn(this.buffer) - 1, s.getEndLine(), s.getEndColumn(this.buffer) - 1));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        caretTimer.setInitialDelay(500);
        caretTimer.start();
        structureTimer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (focusedComponent != null) {
                    focusedComponent.updateStructureHighlight();
                }
            }
        });
        structureTimer.setInitialDelay(100);
        structureTimer.setRepeats(false);
    }

    class MouseHandler
    extends MouseInputAdapter {
        private int dragStartLine;
        private int dragStartOffset;
        private int dragStart;
        private int clickCount;
        private boolean dragged;
        private boolean quickCopyDrag;
        private boolean clearStatus;
        private boolean control;
        private boolean maybeDragAndDrop;

        MouseHandler() {
        }

        public void mousePressed(MouseEvent evt) {
            this.control = OperatingSystem.isMacOS() && evt.isMetaDown() || !OperatingSystem.isMacOS() && evt.isControlDown();
            JEditTextArea.this.view.getInputHandler().resetLastActionCount();
            boolean bl = this.quickCopyDrag = JEditTextArea.this.isQuickCopyEnabled() && GUIUtilities.isMiddleButton(evt.getModifiers());
            if (!this.quickCopyDrag) {
                JEditTextArea.this.requestFocus();
                focusedComponent = JEditTextArea.this;
            }
            if (!JEditTextArea.this.buffer.isLoaded()) {
                return;
            }
            int x = evt.getX();
            int y = evt.getY();
            this.dragStart = JEditTextArea.this.xyToOffset(x, y, !JEditTextArea.this.painter.isBlockCaretEnabled() && !JEditTextArea.this.isOverwriteEnabled());
            this.dragStartLine = JEditTextArea.this.getLineOfOffset(this.dragStart);
            this.dragStartOffset = this.dragStart - JEditTextArea.this.getLineStartOffset(this.dragStartLine);
            if (GUIUtilities.isPopupTrigger(evt) && JEditTextArea.this.popup != null) {
                if (JEditTextArea.this.popupEnabled) {
                    JEditTextArea.this.handlePopupTrigger(evt);
                }
                return;
            }
            this.dragged = false;
            JEditTextArea.this.blink = true;
            JEditTextArea.this.invalidateLine(JEditTextArea.this.caretLine);
            this.clickCount = evt.getClickCount();
            if (JEditTextArea.this.isDragEnabled() && JEditTextArea.this.getDragAndDropCallback() != null && JEditTextArea.this.insideSelection(x, y) && this.clickCount == 1 && !evt.isShiftDown()) {
                this.maybeDragAndDrop = true;
                JEditTextArea.this.moveCaretPosition(this.dragStart, false);
                return;
            }
            this.maybeDragAndDrop = false;
            switch (this.clickCount) {
                case 1: {
                    this.doSingleClick(evt);
                    break;
                }
                case 2: {
                    this.doDoubleClick();
                    break;
                }
                default: {
                    this.doTripleClick();
                }
            }
        }

        private void doSingleClick(MouseEvent evt) {
            float dragStartLineWidth;
            int x = evt.getX();
            int extraEndVirt = 0;
            if (JEditTextArea.this.chunkCache.getLineInfo((int)((JEditTextArea)JEditTextArea.this).screenLastLine).lastSubregion && (float)x > (dragStartLineWidth = (float)JEditTextArea.this.offsetToXY((int)this.dragStartLine, (int)JEditTextArea.this.getLineLength((int)this.dragStartLine), (Point)JEditTextArea.this.returnValue).x)) {
                extraEndVirt = (int)(((float)x - dragStartLineWidth) / (float)JEditTextArea.this.charWidth);
                if (!JEditTextArea.this.getPainter().isBlockCaretEnabled() && !JEditTextArea.this.isOverwriteEnabled() && (x - JEditTextArea.this.getHorizontalOffset()) % JEditTextArea.this.charWidth > JEditTextArea.this.charWidth / 2) {
                    ++extraEndVirt;
                }
            }
            if (this.control || JEditTextArea.this.isRectangularSelectionEnabled()) {
                int screenLine = evt.getY() / JEditTextArea.this.getPainter().getFontMetrics().getHeight();
                if (screenLine > JEditTextArea.this.screenLastLine) {
                    screenLine = JEditTextArea.this.screenLastLine;
                }
                ChunkCache.LineInfo info = JEditTextArea.this.chunkCache.getLineInfo(screenLine);
                if (info.lastSubregion && extraEndVirt != 0) {
                    if (!JEditTextArea.this.isEditable()) {
                        JEditTextArea.this.getToolkit().beep();
                        return;
                    }
                    String whitespace = MiscUtilities.createWhiteSpace(extraEndVirt, 0);
                    JEditTextArea.this.buffer.insert(this.dragStart, whitespace);
                    this.dragStart += whitespace.length();
                }
            }
            if (evt.isShiftDown()) {
                JEditTextArea.this.resizeSelection(JEditTextArea.this.getMarkPosition(), this.dragStart, extraEndVirt, JEditTextArea.this.isRectangularSelectionEnabled() || this.control);
                if (!this.quickCopyDrag) {
                    JEditTextArea.this.moveCaretPosition(this.dragStart, false);
                }
                this.dragStartLine = JEditTextArea.this.getMarkLine();
                this.dragStart = JEditTextArea.this.getMarkPosition();
                this.dragStartOffset = this.dragStart - JEditTextArea.this.getLineStartOffset(this.dragStartLine);
                this.dragged = true;
                return;
            }
            if (!this.quickCopyDrag) {
                JEditTextArea.this.moveCaretPosition(this.dragStart, false);
            }
            if (!JEditTextArea.this.multi && !this.quickCopyDrag) {
                JEditTextArea.this.selectNone();
            }
        }

        private void doDoubleClick() {
            if (JEditTextArea.this.getLineLength(this.dragStartLine) == 0) {
                return;
            }
            String lineText = JEditTextArea.this.getLineText(this.dragStartLine);
            String noWordSep = JEditTextArea.this.buffer.getStringProperty("noWordSep");
            if (this.dragStartOffset == JEditTextArea.this.getLineLength(this.dragStartLine)) {
                --this.dragStartOffset;
            }
            boolean joinNonWordChars = jEdit.getBooleanProperty("view.joinNonWordChars");
            int wordStart = TextUtilities.findWordStart(lineText, this.dragStartOffset, noWordSep, joinNonWordChars);
            int wordEnd = TextUtilities.findWordEnd(lineText, this.dragStartOffset + 1, noWordSep, joinNonWordChars);
            int lineStart = JEditTextArea.this.getLineStartOffset(this.dragStartLine);
            Selection.Range sel = new Selection.Range(lineStart + wordStart, lineStart + wordEnd);
            if (JEditTextArea.this.isMultipleSelectionEnabled()) {
                JEditTextArea.this.addToSelection(sel);
            } else {
                JEditTextArea.this.setSelection(sel);
            }
            if (this.quickCopyDrag) {
                this.quickCopyDrag = false;
            }
            JEditTextArea.this.moveCaretPosition(lineStart + wordEnd, false);
            this.dragged = true;
        }

        private void doTripleClick() {
            int newCaret = JEditTextArea.this.getLineEndOffset(this.dragStartLine);
            if (this.dragStartLine == JEditTextArea.this.buffer.getLineCount() - 1) {
                --newCaret;
            }
            Selection.Range sel = new Selection.Range(JEditTextArea.this.getLineStartOffset(this.dragStartLine), newCaret);
            if (JEditTextArea.this.isMultipleSelectionEnabled()) {
                JEditTextArea.this.addToSelection(sel);
            } else {
                JEditTextArea.this.setSelection(sel);
            }
            if (this.quickCopyDrag) {
                this.quickCopyDrag = false;
            }
            JEditTextArea.this.moveCaretPosition(newCaret, false);
            this.dragged = true;
        }

        public void mouseDragged(MouseEvent evt) {
            if (this.maybeDragAndDrop) {
                JEditTextArea.this.startDragAndDrop(evt, this.control);
                return;
            }
            if (JEditTextArea.this.dndInProgress) {
                return;
            }
            if (GUIUtilities.isPopupTrigger(evt) || JEditTextArea.this.popup != null && JEditTextArea.this.popup.isVisible()) {
                return;
            }
            if (!JEditTextArea.this.buffer.isLoaded()) {
                return;
            }
            if (evt.getY() < 0) {
                int delta = Math.min(-1, evt.getY() / JEditTextArea.this.painter.getFontMetrics().getHeight());
                JEditTextArea.this.setFirstLine(JEditTextArea.this.getFirstLine() + delta);
            } else if (evt.getY() >= JEditTextArea.this.painter.getHeight()) {
                int delta = Math.max(1, (evt.getY() - JEditTextArea.this.painter.getHeight()) / JEditTextArea.this.painter.getFontMetrics().getHeight());
                if (JEditTextArea.this.lastLinePartial) {
                    --delta;
                }
                JEditTextArea.this.setFirstLine(JEditTextArea.this.getFirstLine() + delta);
            }
            if (this.quickCopyDrag) {
                JEditTextArea.this.view.getStatus().setMessage(jEdit.getProperty("view.status.rect-quick-copy"));
                this.clearStatus = true;
            }
            switch (this.clickCount) {
                case 1: {
                    this.doSingleDrag(evt);
                    break;
                }
                case 2: {
                    this.doDoubleDrag(evt);
                    break;
                }
                default: {
                    this.doTripleDrag(evt);
                }
            }
        }

        private void doSingleDrag(MouseEvent evt) {
            float dotLineWidth;
            this.dragged = true;
            int x = evt.getX();
            int y = evt.getY();
            if (y < 0) {
                y = 0;
            } else if (y >= JEditTextArea.this.painter.getHeight()) {
                y = JEditTextArea.this.painter.getHeight() - 1;
            }
            int dot = JEditTextArea.this.xyToOffset(x, y, !JEditTextArea.this.painter.isBlockCaretEnabled() && !JEditTextArea.this.isOverwriteEnabled() || this.quickCopyDrag);
            int dotLine = JEditTextArea.this.buffer.getLineOfOffset(dot);
            int extraEndVirt = 0;
            if (JEditTextArea.this.chunkCache.getLineInfo((int)((JEditTextArea)JEditTextArea.this).screenLastLine).lastSubregion && (float)x > (dotLineWidth = (float)JEditTextArea.this.offsetToXY((int)dotLine, (int)JEditTextArea.this.getLineLength((int)dotLine), (Point)JEditTextArea.this.returnValue).x)) {
                extraEndVirt = (int)(((float)x - dotLineWidth) / (float)JEditTextArea.this.charWidth);
                if (!JEditTextArea.this.getPainter().isBlockCaretEnabled() && !JEditTextArea.this.isOverwriteEnabled() && (x - JEditTextArea.this.getHorizontalOffset()) % JEditTextArea.this.charWidth > JEditTextArea.this.charWidth / 2) {
                    ++extraEndVirt;
                }
            }
            JEditTextArea.this.resizeSelection(this.dragStart, dot, extraEndVirt, JEditTextArea.this.isRectangularSelectionEnabled() || this.control);
            if (this.quickCopyDrag) {
                JEditTextArea.this.scrollTo(dotLine, dot - JEditTextArea.this.buffer.getLineStartOffset(dotLine), false);
            } else {
                if (dot != JEditTextArea.this.caret) {
                    JEditTextArea.this.moveCaretPosition(dot, false);
                }
                if (JEditTextArea.this.isRectangularSelectionEnabled() && extraEndVirt != 0) {
                    JEditTextArea.this.scrollTo(dotLine, dot - JEditTextArea.this.buffer.getLineStartOffset(dotLine) + extraEndVirt, false);
                }
            }
        }

        private void doDoubleDrag(MouseEvent evt) {
            int markLineStart = JEditTextArea.this.getLineStartOffset(this.dragStartLine);
            int markLineLength = JEditTextArea.this.getLineLength(this.dragStartLine);
            int mark = this.dragStartOffset;
            int pos = JEditTextArea.this.xyToOffset(evt.getX(), Math.max(0, Math.min(JEditTextArea.this.painter.getHeight(), evt.getY())), !JEditTextArea.this.painter.isBlockCaretEnabled() && !JEditTextArea.this.isOverwriteEnabled());
            int line = JEditTextArea.this.getLineOfOffset(pos);
            int lineStart = JEditTextArea.this.getLineStartOffset(line);
            int lineLength = JEditTextArea.this.getLineLength(line);
            int offset = pos - lineStart;
            String lineText = JEditTextArea.this.getLineText(line);
            String markLineText = JEditTextArea.this.getLineText(this.dragStartLine);
            String noWordSep = JEditTextArea.this.buffer.getStringProperty("noWordSep");
            boolean joinNonWordChars = jEdit.getBooleanProperty("view.joinNonWordChars");
            if (markLineStart + this.dragStartOffset > lineStart + offset) {
                if (offset != 0 && offset != lineLength) {
                    offset = TextUtilities.findWordStart(lineText, offset, noWordSep, joinNonWordChars);
                }
                if (markLineLength != 0) {
                    mark = TextUtilities.findWordEnd(markLineText, mark, noWordSep, joinNonWordChars);
                }
            } else {
                if (offset != 0 && lineLength != 0) {
                    offset = TextUtilities.findWordEnd(lineText, offset, noWordSep, joinNonWordChars);
                }
                if (mark != 0 && mark != markLineLength) {
                    mark = TextUtilities.findWordStart(markLineText, mark, noWordSep, joinNonWordChars);
                }
            }
            if (lineStart + offset == JEditTextArea.this.caret) {
                return;
            }
            JEditTextArea.this.resizeSelection(markLineStart + mark, lineStart + offset, 0, false);
            JEditTextArea.this.moveCaretPosition(lineStart + offset, false);
            this.dragged = true;
        }

        private void doTripleDrag(MouseEvent evt) {
            int mouse;
            int mark;
            int offset = JEditTextArea.this.xyToOffset(evt.getX(), Math.max(0, Math.min(JEditTextArea.this.painter.getHeight(), evt.getY())), false);
            int mouseLine = JEditTextArea.this.getLineOfOffset(offset);
            if (this.dragStartLine > mouseLine) {
                mark = JEditTextArea.this.getLineEndOffset(this.dragStartLine) - 1;
                mouse = offset == JEditTextArea.this.getLineEndOffset(mouseLine) - 1 ? offset : JEditTextArea.this.getLineStartOffset(mouseLine);
            } else {
                mark = JEditTextArea.this.getLineStartOffset(this.dragStartLine);
                mouse = offset == JEditTextArea.this.getLineStartOffset(mouseLine) ? offset : (offset == JEditTextArea.this.getLineEndOffset(mouseLine) - 1 && mouseLine != JEditTextArea.this.getBuffer().getLineCount() - 1 ? JEditTextArea.this.getLineEndOffset(mouseLine) : JEditTextArea.this.getLineEndOffset(mouseLine) - 1);
            }
            mouse = Math.min(JEditTextArea.this.getBuffer().getLength(), mouse);
            if (mouse == JEditTextArea.this.caret) {
                return;
            }
            JEditTextArea.this.resizeSelection(mark, mouse, 0, false);
            JEditTextArea.this.moveCaretPosition(mouse, false);
            this.dragged = true;
        }

        public void mouseReleased(MouseEvent evt) {
            Selection sel = JEditTextArea.this.getSelectionAtOffset(this.dragStart);
            if (this.dragged && sel != null) {
                Registers.setRegister('%', JEditTextArea.this.getSelectedText(sel));
                if (this.quickCopyDrag) {
                    JEditTextArea.this.removeFromSelection(sel);
                    Registers.paste(focusedComponent, '%', sel instanceof Selection.Rect);
                    focusedComponent.requestFocus();
                }
            } else if (!this.dragged && JEditTextArea.this.isQuickCopyEnabled() && GUIUtilities.isMiddleButton(evt.getModifiers())) {
                JEditTextArea.this.requestFocus();
                focusedComponent = JEditTextArea.this;
                JEditTextArea.this.setCaretPosition(this.dragStart, false);
                if (!JEditTextArea.this.isEditable()) {
                    JEditTextArea.this.getToolkit().beep();
                } else {
                    Registers.paste(JEditTextArea.this, '%', this.control);
                }
            } else if (this.maybeDragAndDrop && !JEditTextArea.this.isMultipleSelectionEnabled()) {
                JEditTextArea.this.selectNone();
            }
            this.dragged = false;
            if (this.clearStatus) {
                this.clearStatus = false;
                JEditTextArea.this.view.getStatus().setMessage(null);
            }
        }
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        public void focusGained(FocusEvent evt) {
            if (JEditTextArea.this.bufferChanging) {
                return;
            }
            if (JEditTextArea.this.match != null) {
                if (JEditTextArea.this.caretLine < ((JEditTextArea)JEditTextArea.this).match.startLine) {
                    JEditTextArea.this.invalidateLineRange(JEditTextArea.this.caretLine, ((JEditTextArea)JEditTextArea.this).match.endLine);
                } else {
                    JEditTextArea.this.invalidateLineRange(((JEditTextArea)JEditTextArea.this).match.startLine, JEditTextArea.this.caretLine);
                }
            } else {
                JEditTextArea.this.invalidateLine(JEditTextArea.this.caretLine);
            }
            focusedComponent = JEditTextArea.this;
        }

        public void focusLost(FocusEvent evt) {
            if (!JEditTextArea.this.isShowing()) {
                return;
            }
            if (JEditTextArea.this.match != null) {
                if (JEditTextArea.this.caretLine < ((JEditTextArea)JEditTextArea.this).match.startLine) {
                    JEditTextArea.this.invalidateLineRange(JEditTextArea.this.caretLine, ((JEditTextArea)JEditTextArea.this).match.endLine);
                } else {
                    JEditTextArea.this.invalidateLineRange(((JEditTextArea)JEditTextArea.this).match.startLine, JEditTextArea.this.caretLine);
                }
            } else {
                JEditTextArea.this.invalidateLine(JEditTextArea.this.caretLine);
            }
        }
    }

    class AdjustHandler
    implements AdjustmentListener {
        AdjustHandler() {
        }

        public void adjustmentValueChanged(AdjustmentEvent evt) {
            if (!JEditTextArea.this.scrollBarsInitialized) {
                return;
            }
            if (evt.getAdjustable() == JEditTextArea.this.vertical) {
                JEditTextArea.this.setFirstLine(JEditTextArea.this.vertical.getValue());
            } else {
                JEditTextArea.this.setHorizontalOffset(-JEditTextArea.this.horizontal.getValue());
            }
        }
    }

    class MutableCaretEvent
    extends CaretEvent {
        MutableCaretEvent() {
            super(JEditTextArea.this);
        }

        public int getDot() {
            return JEditTextArea.this.getCaretPosition();
        }

        public int getMark() {
            return JEditTextArea.this.getMarkPosition();
        }
    }

    static class CaretBlinker
    implements ActionListener {
        CaretBlinker() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (focusedComponent != null && focusedComponent.hasFocus()) {
                focusedComponent.blinkCaret();
            }
        }
    }

    class ScrollLayout
    implements LayoutManager {
        Component center;
        Component left;
        Component right;
        Component bottom;
        Component top;

        ScrollLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
            if (name.equals(JEditTextArea.CENTER)) {
                this.center = comp;
            } else if (name.equals(JEditTextArea.RIGHT)) {
                this.right = comp;
            } else if (name.equals(JEditTextArea.LEFT)) {
                this.left = comp;
            } else if (name.equals(JEditTextArea.BOTTOM)) {
                this.bottom = comp;
            } else if (name.equals(JEditTextArea.TOP)) {
                this.top = comp;
            }
        }

        public void removeLayoutComponent(Component comp) {
            if (this.center == comp) {
                this.center = null;
            } else if (this.right == comp) {
                this.right = null;
            } else if (this.left == comp) {
                this.left = null;
            } else if (this.bottom == comp) {
                this.bottom = null;
            } else if (this.top == comp) {
                this.top = null;
            }
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension();
            Border border = JEditTextArea.this.getBorder();
            Insets insets = border == null ? new Insets(0, 0, 0, 0) : JEditTextArea.this.getBorder().getBorderInsets(JEditTextArea.this);
            dim.width = insets.left + insets.right;
            dim.height = insets.top + insets.bottom;
            Dimension leftPref = this.left.getPreferredSize();
            dim.width += leftPref.width;
            Dimension centerPref = this.center.getPreferredSize();
            dim.width += centerPref.width;
            dim.height += centerPref.height;
            Dimension rightPref = this.right.getPreferredSize();
            dim.width += rightPref.width;
            Dimension bottomPref = this.bottom.getPreferredSize();
            dim.height += bottomPref.height;
            if (this.top != null) {
                Dimension topPref = this.top.getPreferredSize();
                dim.height += topPref.height;
            }
            return dim;
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = new Dimension();
            Border border = JEditTextArea.this.getBorder();
            Insets insets = border == null ? new Insets(0, 0, 0, 0) : JEditTextArea.this.getBorder().getBorderInsets(JEditTextArea.this);
            dim.width = insets.left + insets.right;
            dim.height = insets.top + insets.bottom;
            Dimension leftPref = this.left.getMinimumSize();
            dim.width += leftPref.width;
            Dimension centerPref = this.center.getMinimumSize();
            dim.width += centerPref.width;
            dim.height += centerPref.height;
            Dimension rightPref = this.right.getMinimumSize();
            dim.width += rightPref.width;
            Dimension bottomPref = this.bottom.getMinimumSize();
            dim.height += bottomPref.height;
            if (this.top != null) {
                Dimension topPref = this.top.getMinimumSize();
                dim.height += topPref.height;
            }
            return dim;
        }

        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            Border border = JEditTextArea.this.getBorder();
            Insets insets = border == null ? new Insets(0, 0, 0, 0) : JEditTextArea.this.getBorder().getBorderInsets(JEditTextArea.this);
            int itop = insets.top;
            int ileft = insets.left;
            int ibottom = insets.bottom;
            int iright = insets.right;
            int rightWidth = this.right.getPreferredSize().width;
            int leftWidth = this.left.getPreferredSize().width;
            int topHeight = this.top != null ? this.top.getPreferredSize().height : 0;
            int bottomHeight = this.bottom.getPreferredSize().height;
            int centerWidth = Math.max(0, size.width - leftWidth - rightWidth - ileft - iright);
            int centerHeight = Math.max(0, size.height - topHeight - bottomHeight - itop - ibottom);
            this.left.setBounds(ileft, itop + topHeight, leftWidth, centerHeight);
            this.center.setBounds(ileft + leftWidth, itop + topHeight, centerWidth, centerHeight);
            this.right.setBounds(ileft + leftWidth + centerWidth, itop + topHeight, rightWidth, centerHeight);
            this.bottom.setBounds(ileft, itop + topHeight + centerHeight, Math.max(0, size.width - JEditTextArea.this.vertical.getWidth() - ileft - iright), bottomHeight);
            if (this.top != null) {
                this.top.setBounds(ileft, itop, leftWidth + centerWidth + rightWidth, topHeight);
            }
        }
    }

    static class TextAreaBorder
    extends AbstractBorder {
        TextAreaBorder() {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawRect(0, 0, width - 2, height - 2);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(width - 1, 1, width - 1, height - 1);
            g.drawLine(1, height - 1, width - 1, height - 1);
            g.setColor(MetalLookAndFeel.getControl());
            g.drawLine(width - 2, 2, width - 2, 2);
            g.drawLine(1, height - 2, 1, height - 2);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 2, 2);
        }
    }

    static class RectParams {
        int extraStartVirt;
        int extraEndVirt;
        int newCaret;

        RectParams(int extraStartVirt, int extraEndVirt, int newCaret) {
            this.extraStartVirt = extraStartVirt;
            this.extraEndVirt = extraEndVirt;
            this.newCaret = newCaret;
        }
    }
}

