/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.Target;
import org.apache.axis.encoding.XMLType;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.httpd.ResourceHandler;
import org.astrogrid.samp.hub.BasicHubService;
import org.astrogrid.samp.hub.HubService;
import org.astrogrid.samp.xmlrpc.HubRunner;
import org.astrogrid.samp.xmlrpc.StandardClientProfile;
import org.astrogrid.samp.xmlrpc.XmlRpcKit;
import org.votech.plastic.PlasticHubListener;
import uk.ac.starlink.plastic.PlasticUtils;
import uk.ac.starlink.soap.util.RemoteUtilities;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.mode.ClientRegWatcher;
import uk.ac.starlink.ttools.mode.PlasticMode;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.mode.SampMode;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.VOTableWriter;
import uk.ac.starlink.votable.soap.VOTableSerialization;

public class TopcatMode
implements ProcessingMode {
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.tttools.mode");
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$uk$ac$starlink$table$StarTable;
    static /* synthetic */ Class class$java$lang$String;

    public Parameter[] getAssociatedParameters() {
        return new Parameter[0];
    }

    public String getDescription() {
        return DocUtils.join(new String[]{"<p>Attempts to display the output table directly in", "<webref url='http://www.starlink.ac.uk/topcat/'>TOPCAT</webref>.", "If a TOPCAT instance is already", "running on the local host, an attempt will be made to open", "the table in that.", "A variety of mechanisms are used to attempt communication", "with an existing TOPCAT instance.  In order:", "<ol>", "<li>SAMP using existing hub", " (TOPCAT v3.4+ only, requires SAMP hub to be running)</li>", "<li>PLASTIC using existing hub", " (requires PLASTIC hub to be running)</li>", "<li>SOAP", " (requires TOPCAT to run with somewhat deprecated", " <code>-soap</code> flag,", " may be limitations on table size)</li>", "<li>SAMP using internal, short-lived hub", " (TOPCAT v3.4+ only, running hub not required,", " but may be slow.  It's better to start an external hub,", " e.g. <code>topcat -exthub</code>)</li>", "</ol>", "Failing that, an attempt will be made to launch", "a new TOPCAT instance for display.", "This only works if the TOPCAT classes are on the class path.", "</p>", "<p>If large tables are involved, starting TOPCAT with the", "<code>-disk</code> flag is probably a good idea.", "</p>"});
    }

    public TableConsumer createConsumer(Environment env) {
        final StoragePolicy policy = LineTableEnvironment.getStoragePolicy(env);
        final PrintStream out = env.getOutputStream();
        return new TableConsumer(){

            public void consume(StarTable table) throws IOException {
                TopcatMode.this.toTopcat(table, policy, out);
            }
        };
    }

    private void toTopcat(StarTable table, StoragePolicy policy, PrintStream out) throws IOException {
        boolean done;
        String srcName = table.getName();
        if (srcName == null || srcName.trim().length() == 0) {
            srcName = "(stilts)";
        }
        if (!(done = false)) {
            try {
                logger_.info("Trying SAMP ...");
                this.sampDisplay(table);
                logger_.info("... sent via SAMP");
                done = true;
            }
            catch (IOException e) {
                logger_.info("... SAMP broadcast failed " + e);
            }
        }
        if (!done) {
            try {
                logger_.info("Trying PLASTIC ...");
                this.plasticDisplay(table, policy);
                logger_.info("... sent via PLASTIC");
                done = true;
            }
            catch (IOException e) {
                logger_.info("... PLASTIC broadcast failed " + e);
            }
        }
        if (!done) {
            try {
                logger_.info("Trying SOAP ...");
                this.soapDisplay(table, srcName);
                logger_.info("... sent via SOAP");
                done = true;
            }
            catch (ConnectException e) {
                logger_.info("... SOAP connection failed " + e);
            }
            catch (ServiceException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
            catch (Throwable e) {
                logger_.info("... SOAP connection failed " + e);
            }
        }
        if (!done) {
            try {
                logger_.info("Trying SAMP with short-lived internal hub ...");
                this.sampHubDisplay(table);
                logger_.info("... sent via SAMP with internal hub");
                logger_.warning("This would be more efficient with an external SAMP hub running.");
                done = true;
            }
            catch (IOException e) {
                logger_.info("... SAMP with internal hub failed " + e);
            }
        }
        if (!done) {
            try {
                logger_.info("Trying local JVM using reflection ...");
                table = Tables.randomTable((StarTable)table);
                this.internalDisplay(table, srcName);
                logger_.info("... loaded in local JVM");
                done = true;
            }
            catch (IOException e) {
                logger_.info("... TOPCAT startup failed " + e);
            }
        }
        if (!done) {
            out.println("Couldn't contact or start TOPCAT");
        }
    }

    private void plasticDisplay(StarTable table, StoragePolicy policy) throws IOException {
        PlasticHubListener hub = PlasticUtils.getLocalHub();
        URI plasticId = hub.registerNoCallBack("stilts");
        PlasticMode.broadcast(table, PlasticMode.MSG_BYURL, hub, plasticId, policy, "topcat", null);
    }

    private void sampDisplay(StarTable table) throws IOException {
        VOTableWriter vowriter = new VOTableWriter(DataFormat.BINARY, true);
        SampMode.TableTransmitter transmitter = new SampMode.TableTransmitter(new String[]{"votable"}, new StarTableWriter[]{vowriter}, table, "topcat", null);
        transmitter.run();
        transmitter.close();
    }

    private void sampHubDisplay(StarTable table) throws IOException {
        XmlRpcKit xmlrpc = XmlRpcKit.getInstance();
        HubRunner runner = new HubRunner(xmlrpc.getClientFactory(), xmlrpc.getServerFactory(), (HubService)new BasicHubService(new Random()), SampUtils.getLockFile());
        runner.start();
        HubConnection connection = new StandardClientProfile(xmlrpc).register();
        Metadata meta = SampMode.getStiltsMetadata();
        meta.setIconUrl(Stilts.class.getResource("images/stilts_icon.gif").toString());
        connection.declareMetadata((Map)meta);
        ClientRegWatcher tcWatcher = new ClientRegWatcher(connection);
        connection.setCallable((CallableClient)tcWatcher);
        connection.declareSubscriptions((Map)tcWatcher.getSubscriptions());
        String tcId = tcWatcher.waitForIdFromName("topcat", 5000L);
        if (tcId == null) {
            throw new IOException("No TOPCAT found");
        }
        HttpServer httpd = new HttpServer();
        httpd.setDaemon(true);
        ResourceHandler resHandler = new ResourceHandler(httpd, "table");
        httpd.addHandler((HttpServer.Handler)resHandler);
        Message msg = SampMode.createSendMessage(table, "votable", (StarTableWriter)new VOTableWriter(DataFormat.BINARY, true), resHandler);
        httpd.start();
        String msgTag = "table-send";
        connection.call(tcId, msgTag, (Map)msg);
        Response response = tcWatcher.waitForResponse(msgTag);
        connection.unregister();
        runner.shutdown();
        httpd.stop();
    }

    private void soapDisplay(StarTable table, String srcName) throws ConnectException, ServiceException, IOException {
        Object[] tcServ = RemoteUtilities.readContactFile((String)"topcat");
        if (tcServ == null) {
            throw new ConnectException("No contact file - looks like no TOPCAT server is running");
        }
        String host = (String)tcServ[0];
        int port = (Integer)tcServ[1];
        String cookie = (String)tcServ[2];
        String endpoint = "http://" + host + ":" + port + "/services/TopcatSOAPServices";
        Call call = (Call)new Service().createCall();
        call.setTargetEndpointAddress(endpoint);
        VOTableSerialization.configureCall((Call)call);
        call.setOperationName("displayTable");
        call.addParameter("cookie", XMLType.SOAP_STRING, ParameterMode.IN);
        call.addParameter("table", VOTableSerialization.QNAME_VOTABLE, ParameterMode.IN);
        call.addParameter("location", XMLType.SOAP_STRING, ParameterMode.IN);
        call.setReturnType(XMLType.AXIS_VOID);
        try {
            call.invoke(new Object[]{cookie, table, srcName});
        }
        catch (RemoteException e) {
            Throwable e2 = e.getCause();
            if (e2 instanceof ConnectException) {
                String msg = "Connection refused: TOPCAT server not running?";
                throw (ConnectException)new ConnectException(msg).initCause(e2);
            }
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalDisplay(StarTable randomTable, String srcName) throws IOException {
        TopcatLoader loader;
        try {
            loader = new TopcatLoader(randomTable, srcName, false);
        }
        catch (Throwable e) {
            throw (IOException)new IOException("TOPCAT classes not available").initCause(e);
        }
        try {
            TopcatLoader e = loader;
            synchronized (e) {
                SwingUtilities.invokeLater(loader);
                while (!loader.finished_) {
                    loader.wait();
                }
            }
            if (!loader.success_.booleanValue()) {
                Throwable error = loader.error_;
                if (error instanceof IOException) {
                    throw (IOException)error;
                }
                throw (IOException)new IOException("TOPCAT start/load failed").initCause(error);
            }
        }
        catch (InterruptedException e) {
            logger_.info("Interrupted waiting for table load");
        }
    }

    private static void checkRequisites() {
        RemoteUtilities.class.getName();
        Target.class.getName();
    }

    static {
        TopcatMode.checkRequisites();
    }

    static class TopcatLoader
    implements Runnable {
        private static Class driverClazz_;
        private static Class controlClazz_;
        private static Method main_;
        private static Method getControlWindow_;
        private static Method addTable_;
        private static Method setStandalone_;
        private final Object[] addTableArgs_;
        private Throwable error_;
        private Boolean success_;
        private boolean finished_;

        public TopcatLoader(StarTable randomTable, String srcName, boolean display) throws ClassNotFoundException, NoSuchMethodException {
            TopcatLoader.reflect();
            this.addTableArgs_ = new Object[]{randomTable, srcName, display};
        }

        public synchronized void run() {
            try {
                setStandalone_.invoke(null, Boolean.TRUE);
                main_.invoke(null, new Object[]{new String[]{"-plastic"}});
                Object controlWindow = getControlWindow_.invoke(null, new Object[0]);
                addTable_.invoke(controlWindow, this.addTableArgs_);
                this.success_ = Boolean.TRUE;
            }
            catch (InvocationTargetException e) {
                this.error_ = e.getCause();
                this.success_ = Boolean.FALSE;
            }
            catch (Throwable e) {
                this.error_ = e;
                this.success_ = Boolean.FALSE;
            }
            this.finished_ = true;
            this.notifyAll();
        }

        public static void reflect() throws ClassNotFoundException, NoSuchMethodException {
            driverClazz_ = Class.forName("uk.ac.starlink.topcat.Driver");
            controlClazz_ = Class.forName("uk.ac.starlink.topcat.ControlWindow");
            main_ = driverClazz_.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = TopcatMode.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            setStandalone_ = driverClazz_.getMethod("setStandalone", Boolean.TYPE);
            addTable_ = controlClazz_.getMethod("addTable", class$uk$ac$starlink$table$StarTable == null ? (class$uk$ac$starlink$table$StarTable = TopcatMode.class$("uk.ac.starlink.table.StarTable")) : class$uk$ac$starlink$table$StarTable, class$java$lang$String == null ? (class$java$lang$String = TopcatMode.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE);
            getControlWindow_ = controlClazz_.getMethod("getInstance", new Class[0]);
        }
    }
}

