/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Component;
import java.awt.Graphics;
import uk.ac.starlink.ttools.plot.DataColorTweaker;
import uk.ac.starlink.ttools.plot.Fogger;
import uk.ac.starlink.ttools.plot.MarkStyle;

public abstract class PlotVolume {
    private final Graphics graphics_;
    private final MarkStyle[] styles_;
    private final int scale_;
    private final int xoff_;
    private final int yoff_;
    private final Fogger fogger_;
    private final int width_;
    private final int height_;
    private static final float BYTE_SCALE = 255.99f;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected PlotVolume(Component c, Graphics g, MarkStyle[] styles, double padFactor, int[] padBorders, double fogginess) {
        this.graphics_ = g;
        this.styles_ = (MarkStyle[])styles.clone();
        int padLeft = padBorders[0];
        int padRight = padBorders[1];
        int padBottom = padBorders[2];
        int padTop = padBorders[3];
        int w = c.getWidth() - padLeft - padRight;
        int h = c.getHeight() - padBottom - padTop;
        this.width_ = c.getWidth();
        this.height_ = c.getHeight();
        this.scale_ = (int)Math.round((double)Math.min(h, w) / padFactor);
        this.xoff_ = 0 + (int)((double)(w - this.scale_) / 2.0) + padLeft;
        this.yoff_ = h - (int)((double)(h - this.scale_) / 2.0) + padTop;
        this.fogger_ = new Fogger(1.0);
        this.fogger_.setFogginess(fogginess);
    }

    public MarkStyle[] getStyles() {
        return this.styles_;
    }

    public int getScale() {
        return this.scale_;
    }

    public Fogger getFogger() {
        return this.fogger_;
    }

    public boolean plot3d(double[] centre, int istyle, boolean showPoint, String label, int nerr, double[] xerrs, double[] yerrs, double[] zerrs) {
        if (nerr == 0 && !showPoint && label == null) {
            return false;
        }
        int xp = this.projectX(centre[0]);
        int yp = this.projectY(centre[1]);
        double z = centre[2];
        int maxr = this.styles_[istyle].getMaximumRadius();
        if (xp - maxr < 0 || xp + maxr > this.width_ || yp - maxr < 0 || yp + maxr > this.height_) {
            return false;
        }
        if (nerr > 0) {
            int[] xoffs = new int[nerr];
            int[] yoffs = new int[nerr];
            for (int ierr = 0; ierr < nerr; ++ierr) {
                if (Double.isNaN(xerrs[ierr]) || Double.isNaN(yerrs[ierr])) {
                    xoffs[ierr] = 0;
                    yoffs[ierr] = 0;
                    continue;
                }
                xoffs[ierr] = this.projectX(xerrs[ierr]) - xp;
                yoffs[ierr] = this.projectY(yerrs[ierr]) - yp;
            }
            this.plot2d(xp, yp, z, centre, istyle, showPoint, label, nerr, xoffs, yoffs, zerrs);
            return true;
        }
        if (!$assertionsDisabled && !showPoint) {
            throw new AssertionError();
        }
        this.plot2d(xp, yp, z, centre, istyle, true, label, 0, null, null, null);
        return true;
    }

    public int projectX(double x) {
        double dx = (long)this.xoff_ + Math.round(x * (double)this.scale_);
        return (int)Math.max(-2.147483648E9, Math.min(2.147483647E9, dx));
    }

    public int projectY(double y) {
        double dy = (long)this.yoff_ - Math.round(y * (double)this.scale_);
        return (int)Math.max(-2.147483648E9, Math.min(2.147483647E9, dy));
    }

    protected abstract void plot2d(int var1, int var2, double var3, double[] var5, int var6, boolean var7, String var8, int var9, int[] var10, int[] var11, double[] var12);

    public abstract void flush();

    public Graphics getGraphics() {
        return this.graphics_;
    }

    public DataColorTweaker createFoggingTweaker(DataColorTweaker tweaker) {
        Fogger fogger = this.getFogger();
        if (fogger != null && fogger.getFogginess() > 0.0) {
            return tweaker == null ? fogger.createTweaker(2, 3) : fogger.createTweaker(2, tweaker);
        }
        return tweaker;
    }

    public static int packRgba(float[] rgba) {
        return ((int)(rgba[0] * 255.99f) & 0xFF) << 0 | ((int)(rgba[1] * 255.99f) & 0xFF) << 8 | ((int)(rgba[2] * 255.99f) & 0xFF) << 16 | ((int)(rgba[3] * 255.99f) & 0xFF) << 24;
    }

    public static void unpackRgba(int rgba, float[] buf) {
        buf[0] = (float)(rgba >> 0 & 0xFF) / 255.0f;
        buf[1] = (float)(rgba >> 8 & 0xFF) / 255.0f;
        buf[2] = (float)(rgba >> 16 & 0xFF) / 255.0f;
        buf[3] = (float)(rgba >> 24 & 0xFF) / 255.0f;
    }

    static {
        $assertionsDisabled = !PlotVolume.class.desiredAssertionStatus();
    }
}

