/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plottask;

import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.OutputStreamParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot.GraphicExporter;
import uk.ac.starlink.ttools.plottask.PaintMode;
import uk.ac.starlink.ttools.plottask.Painter;

public class PaintModeParameter
extends ChoiceParameter {
    private final OutputStreamParameter outParam_ = new OutputStreamParameter("out");
    private final ChoiceParameter formatParam_;
    private Painter painterValue_;

    public PaintModeParameter(String name) {
        super(name, (Object[])PaintMode.getKnownModes());
        this.outParam_.setPrompt("Output file for graphics");
        this.outParam_.setDefault(null);
        this.outParam_.setNullPermitted(false);
        Object[] exporters = PaintMode.getKnownExporters();
        this.formatParam_ = new ChoiceParameter("ofmt", exporters);
        this.formatParam_.setPrompt("Graphics format for plot output");
        StringBuffer fmtbuf = new StringBuffer().append("<p>Graphics format in which the plot is written to\n").append("the output file.\n").append("One of:\n").append("<ul>\n");
        for (int ie = 0; ie < exporters.length; ++ie) {
            Object exporter = exporters[ie];
            fmtbuf.append("<li><code>").append(((GraphicExporter)exporter).getName()).append("</code>: ").append(((GraphicExporter)exporter).getMimeType());
            String enc = ((GraphicExporter)exporter).getContentEncoding();
            if (enc != null) {
                fmtbuf.append(" (").append(enc).append(")");
            }
            fmtbuf.append(" format</li>").append("\n");
        }
        fmtbuf.append("</ul>\n").append("May default to a sensible value depending on the\n").append("filename given by ").append("<code>").append(this.outParam_.getName()).append("</code>.\n").append("</p>");
        this.formatParam_.setDescription(fmtbuf.toString());
        PaintMode[] modes = PaintMode.getKnownModes();
        StringBuffer modebuf = new StringBuffer().append("<p>Determines how the drawn plot will be output.\n").append("<ul>\n");
        for (int im = 0; im < modes.length; ++im) {
            PaintMode mode = modes[im];
            modebuf.append("<li><code>").append(mode.getName()).append("</code>:\n").append(mode.getDescription(this)).append("</li>").append("\n");
        }
        modebuf.append("</ul>\n").append("</p>");
        this.setDescription(modebuf.toString());
        this.setPrompt("Mode for graphical output");
        this.setDefault(PaintMode.DEFAULT_MODE.getName());
    }

    public OutputStreamParameter getOutputParameter() {
        return this.outParam_;
    }

    public ChoiceParameter getFormatParameter() {
        return this.formatParam_;
    }

    public void setValueFromString(Environment env, String stringVal) throws TaskException {
        super.setValueFromString(env, stringVal);
        PaintMode mode = (PaintMode)this.objectValue(env);
        this.painterValue_ = mode.createPainter(env, this);
    }

    public void setValueFromPainter(Painter painter) {
        this.painterValue_ = painter;
        this.setStringValue(painter.toString());
        this.setGotValue(true);
    }

    public Painter painterValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        return this.painterValue_;
    }
}

