/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.jxta.swing.TitleBar;
import net.jxta.swing.TitleBarListener;
import net.jxta.swing.VerticalLayout;

public class MultiSplitPane
extends JPanel {
    public static final int VERTICAL_SPLIT = 0;
    public static final int HORIZONTAL_SPLIT = 1;
    public static final int MINIMIZED_HEIGHT = 25;
    private ArrayList components = new ArrayList();
    private VerticalLayout layout = new VerticalLayout();
    private int orientation;
    private Color topColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
    private Color shadowColor = MetalLookAndFeel.getPrimaryControlShadow();

    public MultiSplitPane(int orientation) {
        this.setLayout(this.layout);
        this.orientation = orientation;
        if (orientation != 1) {
            throw new IllegalArgumentException("Only HORIZONTAL_SPLIT is supported at this time");
        }
    }

    private ComponentHolder getComponentHolder(Component dragBar) {
        int i = 0;
        while (i < this.components.size()) {
            Component component = (Component)this.components.get(i);
            if (component == dragBar) {
                return (ComponentHolder)this.components.get(i - 1);
            }
            ++i;
        }
        return null;
    }

    private ComponentHolder getComponentHolderForComponent(Component component) {
        int size = this.components.size();
        int i = 0;
        while (i < size) {
            Component c = (Component)this.components.get(i);
            if (c instanceof ComponentHolder) {
                ComponentHolder ch = (ComponentHolder)c;
                if (ch.component == component) {
                    return ch;
                }
            }
            ++i;
        }
        return null;
    }

    public int setHeight(Component component, int height) {
        int i = 0;
        while (i < this.components.size()) {
            Component comp = (Component)this.components.get(i);
            if (comp instanceof ComponentHolder) {
                ComponentHolder componentHolder = (ComponentHolder)comp;
                if (componentHolder.component == component) {
                    Dimension size = component.getMinimumSize();
                    if (size.height > height) {
                        height = size.height;
                    }
                    componentHolder.height = height;
                    return height;
                }
            }
            ++i;
        }
        return -1;
    }

    public void hideComponent(Component component) {
        component.setVisible(false);
        int i = 0;
        while (i < this.components.size()) {
            Component comp = (Component)this.components.get(i);
            if (comp instanceof ComponentHolder) {
                ComponentHolder componentHolder = (ComponentHolder)comp;
                if (componentHolder.component == component) {
                    componentHolder.restoreHeight = componentHolder.getSize().height;
                    componentHolder.height = 25;
                    DragBar dragBar = (DragBar)this.components.get(i + 1);
                    dragBar.setResizable(false);
                }
            }
            ++i;
        }
    }

    public void showComponent(Component component) {
        component.setVisible(true);
        int i = 0;
        while (i < this.components.size()) {
            Component comp = (Component)this.components.get(i);
            if (comp instanceof ComponentHolder) {
                ComponentHolder componentHolder = (ComponentHolder)comp;
                if (componentHolder.component == component) {
                    componentHolder.height = componentHolder.restoreHeight;
                    DragBar dragBar = (DragBar)this.components.get(i + 1);
                    dragBar.setResizable(true);
                }
            }
            ++i;
        }
    }

    public void removeComponent(Component component) {
        int i = 0;
        while (i < this.components.size()) {
            Component comp = (Component)this.components.get(i);
            if (comp instanceof ComponentHolder) {
                ComponentHolder componentHolder = (ComponentHolder)comp;
                if (componentHolder.component == component) {
                    this.remove(componentHolder);
                    DragBar dragBar = (DragBar)this.components.get(i + 1);
                    this.remove(dragBar);
                }
            }
            ++i;
        }
        this.validate();
        this.repaint();
    }

    public Component add(Component component) {
        ComponentHolder componentHolder = new ComponentHolder(component);
        DragBar dragBar = new DragBar(componentHolder);
        this.components.add(componentHolder);
        this.components.add(dragBar);
        super.add(componentHolder);
        super.add(dragBar);
        return componentHolder;
    }

    public Component getComponentAtIndex(int index) {
        ComponentHolder componentHolder = (ComponentHolder)this.components.get(index * 2);
        return componentHolder.component;
    }

    public String getTitle(Component component) {
        for (Component comp : this.components) {
            if (!(comp instanceof ComponentHolder)) continue;
            ComponentHolder componentHolder = (ComponentHolder)comp;
            if (component != componentHolder.component) continue;
            return componentHolder.getTitle();
        }
        return null;
    }

    public void setTitle(Component component, String title) {
        for (Component comp : this.components) {
            if (!(comp instanceof ComponentHolder)) continue;
            ComponentHolder componentHolder = (ComponentHolder)comp;
            if (component != componentHolder.component) continue;
            componentHolder.setTitle(title);
            return;
        }
    }

    public TitleBar getTitleBarForComponent(Component comp) {
        ComponentHolder ch = this.getComponentHolderForComponent(comp);
        if (ch == null) {
            return null;
        }
        return ch.titleBar;
    }

    public Component add(Component component, TitleBar titleBar) {
        ComponentHolder componentHolder = new ComponentHolder(component, titleBar);
        DragBar dragBar = new DragBar(componentHolder);
        this.components.add(componentHolder);
        this.components.add(dragBar);
        super.add(componentHolder);
        super.add(dragBar);
        return componentHolder;
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame("Test");
            frame.setDefaultCloseOperation(3);
            MultiSplitPane multiSplitPane = new MultiSplitPane(1);
            String[] samples = new String[]{"Sleepy", "Dopey", "Doc"};
            int i = 0;
            while (i < samples.length) {
                String label = samples[i];
                TitleBar titleBar = new TitleBar("Sample - " + label, true, false);
                final JButton button = new JButton(label);
                titleBar.addTitleBarListener(new TitleBarListener(){

                    public void minimize() {
                        MultiSplitPane.this.hideComponent(button);
                    }

                    public void restore() {
                        MultiSplitPane.this.showComponent(button);
                    }

                    public void maximize() {
                    }

                    public void closing() {
                        MultiSplitPane.this.removeComponent(button);
                    }

                    public void closed() {
                    }
                });
                multiSplitPane.add((Component)button, titleBar);
                ++i;
            }
            frame.getContentPane().setLayout(new GridLayout(1, 1));
            frame.getContentPane().add(new JScrollPane(multiSplitPane));
            frame.setSize(500, 500);
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ComponentHolder
    extends JPanel {
        TitleBar titleBar;
        Component component;
        int height;
        int restoreHeight;

        ComponentHolder(Component component) {
            super(new GridLayout(1, 1));
            this.component = component;
            this.height = component.getPreferredSize().height;
            this.add(component);
        }

        ComponentHolder(Component component, TitleBar titleBar) {
            super(new BorderLayout());
            this.component = component;
            this.titleBar = titleBar;
            this.height = component.getPreferredSize().height + titleBar.getPreferredSize().height;
            this.add("North", titleBar);
            this.add("Center", component);
        }

        void setTitle(String title) {
            if (this.titleBar != null) {
                this.titleBar.setTitle(title);
            }
        }

        String getTitle() {
            if (this.titleBar != null) {
                return this.titleBar.getTitle();
            }
            return null;
        }

        void setRestoreHeight(int restoreHeight) {
            this.restoreHeight = restoreHeight;
        }

        int getRealMinimumHeight() {
            return this.component.getMinimumSize().height;
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.component.getPreferredSize().width, this.height);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.component.getMinimumSize().width, this.height);
        }

        public Dimension getMaximumSize() {
            return new Dimension(this.component.getMaximumSize().width, this.height);
        }
    }

    private class DragBar
    extends Container {
        int dragHeight = 7;
        int dragWidth = 200;
        boolean dragging = false;
        int draggingFrom;
        int offset;
        int componentY;
        final ComponentHolder correspondingComponentHolder;
        boolean isResizable = true;
        MouseListener mouseListener;
        MouseMotionListener mouseMotionListener;

        DragBar(ComponentHolder componentHolder) {
            this.correspondingComponentHolder = componentHolder;
            if (MultiSplitPane.this.orientation == 1) {
                this.setCursor(Cursor.getPredefinedCursor(9));
            }
            this.mouseListener = new MouseAdapter(this){
                final /* synthetic */ DragBar this$1;
                {
                    this.this$1 = dragBar;
                }

                public void mousePressed(MouseEvent evt) {
                    this.this$1.dragging = true;
                    this.this$1.offset = evt.getY();
                    this.this$1.componentY = this.this$1.correspondingComponentHolder.getLocation().y;
                }

                public void mouseReleased(MouseEvent evt) {
                    this.this$1.dragging = false;
                }
            };
            this.addMouseListener(this.mouseListener);
            this.mouseMotionListener = new MouseMotionAdapter(this){
                final /* synthetic */ DragBar this$1;
                {
                    this.this$1 = dragBar;
                }

                public void mouseDragged(MouseEvent evt) {
                    int minimumHeight;
                    int y = evt.getY() + this.this$1.getLocation().y;
                    int newHeight = y - this.this$1.componentY - this.this$1.offset;
                    if (newHeight < (minimumHeight = this.this$1.correspondingComponentHolder.getRealMinimumHeight())) {
                        newHeight = minimumHeight;
                    }
                    this.this$1.correspondingComponentHolder.height = newHeight;
                    this.this$1.correspondingComponentHolder.invalidate();
                    DragBar.access$0(this.this$1).getParent().validate();
                    DragBar.access$0(this.this$1).getParent().repaint();
                }
            };
            this.addMouseMotionListener(this.mouseMotionListener);
        }

        public void setResizable(boolean resizable) {
            if (!resizable) {
                this.removeMouseListener(this.mouseListener);
                this.removeMouseMotionListener(this.mouseMotionListener);
            } else if (!this.isResizable) {
                this.addMouseListener(this.mouseListener);
                this.addMouseMotionListener(this.mouseMotionListener);
            }
            this.isResizable = resizable;
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.dragWidth, this.dragHeight);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.dragWidth, this.dragHeight);
        }

        public Dimension getMaximumSize() {
            return new Dimension(this.dragWidth, this.dragHeight);
        }

        public void paint(Graphics graphics) {
            Dimension size = this.getSize();
            int width = size.width;
            int height = size.height;
            graphics.setColor(UIManager.getColor("SplitPane.background"));
            graphics.fillRect(0, 0, width, height);
            graphics.setColor(UIManager.getColor("SplitPane.shadow"));
            int x1 = 0;
            int y1 = 1 * height / 4 + 1;
            int x2 = width;
            int y2 = 3 * height / 4;
            graphics.fillRect(x1, y1, x2 - x1, y2 - y1);
        }

        static /* synthetic */ MultiSplitPane access$0(DragBar dragBar) {
            return dragBar.MultiSplitPane.this;
        }
    }
}

