/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import net.jxta.swing.SortableTableColumnState;
import net.jxta.swing.SortableTableDescriptor;
import net.jxta.swing.SortableTableHeader;
import net.jxta.swing.SortableTableHeaderRenderer;
import net.jxta.swing.SortableTableModelFilter;
import net.jxta.swing.TableRow;
import net.jxta.swing.TruncatableJLabel;
import net.jxta.swing.UpdatableTableModel;

public class SortableTable
extends JTable {
    private UpdatableTableModel updatableTableModel;
    private SortableTableModelFilter sortableTableModelFilter;
    private SortableTableDescriptor sortableTableDescriptor;
    private SortableTableColumnState sortableTableColumnState;
    private int[] justifications;
    private int[] truncations;
    SortableTableCellRenderer myCellRenderer = new SortableTableCellRenderer();

    protected SortableTable() {
        JTableHeader header = this.getTableHeader();
        header.setDefaultRenderer(new SortableTableHeaderRenderer());
    }

    public SortableTable(SortableTableDescriptor sortableTableDescriptor) {
        this();
        String[] columnNames = sortableTableDescriptor.getColumnNames();
        String[] descriptions = sortableTableDescriptor.getColumnDescriptions();
        Class[] classes = sortableTableDescriptor.getColumnClasses();
        this.updatableTableModel = new UpdatableTableModel(columnNames, descriptions, classes);
        this.justifications = sortableTableDescriptor.getColumnJustifications();
        this.truncations = sortableTableDescriptor.getColumnTruncations();
        this.sortableTableModelFilter = new SortableTableModelFilter(this.updatableTableModel);
        this.setModel(this.sortableTableModelFilter);
    }

    public void setSortableTableDescriptor(SortableTableDescriptor sortableTableDescriptor) {
        this.sortableTableDescriptor = sortableTableDescriptor;
    }

    public SortableTableDescriptor getSortableTableDescriptor() {
        return this.sortableTableDescriptor;
    }

    public SortableTableColumnState getSortableTableColumnState() {
        return this.sortableTableColumnState;
    }

    public void setSortableTableColumnState(SortableTableColumnState sortableTableColumnState) {
        this.sortableTableColumnState = sortableTableColumnState;
        boolean[] visibility = sortableTableColumnState.getColumnVisiblity();
        int i = 0;
        while (i < visibility.length) {
            this.sortableTableModelFilter.setColumnVisible(i, visibility[i]);
            ++i;
        }
    }

    protected JTableHeader createDefaultTableHeader() {
        return new SortableTableHeader(this.columnModel, this);
    }

    public void setColumnVisible(int column, boolean visible) {
        SortableTableModelFilter filter = (SortableTableModelFilter)this.getModel();
        filter.setColumnVisible(column, visible);
    }

    public void addRow(TableRow tableRow) {
        this.updatableTableModel.add(tableRow);
    }

    public void removeRow(TableRow tableRow) {
        this.updatableTableModel.remove(tableRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllData() {
        UpdatableTableModel updatableTableModel = this.updatableTableModel;
        synchronized (updatableTableModel) {
            this.updatableTableModel.clear();
        }
        this.repaint();
    }

    public void setColumnTruncation(int column, int truncation) {
        this.truncations[column] = truncation;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        if (this.truncations != null) {
            this.myCellRenderer.setTruncation(this.truncations[column]);
        } else {
            this.myCellRenderer.setTruncation(2);
        }
        if (this.justifications != null) {
            this.myCellRenderer.setHorizontalAlignment(this.justifications[column]);
        } else {
            this.myCellRenderer.setHorizontalAlignment(4);
        }
        return this.myCellRenderer;
    }

    class SortableTableCellRenderer
    extends TruncatableJLabel
    implements TableCellRenderer {
        protected Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private Color unselectedForeground;
        private Color unselectedBackground;

        public SortableTableCellRenderer() {
            this.setOpaque(true);
            this.setBorder(this.noFocusBorder);
        }

        public String getToolTipText(MouseEvent event) {
            return this.getOriginalText();
        }

        public void setForeground(Color c) {
            super.setForeground(c);
            this.unselectedForeground = c;
        }

        public void setBackground(Color c) {
            super.setBackground(c);
            this.unselectedBackground = c;
        }

        public void updateUI() {
            super.updateUI();
            this.setForeground(null);
            this.setBackground(null);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
            }
            this.setFont(table.getFont());
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (table.isCellEditable(row, column)) {
                    super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    super.setBackground(UIManager.getColor("Table.focusCellBackground"));
                }
            } else {
                this.setBorder(this.noFocusBorder);
            }
            this.setValue(value);
            Color back = this.getBackground();
            boolean colorMatch = back != null && back.equals(table.getBackground()) && table.isOpaque();
            this.setOpaque(!colorMatch);
            return this;
        }

        void setValue(Object value) {
            this.setText(value == null ? "" : value.toString());
        }

        public void validate() {
        }

        public void revalidate() {
        }

        public void repaint(long tm, int x, int y, int width, int height) {
        }

        public void repaint(Rectangle r) {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (propertyName == "text") {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }
}

