/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.swing;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import net.jxta.swing.ColumnShowHideDialog;
import net.jxta.swing.SortableTable;
import net.jxta.swing.SortableTableModelFilter;
import net.jxta.swing.SwingTools;

public class SortableTableHeader
extends JTableHeader {
    protected int sortColumn = -1;
    SortableTable sortableTable;

    public SortableTableHeader(TableColumnModel columnModel, SortableTable sortableTable) {
        super(columnModel);
        this.sortableTable = sortableTable;
        this.addMouseListener(new DoubleClickAdapter());
    }

    protected void doubleClick(MouseEvent event) {
        int column = this.columnAtPoint(event.getPoint());
        int modelIndex = this.table.getColumnModel().getColumn(column).getModelIndex();
        SortableTableModelFilter filter = null;
        try {
            filter = (SortableTableModelFilter)this.table.getModel();
            if (filter.getSortColumn() == modelIndex) {
                filter.toggleDirection();
            } else {
                filter.setDirection(0);
                filter.setSortColumn(modelIndex);
            }
            this.table.repaint();
            this.table.getTableHeader().repaint();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    protected void rightClick(MouseEvent event) {
        SortableTableModelFilter filter = null;
        try {
            filter = (SortableTableModelFilter)this.table.getModel();
            Window parentWindow = SwingUtilities.getWindowAncestor(this.sortableTable);
            Frame parentFrame = parentWindow instanceof Frame ? (Frame)parentWindow : null;
            ColumnShowHideDialog dialog = new ColumnShowHideDialog(parentFrame, filter, this.columnModel);
            Component parent = (Component)event.getSource();
            SwingTools.setLocation(this.sortableTable, (Window)dialog);
            dialog.setVisible(true);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    protected class DoubleClickAdapter
    extends MouseAdapter {
        protected DoubleClickAdapter() {
        }

        public void mouseClicked(MouseEvent event) {
            if ((event.getModifiers() & 4) != 0) {
                SortableTableHeader.this.rightClick(event);
                return;
            }
            if (event.getClickCount() < 2) {
                return;
            }
            SortableTableHeader.this.doubleClick(event);
        }
    }
}

