/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import net.jxta.swing.SortableTableModelFilter;

public class SortableTableHeaderRenderer
extends DefaultTableCellRenderer {
    static Font headerFont = new Font("Arial", 1, 11);
    static Border headerBorder = new CompoundBorder(UIManager.getBorder("TableHeader.cellBorder"), new EmptyBorder(0, 1, 0, 1));
    static Color normalBackground = UIManager.getColor("TableHeader.background");
    static Icon downArrow = new DownArrow();
    static Icon upArrow = new UpArrow();
    static Color sortBackground = new Color(250, 250, 140);

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        label.setHorizontalTextPosition(2);
        label.setHorizontalAlignment(0);
        label.setBorder(headerBorder);
        label.setFont(headerFont);
        SortableTableModelFilter filter = null;
        try {
            filter = (SortableTableModelFilter)table.getModel();
        }
        catch (ClassCastException ex) {
            return label;
        }
        TableColumn tableColumn = table.getColumnModel().getColumn(column);
        if (tableColumn.getModelIndex() == filter.getSortColumn()) {
            label.setBackground(sortBackground);
            if (filter.getDirection() == 0) {
                label.setIcon(upArrow);
            } else {
                label.setIcon(downArrow);
            }
        } else {
            label.setBackground(normalBackground);
            label.setIcon(null);
        }
        return label;
    }

    static abstract class AbstractArrow
    implements Icon {
        AbstractArrow() {
        }

        public int getIconHeight() {
            return 8;
        }

        public int getIconWidth() {
            return 9;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.translate(x, y);
            g2.setColor(Color.magenta);
            g2.fill(this.getShape());
            g2.setColor(Color.black);
            g2.draw(this.getShape());
            g2.translate(-x, -y);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }

        public abstract Shape getShape();
    }

    static class UpArrow
    extends AbstractArrow {
        protected static GeneralPath path = new GeneralPath();

        static {
            path.moveTo(9.0f, 8.0f);
            path.moveTo(0.0f, 8.0f);
            path.lineTo(4.0f, 0.0f);
            path.lineTo(9.0f, 8.0f);
            path.closePath();
        }

        UpArrow() {
        }

        public Shape getShape() {
            return path;
        }
    }

    static class DownArrow
    extends AbstractArrow {
        protected static GeneralPath path = new GeneralPath();

        static {
            path.moveTo(9.0f, 8.0f);
            path.moveTo(0.0f, 0.0f);
            path.lineTo(9.0f, 0.0f);
            path.lineTo(4.0f, 8.0f);
            path.closePath();
        }

        DownArrow() {
        }

        public Shape getShape() {
            return path;
        }
    }
}

