/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.jxta.swing.TitleBarListener;

public class TitleBar
extends JPanel {
    private final TitleButton minButton = new TitleButton("MultiSplitPane.minimizeIcon", "MultiSplitPane.minButtonToolTip");
    private final TitleButton closeButton = new TitleButton("MultiSplitPane.closeIcon", "MultiSplitPane.closeButtonToolTip");
    private final TitleButton restoreButton = new TitleButton("MultiSplitPane.restoreIcon", "MultiSplitPane.restoreButtonToolTip");
    private LinkedList titleBarListeners = new LinkedList();
    private TitleArea titleArea = new TitleArea();
    private String title;
    private boolean minimized = false;

    static {
        TitleBar.putIfAbsent("MultiSplitPane.minimizeIcon", "InternalFrame.minimizeIcon", true);
        TitleBar.putIfAbsent("MultiSplitPane.minButtonToolTip", "Minimize", false);
        TitleBar.putIfAbsent("MultiSplitPane.closeIcon", "InternalFrame.closeIcon", true);
        TitleBar.putIfAbsent("MultiSplitPane.closeButtonToolTip", "InternalFrame.closeButtonToolTip", true);
        TitleBar.putIfAbsent("MultiSplitPane.maximizeIcon", "InternalFrame.maximizeIcon", true);
        TitleBar.putIfAbsent("MultiSplitPane.maxButtonToolTip", "InternalFrame.maxButtonToolTip", true);
        TitleBar.putIfAbsent("MultiSplitPane.restoreIcon", "InternalFrame.maximizeIcon", true);
        TitleBar.putIfAbsent("MultiSplitPane.restoreButtonToolTip", "InternalFrame.restoreButtonToolTip", true);
        TitleBar.putIfAbsent("MultiSplitPane.titleFont", "InternalFrame.titleFont", true);
    }

    private static void putIfAbsent(String key, Object obj, boolean objIsKey) {
        if (UIManager.get(key) == null) {
            if (objIsKey) {
                obj = UIManager.get(obj);
            }
            UIManager.put(key, obj);
        }
    }

    public TitleBar(String title) {
        this(title, true, true);
    }

    public TitleBar(String title, boolean hasMinButton, boolean hasCloseButton) {
        super(new BorderLayout());
        this.title = title;
        this.setFont(UIManager.getFont("MultiSplitPane.titleFont"));
        JPanel panel = new JPanel(new FlowLayout(1, 2, 2));
        if (hasMinButton) {
            panel.add(this.minButton);
            panel.add(this.restoreButton);
        }
        this.restoreButton.setVisible(false);
        if (hasCloseButton) {
            panel.add(this.closeButton);
        }
        this.minButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                for (TitleBarListener titleBarListener : TitleBar.this.titleBarListeners) {
                    titleBarListener.minimize();
                    TitleBar.this.minButton.setVisible(false);
                    TitleBar.this.restoreButton.setVisible(true);
                }
            }
        });
        this.restoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                for (TitleBarListener titleBarListener : TitleBar.this.titleBarListeners) {
                    titleBarListener.restore();
                    TitleBar.this.restoreButton.setVisible(false);
                    TitleBar.this.minButton.setVisible(true);
                }
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                for (TitleBarListener titleBarListener : TitleBar.this.titleBarListeners) {
                    titleBarListener.closing();
                }
            }
        });
        this.add((Component)this.titleArea, "Center");
        this.add((Component)panel, "East");
    }

    public void addTitleBarListener(TitleBarListener titleBarListener) {
        this.titleBarListeners.add(titleBarListener);
    }

    public void setTitle(String title) {
        this.title = title;
        this.revalidate();
        this.repaint();
    }

    public String getTitle() {
        return this.title;
    }

    private class TitleButton
    extends JButton {
        public TitleButton(String iconId, String toolTipId) {
            Icon icon = UIManager.getIcon(iconId);
            this.setIcon(icon);
            this.setToolTipText(UIManager.getString(toolTipId));
            this.setFocusPainted(false);
            Dimension size = new Dimension(icon.getIconHeight(), icon.getIconWidth());
            this.setPreferredSize(size);
        }

        public boolean isFocusable() {
            return false;
        }

        public void requestFocus() {
        }

        public boolean isOpaque() {
            return true;
        }
    }

    private class TitleArea
    extends JPanel {
        TitleArea() {
        }

        public void paint(Graphics graphics) {
            Dimension size = this.getSize();
            int width = size.width;
            int height = size.height;
            graphics.setColor(TitleBar.this.getBackground());
            graphics.fillRect(0, 0, width - 1, height - 1);
            graphics.setColor(TitleBar.this.getForeground());
            graphics.setFont(TitleBar.this.getFont());
            FontMetrics fm = graphics.getFontMetrics();
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            graphics.drawString(TitleBar.this.title, 5, yOffset);
        }
    }
}

