/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.swing;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;

public class TruncatableJLabel
extends JLabel
implements SwingConstants {
    private String originalText;
    private int sideToTruncate = 2;

    public TruncatableJLabel(String text, Icon icon, int sideToTruncate, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.sideToTruncate = sideToTruncate;
    }

    public TruncatableJLabel(String text, int sideToTruncate, int horizontalAlignment) {
        this(text, null, sideToTruncate, horizontalAlignment);
    }

    public TruncatableJLabel(String text, int sideToTruncate) {
        this(text, null, sideToTruncate, 10);
    }

    public TruncatableJLabel(int sideToTruncate) {
        this("", null, sideToTruncate, 10);
    }

    public TruncatableJLabel(String text) {
        this(text, null, 2, 10);
    }

    public TruncatableJLabel() {
        this("", null, 2, 10);
    }

    public void setTruncation(int sideToTruncate) {
        this.sideToTruncate = sideToTruncate;
        this.setText(this.originalText);
        this.repaint();
    }

    public void setText(String newText) {
        this.originalText = newText;
        Font font = this.getFont();
        if (font == null) {
            super.setText(newText);
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Insets paintViewInsets = this.getInsets();
        int availableWidth = this.getWidth() - (paintViewInsets.left + paintViewInsets.right);
        if (availableWidth == 0) {
            return;
        }
        if (this.getIcon() != null) {
            availableWidth -= this.getIconTextGap() + this.getIcon().getIconWidth();
        }
        newText = TruncatableJLabel.truncateString(newText, this.sideToTruncate, "...", fontMetrics, availableWidth);
        super.setText(newText);
    }

    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        this.setText(this.originalText);
    }

    public static String truncateString(String originalString, int sideToTruncate, String clipString, FontMetrics fontMetrics, int availableWidth) {
        if (originalString == null) {
            return originalString;
        }
        int widthOfText = SwingUtilities.computeStringWidth(fontMetrics, originalString);
        if (widthOfText <= availableWidth) {
            return originalString;
        }
        if (sideToTruncate == 2) {
            int totalWidth = SwingUtilities.computeStringWidth(fontMetrics, clipString);
            int nChars = originalString.length() - 1;
            while (nChars >= 0) {
                if ((totalWidth += fontMetrics.charWidth(originalString.charAt(nChars))) > availableWidth) break;
                --nChars;
            }
            return String.valueOf(clipString) + originalString.substring(nChars + 1);
        }
        if (sideToTruncate == 0) {
            String leftClipString = "";
            String newString = String.valueOf(leftClipString) + originalString + clipString;
            int totalWidth = SwingUtilities.computeStringWidth(fontMetrics, newString);
            while (originalString.length() >= 2 && totalWidth >= availableWidth) {
                originalString = originalString.substring(0, originalString.length() - 1);
                newString = String.valueOf(leftClipString) + originalString + clipString;
                totalWidth = SwingUtilities.computeStringWidth(fontMetrics, newString);
                if (totalWidth < availableWidth) break;
                originalString = originalString.substring(1);
                leftClipString = clipString;
                newString = String.valueOf(leftClipString) + originalString + clipString;
            }
            return newString;
        }
        int totalWidth = SwingUtilities.computeStringWidth(fontMetrics, clipString);
        int nChars = 0;
        while (nChars < originalString.length()) {
            if ((totalWidth += fontMetrics.charWidth(originalString.charAt(nChars))) > availableWidth) break;
            ++nChars;
        }
        return String.valueOf(originalString.substring(0, nChars)) + clipString;
    }

    public String getOriginalText() {
        return this.originalText;
    }
}

