/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VerticalLayout
implements LayoutManager {
    int gap;

    public VerticalLayout() {
    }

    public VerticalLayout(int gap) {
        this.gap = gap;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int width = 0;
            int height = insets.top + insets.bottom;
            int numVisible = 0;
            int i = 0;
            while (i < ncomponents) {
                Component component = parent.getComponent(i);
                if (component.isVisible()) {
                    ++numVisible;
                    Dimension dimension = component.getPreferredSize();
                    height += dimension.height;
                    if (width < dimension.width) {
                        width = dimension.width;
                    }
                }
                ++i;
            }
            if (numVisible > 1) {
                height += this.gap * (numVisible - 2);
            }
            return new Dimension(width += insets.left + insets.right, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int numComponents = parent.getComponentCount();
            int width = 0;
            int height = insets.top + insets.bottom;
            int numVisible = 0;
            int i = 0;
            while (i < numComponents) {
                Component component = parent.getComponent(i);
                if (component.isVisible()) {
                    ++numVisible;
                    Dimension dimension = component.getMinimumSize();
                    height += dimension.height;
                    if (width < dimension.width) {
                        width = dimension.width;
                    }
                }
                ++i;
            }
            if (numVisible > 1) {
                height += this.gap * (numVisible - 2);
            }
            return new Dimension(width += insets.left + insets.right, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int numComponents = parent.getComponentCount();
            Insets insets = parent.getInsets();
            Dimension parentSize = parent.getSize();
            int width = parentSize.width - (insets.left + insets.right);
            int height = parentSize.height - (insets.top + insets.bottom);
            int x = insets.left;
            int y = insets.top;
            int i = 0;
            while (i < numComponents) {
                Component component = parent.getComponent(i);
                if (component.isVisible()) {
                    Dimension componentSize = component.getPreferredSize();
                    int componentHeight = componentSize.height;
                    component.setBounds(x, y, width, componentHeight);
                    y += componentHeight;
                    height -= componentHeight + this.gap;
                    height -= this.gap;
                }
                ++i;
            }
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[gap=" + this.gap + "]";
    }
}

