/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb;

import alma.acs.util.ACSPorts;
import com.cosylab.cdb.CDBTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.JApplet;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class CDBBrowser
extends JApplet
implements TreeSelectionListener {
    private JSplitPane jSplitPane;
    private JTree cdbTree;
    private JTextArea jTextArea;
    private String strIOR = null;

    public void setIOR(String strIOR) {
        this.strIOR = strIOR;
    }

    @Override
    public void init() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.cosylab.cdb.jdal.JNDIContextFactory");
        if (this.strIOR == null) {
            env.put("java.naming.provider.url", "corbaloc::" + ACSPorts.getIP() + ":" + ACSPorts.getCDBPort() + "/CDB");
        } else {
            env.put("java.naming.provider.url", this.strIOR);
        }
        InitialContext context = null;
        try {
            context = new InitialContext(env);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        if (context == null) {
            return;
        }
        this.cdbTree = new JTree(new CDBTreeNode("root", null, context));
        this.cdbTree.addTreeSelectionListener(this);
        this.jTextArea = new JTextArea();
        this.jSplitPane = new JSplitPane();
        this.jSplitPane.setOrientation(1);
        this.jSplitPane.setLeftComponent(new JScrollPane(this.cdbTree));
        this.jSplitPane.setRightComponent(new JScrollPane(this.jTextArea));
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)this.jSplitPane, "Center");
        this.validate();
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        CDBTreeNode node;
        String value;
        Object last = this.cdbTree.getLastSelectedPathComponent();
        if (last != null && last instanceof CDBTreeNode && (value = (node = (CDBTreeNode)last).getValue()) != null) {
            this.jTextArea.setText(value);
        }
    }

    public static void main(String[] args) {
        CDBBrowser app = new CDBBrowser();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-d") && i < args.length - 1) {
                app.setIOR(args[++i]);
            }
            if (!args[i].equals("-h") && !args[i].equals("-help")) continue;
            System.out.println("Usage: cmd [-d ior -h|-help]");
            return;
        }
        Frame frame = new Frame("CDB Browser");
        frame.add(app);
        frame.setSize(800, 600);
        frame.setLocationRelativeTo(null);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        app.init();
        app.start();
        frame.setVisible(true);
    }
}

