/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb.client;

import alma.acs.util.ACSPorts;
import alma.acs.util.AcsLocations;
import alma.cdbErrType.wrappers.AcsJCDBXMLErrorEx;
import com.cosylab.CDB.DAL;
import com.cosylab.CDB.DALChangeListener;
import com.cosylab.CDB.DALChangeListenerPOA;
import com.cosylab.CDB.DALHelper;
import com.cosylab.CDB.DAOOperations;
import com.cosylab.cdb.client.DAOProxy;
import com.cosylab.cdb.jdal.DAOImpl;
import com.cosylab.cdb.jdal.XMLHandler;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class CDBAccess {
    private static final String CDBDAL_PREFIX = "DAL";
    private static final String CDBDAO_PREFIX = "DAO";
    private static final String CDBDAL_DEFAULT_REFERENCE = "DAL.defaultReference";
    private static final String DEFAULT_REFERENCE = AcsLocations.convertToCdbLocation((String)ACSPorts.getIP(), (String)ACSPorts.getCDBPort());
    private static final String CDBDAO_REMOTE = "DAO.remote";
    private boolean remoteDAO = true;
    private String defaultDAL = null;
    private DAL dalReference = null;
    private ORB orb = null;
    private final Logger logger;
    private ChangeListener changeListener = null;
    private boolean bypassNameService = false;

    public CDBAccess(Logger logger) {
        this(null, logger);
    }

    public CDBAccess(ORB orb, Logger logger) {
        this.orb = orb;
        this.logger = logger;
        this.readConfiguration();
        this.changeListener = new ChangeListener();
    }

    public DAOProxy createDAO(String curl) {
        DAOProxy proxy = new DAOProxy(curl);
        this.internalConnect(proxy);
        return proxy;
    }

    private void internalConnect(DAOProxy proxy) {
        String curl = null;
        try {
            this.checkDALConnection();
        }
        catch (Throwable th) {
            RuntimeException re = new RuntimeException("Failed to obtain DAO for proxy '" + proxy + "'.", th);
            throw re;
        }
        java.lang.Object dao = null;
        try {
            curl = proxy.getCURL();
            if (this.remoteDAO) {
                dao = this.dalReference.get_DAO_Servant(curl);
            } else {
                String xml = this.dalReference.get_DAO(curl);
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                XMLHandler xmlSolver = new XMLHandler(false, this.logger);
                saxParser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)xmlSolver);
                if (xmlSolver.m_errorString != null) {
                    AcsJCDBXMLErrorEx e = new AcsJCDBXMLErrorEx();
                    e.setErrorString("XML parser error: " + xmlSolver.m_errorString);
                    throw e;
                }
                dao = new DAOImpl(curl, xmlSolver.m_rootNode, null, this.logger, true);
                proxy.setElementName(xmlSolver.m_rootNode.getName());
            }
            if (this.changeListener != null && !this.changeListener.isRegistered(curl)) {
                this.changeListener.handle(this.dalReference, curl, proxy);
            }
        }
        catch (Throwable th) {
            RuntimeException re = new RuntimeException("Failed to obtain DAO object for proxy '" + proxy + "'.", th);
            throw re;
        }
        try {
            proxy.initialize((DAOOperations)dao);
        }
        catch (Throwable th) {
            RuntimeException re = new RuntimeException("The proxy '" + proxy + "' rejects the DAO.", th);
            throw re;
        }
        this.logger.config("Connected to DAO '" + proxy.getCURL() + "'.");
    }

    public boolean isBypassNameService() {
        return this.bypassNameService;
    }

    public void setBypassNameService(boolean bypassNameService) {
        this.bypassNameService = bypassNameService;
    }

    private DAL queryNSForDALReference() {
        try {
            Object objRef = this.orb.resolve_initial_references("NameService");
            NamingContext ncRef = NamingContextHelper.narrow((Object)objRef);
            NameComponent[] path = new NameComponent[]{new NameComponent("CDB", "")};
            Object objectReference = ncRef.resolve(path);
            DAL dalRef = DALHelper.narrow((Object)objectReference);
            return dalRef;
        }
        catch (Throwable th) {
            throw new RuntimeException("Failed to get DAL object from the naming service.", th);
        }
    }

    private void checkDALConnection() {
        try {
            if (this.dalReference == null) {
                this.logger.info("Connecting to DAL '" + this.defaultDAL + "'...");
                if (this.bypassNameService) {
                    this.dalReference = DALHelper.narrow((Object)this.orb.string_to_object(this.defaultDAL));
                    if (this.dalReference == null) {
                        throw new RuntimeException("Failed to connect to the DAL object with reference, got 'null' reference.");
                    }
                } else {
                    this.dalReference = this.queryNSForDALReference();
                }
                this.logger.info("Connected to DAL '" + this.defaultDAL + "'.");
            }
        }
        catch (Throwable th) {
            this.logger.info("Failed to connect to DAL '" + this.defaultDAL + "'.");
            RuntimeException re = new RuntimeException("Failed to connect to the DAL object with reference '" + this.defaultDAL + "'.", th);
            throw re;
        }
    }

    private void internalDisconnect(DAOProxy proxy) {
        assert (proxy != null);
        proxy.initialize(null);
    }

    public String[] getSubNodes(DAOProxy proxy) throws Throwable {
        return this.getSubNodes(proxy, null);
    }

    public String[] getSubNodes(DAOProxy proxy, String subnode) throws Throwable {
        assert (proxy != null);
        this.checkDALConnection();
        ArrayList<String> subnodes = new ArrayList<String>();
        LinkedList<String> stack = new LinkedList<String>();
        if (subnode == null) {
            stack.addLast(proxy.getCURL());
        } else {
            stack.addLast(proxy.getCURL() + "/" + subnode);
        }
        while (!stack.isEmpty()) {
            String parentNode = stack.removeLast().toString();
            String nodes = this.dalReference.list_nodes(parentNode);
            if (nodes.length() <= 0) continue;
            StringTokenizer tokenizer = new StringTokenizer(nodes);
            while (tokenizer.hasMoreTokens()) {
                String nodeName = tokenizer.nextToken();
                if (nodeName.endsWith(".xml")) continue;
                String fullName = parentNode + "/" + nodeName;
                stack.addLast(fullName);
                subnodes.add(fullName.substring(proxy.getCURL().length() + 1));
            }
        }
        String[] retVal = new String[subnodes.size()];
        subnodes.toArray(retVal);
        return retVal;
    }

    public void readConfiguration() {
        this.defaultDAL = System.getProperty(CDBDAL_DEFAULT_REFERENCE, DEFAULT_REFERENCE);
        this.remoteDAO = Boolean.valueOf(System.getProperty(CDBDAO_REMOTE, "false"));
    }

    public void destroy() {
        if (this.changeListener != null) {
            this.changeListener.destroy();
        }
    }

    public void setDAL(DAL dal) {
        this.dalReference = dal;
    }

    public DAL getDAL() {
        return this.dalReference;
    }

    public DAL connectAndGetDAL() {
        try {
            this.checkDALConnection();
            return this.dalReference;
        }
        catch (Throwable th) {
            return null;
        }
    }

    private class ChangeListener
    extends DALChangeListenerPOA {
        private HashMap curlMap = new HashMap();
        private HashMap dalMap = new HashMap();
        private DALChangeListener cl = null;

        private ChangeListener() {
        }

        public void object_changed(String curl) {
            DAOProxy connectable = (DAOProxy)this.curlMap.get(curl);
            if (connectable != null) {
                new ReconnectTask(connectable).start();
            }
        }

        public void handle(DAL dal, String curl, DAOProxy conn) {
            Integer listenerID;
            if (this.cl == null) {
                this.cl = CDBAccess.this.changeListener._this(CDBAccess.this.orb);
            }
            if ((listenerID = (Integer)this.dalMap.get(dal)) == null) {
                int id = dal.add_change_listener(this.cl);
                listenerID = new Integer(id);
                this.dalMap.put(dal, listenerID);
            }
            dal.listen_for_changes(curl, listenerID.intValue());
            this.curlMap.put(curl, conn);
        }

        public boolean isRegistered(String curl) {
            return this.curlMap.containsKey(curl);
        }

        public void destroy() {
            for (DAL dal : this.dalMap.keySet()) {
                Integer listenerID = (Integer)this.dalMap.get(dal);
                try {
                    dal.remove_change_listener(listenerID.intValue());
                }
                catch (Exception exception) {}
            }
            this.dalMap.clear();
            this.curlMap.clear();
        }

        private class ReconnectTask
        extends Thread {
            DAOProxy connectable;

            public ReconnectTask(DAOProxy connectable) {
                this.connectable = connectable;
            }

            @Override
            public void run() {
                int RETRIES = 3;
                for (int i = 0; i < 3; ++i) {
                    try {
                        CDBAccess.this.internalConnect(this.connectable);
                        break;
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                }
            }
        }
    }
}

