/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb.jdal;

import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.AcsLogger;
import alma.acs.logging.ClientLogManager;
import alma.acs.util.ACSPorts;
import com.cosylab.CDB.JDAL;
import com.cosylab.CDB.JDALHelper;
import java.net.InetAddress;
import java.util.logging.Level;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class ClearCache {
    public static void main(String[] args) {
        AcsLogger m_logger = ClientLogManager.getAcsLogManager().getLoggerForApplication("cdbjDALClearCache", false);
        try {
            String curl = null;
            String strIOR = null;
            if (args.length >= 1 && !args[0].equals("-d")) {
                curl = args[0];
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-d") && i < args.length - 1) {
                    strIOR = args[++i];
                }
                if (!args[i].equals("-h")) continue;
                System.out.println("Usage: cmd [curl] [-d ior -h]");
                System.out.println("if curl is not set, is invoked for all curls");
                return;
            }
            if (strIOR == null) {
                strIOR = "corbaloc::" + InetAddress.getLocalHost().getHostName() + ":" + ACSPorts.getCDBPort() + "/CDB";
            }
            ORB orb = ORB.init((String[])args, null);
            JDAL dal = JDALHelper.narrow((Object)orb.string_to_object(strIOR));
            if (curl != null) {
                dal.clear_cache(curl);
                m_logger.log((Level)AcsLogLevel.INFO, "Cleared CDB cache for curl=" + curl);
            } else {
                dal.clear_cache_all();
                m_logger.log((Level)AcsLogLevel.INFO, "Cleared CDB cache for all curls.");
            }
        }
        catch (Exception e) {
            m_logger.log((Level)AcsLogLevel.NOTICE, "Failed to clear the CDB cache:", e);
        }
    }
}

