/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb.jdal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class DALNode {
    protected String name;
    protected ArrayList childs;
    protected DALNode parent;

    public static DALNode getRoot(String filePath) {
        DALNode rootNode = new DALNode(filePath, null);
        rootNode.loadNodes(filePath);
        return rootNode;
    }

    public DALNode(String name, DALNode parent) {
        this.name = name;
        this.parent = parent;
    }

    public String list(String path) {
        StringBuffer sbuf = new StringBuffer(50);
        DALNode node = this.findNode(path);
        for (int i = 0; node != null && node.childs != null && i < node.childs.size(); ++i) {
            DALNode currNode = (DALNode)node.childs.get(i);
            sbuf.append(currNode.name);
            sbuf.append(' ');
        }
        return new String(sbuf);
    }

    protected DALNode findNode(String path) {
        StringTokenizer st = new StringTokenizer(path, "/");
        if (!st.hasMoreTokens()) {
            return this;
        }
        String nodeName = st.nextToken();
        DALNode child = this.getNode(nodeName);
        if (child == null) {
            return null;
        }
        if (st.hasMoreTokens()) {
            return child.findNode(path.substring(path.indexOf(nodeName) + nodeName.length()));
        }
        return child;
    }

    protected void loadNodes(String filePath) {
        File base = new File(filePath);
        File[] basefiles = base.listFiles();
        for (int i = 0; basefiles != null && i < basefiles.length; ++i) {
            String fileName = basefiles[i].getName();
            if (!fileName.endsWith(".xml")) {
                this.loadNodes(basefiles[i].getPath());
                continue;
            }
            String parentDirName = basefiles[i].getParentFile().getName();
            if (!parentDirName.equals(fileName.substring(0, fileName.length() - 4))) continue;
            this.addNode(basefiles[i].getPath().substring(this.name.length()));
        }
    }

    protected void addNode(String nodePath) {
        StringTokenizer st;
        if (this.childs == null) {
            this.childs = new ArrayList(1);
        }
        if (!(st = new StringTokenizer(nodePath, String.valueOf(File.separatorChar))).hasMoreTokens()) {
            return;
        }
        String nodeName = st.nextToken();
        DALNode child = this.getNode(nodeName);
        if (child == null) {
            child = new DALNode(nodeName, this);
            this.childs.add(child);
        }
        if (st.hasMoreTokens()) {
            child.addNode(nodePath.substring(nodePath.indexOf(nodeName) + nodeName.length()));
        }
    }

    protected DALNode getNode(String nodeName) {
        for (int i = 0; this.childs != null && i < this.childs.size(); ++i) {
            DALNode currNode = (DALNode)this.childs.get(i);
            if (!currNode.name.equals(nodeName)) continue;
            return currNode;
        }
        return null;
    }

    protected void getNodes(List list) {
        if (this.childs == null) {
            list.add(this.getCurl());
        }
        for (int i = 0; this.childs != null && i < this.childs.size(); ++i) {
            DALNode currNode = (DALNode)this.childs.get(i);
            currNode.getNodes(list);
        }
    }

    public String getCurl() {
        DALNode node = this.getCurlNode();
        if (node == null) {
            return null;
        }
        String curl = "";
        DALNode curr = node.parent;
        while (curr != null && curr.parent != null) {
            curl = "/" + curr.name + curl;
            curr = curr.parent;
        }
        return curl;
    }

    public void print(int level) {
        for (int j = 0; j < level; ++j) {
            System.out.print("  ");
        }
        System.out.println(this.name);
        for (int i = 0; this.childs != null && i < this.childs.size(); ++i) {
            DALNode currNode = (DALNode)this.childs.get(i);
            currNode.print(level + 1);
        }
    }

    public DALNode getCurlNode() {
        for (int i = 0; this.childs != null && i < this.childs.size(); ++i) {
            DALNode currNode = (DALNode)this.childs.get(i);
            if (currNode.childs != null) continue;
            return currNode;
        }
        return null;
    }

    public DALNode[] getChilds() {
        ArrayList<DALNode> list = new ArrayList<DALNode>();
        for (int i = 0; this.childs != null && i < this.childs.size(); ++i) {
            DALNode currNode = (DALNode)this.childs.get(i);
            if (currNode.childs == null) continue;
            list.add(currNode);
        }
        DALNode[] childs = new DALNode[list.size()];
        list.toArray(childs);
        return childs;
    }

    public boolean isSimple() {
        if (this.childs == null || this.childs.size() > 1) {
            return false;
        }
        DALNode firstChild = (DALNode)this.childs.get(0);
        return firstChild.childs == null;
    }

    public boolean hasXmlChild() {
        boolean hasXmlChild = this.findNode(this.name + ".xml") != null;
        return hasXmlChild;
    }
}

