/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb.jdal;

import alma.acs.logging.AcsLogLevel;
import alma.cdbErrType.CDBFieldDoesNotExistEx;
import alma.cdbErrType.WrongCDBDataTypeEx;
import alma.cdbErrType.wrappers.AcsJCDBFieldDoesNotExistEx;
import alma.cdbErrType.wrappers.AcsJWrongCDBDataTypeEx;
import com.cosylab.CDB.DAOOperations;
import com.cosylab.cdb.jdal.XMLTreeNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.PortableServer.POA;

public class DAOImpl
implements DAOOperations,
Serializable {
    private final String m_name;
    private XMLTreeNode m_rootNode;
    private final transient POA m_poa;
    private boolean m_silent;
    private final transient Logger m_logger;

    public DAOImpl(String name, XMLTreeNode rootNode, POA poa, Logger logger) {
        this(name, rootNode, poa, logger, false);
    }

    public DAOImpl(String name, XMLTreeNode rootNode, POA poa, Logger logger, boolean silent) {
        this.m_name = name;
        this.m_rootNode = rootNode;
        this.m_poa = poa;
        this.m_silent = silent;
        this.m_logger = logger;
    }

    public void destroy() {
        block3: {
            try {
                if (this.m_poa != null) {
                    byte[] thisId = this.m_name.getBytes();
                    this.m_poa.deactivate_object(thisId);
                }
            }
            catch (Exception e) {
                if (this.m_silent) break block3;
                this.m_logger.log((Level)AcsLogLevel.NOTICE, "Exception destroying object " + this + " : " + e);
                e.printStackTrace();
            }
        }
    }

    private String getField(String strFieldName) throws AcsJCDBFieldDoesNotExistEx {
        XMLTreeNode pNode = this.m_rootNode;
        if (strFieldName.length() == 0 || strFieldName.equals(this.m_rootNode.m_name)) {
            return pNode.getAttributeAndNodeNames();
        }
        StringTokenizer st = new StringTokenizer(strFieldName, "/");
        String fieldName = st.nextToken();
        while (st.hasMoreTokens()) {
            XMLTreeNode child = pNode.m_subNodesMap.get(fieldName);
            if (child == null) {
                fieldName = fieldName + "/" + st.nextToken();
                continue;
            }
            pNode = child;
            fieldName = st.nextToken();
        }
        if (pNode == null) {
            AcsJCDBFieldDoesNotExistEx e2 = new AcsJCDBFieldDoesNotExistEx();
            e2.setFieldName(strFieldName);
            throw e2;
        }
        String value = this.getFieldValue(pNode, fieldName);
        if (value == null) {
            XMLTreeNode node = pNode.m_subNodesMap.get(fieldName);
            if (node == null) {
                int lpos = strFieldName.lastIndexOf(47);
                if (lpos > 0 && (pNode = this.m_rootNode.m_subNodesMap.get(strFieldName.substring(0, lpos))) != null && (value = this.getFieldValue(pNode, fieldName = strFieldName.substring(lpos + 1))) != null) {
                    if (!this.m_silent) {
                        this.m_logger.log((Level)AcsLogLevel.DEBUG, "DAO:'" + this.m_name + "' returned '" + strFieldName + "'=" + value);
                    }
                    return value;
                }
                if (!this.m_silent) {
                    this.m_logger.log((Level)AcsLogLevel.NOTICE, "DAO:'" + this.m_name + "' Unable to return field: '" + strFieldName + "'");
                }
                AcsJCDBFieldDoesNotExistEx e2 = new AcsJCDBFieldDoesNotExistEx();
                e2.setFieldName(strFieldName);
                throw e2;
            }
            value = node.getAttributeAndNodeNames();
        }
        if (!this.m_silent) {
            this.m_logger.log((Level)AcsLogLevel.DEBUG, "DAO:'" + this.m_name + "' returned '" + strFieldName + "'=" + value);
        }
        return value;
    }

    private String getFieldValue(XMLTreeNode pNode, String fieldName) {
        String value = fieldName.equals("_characteristics") ? pNode.getAttributeAndNodeNames() : (fieldName.equals("_attributes") ? pNode.getAttributeNames() : (fieldName.equals("_elements") ? pNode.getElementNames() : (fieldName.equals("_subnodes") ? pNode.getSubNodeNames() : (fieldName.equals("_name") ? pNode.getRawName() : pNode.m_fieldMap.get(fieldName)))));
        return value;
    }

    public int get_long(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        String stringValue;
        try {
            stringValue = this.getField(propertyName);
        }
        catch (AcsJCDBFieldDoesNotExistEx e) {
            throw e.toCDBFieldDoesNotExistEx();
        }
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException nfe) {
            if (!this.m_silent) {
                this.m_logger.log((Level)AcsLogLevel.NOTICE, "Failed to cast '" + stringValue + "' to long: " + nfe);
            }
            AcsJWrongCDBDataTypeEx e2 = new AcsJWrongCDBDataTypeEx((Throwable)nfe);
            e2.setValue(stringValue);
            e2.setDataType("long");
            throw e2.toWrongCDBDataTypeEx();
        }
    }

    public double get_double(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        String stringValue;
        try {
            stringValue = this.getField(propertyName);
        }
        catch (AcsJCDBFieldDoesNotExistEx e) {
            throw e.toCDBFieldDoesNotExistEx();
        }
        try {
            return Double.parseDouble(stringValue);
        }
        catch (NumberFormatException nfe) {
            this.m_logger.log((Level)AcsLogLevel.NOTICE, "Failed to cast '" + stringValue + "' to double: " + nfe);
            AcsJWrongCDBDataTypeEx e2 = new AcsJWrongCDBDataTypeEx((Throwable)nfe);
            e2.setValue(stringValue);
            e2.setDataType("double");
            throw e2.toWrongCDBDataTypeEx();
        }
    }

    public String get_string(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        try {
            return this.getField(propertyName);
        }
        catch (AcsJCDBFieldDoesNotExistEx e) {
            throw e.toCDBFieldDoesNotExistEx();
        }
    }

    public String get_field_data(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        try {
            return this.getField(propertyName);
        }
        catch (AcsJCDBFieldDoesNotExistEx e) {
            throw e.toCDBFieldDoesNotExistEx();
        }
    }

    public String[] get_string_seq(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        String stringValue;
        try {
            stringValue = this.getField(propertyName);
        }
        catch (AcsJCDBFieldDoesNotExistEx e) {
            throw e.toCDBFieldDoesNotExistEx();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(stringValue, ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        String[] seq = new String[list.size()];
        list.toArray(seq);
        return seq;
    }

    public int[] get_long_seq(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        String stringValue;
        try {
            stringValue = this.getField(propertyName);
        }
        catch (AcsJCDBFieldDoesNotExistEx e) {
            throw e.toCDBFieldDoesNotExistEx();
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        String val = null;
        try {
            StringTokenizer st = new StringTokenizer(stringValue, ",");
            while (st.hasMoreTokens()) {
                val = st.nextToken().trim();
                list.add(new Integer(val));
            }
        }
        catch (NumberFormatException nfe) {
            if (!this.m_silent) {
                this.m_logger.log((Level)AcsLogLevel.NOTICE, "Failed to cast element #" + list.size() + " of value '" + val + "' to long: " + nfe);
            }
            AcsJWrongCDBDataTypeEx e2 = new AcsJWrongCDBDataTypeEx((Throwable)nfe);
            e2.setValue(val);
            e2.setDataType("long");
            throw e2.toWrongCDBDataTypeEx();
        }
        int[] seq = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            seq[i] = (Integer)list.get(i);
        }
        return seq;
    }

    public double[] get_double_seq(String propertyName) throws WrongCDBDataTypeEx, CDBFieldDoesNotExistEx {
        String stringValue;
        try {
            stringValue = this.getField(propertyName);
        }
        catch (AcsJCDBFieldDoesNotExistEx e) {
            throw e.toCDBFieldDoesNotExistEx();
        }
        ArrayList<Double> list = new ArrayList<Double>();
        String val = null;
        try {
            StringTokenizer st = new StringTokenizer(stringValue, ",");
            while (st.hasMoreTokens()) {
                val = st.nextToken().trim();
                list.add(new Double(val));
            }
        }
        catch (NumberFormatException nfe) {
            if (!this.m_silent) {
                this.m_logger.log((Level)AcsLogLevel.NOTICE, "Failed to cast element #" + list.size() + " of value '" + val + "' to double: " + nfe);
            }
            AcsJWrongCDBDataTypeEx e = new AcsJWrongCDBDataTypeEx((Throwable)nfe);
            e.setValue(val);
            e.setDataType("double");
            throw e.toWrongCDBDataTypeEx();
        }
        double[] seq = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            seq[i] = (Double)list.get(i);
        }
        return seq;
    }

    public XMLTreeNode getRootNode() {
        return this.m_rootNode;
    }

    public void setRootNode(XMLTreeNode mRootNode) {
        this.m_rootNode = mRootNode;
    }

    public String getName() {
        return this.m_name;
    }

    public POA getPOA() {
        return this.m_poa;
    }
}

