/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb.jdal;

import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.AcsLogger;
import alma.acs.logging.ClientLogManager;
import alma.acs.monitoring.SimpleCallInterceptor;
import alma.acs.util.ACSPorts;
import alma.cdbErrType.CDBRecordDoesNotExistEx;
import alma.cdbErrType.CDBXMLErrorEx;
import com.cosylab.CDB.JDAL;
import com.cosylab.CDB.JDALHelper;
import com.cosylab.CDB.WJDALOperations;
import com.cosylab.CDB.WJDALPOATie;
import com.cosylab.cdb.jdal.DALImpl;
import com.cosylab.cdb.jdal.Recoverer;
import com.cosylab.cdb.jdal.WDALImpl;
import com.sun.corba.se.internal.Interceptors.PIORB;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;

public class Server {
    public static final String CDB_LOGGER_NAME = "CDB";
    public static final String LOG_CDB_CALLS_PROPERTYNAME = "alma.acs.cdb.log_corba_calls";
    private JDAL jdal;
    private static String[] PRELOAD_TABLE = new String[]{"MACI/Managers/Manager", "MACI/Components"};
    private static String[] PRELOAD_TABLE_SUBTREE = new String[]{"MACI/Containers"};

    public static void main(String[] args) {
        new Server().run(args);
    }

    public void run(String[] args) {
        String iorFileName = null;
        AcsLogger sharedLogger = ClientLogManager.getAcsLogManager().getLoggerForApplication(CDB_LOGGER_NAME, true);
        try {
            WDALImpl servantDelegate;
            Properties properties = System.getProperties();
            boolean useJacORB = false;
            int portNumber = Integer.parseInt(ACSPorts.getCDBPort());
            for (int i = 0; i < args.length; ++i) {
                if ((args[i].equals("-OAport") || args[i].equals("-OAPort")) && i < args.length - 1) {
                    portNumber = Integer.valueOf(args[++i]);
                }
                if (args[i].equals("-OAIAddr") && i < args.length - 1) {
                    properties.put("OAIAddr", args[++i]);
                }
                if (args[i].equals("-orbacus")) {
                    sharedLogger.log((Level)AcsLogLevel.NOTICE, "ORBacus is no longer supported, switching to JacORB.");
                    useJacORB = true;
                }
                if (args[i].equals("-jacorb")) {
                    useJacORB = true;
                }
                if (!args[i].equals("-o")) continue;
                iorFileName = i < args.length - 1 ? args[++i] : "DAL.ior";
            }
            if (useJacORB) {
                sharedLogger.log((Level)AcsLogLevel.DELOUSE, "DALfs will use JacORB ORB");
                properties.put("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
                properties.put("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
                properties.put("OAPort", Integer.toString(portNumber));
                properties.put("jacorb.implname", "ORB");
                properties.put("jacorb.orb.objectKeyMap.CDB", "ORB/dalPOA/CDB");
            } else {
                properties.put("com.sun.CORBA.POA.ORBPersistentServerPort", Integer.toString(portNumber));
            }
            ORB orb = ORB.init((String[])args, (Properties)properties);
            POA rootpoa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
            Policy[] policies = new Policy[]{rootpoa.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), useJacORB ? rootpoa.create_lifespan_policy(LifespanPolicyValue.PERSISTENT) : rootpoa.create_lifespan_policy(LifespanPolicyValue.TRANSIENT)};
            POA dalpoa = rootpoa.create_POA("dalPOA", rootpoa.the_POAManager(), policies);
            for (int i = 0; i < policies.length; ++i) {
                policies[i].destroy();
            }
            rootpoa.the_POAManager().activate();
            WDALImpl topLevelServantDelegate = servantDelegate = new WDALImpl(args, orb, dalpoa, (Logger)sharedLogger);
            if (Boolean.getBoolean(LOG_CDB_CALLS_PROPERTYNAME)) {
                WJDALOperations interceptingServantDelegate = (WJDALOperations)SimpleCallInterceptor.createSimpleInterceptor(WJDALOperations.class, (java.lang.Object)servantDelegate, (Logger)sharedLogger);
                topLevelServantDelegate = interceptingServantDelegate;
            }
            WJDALPOATie servant = new WJDALPOATie((WJDALOperations)topLevelServantDelegate);
            byte[] id = new byte[]{67, 68, 66};
            dalpoa.activate_object_with_id(id, (Servant)servant);
            Object ref = dalpoa.servant_to_reference((Servant)servant);
            this.jdal = JDALHelper.narrow((Object)ref);
            if (!useJacORB) {
                ((PIORB)orb).register_initial_reference(CDB_LOGGER_NAME, rootpoa.servant_to_reference((Servant)servant));
            }
            try {
                Object objRef = orb.resolve_initial_references("NameService");
                NamingContext ncRef = NamingContextHelper.narrow((Object)objRef);
                NameComponent nc = new NameComponent(CDB_LOGGER_NAME, "");
                NameComponent[] path = new NameComponent[]{nc};
                ncRef.rebind(path, (Object)this.jdal);
            }
            catch (Exception e1) {
                sharedLogger.log((Level)AcsLogLevel.NOTICE, "JDAL is NOT registered in the name service because of: " + e1);
            }
            if (Integer.getInteger("ACS.logstdout", 4) < 4) {
                sharedLogger.log((Level)AcsLogLevel.INFO, "JDAL is listening on " + ACSPorts.getIP() + ":" + portNumber + "/CDB");
            }
            if (servantDelegate instanceof Recoverer) {
                servantDelegate.recoverClients();
            }
            if (iorFileName != null) {
                PrintWriter iorFile = new PrintWriter(new FileWriter(iorFileName));
                iorFile.println(orb.object_to_string((Object)this.jdal));
                iorFile.close();
            }
            sharedLogger.log((Level)AcsLogLevel.INFO, "JDAL is ready and waiting ...");
            System.out.println("JDAL is ready and waiting ...");
            new Thread(new Runnable((Logger)sharedLogger){
                final /* synthetic */ Logger val$sharedLogger;
                {
                    this.val$sharedLogger = logger;
                }

                @Override
                public void run() {
                    Server.this.preloadCache(servantDelegate.getDALImplDelegate(), this.val$sharedLogger);
                }
            }, "preload-cache").start();
            try {
                ClientLogManager.getAcsLogManager().initRemoteLoggingForService(orb, true);
            }
            catch (Throwable t) {
                sharedLogger.log((Level)AcsLogLevel.ERROR, "Error initializing the remote logging");
            }
            orb.run();
            sharedLogger.log((Level)AcsLogLevel.INFO, "JDAL exiting ORB loop ...");
        }
        catch (Exception e) {
            sharedLogger.log((Level)AcsLogLevel.NOTICE, "ERROR: " + e);
            e.printStackTrace(System.out);
        }
    }

    public void shutdown() {
        this.jdal.shutdown();
    }

    private void preloadCache(DALImpl dal, Logger sharedLogger) {
        boolean allRead = false;
        sharedLogger.log((Level)AcsLogLevel.DEBUG, "Starting pre-filling cache...");
        try {
            for (String node : PRELOAD_TABLE) {
                if (dal.wasCacheLimitReached()) {
                    return;
                }
                try {
                    this.jdal.get_DAO(node);
                }
                catch (CDBXMLErrorEx cDBXMLErrorEx) {
                }
                catch (CDBRecordDoesNotExistEx cDBRecordDoesNotExistEx) {
                    // empty catch block
                }
            }
            for (String subTree : PRELOAD_TABLE_SUBTREE) {
                if (dal.wasCacheLimitReached()) {
                    return;
                }
                String daos = this.jdal.list_nodes(subTree);
                if (daos == null) continue;
                StringTokenizer tokenizer = new StringTokenizer(daos);
                while (tokenizer.hasMoreTokens()) {
                    try {
                        this.jdal.get_DAO(subTree + "/" + tokenizer.nextToken());
                    }
                    catch (CDBXMLErrorEx cDBXMLErrorEx) {
                    }
                    catch (CDBRecordDoesNotExistEx cDBRecordDoesNotExistEx) {}
                }
            }
            allRead = true;
        }
        catch (NO_RESOURCES nores) {
            sharedLogger.log((Level)AcsLogLevel.DEBUG, "Cache filling canceled due to server shutdown.");
            return;
        }
        if (allRead) {
            sharedLogger.log((Level)AcsLogLevel.DEBUG, "Cache filling fully completed.");
        } else {
            sharedLogger.log((Level)AcsLogLevel.DEBUG, "Cache filling partly completed, terminated since cache memory limit was reached.");
        }
    }
}

