/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb.jdal;

import alma.cdbErrType.wrappers.AcsJCDBRecordDoesNotExistEx;
import com.cosylab.cdb.jdal.XMLTreeNode;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLHandler
extends DefaultHandler {
    private static boolean m_toString;
    private final Logger logger;
    public XMLTreeNode m_rootNode = null;
    protected XMLTreeNode m_parent;
    private int elementID = 0;
    private boolean headerEmited = false;
    private boolean autoCloseStartingElement = true;
    private boolean firstElement = true;
    private ArrayList startElements = null;
    private ArrayList elementNames = null;
    private String firstElementName = null;
    private ArrayList prefixes = new ArrayList();
    private int markArrays = 1;
    public String m_errorString = null;
    public StringBuffer m_xmlString = new StringBuffer(256);

    public XMLHandler(boolean toString, Logger logger) {
        this.logger = logger;
        m_toString = toString;
    }

    @Override
    public void startDocument() throws SAXException {
        if (m_toString && !this.headerEmited) {
            this.m_xmlString.append("<?xml version='1.0' encoding='ISO-8859-1'?>\n");
            this.headerEmited = true;
        }
        this.firstElement = true;
    }

    @Override
    public void startElement(String uri, String local, String raw, Attributes attrs) throws SAXException {
        boolean inArray = false;
        if (!this.autoCloseStartingElement && this.firstElement) {
            if (this.startElements == null) {
                this.startElements = new ArrayList();
                this.elementNames = new ArrayList();
            }
            this.startElements.add(raw);
            if (this.firstElementName == null || raw.equals("fault-family")) {
                this.firstElementName = raw;
            }
            this.elementNames.add(this.firstElementName);
            raw = this.firstElementName;
            this.firstElementName = null;
            this.firstElement = false;
        }
        if (!m_toString) {
            if (this.m_rootNode == null) {
                this.m_rootNode = new XMLTreeNode(null);
                this.m_rootNode.m_name = raw;
                this.m_parent = this.m_rootNode;
            } else {
                String mapKey;
                XMLTreeNode pNode = new XMLTreeNode(this.m_parent);
                if (attrs.getLength() > 0 && (raw.equals("_") || raw.endsWith(":_"))) {
                    if (raw.indexOf(58) >= 0) {
                        pNode.m_nameSpace = raw.substring(0, raw.indexOf(58));
                    }
                    if ((raw = attrs.getValue("Name")) == null) {
                        inArray = true;
                        raw = attrs.getValue(0);
                        if (this.markArrays > 0) {
                            pNode.setArrayNode();
                        }
                    } else if (this.markArrays > 0) {
                        if (raw.equals("*")) {
                            pNode.setDynamicNode();
                        } else {
                            pNode.setMapNode();
                        }
                    }
                }
                if (this.m_parent.m_subNodesMap.get(raw) != null) {
                    ++this.elementID;
                    pNode.m_name = raw;
                    mapKey = raw + this.elementID;
                } else {
                    pNode.m_name = mapKey = raw;
                }
                this.m_parent.m_subNodesMap.put(mapKey, pNode);
                this.m_parent = pNode;
            }
        } else {
            if (this.elementNames == null) {
                this.elementNames = new ArrayList();
            }
            this.m_xmlString.append('<');
            if (attrs.getLength() > 0 && (raw.equals("_") || raw.endsWith(":_"))) {
                this.m_xmlString.append(raw);
                this.elementNames.add(raw);
            } else {
                this.m_xmlString.append(raw);
                this.elementNames.add(raw);
            }
        }
        if (this.prefixes.size() > 0) {
            for (int i = 0; i < this.prefixes.size(); ++i) {
                if (m_toString) {
                    this.m_xmlString.append(this.prefixes.get(i));
                    continue;
                }
                String prefix = (String)this.prefixes.get(i);
                String name = prefix.substring(0, prefix.indexOf(61));
                String value = prefix.substring(prefix.indexOf(61) + 1);
                this.m_parent.m_fieldMap.put(name, value);
            }
            this.prefixes.clear();
        }
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                if (m_toString) {
                    this.m_xmlString.append(' ').append(attrs.getQName(i)).append("=\"").append(attrs.getValue(i)).append("\"");
                    continue;
                }
                this.m_parent.m_fieldMap.put(attrs.getQName(i), attrs.getValue(i));
            }
        }
        if (m_toString) {
            this.m_xmlString.append('>');
        }
    }

    @Override
    public void endElement(String uri, String local, String raw) throws SAXException {
        String elem;
        if (!this.autoCloseStartingElement && (elem = (String)this.startElements.get(this.startElements.size() - 1)).equals(raw)) {
            return;
        }
        if (m_toString) {
            elem = (String)this.elementNames.remove(this.elementNames.size() - 1);
            this.m_xmlString.append("</").append(elem).append('>');
        } else {
            this.m_parent = this.m_parent.m_parent;
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (m_toString) {
            this.m_xmlString.append(buf, offset, len);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (prefix.length() > 0) {
            this.prefixes.add(" xmlns:" + prefix + "=\"" + uri + "\"");
        } else {
            this.prefixes.add(" xmlns=\"" + uri + "\"");
        }
    }

    @Override
    public void error(SAXParseException e) {
        this.m_errorString = "Line=" + e.getLineNumber() + ", Column=" + e.getColumnNumber() + ": " + e.getMessage();
        this.logger.log(Level.FINE, "XML parser error: ", e);
    }

    public void setAutoCloseStartingElement(boolean b) {
        this.autoCloseStartingElement = b;
    }

    public void closeElement() throws SAXException {
        if (this.autoCloseStartingElement) {
            return;
        }
        this.startElements.remove(this.startElements.size() - 1);
        if (this.startElements.size() == 0) {
            this.startElements.add("dummy_elem");
        }
        String name = (String)this.elementNames.remove(this.elementNames.size() - 1);
        this.endElement(null, null, name);
    }

    public void setFirstElement(String string) {
        this.firstElementName = string;
    }

    public void setMarkArrays(int mode) {
        this.markArrays = mode;
    }

    public XMLHandler getChild(String curl) throws AcsJCDBRecordDoesNotExistEx {
        XMLTreeNode tnFather = this.m_rootNode;
        XMLTreeNode tnChild = null;
        String strFirst = "";
        String strLast = curl;
        String strPast = "";
        do {
            strFirst = strLast.substring(0, strLast.indexOf(47));
            strLast = strLast.substring(strLast.indexOf(47) + 1);
            tnChild = tnFather.getNodesMap().get(strFirst);
            strPast = strPast + "/" + strFirst;
            if (tnChild == null) {
                AcsJCDBRecordDoesNotExistEx recordDoesNotExist = new AcsJCDBRecordDoesNotExistEx();
                recordDoesNotExist.setCurl(strPast);
                throw recordDoesNotExist;
            }
            tnFather = tnChild;
        } while (!strLast.equals(""));
        XMLHandler a = new XMLHandler(false, this.logger);
        a.m_rootNode = tnChild;
        return a;
    }

    public String toString(boolean withMapNames) {
        if (m_toString) {
            return this.m_xmlString.toString();
        }
        if (this.m_rootNode == null) {
            return null;
        }
        return this.m_rootNode.toString(withMapNames);
    }
}

