/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.archive;

import alma.acs.logging.archive.ArchiveConnectionManager;
import alma.acs.logging.engine.parser.ACSLogParser;
import alma.acs.logging.engine.parser.ACSLogParserFactory;
import alma.acs.logging.io.LoadSwitchesPanel;
import com.cosylab.logging.LoggingClient;
import com.cosylab.logging.engine.ACS.ACSRemoteErrorListener;
import com.cosylab.logging.engine.ACS.ACSRemoteLogListener;
import com.cosylab.logging.engine.LogMatcher;
import com.cosylab.logging.engine.log.ILogEntry;
import com.cosylab.logging.engine.log.LogTypeHelper;
import com.cosylab.logging.settings.LogTypeRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class QueryDlg
extends JDialog
implements ActionListener {
    private ACSRemoteLogListener logListener;
    private ACSRemoteErrorListener errorListener;
    private JButton submitBtn;
    private JButton doneBtn;
    private ArchiveConnectionManager archive;
    private JTextField fromYY;
    private JTextField fromMM;
    private JTextField fromDD;
    private JTextField fromHr;
    private JTextField fromMin;
    private JTextField fromSec;
    private JTextField toYY;
    private JTextField toMM;
    private JTextField toDD;
    private JTextField toHr;
    private JTextField toMin;
    private JTextField toSec;
    private JComboBox minLogLevelCB;
    private JComboBox maxLogLevelCB;
    private JTextField procName;
    private JTextField sourceName;
    private JTextField routineName;
    private JTextField rowLimit;
    private ACSLogParser parser = null;
    private LoggingClient loggingClient = null;
    private LoadSwitchesPanel guiSwitches;
    private JLabel statusLbl = new JLabel();
    private volatile boolean terminateThread;

    public QueryDlg(ArchiveConnectionManager archiveConn, ACSRemoteLogListener listener, ACSRemoteErrorListener errorListener, LoggingClient client) {
        if (listener == null) {
            throw new IllegalArgumentException("Invalid null listener!");
        }
        if (errorListener == null) {
            throw new IllegalArgumentException("Invalid null error listener!");
        }
        if (client == null) {
            throw new IllegalArgumentException("Invalid null LoggingClient!");
        }
        this.loggingClient = client;
        try {
            this.parser = ACSLogParserFactory.getParser();
        }
        catch (Exception pce) {
            System.out.println("Exception in QueryDlg constructor: " + pce);
            pce.printStackTrace();
            this.parser = null;
        }
        this.logListener = listener;
        this.errorListener = errorListener;
        this.setTitle("Load from database");
        this.archive = archiveConn;
        this.setDefaultCloseOperation(2);
        this.initGUI();
        this.setBounds(50, 50, 50, 50);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.submitBtn) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    QueryDlg.this.loggingClient.animateProgressBar("Loading from DB");
                    QueryDlg.this.terminateThread = false;
                    QueryDlg.this.enableInputFields(false);
                    try {
                        QueryDlg.this.submitQuery();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    finally {
                        QueryDlg.this.enableInputFields(true);
                        QueryDlg.this.loggingClient.freezeProgressBar();
                        QueryDlg.this.submitBtn.setEnabled(true);
                    }
                }
            };
            t.setDaemon(false);
            t.setName("DatabaseQuery");
            t.start();
        } else if (e.getSource() == this.doneBtn) {
            this.terminateThread = true;
            this.setVisible(false);
            this.dispose();
        } else {
            System.err.println("Unknown event " + e);
        }
    }

    private void initGUI() {
        Calendar calendar = Calendar.getInstance();
        this.guiSwitches = new LoadSwitchesPanel(this.loggingClient);
        JRootPane mainPnl = this.getRootPane();
        mainPnl.setLayout(new BorderLayout());
        JPanel optionsPnl = new JPanel();
        GridBagLayout prefsLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        optionsPnl.setLayout(prefsLayout);
        JLabel maxLogs = new JLabel("Max num of logs to load:");
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 25;
        c.insets = new Insets(10, 5, 5, 5);
        optionsPnl.add((Component)maxLogs, c);
        JLabel fromLbl = new JLabel("From:");
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 25;
        c.insets = new Insets(5, 5, 5, 5);
        optionsPnl.add((Component)fromLbl, c);
        JLabel toLbl = new JLabel("To:");
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 25;
        c.insets = new Insets(5, 5, 5, 5);
        optionsPnl.add((Component)toLbl, c);
        JLabel routinNameLbl = new JLabel("Routine name:");
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 25;
        c.insets = new Insets(5, 5, 5, 5);
        optionsPnl.add((Component)routinNameLbl, c);
        JLabel procNameLbl = new JLabel("Process name:");
        c.gridx = 0;
        c.gridy = 4;
        c.anchor = 25;
        c.insets = new Insets(5, 5, 5, 5);
        optionsPnl.add((Component)procNameLbl, c);
        JLabel srcNameLbl = new JLabel("Source object:");
        c.gridx = 0;
        c.gridy = 5;
        c.anchor = 25;
        c.insets = new Insets(5, 5, 5, 5);
        optionsPnl.add((Component)srcNameLbl, c);
        JLabel minLogType = new JLabel("From type:");
        c.gridx = 0;
        c.gridy = 6;
        c.anchor = 25;
        c.insets = new Insets(5, 5, 5, 5);
        optionsPnl.add((Component)minLogType, c);
        JLabel maxLogType = new JLabel("To type:");
        c.gridx = 0;
        c.gridy = 7;
        c.anchor = 25;
        c.insets = new Insets(5, 5, 10, 5);
        optionsPnl.add((Component)maxLogType, c);
        this.fromYY = new JTextField(Integer.toString(calendar.get(1)), 4);
        this.fromYY.setName(fromLbl.getText());
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 25;
        c.insets = new Insets(5, 5, 5, 0);
        this.fromYY.getDocument().addDocumentListener(new IntegerDocumentListener());
        optionsPnl.add((Component)this.fromYY, c);
        JLabel separatorF1 = new JLabel("-");
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 25;
        c.insets = new Insets(5, 0, 5, 0);
        optionsPnl.add((Component)separatorF1, c);
        this.fromMM = new JTextField(Integer.toString(calendar.get(2) + 1), 2);
        this.fromMM.setName(fromLbl.getText());
        c.gridx = 3;
        c.gridy = 1;
        c.anchor = 25;
        this.fromMM.getDocument().addDocumentListener(new IntegerDocumentListener());
        optionsPnl.add((Component)this.fromMM, c);
        JLabel separatorF2 = new JLabel("-");
        c.gridx = 4;
        c.gridy = 1;
        c.anchor = 25;
        optionsPnl.add((Component)separatorF2, c);
        this.fromDD = new JTextField(Integer.toString(calendar.get(5)), 2);
        this.fromDD.setName(fromLbl.getText());
        c.gridx = 5;
        c.gridy = 1;
        c.anchor = 25;
        this.fromDD.getDocument().addDocumentListener(new IntegerDocumentListener());
        optionsPnl.add((Component)this.fromDD, c);
        JLabel tlbl = new JLabel("T");
        c.gridx = 6;
        c.gridy = 1;
        c.anchor = 25;
        optionsPnl.add((Component)tlbl, c);
        this.fromHr = new JTextField(Integer.toString(calendar.get(11)), 2);
        this.fromHr.setName(fromLbl.getText());
        c.gridx = 7;
        c.gridy = 1;
        c.anchor = 25;
        this.fromHr.getDocument().addDocumentListener(new IntegerDocumentListener());
        optionsPnl.add((Component)this.fromHr, c);
        JLabel comaF1Lbl = new JLabel(":");
        c.gridx = 8;
        c.gridy = 1;
        c.anchor = 25;
        optionsPnl.add((Component)comaF1Lbl, c);
        this.fromMin = new JTextField(Integer.toString(calendar.get(12)), 2);
        this.fromMin.setName(fromLbl.getText());
        c.gridx = 9;
        c.gridy = 1;
        c.anchor = 25;
        this.fromMin.getDocument().addDocumentListener(new IntegerDocumentListener());
        optionsPnl.add((Component)this.fromMin, c);
        JLabel comaF2Lbl = new JLabel(":");
        c.gridx = 10;
        c.gridy = 1;
        c.anchor = 25;
        optionsPnl.add((Component)comaF2Lbl, c);
        this.fromSec = new JTextField(Integer.toString(calendar.get(13)), 2);
        this.fromSec.setName(fromLbl.getText());
        c.gridx = 11;
        c.gridy = 1;
        c.anchor = 25;
        c.gridwidth = 0;
        this.fromSec.getDocument().addDocumentListener(new IntegerDocumentListener());
        optionsPnl.add((Component)this.fromSec, c);
        this.toYY = new JTextField(Integer.toString(calendar.get(1)), 4);
        this.toYY.setName(toLbl.getText());
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = 25;
        c.insets = new Insets(5, 5, 5, 0);
        this.toYY.getDocument().addDocumentListener(new IntegerDocumentListener());
        optionsPnl.add((Component)this.toYY, c);
        JLabel separatorTo1 = new JLabel("-");
        c.gridx = 2;
        c.gridy = 2;
        c.gridwidth = -1;
        c.anchor = 25;
        c.insets = new Insets(5, 0, 5, 0);
        optionsPnl.add((Component)separatorTo1, c);
        this.toMM = new JTextField(Integer.toString(calendar.get(2) + 1), 2);
        this.toMM.setName(toLbl.getText());
        c.gridx = 3;
        c.gridy = 2;
        c.gridwidth = -1;
        c.anchor = 25;
        this.toMM.getDocument().addDocumentListener(new IntegerDocumentListener());
        optionsPnl.add((Component)this.toMM, c);
        JLabel separatorTo2 = new JLabel("-");
        c.gridx = 4;
        c.gridy = 2;
        c.gridwidth = -1;
        c.anchor = 25;
        optionsPnl.add((Component)separatorTo2, c);
        this.toDD = new JTextField(Integer.toString(calendar.get(5)), 2);
        this.toDD.setName(toLbl.getText());
        c.gridx = 5;
        c.gridy = 2;
        c.gridwidth = -1;
        c.anchor = 25;
        this.toDD.getDocument().addDocumentListener(new IntegerDocumentListener());
        optionsPnl.add((Component)this.toDD, c);
        JLabel t2lbl = new JLabel("T");
        c.gridx = 6;
        c.gridy = 2;
        c.gridwidth = -1;
        c.anchor = 25;
        optionsPnl.add((Component)t2lbl, c);
        this.toHr = new JTextField(Integer.toString(calendar.get(11)), 2);
        this.toHr.setName(toLbl.getText());
        c.gridx = 7;
        c.gridy = 2;
        c.gridwidth = -1;
        c.anchor = 25;
        this.toHr.getDocument().addDocumentListener(new IntegerDocumentListener());
        optionsPnl.add((Component)this.toHr, c);
        JLabel comaTo1Lbl = new JLabel(":");
        c.gridx = 8;
        c.gridy = 2;
        c.gridwidth = -1;
        c.anchor = 25;
        optionsPnl.add((Component)comaTo1Lbl, c);
        this.toMin = new JTextField(Integer.toString(calendar.get(12)), 2);
        this.toMin.setName(toLbl.getText());
        c.gridx = 9;
        c.gridy = 2;
        c.gridwidth = -1;
        c.anchor = 25;
        this.toMin.getDocument().addDocumentListener(new IntegerDocumentListener());
        optionsPnl.add((Component)this.toMin, c);
        JLabel comaTo2Lbl = new JLabel(":");
        c.gridx = 10;
        c.gridy = 2;
        c.gridwidth = -1;
        c.anchor = 25;
        optionsPnl.add((Component)comaTo2Lbl, c);
        this.toSec = new JTextField(Integer.toString(calendar.get(13)), 2);
        this.toSec.setName(toLbl.getText());
        c.gridx = 11;
        c.gridy = 2;
        c.anchor = 25;
        c.gridwidth = 0;
        this.toSec.getDocument().addDocumentListener(new IntegerDocumentListener());
        optionsPnl.add((Component)this.toSec, c);
        this.rowLimit = new JTextField("10000", 20);
        this.rowLimit.setName(maxLogs.getText());
        this.rowLimit.setToolTipText("Valid range  is [0, 2147483646]");
        this.rowLimit.getDocument().addDocumentListener(new IntegerDocumentListener());
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 0;
        c.insets = new Insets(10, 5, 5, 5);
        optionsPnl.add((Component)this.rowLimit, c);
        this.routineName = new JTextField("*", 20);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 0;
        c.insets = new Insets(5, 5, 5, 5);
        optionsPnl.add((Component)this.routineName, c);
        this.procName = new JTextField("*", 20);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 0;
        c.insets = new Insets(5, 5, 5, 5);
        optionsPnl.add((Component)this.procName, c);
        this.sourceName = new JTextField("*", 20);
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 0;
        c.insets = new Insets(5, 5, 5, 5);
        optionsPnl.add((Component)this.sourceName, c);
        this.minLogLevelCB = this.setupTypeCB(this.minLogLevelCB);
        this.minLogLevelCB.setSelectedIndex(LogTypeHelper.INFO.ordinal());
        c.gridx = 1;
        c.gridy = 6;
        c.gridwidth = 0;
        c.insets = new Insets(5, 5, 5, 5);
        optionsPnl.add((Component)this.minLogLevelCB, c);
        this.maxLogLevelCB = this.setupTypeCB(this.maxLogLevelCB);
        this.maxLogLevelCB.setSelectedIndex(LogTypeHelper.EMERGENCY.ordinal());
        c.gridx = 1;
        c.gridy = 7;
        c.gridwidth = 0;
        c.insets = new Insets(5, 5, 10, 5);
        optionsPnl.add((Component)this.maxLogLevelCB, c);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel btnPnl = new JPanel();
        btnPnl.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        BoxLayout boxLayout = new BoxLayout(btnPnl, 2);
        btnPnl.setLayout(boxLayout);
        btnPnl.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.submitBtn = new JButton("Submit");
        this.submitBtn.addActionListener(this);
        this.submitBtn.setEnabled(this.archive.getDBStatus() == ArchiveConnectionManager.DBState.DATABASE_OK);
        this.doneBtn = new JButton("Cancel");
        this.doneBtn.addActionListener(this);
        btnPnl.add((Component)this.submitBtn, "West");
        btnPnl.add(Box.createRigidArea(new Dimension(10, 0)));
        btnPnl.add((Component)this.doneBtn, "East");
        btnPnl.add(Box.createRigidArea(new Dimension(10, 0)));
        this.statusLbl.setBorder(BorderFactory.createLoweredBevelBorder());
        Font fnt = this.statusLbl.getFont();
        Font newFont = fnt.deriveFont(fnt.getSize() * 2 / 3);
        this.statusLbl.setFont(newFont);
        bottomPanel.add((Component)btnPnl, "East");
        bottomPanel.add((Component)this.statusLbl, "Center");
        mainPnl.add((Component)this.guiSwitches, "North");
        mainPnl.add((Component)optionsPnl, "Center");
        mainPnl.add((Component)bottomPanel, "South");
    }

    private JComboBox setupTypeCB(JComboBox box) {
        String[] Descritpions = new String[LogTypeHelper.values().length];
        int t = 0;
        for (LogTypeHelper log : LogTypeHelper.values()) {
            Descritpions[t++] = log.logEntryType;
        }
        JComboBox<String> logLevelCB = new JComboBox<String>(Descritpions);
        LogTypeRenderer rendererCB = new LogTypeRenderer();
        logLevelCB.setEditable(false);
        logLevelCB.setMaximumRowCount(LogTypeHelper.values().length);
        logLevelCB.setRenderer(rendererCB);
        return logLevelCB;
    }

    private void submitQuery() {
        String process;
        String source;
        FieldState chekResult = this.checkFields();
        if (chekResult != FieldState.OK) {
            JOptionPane.showMessageDialog(this, "<HTML>Error getting values from the form!<BR>Check the values of " + chekResult.desc, "Input error!", 0);
            return;
        }
        this.loggingClient.reportStatus("Submitting a query");
        this.guiSwitches.execute();
        StringBuilder from = new StringBuilder(this.fromYY.getText());
        from.append('-');
        if (this.fromMM.getText().length() == 1) {
            from.append('0');
        }
        from.append(this.fromMM.getText());
        from.append('-');
        if (this.fromDD.getText().length() == 1) {
            from.append('0');
        }
        from.append(this.fromDD.getText());
        from.append('T');
        if (this.fromHr.getText().length() == 1) {
            from.append('0');
        }
        from.append(this.fromHr.getText());
        from.append(':');
        if (this.fromMin.getText().length() == 1) {
            from.append('0');
        }
        from.append(this.fromMin.getText());
        from.append(':');
        if (this.fromSec.getText().length() == 1) {
            from.append('0');
        }
        from.append(this.fromSec.getText());
        StringBuilder to = new StringBuilder(this.toYY.getText());
        to.append('-');
        if (this.toMM.getText().length() == 1) {
            to.append('0');
        }
        to.append(this.toMM.getText());
        to.append('-');
        if (this.toDD.getText().length() == 1) {
            to.append('0');
        }
        to.append(this.toDD.getText());
        to.append('T');
        if (this.toHr.getText().length() == 1) {
            to.append('0');
        }
        to.append(this.toHr.getText());
        to.append(':');
        if (this.toMin.getText().length() == 1) {
            to.append('0');
        }
        to.append(this.toMin.getText());
        to.append(':');
        if (this.toSec.getText().length() == 1) {
            to.append('0');
        }
        to.append(this.toSec.getText());
        short minType = (short)LogTypeHelper.values()[this.minLogLevelCB.getSelectedIndex()].acsCoreLevel.value;
        short maxType = (short)LogTypeHelper.values()[this.maxLogLevelCB.getSelectedIndex()].acsCoreLevel.value;
        String routine = this.routineName.getText();
        if (routine.length() == 0) {
            routine = "*";
        }
        if ((source = this.sourceName.getText()).length() == 0) {
            source = "*";
        }
        if ((process = this.procName.getText()).length() == 0) {
            process = "*";
        }
        int maxRows = Integer.parseInt(this.rowLimit.getText());
        Collection logs = null;
        this.updateStatusLbl("Submitting query");
        try {
            logs = this.archive.getLogs(from.toString() + ".000", to.toString() + ".000", minType, maxType, routine, source, process, maxRows);
        }
        catch (Throwable t) {
            System.err.println("Error executing the query: " + t.getMessage());
            t.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, this.formatErrorMsg("Error executing the query:\n" + t.getMessage()), "Database error!", 0);
            this.loggingClient.reportStatus("Query terminated with error");
        }
        if (logs != null && !logs.isEmpty()) {
            this.loggingClient.reportStatus("Num. of logs read from DB: " + logs.size());
            LogMatcher matcher = new LogMatcher();
            matcher.setAudience(this.loggingClient.getEngine().getAudience());
            matcher.setFilters(this.loggingClient.getEngine().getFilters());
            matcher.setDiscardLevel(this.loggingClient.getEngine().getDiscardLevel());
            Iterator iter = logs.iterator();
            int count = 0;
            while (iter.hasNext() && !this.terminateThread) {
                if (++count % 1000 == 0) {
                    this.updateStatusLbl("Flushing logs " + count + "/" + logs.size());
                }
                String str = (String)iter.next();
                ILogEntry logEntry = null;
                try {
                    logEntry = this.parser.parse(str);
                }
                catch (Exception e) {
                    this.errorListener.errorReceived(str);
                    continue;
                }
                if (!matcher.match(logEntry)) continue;
                this.logListener.logEntryReceived(logEntry);
            }
            logs.clear();
            logs = null;
        }
        this.updateStatusLbl("");
        this.guiSwitches.checkControlsState();
    }

    private FieldState checkFields() {
        long rLimit;
        int to_s;
        int to_m;
        int to_h;
        int toD;
        int toM;
        int toY;
        int from_s;
        int from_m;
        int from_h;
        int fromD;
        int fromM;
        int fromY;
        boolean ret;
        boolean bl = ret = Pattern.matches("[0-9]+", this.fromYY.getText()) && Pattern.matches("[0-9]+", this.fromMM.getText()) && Pattern.matches("[0-9]+", this.fromMM.getText()) && Pattern.matches("[0-9]+", this.fromHr.getText()) && Pattern.matches("[0-9]+", this.fromMin.getText()) && Pattern.matches("[0-9]+", this.fromSec.getText());
        if (!ret) {
            return FieldState.FROMDATE_ERROR;
        }
        boolean bl2 = ret = Pattern.matches("[0-9]+", this.toYY.getText()) && Pattern.matches("[0-9]+", this.toMM.getText()) && Pattern.matches("[0-9]+", this.toDD.getText()) && Pattern.matches("[0-9]+", this.toHr.getText()) && Pattern.matches("[0-9]+", this.toMin.getText()) && Pattern.matches("[0-9]+", this.toSec.getText());
        if (!ret) {
            return FieldState.TODATE_ERROR;
        }
        if (!Pattern.matches("[0-9]+", this.rowLimit.getText())) {
            return FieldState.LOGNUM_ERROR;
        }
        try {
            fromY = Integer.parseInt(this.fromYY.getText());
            fromM = Integer.parseInt(this.fromMM.getText());
            fromD = Integer.parseInt(this.fromDD.getText());
            from_h = Integer.parseInt(this.fromHr.getText());
            from_m = Integer.parseInt(this.fromMin.getText());
            from_s = Integer.parseInt(this.fromSec.getText());
        }
        catch (Exception e) {
            return FieldState.FROMDATE_ERROR;
        }
        try {
            toY = Integer.parseInt(this.toYY.getText());
            toM = Integer.parseInt(this.toMM.getText());
            toD = Integer.parseInt(this.toDD.getText());
            to_h = Integer.parseInt(this.toHr.getText());
            to_m = Integer.parseInt(this.toMin.getText());
            to_s = Integer.parseInt(this.toSec.getText());
        }
        catch (Exception e) {
            return FieldState.TODATE_ERROR;
        }
        try {
            rLimit = Long.parseLong(this.rowLimit.getText());
        }
        catch (Exception e) {
            return FieldState.LOGNUM_ERROR;
        }
        ret = fromY >= 2000 && fromY < 2100;
        ret = ret && fromM >= 1 && fromM <= 12;
        ret = ret && fromD >= 1 && fromD <= 31;
        ret = ret && from_h >= 0 && from_h < 24;
        ret = ret && from_m >= 0 && from_m < 60;
        boolean bl3 = ret = ret && from_s >= 0 && from_s < 60;
        if (!ret) {
            return FieldState.FROMDATE_ERROR;
        }
        ret = toY >= 2000 && toY < 2100;
        ret = ret && toM >= 1 && toM <= 12;
        ret = ret && toD >= 1 && toD <= 31;
        ret = ret && to_h >= 0 && to_h < 24;
        ret = ret && to_m >= 0 && to_m < 60;
        boolean bl4 = ret = ret && to_s >= 0 && to_s < 60;
        if (!ret) {
            return FieldState.TODATE_ERROR;
        }
        if (rLimit <= 0L || rLimit >= Integer.MAX_VALUE) {
            return FieldState.LOGNUM_ERROR;
        }
        return FieldState.OK;
    }

    private String formatErrorMsg(String msg) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (int t = 0; t < msg.length(); ++t) {
            char c = msg.charAt(t);
            sb.append(c);
            if (c == '\n') {
                count = 0;
                continue;
            }
            if (++count < 80 || c != ' ') continue;
            count = 0;
            sb.append('\n');
        }
        return sb.toString();
    }

    private void updateStatusLbl(final String msg) {
        class NewMessage
        implements Runnable {
            NewMessage() {
            }

            @Override
            public void run() {
                QueryDlg.this.statusLbl.setText(msg);
            }
        }
        SwingUtilities.invokeLater(new NewMessage());
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.isShowing()) {
            Point loggingPos = this.loggingClient.getLocationOnScreen();
            this.setLocation(loggingPos);
            this.toFront();
        }
        this.guiSwitches.checkControlsState();
    }

    public void close() {
        this.terminateThread = true;
        this.setVisible(false);
        this.dispose();
    }

    private void enableInputFields(final boolean enable) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    QueryDlg.this.fromYY.setEnabled(enable);
                    QueryDlg.this.fromDD.setEnabled(enable);
                    QueryDlg.this.fromMM.setEnabled(enable);
                    QueryDlg.this.fromHr.setEnabled(enable);
                    QueryDlg.this.fromMin.setEnabled(enable);
                    QueryDlg.this.fromSec.setEnabled(enable);
                    QueryDlg.this.toYY.setEnabled(enable);
                    QueryDlg.this.toMM.setEnabled(enable);
                    QueryDlg.this.toDD.setEnabled(enable);
                    QueryDlg.this.toHr.setEnabled(enable);
                    QueryDlg.this.toMin.setEnabled(enable);
                    QueryDlg.this.toSec.setEnabled(enable);
                    QueryDlg.this.rowLimit.setEnabled(enable);
                    QueryDlg.this.routineName.setEnabled(enable);
                    QueryDlg.this.procName.setEnabled(enable);
                    QueryDlg.this.sourceName.setEnabled(enable);
                    QueryDlg.this.minLogLevelCB.setEnabled(enable);
                    QueryDlg.this.maxLogLevelCB.setEnabled(enable);
                    QueryDlg.this.submitBtn.setEnabled(enable);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static enum FieldState {
        OK("OK"),
        FROMDATE_ERROR("Start date"),
        TODATE_ERROR("End date"),
        LOGNUM_ERROR("Max num. of logs to read");

        public final String desc;

        private FieldState(String desc) {
            this.desc = desc;
        }
    }

    private static class IntegerDocumentListener
    implements DocumentListener {
        private final Pattern pattern = Pattern.compile("[0-9]+");

        private IntegerDocumentListener() {
        }

        @Override
        public void insertUpdate(final DocumentEvent e) {
            String insertedText = null;
            try {
                insertedText = e.getDocument().getText(e.getOffset(), e.getLength());
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            if (insertedText == null || insertedText.isEmpty()) {
                return;
            }
            Matcher m = this.pattern.matcher(insertedText);
            if (!m.matches()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            e.getDocument().remove(e.getOffset(), e.getLength());
                        }
                        catch (BadLocationException ble) {
                            try {
                                e.getDocument().remove(0, e.getDocument().getLength());
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

