/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.table;

import alma.acs.gui.util.threadsupport.EDTExecutor;
import alma.acs.logging.archive.zoom.ZoomProgressListener;
import alma.acs.logging.table.LogTableDataModel;
import alma.acs.logging.table.LogTableRowSorter;
import alma.acs.logging.table.LogTooltipHelper;
import alma.acs.logging.table.TablePopupMenu;
import alma.acs.logging.table.renderer.DateRenderer;
import alma.acs.logging.table.renderer.EntryTypeRenderer;
import alma.acs.logging.table.renderer.InfoRenderer;
import alma.acs.util.IsoDateFormat;
import com.cosylab.logging.LoggingClient;
import com.cosylab.logging.client.EntryTypeIcon;
import com.cosylab.logging.engine.FiltersVector;
import com.cosylab.logging.engine.log.ILogEntry;
import com.cosylab.logging.engine.log.LogField;
import com.cosylab.logging.engine.log.LogTypeHelper;
import com.cosylab.logging.settings.FieldChooserDialog;
import com.cosylab.logging.viewcoordination.ViewCoordinator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ProgressMonitor;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.RowSorterEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.w3c.dom.Node;

public class LogEntryTable
extends JTable
implements ZoomProgressListener {
    private TableColumn[] columnsList;
    private boolean[] visibleColumns;
    private FieldChooserDialog fieldChooser = null;
    private LoggingClient loggingClient;
    private DefaultListSelectionModel selectionModel;
    private LogTableRowSorter rowSorter;
    private int selecteViewdRow = -1;
    private int selecteModelRow = -1;
    private int selecteLogKey = -1;
    private DateRenderer dateRenderer;
    private EntryTypeRenderer logTypeRenderer;
    private ProgressMonitor zoomProgressMonitor = null;
    private int zoomTotFiles;
    private volatile ViewCoordinator.SingleLogSelectionListener listener;

    public LogEntryTable(LoggingClient client, boolean initialDateFormat, boolean initalLogTypeFormat) throws Exception {
        if (client == null) {
            throw new IllegalArgumentException("Invalid null LoggingClient!");
        }
        this.loggingClient = client;
        LogTableDataModel model = new LogTableDataModel(client);
        this.setModel(model);
        model.start();
        this.rowSorter = new LogTableRowSorter(model);
        EDTExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                LogEntryTable.this.setRowSorter(LogEntryTable.this.rowSorter);
            }
        });
        final ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(LogField.TIMESTAMP.ordinal() + 1, SortOrder.DESCENDING));
        EDTExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                LogEntryTable.this.rowSorter.setSortKeys(sortKeys);
            }
        });
        this.initialize(initialDateFormat, initalLogTypeFormat);
    }

    protected int columnToModel(int index) {
        return this.convertColumnIndexToModel(index) - 1;
    }

    public Node getExtraInfo() {
        int index = this.getSelectedRow();
        if (index < 0) {
            return null;
        }
        ILogEntry additionalInfo = this.getLCModel().getVisibleLogEntry(index);
        if (!additionalInfo.hasDatas()) {
            return null;
        }
        return null;
    }

    public LogTableDataModel getLCModel() {
        return (LogTableDataModel)this.getModel();
    }

    public int getSortIndex() {
        return this.getLCModel().getFieldSortNumber();
    }

    public void hideColumn(int columnIndex) {
        if (columnIndex > 0 && columnIndex < this.columnsList.length) {
            this.getColumnModel().removeColumn(this.columnsList[columnIndex]);
            this.visibleColumns[columnIndex] = false;
        }
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
        Component c;
        String tooltipTxt = this.getCellStringContent(rowIndex, vColIndex);
        try {
            c = super.prepareRenderer(renderer, rowIndex, vColIndex);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        LogTooltipHelper.setToolTip((JComponent)c, tooltipTxt, 96);
        return c;
    }

    private String getCellStringContent(int row, int col) {
        Object value = this.getValueAt(row, col);
        if (value == null) {
            return "";
        }
        String tempStr = "";
        if (value instanceof Date) {
            IsoDateFormat sdf = new IsoDateFormat();
            tempStr = sdf.format(value);
        } else {
            tempStr = value instanceof Integer ? (this.getColumnName(col).compareTo(LogField.ENTRYTYPE.getName()) == 0 ? LogTypeHelper.values()[((Integer)value).intValue()].logEntryType : value.toString()) : value.toString();
        }
        return tempStr;
    }

    public int getColumnWidth(int n) {
        int width = 0;
        for (int i = 0; i < n; ++i) {
            width += this.getColumnModel().getColumn(i).getWidth();
        }
        return width;
    }

    public void setAdditionalWidth(int n, int width) {
        for (int i = 0; i < n; ++i) {
            TableColumn tc = this.getColumnModel().getColumn(i);
            if (!tc.getHeaderValue().equals("Log Message")) continue;
            tc.setPreferredWidth(tc.getWidth() + width);
        }
    }

    private void initialize(boolean shortDateFormat, boolean logTypeformat) {
        this.createDefaultColumnsFromModel();
        this.setShowHorizontalLines(false);
        TableColumnModel tcm = this.getColumnModel();
        TableColumn tc = tcm.getColumn(0);
        tc.setCellRenderer(new InfoRenderer());
        tc.setWidth(18);
        tc.setMaxWidth(18);
        tc.setResizable(false);
        tc = tcm.getColumn(LogField.ENTRYTYPE.ordinal() + 1);
        this.logTypeRenderer = new EntryTypeRenderer(logTypeformat);
        tc.setCellRenderer(this.logTypeRenderer);
        tc = tcm.getColumn(LogField.TIMESTAMP.ordinal() + 1);
        this.dateRenderer = new DateRenderer(shortDateFormat);
        tc.setCellRenderer(this.dateRenderer);
        int n = tcm.getColumnCount();
        this.columnsList = new TableColumn[n];
        this.visibleColumns = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.columnsList[i] = tcm.getColumn(i);
            this.visibleColumns[i] = true;
            if (i != LogField.LOGMESSAGE.ordinal() + 1) continue;
            this.columnsList[i].setPreferredWidth(250);
        }
        this.setAutoResizeMode(0);
        this.sizeColumnsToFit(0);
        this.hideColumn(LogField.LINE.ordinal() + 1);
        this.hideColumn(LogField.ROUTINE.ordinal() + 1);
        this.hideColumn(LogField.HOST.ordinal() + 1);
        this.hideColumn(LogField.PROCESS.ordinal() + 1);
        this.hideColumn(LogField.CONTEXT.ordinal() + 1);
        this.hideColumn(LogField.THREAD.ordinal() + 1);
        this.hideColumn(LogField.LOGID.ordinal() + 1);
        this.hideColumn(LogField.PRIORITY.ordinal() + 1);
        this.hideColumn(LogField.URI.ordinal() + 1);
        this.hideColumn(LogField.STACKID.ordinal() + 1);
        this.hideColumn(LogField.FILE.ordinal() + 1);
        this.hideColumn(LogField.STACKLEVEL.ordinal() + 1);
        this.hideColumn(LogField.AUDIENCE.ordinal() + 1);
        this.hideColumn(LogField.ARRAY.ordinal() + 1);
        this.hideColumn(LogField.ANTENNA.ordinal() + 1);
        this.selectionModel = new DefaultListSelectionModel();
        this.selectionModel.setSelectionMode(2);
        this.setSelectionModel(this.selectionModel);
        this.addMouseListener(new TableMouseAdapter());
    }

    public boolean isSortAscending() {
        return this.getLCModel().sortedAscending();
    }

    public void setSortIndex(final int index) {
        EDTExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                LogTableDataModel ltdm = LogEntryTable.this.getLCModel();
                ltdm.setSortComparator(index, ltdm.sortedAscending());
            }
        });
    }

    public void setSortOrder(final boolean ascending) {
        EDTExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                LogTableDataModel ltdm = LogEntryTable.this.getLCModel();
                ltdm.setSortComparator(ltdm.getFieldSortNumber(), ascending);
            }
        });
    }

    public void setOrdering(final int field, final boolean ascending) {
        EDTExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                LogEntryTable.this.getLCModel().setSortComparator(field, ascending);
            }
        });
    }

    public void showColumn(int columnIndex) {
        if (columnIndex > 0 && columnIndex < this.columnsList.length) {
            TableColumnModel tcm = this.getColumnModel();
            if (!this.visibleColumns[columnIndex]) {
                tcm.addColumn(this.columnsList[columnIndex]);
                this.visibleColumns[columnIndex] = true;
            }
            int w = this.columnsList[0].getWidth();
            this.columnsList[0].setWidth(w + 1);
            this.columnsList[0].setWidth(w);
        }
    }

    public void showFieldChooser() {
        String[] fieldNames = new String[LogField.values().length];
        int t = 0;
        for (LogField f : LogField.values()) {
            fieldNames[t++] = f.getName();
        }
        boolean[] fieldVisible = this.getVisibleColumns(true);
        if (this.fieldChooser == null) {
            this.fieldChooser = new FieldChooserDialog(this.loggingClient);
        }
        this.fieldChooser.setupFields(fieldNames, fieldVisible);
        this.fieldChooser.setVisible(true);
        if (this.fieldChooser.getModalResult() == FieldChooserDialog.DialogExitAction.CANCEL) {
            return;
        }
        boolean[] newFields = this.fieldChooser.getFields();
        for (int i = 0; i < LogField.values().length; ++i) {
            if (newFields[i] == fieldVisible[i]) continue;
            if (newFields[i]) {
                this.showColumn(i + 1);
                continue;
            }
            this.hideColumn(i + 1);
        }
    }

    public boolean[] getVisibleColumns(boolean zeroBased) {
        int nFields = LogField.values().length;
        boolean[] visibleCols = new boolean[nFields];
        int pad = !zeroBased ? 0 : 1;
        for (int i = 0; i < nFields; ++i) {
            visibleCols[i] = this.visibleColumns[i + pad];
        }
        return visibleCols;
    }

    public void close() {
        if (this.fieldChooser != null) {
            this.fieldChooser.setVisible(false);
            this.fieldChooser.dispose();
            this.fieldChooser = null;
        }
    }

    public void setShortDateFormat(boolean shortFormat) {
        this.dateRenderer.setShortDateFormat(shortFormat);
        this.repaint();
    }

    public void setLogTypeDescriptionView(boolean showDescription) {
        this.logTypeRenderer.viewDescription(showDescription);
        TableColumn logTypeCol = this.columnsList[LogField.ENTRYTYPE.ordinal() + 1];
        if (!showDescription) {
            logTypeCol.setPreferredWidth(EntryTypeIcon.INFO_ICON.icon.getIconWidth());
        } else {
            logTypeCol.setPreferredWidth(4 * EntryTypeIcon.INFO_ICON.icon.getIconWidth());
        }
        this.repaint();
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
        ViewCoordinator.SingleLogSelectionListener listenerCopy = this.listener;
        if (rowIndex != -1 && !toggle && !extend) {
            LogTableDataModel model = (LogTableDataModel)this.getModel();
            ILogEntry log = model.getVisibleLogEntry(this.convertRowIndexToModel(rowIndex));
            this.loggingClient.setLogDetailContent(log);
            this.selecteViewdRow = rowIndex;
            this.selecteModelRow = this.convertRowIndexToModel(rowIndex);
            this.selecteLogKey = ((LogTableDataModel)this.getModel()).getLogKey(this.selecteModelRow);
            if (listenerCopy != null && log != null) {
                listenerCopy.notifyLogSelected(log);
            }
        } else if (listenerCopy != null) {
            listenerCopy.notifyLogSelected(null);
        }
    }

    public void setLogSelectionListener(ViewCoordinator.SingleLogSelectionListener listener) {
        this.listener = listener;
    }

    public void scrollToNextSelectedRow() {
        if (this.selecteViewdRow == -1 || this.selecteViewdRow == this.getRowCount() - 1) {
            return;
        }
        this.changeSelection(this.selecteViewdRow + 1, 1, false, false);
    }

    public void scrollToPrevSelectedRow() {
        if (this.selecteViewdRow <= 0) {
            return;
        }
        this.changeSelection(this.selecteViewdRow - 1, 1, false, false);
    }

    public void scrollToFirstRow() {
        this.changeSelection(0, 1, false, false);
    }

    public void scrollToLastRow() {
        this.changeSelection(this.getRowCount() - 1, 1, false, false);
    }

    public void scrollToSelectedRow() {
        if (this.selecteViewdRow == -1) {
            return;
        }
        EDTExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                int modelRow = ((LogTableDataModel)LogEntryTable.this.getModel()).findKeyPos(LogEntryTable.this.selecteLogKey);
                if (modelRow != -1) {
                    LogEntryTable.this.changeSelection(LogEntryTable.this.convertRowIndexToView(modelRow), 1, false, false);
                }
            }
        });
    }

    public FiltersVector getFilters() {
        return this.rowSorter.getFilters();
    }

    public void setFilters(final FiltersVector newFilters, final boolean append) {
        EDTExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                LogEntryTable.this.rowSorter.setFilters(newFilters, append);
            }
        });
    }

    public String getFiltersString() {
        return this.rowSorter.getFiltersString();
    }

    public void setLogLevel(final LogTypeHelper newLevel) {
        EDTExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                LogEntryTable.this.rowSorter.setLogLevel(newLevel);
            }
        });
        this.rowSorter.setLogLevel(newLevel);
    }

    public int getViewRowCount() {
        return this.rowSorter.getViewRowCount();
    }

    @Override
    public void sorterChanged(RowSorterEvent e) {
        if (e.getType() == RowSorterEvent.Type.SORT_ORDER_CHANGED) {
            this.setVisible(false);
            this.loggingClient.setEnabled(false);
            super.sorterChanged(e);
            this.loggingClient.animateProgressBar("Sorting");
        } else if (e.getType() == RowSorterEvent.Type.SORTED) {
            this.loggingClient.freezeProgressBar();
            super.sorterChanged(e);
            this.loggingClient.setEnabled(true);
            this.setVisible(true);
        }
    }

    public void zoom() {
        if (this.getSelectedRowCount() <= 1) {
            return;
        }
        int[] indexes = this.getSelectedRows();
        long startDate = Long.MAX_VALUE;
        long endDate = 0L;
        this.zoomTotFiles = 0;
        System.out.println("Keys " + indexes.length);
        for (int i : indexes) {
            ILogEntry log = this.getLCModel().getVisibleLogEntry(this.convertRowIndexToModel(i));
            long time = (Long)log.getField(LogField.TIMESTAMP);
            if (time < startDate) {
                startDate = time;
            }
            if (time <= endDate) continue;
            endDate = time;
        }
        String startDateStr = IsoDateFormat.formatDate((Date)new Date(startDate));
        String endDateStr = IsoDateFormat.formatDate((Date)new Date(endDate));
        System.out.println("Zooming from " + startDateStr + " to " + endDateStr);
        try {
            this.loggingClient.getZoomManager().zoom(startDateStr, endDateStr, this.loggingClient, this, this.loggingClient);
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this.loggingClient, "Error while loading logs.\n" + t.getMessage(), "Zoom error", 0);
        }
        if (this.zoomProgressMonitor != null) {
            this.zoomProgressMonitor.close();
            this.zoomProgressMonitor = null;
        }
    }

    @Override
    public void zoomReadingFile(int num) {
        if (this.zoomProgressMonitor != null) {
            this.zoomProgressMonitor.setProgress(num);
            this.zoomProgressMonitor.setNote("Reading " + num + "/" + this.zoomTotFiles);
            if (this.zoomProgressMonitor.isCanceled()) {
                this.loggingClient.getZoomManager().stopZoom();
            }
        }
    }

    @Override
    public void zoomTotalFileToRead(int num) {
        this.zoomTotFiles = num;
        this.zoomProgressMonitor = new ProgressMonitor(this, "Zoom", null, 0, num);
        System.out.println("" + num + " files to read while zoom");
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer temp = super.getCellRenderer(row, column);
        if (temp instanceof JLabel) {
            ((JLabel)((Object)temp)).setVerticalAlignment(1);
        }
        return temp;
    }

    private class TableMouseAdapter
    extends MouseAdapter {
        private TablePopupMenu popupMenu;

        private TableMouseAdapter() {
            this.popupMenu = new TablePopupMenu(LogEntryTable.this.loggingClient, LogEntryTable.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int col = LogEntryTable.this.getColumnModel().getColumnIndexAtX(e.getX());
            int row = LogEntryTable.this.rowAtPoint(e.getPoint());
            if (e.isPopupTrigger() && LogEntryTable.this.getSelectedRowCount() > 0) {
                String textUnderMouse = LogEntryTable.this.getCellStringContent(row, col);
                this.popupMenu.show(LogEntryTable.this, e.getX(), e.getY(), row, col, textUnderMouse);
            }
            LogEntryTable.this.loggingClient.getToolBar().setZoomable(LogEntryTable.this.getSelectedRowCount() > 1 && LogEntryTable.this.loggingClient.getZoomManager().isAvailable());
        }
    }

    public class ColumnMenu
    extends JPopupMenu {
        private String[] menuNames = new String[]{"Sort ascending", "Sort descending", "-", "Remove column", "Column chooser", "-", "Group by column", "Ungroup"};
        private final int itemCount = this.menuNames.length;
        private int columnIndex = 0;
        private JMenuItem[] items = new JMenuItem[this.itemCount];

        public ColumnMenu() {
            JMenuItem menuItem = null;
            for (int i = 0; i < this.itemCount; ++i) {
                if (this.menuNames[i].equals("-")) {
                    this.addSeparator();
                    continue;
                }
                menuItem = new JMenuItem();
                menuItem.setText(this.menuNames[i]);
                menuItem.addActionListener(new MenuClicked());
                this.items[i] = menuItem;
                this.add(menuItem);
            }
        }

        public void setColumnIndex(int index) {
            this.columnIndex = index;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        protected int findItem(Object source) {
            for (int i = 0; i < this.itemCount; ++i) {
                if (this.items[i] != source) continue;
                return i;
            }
            return -1;
        }

        private class MenuClicked
        implements ActionListener {
            private MenuClicked() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                LogEntryTable let = LogEntryTable.this;
                ColumnMenu menu = ColumnMenu.this;
                switch (ColumnMenu.this.findItem(e.getSource())) {
                    case -1: {
                        break;
                    }
                    case 0: {
                        let.setOrdering(menu.getColumnIndex(), true);
                        break;
                    }
                    case 1: {
                        let.setOrdering(menu.getColumnIndex(), false);
                        break;
                    }
                    case 3: {
                        let.hideColumn(menu.getColumnIndex() + 1);
                        break;
                    }
                    case 4: {
                        let.showFieldChooser();
                        break;
                    }
                    case 6: {
                        break;
                    }
                }
            }
        }
    }
}

