/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.table;

import alma.acs.logging.table.LogEntryTable;
import alma.acs.logging.table.LogTableDataModel;
import alma.acs.logging.table.LogTableRowSorter;
import alma.acs.logging.tools.CSVConverter;
import alma.acs.logging.tools.LogConverter;
import alma.acs.logging.tools.TextConverter;
import alma.acs.logging.tools.TwikiTableConverter;
import alma.acs.logging.tools.XMLConverter;
import alma.acs.util.IsoDateFormat;
import com.cosylab.logging.LoggingClient;
import com.cosylab.logging.engine.ExactFilter;
import com.cosylab.logging.engine.Filter;
import com.cosylab.logging.engine.FiltersVector;
import com.cosylab.logging.engine.log.ILogEntry;
import com.cosylab.logging.engine.log.LogField;
import com.cosylab.logging.engine.log.LogTypeHelper;
import com.cosylab.logging.settings.UserInfoDlg;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class TablePopupMenu
extends JPopupMenu
implements ActionListener {
    private final JMenuItem showErrorStack = new JMenuItem("Show error stack");
    private final JMenuItem addUserInfo = new JMenuItem("add Info");
    private final ImageIcon saveIcon = new ImageIcon(LogTypeHelper.class.getResource("/disk.png"));
    private final JMenu saveSelected = new JMenu("Save selected logs...");
    private final ImageIcon saveXmlIcon = new ImageIcon(LogTypeHelper.class.getResource("/xml-file.png"));
    private final JMenuItem saveSelectedAsXML = new JMenuItem("Save as XML", this.saveXmlIcon);
    private final ImageIcon saveTextIcon = new ImageIcon(LogTypeHelper.class.getResource("/text-files.gif"));
    private final JMenuItem saveSelectedAsText = new JMenuItem("Save as text", this.saveTextIcon);
    private final ImageIcon saveTwikiTableIcon = new ImageIcon(LogTypeHelper.class.getResource("/T-twiki.gif"));
    private final JMenuItem saveSelectedAsTwiki = new JMenuItem("Save as twiki table", this.saveTwikiTableIcon);
    private final ImageIcon saveCsvIcon = new ImageIcon(LogTypeHelper.class.getResource("/csv-files.png"));
    private final JMenuItem saveSelectedAsCSV = new JMenuItem("Save as CSV", this.saveCsvIcon);
    private final ImageIcon zoomIcon = new ImageIcon(LogTypeHelper.class.getResource("/zoom.png"));
    private final JMenuItem zoomOverSelected = new JMenuItem("Drill down", this.zoomIcon);
    private LogTableRowSorter sorter;
    private final ImageIcon clipboardIcon = new ImageIcon(LogTypeHelper.class.getResource("/clipboard.png"));
    private final JMenu copyClipboard = new JMenu("to clipboard");
    private final JMenuItem copyClipTxt = new JMenuItem("Copy as text", this.saveTextIcon);
    private final JMenuItem copyClipXml = new JMenuItem("Copy as XML", this.saveXmlIcon);
    private final JMenuItem copyClipTwikiTable = new JMenuItem("Copy as TwikiTable", this.saveTwikiTableIcon);
    private final JMenuItem copyClipCSV = new JMenuItem("Copy as CSV", this.saveCsvIcon);
    private final JMenu quickFiltersMenu = new JMenu("Table filtering");
    private final JMenuItem showsOnlyMI = new JMenuItem("Shows only");
    private final JMenuItem filtersOutMI = new JMenuItem("Filters out");
    private String textToCopy;
    private int row;
    private int col;
    private String stackId;
    private final LoggingClient loggingClient;
    private final LogEntryTable table;
    private final LogTableDataModel model;
    private final DefaultListSelectionModel selectionModel;
    private final TextTransfer textTransfer = new TextTransfer();

    public TablePopupMenu(LoggingClient logCli, LogEntryTable table) {
        this.loggingClient = logCli;
        this.table = table;
        this.model = table.getLCModel();
        this.selectionModel = (DefaultListSelectionModel)table.getSelectionModel();
        this.sorter = (LogTableRowSorter)table.getRowSorter();
        this.setLabel("Paste");
        this.add(this.zoomOverSelected);
        this.zoomOverSelected.addActionListener(this);
        this.addSeparator();
        this.add(this.showErrorStack);
        this.addSeparator();
        this.saveSelected.setIcon(this.saveIcon);
        this.saveSelected.add(this.saveSelectedAsXML);
        this.saveSelected.add(this.saveSelectedAsText);
        this.saveSelected.add(this.saveSelectedAsTwiki);
        this.saveSelected.add(this.saveSelectedAsCSV);
        this.add(this.saveSelected);
        this.addSeparator();
        this.copyClipboard.setIcon(this.clipboardIcon);
        this.copyClipboard.add(this.copyClipXml);
        this.copyClipboard.add(this.copyClipTxt);
        this.copyClipboard.add(this.copyClipTwikiTable);
        this.copyClipboard.add(this.copyClipCSV);
        this.add(this.copyClipboard);
        this.add(this.addUserInfo);
        this.addSeparator();
        this.quickFiltersMenu.add(this.filtersOutMI);
        this.filtersOutMI.setToolTipText("Filters out logs like the one under the mouse pointer");
        this.quickFiltersMenu.add(this.showsOnlyMI);
        this.showsOnlyMI.setToolTipText("Shows only logs like the one under the mouse pointer");
        this.add(this.quickFiltersMenu);
        this.showErrorStack.addActionListener(this);
        this.copyClipXml.addActionListener(this);
        this.copyClipTxt.addActionListener(this);
        this.copyClipTwikiTable.addActionListener(this);
        this.copyClipCSV.addActionListener(this);
        this.addUserInfo.addActionListener(this);
        this.saveSelectedAsCSV.addActionListener(this);
        this.saveSelectedAsText.addActionListener(this);
        this.saveSelectedAsTwiki.addActionListener(this);
        this.saveSelectedAsXML.addActionListener(this);
        this.filtersOutMI.addActionListener(this);
        this.showsOnlyMI.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.textToCopy == null) {
            return;
        }
        if (e.getSource() == this.copyClipXml) {
            this.copyToClipboard(new XMLConverter());
        } else if (e.getSource() == this.copyClipTxt) {
            this.copyToClipboard(new TextConverter(null));
        } else if (e.getSource() == this.copyClipTwikiTable) {
            this.copyToClipboard(new TwikiTableConverter(null));
        } else if (e.getSource() == this.copyClipCSV) {
            this.copyToClipboard(new CSVConverter());
        } else if (e.getSource() == this.addUserInfo) {
            UserInfoDlg dlg = new UserInfoDlg();
            if (dlg.okPressed()) {
                String name = dlg.getInfoName();
                String value = dlg.getInfo();
                value = value.replaceAll("&", "&amp;");
                value = value.replaceAll("'", "&apos;");
                value = value.replaceAll("`", "&apos;");
                value = value.replaceAll("\"", "&quot;");
                value = value.replaceAll("<", "&lt;");
                value = value.replaceAll(">", "&gt;");
                name = name.replaceAll("&", "&amp;");
                name = name.replaceAll("'", "&apos;");
                name = name.replaceAll("`", "&apos;");
                name = name.replaceAll("\"", "&quot;");
                name = name.replaceAll("<", "&lt;");
                name = name.replaceAll(">", "&gt;");
                ILogEntry logEntry = this.model.getVisibleLogEntry(this.table.convertRowIndexToModel(this.row));
                logEntry.addData(name, value);
                this.model.replaceLog(this.table.convertRowIndexToModel(this.row), logEntry);
                LogTableDataModel tableModel = (LogTableDataModel)this.table.getModel();
                tableModel.fireTableRowsUpdated(this.table.convertRowIndexToModel(this.row), this.table.convertRowIndexToModel(this.row));
                this.table.setRowSelectionInterval(this.row, this.row);
                this.loggingClient.setLogDetailContent(logEntry);
            }
        } else if (e.getSource() == this.saveSelectedAsCSV) {
            this.saveSelectedLogs(new CSVConverter(), this.saveCsvIcon, "txt");
        } else if (e.getSource() == this.saveSelectedAsText) {
            this.saveSelectedLogs(new TextConverter(null), this.saveTextIcon, "txt");
        } else if (e.getSource() == this.saveSelectedAsTwiki) {
            this.saveSelectedLogs(new TwikiTableConverter(null), this.saveTwikiTableIcon, "txt");
        } else if (e.getSource() == this.saveSelectedAsXML) {
            this.saveSelectedLogs(new XMLConverter(), this.saveXmlIcon, "xml");
        } else if (e.getSource() == this.showErrorStack) {
            if (this.stackId != null && !this.stackId.isEmpty()) {
                this.loggingClient.addErrorTab(this.stackId);
            }
        } else if (e.getSource() == this.zoomOverSelected) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    TablePopupMenu.this.table.zoom();
                }
            });
            t.setDaemon(true);
            t.setName("TablePopupMenu.actionPerformed.Zoom");
            t.start();
        } else if (e.getSource() == this.showsOnlyMI || e.getSource() == this.filtersOutMI) {
            this.filters(e.getSource() == this.filtersOutMI);
        } else {
            System.err.println("Unhandled event " + e);
        }
    }

    private void filters(boolean out) {
        if (this.textToCopy.startsWith("<html>")) {
            this.textToCopy = this.textToCopy.substring(6, this.textToCopy.length());
            if (this.textToCopy.endsWith("</html>")) {
                this.textToCopy = this.textToCopy.substring(0, this.textToCopy.length() - 7);
            }
        }
        int colModelIndex = this.table.convertColumnIndexToModel(this.col);
        Object comparable = null;
        if (LogField.values()[colModelIndex - 1].getType() == String.class) {
            comparable = this.textToCopy;
        } else if (LogField.values()[colModelIndex - 1].getType() == Integer.class) {
            comparable = Integer.valueOf(this.textToCopy);
        } else if (LogField.values()[colModelIndex - 1].getType() == LogTypeHelper.class) {
            comparable = LogTypeHelper.fromLogTypeDescription((String)this.textToCopy);
        } else if (LogField.values()[colModelIndex - 1].getType() == Long.class) {
            try {
                comparable = IsoDateFormat.parseIsoTimestamp((String)this.textToCopy).getTime();
            }
            catch (Throwable t) {
                System.err.println("Error parsing date " + this.textToCopy + ": " + t.getMessage());
                t.printStackTrace(System.err);
                return;
            }
        }
        FiltersVector newFilterVector = new FiltersVector();
        try {
            ExactFilter newFilter = new ExactFilter(LogField.values()[colModelIndex - 1], false, (Comparable)comparable, out);
            newFilterVector.addFilter((Filter)newFilter, true);
        }
        catch (Throwable t) {
            System.err.println("Error creating filter " + t.getMessage());
            t.printStackTrace(System.err);
        }
        this.table.setFilters(newFilterVector, true);
        this.loggingClient.setTableFilterLbl();
    }

    private void saveSelectedLogs(LogConverter converter, ImageIcon fileIcon, String extension) {
        if (converter == null) {
            throw new IllegalArgumentException("The converter can't be null");
        }
        if (extension == null || extension.isEmpty()) {
            throw new IllegalArgumentException("Invalid file extension");
        }
        converter.setCols(this.buildFields());
        StringBuilder strBuffer = new StringBuilder();
        if (!this.selectionModel.isSelectionEmpty()) {
            for (int i = this.selectionModel.getMinSelectionIndex(); i <= this.selectionModel.getMaxSelectionIndex(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                ILogEntry log = this.model.getVisibleLogEntry(this.sorter.convertRowIndexToModel(i));
                strBuffer.append(converter.convert(log));
            }
            if (strBuffer.length() == 0) {
                return;
            }
        }
        FileNameExtensionFilter fileFilter = new FileNameExtensionFilter("File " + extension, extension);
        CustomFileChooser fc = new CustomFileChooser(fileIcon, fileFilter);
        fc.addChoosableFileFilter(fileFilter);
        if (fc.showSaveDialog(null) == 0) {
            File file = fc.getSelectedFile();
            if (!file.getAbsolutePath().toLowerCase().endsWith("." + extension)) {
                file = new File(file.getAbsolutePath() + "." + extension);
            }
            FileOutputStream outFStream = null;
            try {
                outFStream = new FileOutputStream(file);
            }
            catch (FileNotFoundException fnfe) {
                JOptionPane.showMessageDialog(null, "Error creating " + file.getAbsolutePath() + ":\n" + fnfe.getMessage(), "Error saving logs", 0);
                return;
            }
            try {
                outFStream.write(strBuffer.toString().getBytes());
                outFStream.flush();
                outFStream.close();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, "Error saving " + file.getAbsolutePath() + ":\n" + ioe.getMessage(), "Error saving logs", 0);
            }
        }
    }

    public void show(Component invoker, int x, int y, int row, int col, String txt) {
        boolean singleLineSelected;
        this.row = row;
        this.col = col;
        this.textToCopy = txt;
        boolean bl = singleLineSelected = this.selectionModel.getMinSelectionIndex() == this.selectionModel.getMaxSelectionIndex();
        if (singleLineSelected) {
            ILogEntry selectedLog = this.model.getVisibleLogEntry(this.table.convertRowIndexToModel(row));
            this.stackId = (String)selectedLog.getField(LogField.STACKID);
            this.showErrorStack.setEnabled(this.stackId != null && !this.stackId.isEmpty());
        } else {
            this.stackId = null;
            this.showErrorStack.setEnabled(false);
        }
        this.addUserInfo.setEnabled(singleLineSelected);
        this.copyClipboard.setEnabled(true);
        this.saveSelected.setEnabled(true);
        int colModelIndex = this.table.convertColumnIndexToModel(col);
        this.quickFiltersMenu.setEnabled(colModelIndex > 0);
        if (this.textToCopy == null || this.textToCopy.length() == 0) {
            this.copyClipboard.setEnabled(false);
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkSystemClipboardAccess();
            }
            catch (Exception e) {
                this.copyClipboard.setEnabled(false);
            }
        }
        this.zoomOverSelected.setEnabled(!singleLineSelected && this.loggingClient.getZoomManager().isAvailable());
        this.show(invoker, x, y);
    }

    private String buildFields() {
        int colCount = this.table.getColumnCount();
        StringBuilder ret = new StringBuilder();
        for (int t = 0; t < colCount; ++t) {
            int modelCount = this.table.convertColumnIndexToModel(t);
            if (modelCount == 0) continue;
            ret.append(LogField.values()[modelCount - 1].id);
        }
        return ret.toString();
    }

    private void copyToClipboard(LogConverter converter) {
        if (converter == null) {
            throw new IllegalArgumentException("Invalid null converter");
        }
        converter.setCols(this.buildFields());
        if (!this.selectionModel.isSelectionEmpty()) {
            StringBuffer strBuffer = new StringBuffer();
            for (int i = this.selectionModel.getMinSelectionIndex(); i <= this.selectionModel.getMaxSelectionIndex(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                ILogEntry log = this.model.getVisibleLogEntry(this.table.convertRowIndexToModel(i));
                strBuffer.append(converter.convert(log));
            }
            this.textTransfer.setClipboardContents(strBuffer.toString());
        }
    }

    private static final class TextTransfer
    implements ClipboardOwner {
        private TextTransfer() {
        }

        @Override
        public void lostOwnership(Clipboard aClipboard, Transferable aContents) {
        }

        public void setClipboardContents(String str) {
            StringSelection stringSelection = new StringSelection(str);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            try {
                clipboard.setContents(stringSelection, stringSelection);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }

        private String getClipboardContents() {
            boolean hasTransferableText;
            String result = "";
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = clipboard.getContents(null);
            boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
            if (hasTransferableText) {
                try {
                    result = (String)contents.getTransferData(DataFlavor.stringFlavor);
                }
                catch (UnsupportedFlavorException ex) {
                    System.out.println(ex);
                }
                catch (IOException ex) {
                    System.out.println(ex);
                }
            }
            return result;
        }
    }

    private static final class CustomFileChooser
    extends JFileChooser {
        private final ImageIcon icon;
        private final FileFilter filter;

        public CustomFileChooser(ImageIcon icon, FileFilter filter) {
            if (icon == null || filter == null) {
                throw new IllegalArgumentException("Invalid null param");
            }
            this.icon = icon;
            this.filter = filter;
        }

        @Override
        public Icon getIcon(File f) {
            if (f.isDirectory()) {
                return super.getIcon(f);
            }
            if (this.filter != null && this.filter.accept(f)) {
                return this.icon;
            }
            return super.getIcon(f);
        }
    }
}

