/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging;

import alma.acs.container.AdvancedContainerServices;
import alma.acs.container.ContainerServicesBase;
import alma.acs.gui.widgets.ExtendedTextArea;
import alma.acs.logging.archive.ArchiveConnectionManager;
import alma.acs.logging.archive.QueryDlg;
import alma.acs.logging.archive.zoom.ManualZoomDlg;
import alma.acs.logging.archive.zoom.ZoomManager;
import alma.acs.logging.archive.zoom.ZoomPrefsDlg;
import alma.acs.logging.dialogs.error.ErrorLogDialog;
import alma.acs.logging.dialogs.main.LogFrame;
import alma.acs.logging.dialogs.main.LogMenuBar;
import alma.acs.logging.dialogs.main.LogNavigationBar;
import alma.acs.logging.dialogs.main.LogToolBar;
import alma.acs.logging.errorbrowser.ErrorBrowserDlg;
import alma.acs.logging.preferences.ExpertPrefsDlg;
import alma.acs.logging.preferences.UserPreferences;
import alma.acs.logging.table.LogEntryTable;
import alma.acs.logging.table.LogTableDataModel;
import com.cosylab.logging.MessageWidget;
import com.cosylab.logging.TransparentGlassPane;
import com.cosylab.logging.client.DetailedLogTable;
import com.cosylab.logging.engine.ACS.ACSLogConnectionListener;
import com.cosylab.logging.engine.ACS.ACSRemoteErrorListener;
import com.cosylab.logging.engine.ACS.ACSRemoteLogListener;
import com.cosylab.logging.engine.ACS.LCEngine;
import com.cosylab.logging.engine.Filterable;
import com.cosylab.logging.engine.FiltersVector;
import com.cosylab.logging.engine.audience.Audience;
import com.cosylab.logging.engine.log.ILogEntry;
import com.cosylab.logging.engine.log.LogTypeHelper;
import com.cosylab.logging.search.SearchDialog;
import com.cosylab.logging.settings.FilterChooserDialog;
import com.cosylab.logging.stats.StatsDlg;
import com.cosylab.logging.viewcoordination.ViewCoordinator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.omg.CORBA.ORB;

public class LoggingClient
extends JRootPane
implements ACSRemoteLogListener,
ACSLogConnectionListener,
ACSRemoteErrorListener,
MessageWidget.MessageWidgetListener {
    public static final LogTypeHelper DEFAULT_LOGLEVEL = LogTypeHelper.INFO;
    public static final LogTypeHelper DEFAULT_DISCARDLEVEL = LogTypeHelper.DEBUG;
    private static final String AUDIENCE_PROPERTY = "jlog.mode.audience";
    private JLabel audienceLbl = new JLabel();
    private JLabel engineFiltersLbl = new JLabel();
    private JLabel tableFiltersLbl = new JLabel();
    private JLabel maxNumOfLogsLbl = new JLabel();
    private ArchiveConnectionManager archive;
    private UserPreferences userPreferences = new UserPreferences(0, 100000, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private JPanel ivjJPanel2 = null;
    private JPanel detailedInfoPanel = null;
    private DetailedLogTable detailedLogTable = new DetailedLogTable();
    private JPanel statusLinePnl = null;
    private JScrollPane statusAreaPanel = null;
    private JScrollPane detailedInfoScrollPane = null;
    private JSplitPane statusAreaHrSplitP = null;
    private JSplitPane tableDetailsVrSplitP = null;
    private JScrollPane scrollLogTable = null;
    private LogEntryTable logEntryTable = null;
    private ExtendedTextArea messageTextArea = null;
    private JPanel ivjJFrameContentPane = null;
    private ErrorLogDialog errorDialog;
    private JProgressBar progressBar = new JProgressBar(0, 0, 100);
    private ZoomManager zoom = new ZoomManager();
    private ManualZoomDlg manualZoomDlg;
    private boolean isConnected = false;
    private volatile boolean isStopped = true;
    private SearchDialog searchDialog;
    private StatsDlg statsDlg;
    private QueryDlg databaseDlg = null;
    private EventHandler eventHandler = new EventHandler();
    private LCEngine engine = null;
    private LogTableDataModel tableModel = null;
    private static final int CONNECTED_ICON = 0;
    private static final int CONNECTING_ICON = 1;
    private static final int DISCONNECTED_ICON = 2;
    private static final int SUSPENDED_ICON = 3;
    private static final int DELAY_ICON = 4;
    private ImageIcon[] connectionStatusIcons;
    private JLabel connectionStatusLbl;
    private JLabel connectionDBLbl;
    private final JLabel jlogErrorLbl = new JLabel(new ImageIcon(this.getClass().getResource("/errorLogIcon.png")));
    private LogToolBar toolBar;
    private LogNavigationBar navigationToolbar;
    private LogMenuBar menuBar = new LogMenuBar();
    private FilterChooserDialog engineFiltersDlg = null;
    private ErrorBrowserDlg errorBrowserDialog = null;
    private FilterChooserDialog filterChooserDialog = null;
    private final LogFrame logFrame;
    private static final String DEBUG_MODE_PROPERTY = "alma.acs.jlog.debugMode";
    private final boolean debugMode = Boolean.getBoolean("alma.acs.jlog.debugMode");
    protected ContainerServicesBase containerServices = null;
    private MessageWidget errorWidget = new MessageWidget();
    private TransparentGlassPane glassPane;
    private ViewCoordinator viewCoord;

    public LoggingClient() {
        this.logFrame = null;
        this.initialize(DEFAULT_LOGLEVEL, DEFAULT_DISCARDLEVEL, false);
        this.initAudience(null);
    }

    public LoggingClient(LogFrame frame, LogTypeHelper logLevel, LogTypeHelper discardLevel, boolean unlimited, Audience.AudienceInfo aInfo) {
        this.isStopped = false;
        this.logFrame = frame;
        this.initialize(logLevel, discardLevel, unlimited);
        this.initAudience(aInfo);
    }

    public void start() throws Exception {
        if (this.containerServices == null) {
            throw new IllegalArgumentException("Starting the plugin without setting the ContainerServices");
        }
        this.isStopped = false;
        this.connect();
    }

    public void stop() throws Exception {
        this.isStopped = true;
        this.close(false);
    }

    public void pause() throws Exception {
        this.toolBar.pause();
        this.engine.setPaused(true);
    }

    public void resume() throws Exception {
        this.toolBar.unpause();
        this.engine.setPaused(false);
    }

    public void connect(boolean connectEngine) {
        if (connectEngine) {
            this.menuBar.getSuspendMenuItem().setSelected(false);
            this.getEngine().setSupended(this.menuBar.getSuspendMenuItem().isSelected());
            this.connect();
        } else {
            this.menuBar.getAutoReconnectMenuItem().setState(false);
            this.engine.enableAutoReconnection(false);
            this.disconnect();
        }
    }

    public void connect() {
        if (this.containerServices != null) {
            ORB orb = null;
            AdvancedContainerServices advContSvc = this.containerServices.getAdvancedContainerServices();
            if (advContSvc != null) {
                orb = advContSvc.getORB();
                this.getEngine().setConnectionParams(orb, null);
            }
        }
        try {
            this.getEngine().connect("ACS");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void disconnect() {
        this.getEngine().disconnect();
    }

    private void connFields(ActionEvent arg1) {
        try {
            this.getLogEntryTable().showFieldChooser();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void showTableFiltersDialog(ActionEvent arg1) {
        if (this.filterChooserDialog == null) {
            class TableFilterable
            implements Filterable {
                TableFilterable() {
                }

                public FiltersVector getFilters() {
                    return LoggingClient.this.logEntryTable.getFilters();
                }

                public void setFilters(FiltersVector newFilters, boolean append) {
                    LoggingClient.this.logEntryTable.setFilters(newFilters, append);
                    LoggingClient.this.setTableFilterLbl();
                }
            }
            this.filterChooserDialog = new FilterChooserDialog("Filter chooser", this, new TableFilterable());
        }
        this.filterChooserDialog.setFilters(this.logEntryTable.getFilters());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoggingClient.this.enableFiltersWidgets(false);
                LoggingClient.this.filterChooserDialog.setVisible(true);
            }
        });
    }

    public void setTableFilterLbl() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LoggingClient.this.logEntryTable.getFilters().hasActiveFilters()) {
                    LoggingClient.this.tableFiltersLbl.setForeground(Color.RED);
                    LoggingClient.this.tableFiltersLbl.setText("Table filtered");
                    LoggingClient.this.tableFiltersLbl.setToolTipText(LoggingClient.this.logEntryTable.getFiltersString());
                } else {
                    LoggingClient.this.tableFiltersLbl.setForeground(Color.BLACK);
                    LoggingClient.this.tableFiltersLbl.setText("Table not filtered");
                    LoggingClient.this.tableFiltersLbl.setToolTipText(null);
                }
            }
        });
    }

    private void setNumberOfLogsLbl() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int nLogs = LoggingClient.this.userPreferences.getMaxNumOfLogs();
                if (nLogs > 0) {
                    String str = Integer.toString(nLogs);
                    if (str.length() > 3) {
                        str = str.substring(0, str.length() - 3) + "K";
                    }
                    LoggingClient.this.maxNumOfLogsLbl.setForeground(Color.RED);
                    LoggingClient.this.maxNumOfLogsLbl.setText(str);
                    LoggingClient.this.maxNumOfLogsLbl.setToolTipText("The number of logs to keep in memory is limited to " + str);
                } else {
                    LoggingClient.this.maxNumOfLogsLbl.setForeground(Color.BLACK);
                    LoggingClient.this.maxNumOfLogsLbl.setText("Unlimited");
                    LoggingClient.this.maxNumOfLogsLbl.setToolTipText("The number of logs to keep in memory is unlimited");
                }
            }
        });
    }

    private void setEngineFilterLbl() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LoggingClient.this.engine == null || LoggingClient.this.engine.getFilters() == null || !LoggingClient.this.engine.getFilters().hasActiveFilters()) {
                    LoggingClient.this.engineFiltersLbl.setForeground(Color.BLACK);
                    LoggingClient.this.engineFiltersLbl.setText("Engine not filtered");
                    LoggingClient.this.engineFiltersLbl.setToolTipText(null);
                } else {
                    LoggingClient.this.engineFiltersLbl.setForeground(Color.RED);
                    LoggingClient.this.engineFiltersLbl.setText("Engine filtered");
                    LoggingClient.this.engineFiltersLbl.setToolTipText(LoggingClient.this.engine.getFiltersString());
                }
            }
        });
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("JFrameContentPane");
                this.ivjJFrameContentPane.setLayout(new BorderLayout());
                this.ivjJFrameContentPane.add((Component)this.getStatusAreaHrPane(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJFrameContentPane;
    }

    public JScrollPane getLogTableScroolP() {
        if (this.scrollLogTable == null) {
            try {
                this.scrollLogTable = new JScrollPane(this.getLogEntryTable(), 20, 30);
                this.scrollLogTable.setName("scrollLogTable");
                this.scrollLogTable.setBackground(new Color(204, 204, 204));
                this.scrollLogTable.setFont(new Font("Arial", 1, 12));
                this.scrollLogTable.setMinimumSize(new Dimension(100, 50));
                this.scrollLogTable.addComponentListener(new CustomColumnListener());
                this.scrollLogTable.getViewport().setScrollMode(1);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.scrollLogTable;
    }

    public LogEntryTable getLogEntryTable() {
        if (this.logEntryTable == null) {
            try {
                this.logEntryTable = new LogEntryTable(this, this.menuBar.getShortDateViewMenuItem().isSelected(), this.menuBar.getLogTypeDescriptionViewMenuItem().isSelected());
                this.logEntryTable.setName("logEntryTable");
                this.logEntryTable.setBounds(0, 0, 200, 200);
                this.tableModel = this.logEntryTable.getLCModel();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.logEntryTable;
    }

    private void handleException(Throwable exception) {
        this.showErrorMessage("Uncaught exception", exception);
    }

    private void initConnections() throws Exception {
        this.menuBar.setEventHandler(this.eventHandler, this.eventHandler);
        this.toolBar.setEventHandler(this.eventHandler);
        this.navigationToolbar.setEventHandler(this.eventHandler);
    }

    private void initialize(LogTypeHelper logLevel, LogTypeHelper discardLevel, boolean unlimited) {
        try {
            this.setName("LoggingClientPanel");
            this.messageTextArea = new ExtendedTextArea();
            this.glassPane = new TransparentGlassPane(this.getContentPane());
            this.setGlassPane(this.glassPane);
            this.errorWidget.addAckListener(this);
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.setDismissDelay(60000);
            Dimension d = new Dimension(750, 550);
            this.setPreferredSize(d);
            this.getContentPane().setLayout(new BorderLayout());
            this.setJMenuBar(this.menuBar);
            this.getContentPane().add((Component)this.getJFrameContentPane(), "Center");
            JPanel northPanel = new JPanel(new BorderLayout());
            JPanel toolbarsPanel = new JPanel();
            BoxLayout toolbarLayout = new BoxLayout(toolbarsPanel, 1);
            toolbarsPanel.setLayout(toolbarLayout);
            this.toolBar = new LogToolBar(logLevel, discardLevel);
            boolean zoomAvailable = this.zoom.isAvailable();
            this.toolBar.setZoomable(zoomAvailable);
            this.menuBar.getManualZoomMI().setEnabled(zoomAvailable);
            toolbarsPanel.add(this.toolBar);
            this.navigationToolbar = new LogNavigationBar(this.getLogEntryTable());
            toolbarsPanel.add(this.navigationToolbar);
            northPanel.add((Component)toolbarsPanel, "North");
            northPanel.add((Component)this.errorWidget, "South");
            this.getContentPane().add((Component)northPanel, "North");
            this.initConnections();
            this.validate();
            this.getLogEntryTable().setLogLevel((LogTypeHelper)this.toolBar.getLogLevelCB().getSelectedItem());
            if (unlimited) {
                this.userPreferences.setMaxLogs(0);
            }
            this.getLCModel1().setTimeFrame(this.userPreferences.getMillisecondsTimeFrame());
            this.getLCModel1().setMaxLog(this.userPreferences.getMaxNumOfLogs());
            this.archive = new ArchiveConnectionManager(this);
            this.setTableFilterLbl();
            this.setEngineFilterLbl();
            this.setNumberOfLogsLbl();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.getTableDetailsVrPane().setDividerLocation(this.getTableDetailsVrPane().getLastDividerLocation());
        this.getStatusAreaHrPane().setDividerLocation(350);
    }

    public void showDetailedLogInfo() {
        try {
            LogEntryTable jt = this.getLogEntryTable();
            int selectedRow = jt.getSelectedRow();
            if (selectedRow == -1) {
                this.detailedLogTable.setupContent(null);
            } else {
                ILogEntry log = jt.getLCModel().getVisibleLogEntry(selectedRow);
                this.detailedLogTable.setupContent(log);
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void setLogDetailContent(ILogEntry log) {
        class DetailedLogFiller
        implements Runnable {
            public ILogEntry logToWrite;

            DetailedLogFiller() {
            }

            @Override
            public void run() {
                LoggingClient.this.detailedLogTable.setupContent(this.logToWrite);
            }
        }
        DetailedLogFiller filler = new DetailedLogFiller();
        filler.logToWrite = log;
        SwingUtilities.invokeLater(filler);
    }

    public void connLCEngDisconnect(WindowEvent arg1) {
        try {
            this.getEngine().disconnect();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JPanel getJPanel2() {
        if (this.ivjJPanel2 == null) {
            try {
                this.ivjJPanel2 = new JPanel();
                this.ivjJPanel2.setName("JPanel2");
                this.ivjJPanel2.setLayout(new BorderLayout());
                this.ivjJPanel2.add((Component)this.getStatusLinePnl(), "South");
                this.ivjJPanel2.add((Component)this.getTableDetailsVrPane(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel2;
    }

    private JPanel getDeatailedInfoPanel() {
        if (this.detailedInfoPanel == null) {
            try {
                BorderLayout layout = new BorderLayout();
                layout.setVgap(10);
                this.detailedInfoPanel = new JPanel(layout);
                this.detailedInfoPanel.setName("detailedInfoPanel");
                JLabel lbl = new JLabel("Detailed info");
                this.detailedInfoPanel.add((Component)lbl, "North");
                this.detailedInfoPanel.add((Component)this.getLogDetailScrollPane(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.detailedInfoPanel;
    }

    private JPanel getStatusLinePnl() {
        if (this.statusLinePnl == null) {
            try {
                this.connectionStatusIcons = new ImageIcon[5];
                this.connectionStatusIcons[0] = new ImageIcon(this.getClass().getResource("/console-connected.png"));
                this.connectionStatusIcons[1] = new ImageIcon(this.getClass().getResource("/console-connecting.png"));
                this.connectionStatusIcons[2] = new ImageIcon(this.getClass().getResource("/console-disconnected.png"));
                this.connectionStatusIcons[3] = new ImageIcon(this.getClass().getResource("/console-suspended.png"));
                this.connectionStatusIcons[4] = new ImageIcon(this.getClass().getResource("/console-delay.png"));
                this.connectionStatusLbl = new JLabel(this.connectionStatusIcons[1]);
                this.connectionDBLbl = new JLabel();
                this.statusLinePnl = new JPanel();
                this.statusLinePnl.setName("Status_line");
                this.statusLinePnl.setLayout(new GridBagLayout());
                GridBagConstraints constraintsProgressBar = new GridBagConstraints();
                constraintsProgressBar.gridx = 0;
                constraintsProgressBar.gridy = 0;
                constraintsProgressBar.fill = 1;
                constraintsProgressBar.anchor = 17;
                constraintsProgressBar.weightx = 1.0;
                constraintsProgressBar.insets = new Insets(1, 2, 1, 1);
                this.statusLinePnl.add((Component)this.progressBar, constraintsProgressBar);
                GridBagConstraints constraintsNumFlt = new GridBagConstraints();
                constraintsNumFlt.gridx = 1;
                constraintsNumFlt.gridy = 0;
                constraintsNumFlt.insets = new Insets(1, 1, 1, 1);
                this.maxNumOfLogsLbl.setVisible(true);
                this.maxNumOfLogsLbl.setBorder(BorderFactory.createLoweredBevelBorder());
                Font fntNumFlt = this.maxNumOfLogsLbl.getFont();
                Font newFontNumFlt = fntNumFlt.deriveFont(fntNumFlt.getSize() - 2);
                this.maxNumOfLogsLbl.setFont(newFontNumFlt);
                this.statusLinePnl.add((Component)this.maxNumOfLogsLbl, constraintsNumFlt);
                GridBagConstraints constraintsEngineFlt = new GridBagConstraints();
                constraintsEngineFlt.gridx = 2;
                constraintsEngineFlt.gridy = 0;
                constraintsEngineFlt.insets = new Insets(1, 1, 1, 1);
                this.engineFiltersLbl.setVisible(true);
                this.engineFiltersLbl.setBorder(BorderFactory.createLoweredBevelBorder());
                Font fntEngineFlt = this.engineFiltersLbl.getFont();
                Font newFontEngineFlt = fntEngineFlt.deriveFont(fntEngineFlt.getSize() - 2);
                this.engineFiltersLbl.setFont(newFontEngineFlt);
                this.statusLinePnl.add((Component)this.engineFiltersLbl, constraintsEngineFlt);
                GridBagConstraints constraintsTableFlt = new GridBagConstraints();
                constraintsTableFlt.gridx = 3;
                constraintsTableFlt.gridy = 0;
                constraintsTableFlt.insets = new Insets(1, 1, 1, 1);
                this.tableFiltersLbl.setVisible(true);
                this.tableFiltersLbl.setBorder(BorderFactory.createLoweredBevelBorder());
                Font fntTableFlt = this.tableFiltersLbl.getFont();
                Font newFontTableFlt = fntTableFlt.deriveFont(fntTableFlt.getSize() - 2);
                this.tableFiltersLbl.setFont(newFontTableFlt);
                this.statusLinePnl.add((Component)this.tableFiltersLbl, constraintsTableFlt);
                GridBagConstraints constraintsAudience = new GridBagConstraints();
                constraintsAudience.gridx = 4;
                constraintsAudience.gridy = 0;
                constraintsAudience.insets = new Insets(1, 1, 1, 1);
                this.audienceLbl.setVisible(true);
                this.audienceLbl.setBorder(BorderFactory.createLoweredBevelBorder());
                Font fnt = this.audienceLbl.getFont();
                Font newFont = fnt.deriveFont(fnt.getSize() - 2);
                this.audienceLbl.setFont(newFont);
                this.statusLinePnl.add((Component)this.audienceLbl, constraintsAudience);
                GridBagConstraints constraintsConnectionDBStatus = new GridBagConstraints();
                constraintsConnectionDBStatus.gridx = 5;
                constraintsConnectionDBStatus.gridy = 0;
                constraintsConnectionDBStatus.insets = new Insets(1, 2, 1, 2);
                this.statusLinePnl.add((Component)this.connectionDBLbl, constraintsConnectionDBStatus);
                GridBagConstraints constraintsJlogErrors = new GridBagConstraints();
                constraintsConnectionDBStatus.gridx = 6;
                constraintsConnectionDBStatus.gridy = 0;
                constraintsConnectionDBStatus.insets = new Insets(1, 2, 1, 2);
                this.statusLinePnl.add((Component)this.jlogErrorLbl, constraintsJlogErrors);
                this.jlogErrorLbl.setVisible(false);
                this.jlogErrorLbl.setToolTipText("Error reading logs");
                this.jlogErrorLbl.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        LoggingClient.this.jlogErrorLbl.setVisible(false);
                        LoggingClient.this.errorDialog.setVisible(true, LoggingClient.this);
                        super.mouseClicked(e);
                    }
                });
                GridBagConstraints constraintsConnectionStatus = new GridBagConstraints();
                constraintsConnectionStatus.gridx = 7;
                constraintsConnectionStatus.gridy = 0;
                constraintsConnectionStatus.insets = new Insets(1, 2, 1, 2);
                this.statusLinePnl.add((Component)this.connectionStatusLbl, constraintsConnectionStatus);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.statusLinePnl;
    }

    private JScrollPane getStatusAreaPanel() {
        if (this.statusAreaPanel == null) {
            try {
                this.statusAreaPanel = new JScrollPane();
                this.statusAreaPanel.setName("JScrollPane1");
                this.statusAreaPanel.setVerticalScrollBarPolicy(22);
                this.statusAreaPanel.setPreferredSize(new Dimension(50, 50));
                this.statusAreaPanel.setMinimumSize(new Dimension(50, 50));
                this.statusAreaPanel.setViewportView((Component)this.messageTextArea);
                this.statusAreaPanel.setVisible(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.statusAreaPanel;
    }

    public JScrollPane getLogDetailScrollPane() {
        if (this.detailedInfoScrollPane == null) {
            try {
                this.detailedInfoScrollPane = new JScrollPane(this.detailedLogTable);
                this.detailedInfoScrollPane.setName("detailedInfoScrollPane");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.detailedInfoScrollPane;
    }

    private JSplitPane getStatusAreaHrPane() {
        if (this.statusAreaHrSplitP == null) {
            try {
                this.statusAreaHrSplitP = new JSplitPane(0);
                this.statusAreaHrSplitP.setName("JSplitPane1");
                this.statusAreaHrSplitP.setLastDividerLocation(350);
                this.statusAreaHrSplitP.setDividerLocation(350);
                this.statusAreaHrSplitP.add((Component)this.getStatusAreaPanel(), "bottom");
                this.statusAreaHrSplitP.add((Component)this.getJPanel2(), "top");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.statusAreaHrSplitP;
    }

    private JSplitPane getTableDetailsVrPane() {
        if (this.tableDetailsVrSplitP == null) {
            try {
                this.tableDetailsVrSplitP = new JSplitPane(1);
                this.tableDetailsVrSplitP.setName("TableDetailsSplitPane");
                this.tableDetailsVrSplitP.setLastDividerLocation(570);
                this.tableDetailsVrSplitP.setAlignmentX(0.0f);
                this.tableDetailsVrSplitP.setContinuousLayout(true);
                this.tableDetailsVrSplitP.add((Component)this.getLogTableScroolP(), "left");
                this.tableDetailsVrSplitP.add((Component)this.getDeatailedInfoPanel(), "right");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.tableDetailsVrSplitP;
    }

    public LCEngine getEngine() {
        if (this.engine == null) {
            try {
                this.engine = new LCEngine();
                this.engine.addLogConnectionListener((ACSLogConnectionListener)this);
                this.engine.addLogListener((ACSRemoteLogListener)this);
                this.engine.addLogErrorListener((ACSRemoteErrorListener)this);
                this.engine.setDiscardLevel(LogTypeHelper.fromLogTypeDescription((String)((String)this.toolBar.getDiscardLevelCB().getSelectedItem())));
                if (this.logFrame != null) {
                    this.engine.addLogConnectionListener((ACSLogConnectionListener)this.logFrame);
                }
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.engine;
    }

    public LogTableDataModel getLCModel1() {
        return this.tableModel;
    }

    public void loggingClient_ComponentResized(ComponentEvent e) {
        if (e.getComponent() == this) {
            int w = this.getLogEntryTable().getWidth();
            int h = this.getLogEntryTable().getHeight();
            System.out.println(w + ", " + h);
            System.out.println(this.getTableDetailsVrPane().getWidth());
            System.out.println(this.getStatusAreaHrPane().getHeight());
            this.getTableDetailsVrPane().setDividerLocation(this.getTableDetailsVrPane().getWidth() - w);
            this.getStatusAreaHrPane().setDividerLocation(this.getStatusAreaHrPane().getHeight() - h);
        }
    }

    private void setLCModel1(LogTableDataModel newValue) {
        if (this.tableModel != newValue) {
            try {
                this.tableModel = newValue;
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
    }

    public void enableSearchNext(boolean enable) {
        this.menuBar.getSearchNextMenuItem().setEnabled(enable);
    }

    public void animateProgressBar(final String text, final int min, final int max) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (min >= max) {
                    throw new IllegalArgumentException("Invalid range: [" + min + "," + max + "]");
                }
                Cursor hourglassCursor = new Cursor(3);
                LoggingClient.this.setCursor(hourglassCursor);
                if (text != null && text.length() > 0) {
                    LoggingClient.this.progressBar.setString(text);
                    LoggingClient.this.progressBar.setStringPainted(true);
                    LoggingClient.this.progressBar.setToolTipText(text);
                } else {
                    LoggingClient.this.progressBar.setStringPainted(false);
                    LoggingClient.this.progressBar.setToolTipText("Wait please");
                }
                LoggingClient.this.progressBar.setMinimum(min);
                LoggingClient.this.progressBar.setMaximum(max);
                LoggingClient.this.progressBar.setIndeterminate(false);
                LoggingClient.this.progressBar.setVisible(true);
            }
        });
    }

    public void moveProgressBar(final int newPos) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoggingClient.this.progressBar.setValue(newPos);
            }
        });
    }

    public void animateProgressBar(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Cursor hourglassCursor = new Cursor(3);
                LoggingClient.this.setCursor(hourglassCursor);
                if (text != null && text.length() > 0) {
                    LoggingClient.this.progressBar.setString(text);
                    LoggingClient.this.progressBar.setStringPainted(true);
                    LoggingClient.this.progressBar.setToolTipText(text);
                } else {
                    LoggingClient.this.progressBar.setStringPainted(false);
                    LoggingClient.this.progressBar.setToolTipText("Wait please");
                }
                LoggingClient.this.progressBar.setIndeterminate(true);
            }
        });
    }

    public void freezeProgressBar() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoggingClient.this.progressBar.setIndeterminate(false);
                LoggingClient.this.progressBar.setMinimum(0);
                LoggingClient.this.progressBar.setMaximum(100);
                LoggingClient.this.progressBar.setValue(0);
                LoggingClient.this.progressBar.setStringPainted(false);
                LoggingClient.this.progressBar.setToolTipText(null);
                Cursor normalCursor = new Cursor(0);
                LoggingClient.this.setCursor(normalCursor);
            }
        });
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public int getDiscardLevel() {
        return this.toolBar.getDiscardLevelCB().getSelectedIndex();
    }

    public void logEntryReceived(ILogEntry logEntry) {
        this.getLogEntryTable().getLCModel().appendLog(logEntry);
    }

    public void reportStatus(String status) {
        this.messageTextArea.append(status);
    }

    public void acsLogConnEstablished() {
        this.isConnected = true;
        this.connectionStatusLbl.setIcon(this.connectionStatusIcons[0]);
        this.connectionStatusLbl.setToolTipText("Connected");
        this.glassPane.setVisible(false);
        if (this.errorWidget.getAckButton().isVisible()) {
            this.errorWidget.getAckButton().doClick();
        }
    }

    public void acsLogConnDisconnected() {
        this.isConnected = false;
        this.connectionStatusLbl.setIcon(this.connectionStatusIcons[2]);
        this.connectionStatusLbl.setToolTipText("Disconnected");
        this.glassPane.setVisible(true);
    }

    public void acsLogConnLost() {
        this.isConnected = false;
        if (this.isStopped) {
            return;
        }
        this.glassPane.setVisible(true);
        this.showErrorMessage("Connection lost", null);
    }

    public void acsLogConnConnecting() {
        this.connectionStatusLbl.setIcon(this.connectionStatusIcons[1]);
        this.connectionStatusLbl.setToolTipText("Connecting");
    }

    public void acsLogConnSuspended() {
        this.connectionStatusLbl.setIcon(this.connectionStatusIcons[3]);
        this.connectionStatusLbl.setToolTipText("Suspended");
    }

    public void acsLogsDelay() {
        this.connectionStatusLbl.setIcon(this.connectionStatusIcons[4]);
        this.connectionStatusLbl.setToolTipText("Delay");
    }

    public void showDBStatus(ImageIcon icon, String msg) {
        this.connectionDBLbl.setIcon(icon);
        this.connectionDBLbl.setToolTipText(msg);
    }

    public UserPreferences getPrefs() {
        return this.userPreferences;
    }

    public boolean isPaused() {
        return this.toolBar.isPaused();
    }

    public void hideExitMenu(boolean hide) {
        this.menuBar.hideExitMenu(hide);
    }

    public void close(boolean sync) {
        this.setVisible(false);
        if (this.tableModel != null) {
            this.tableModel.close(sync);
        }
        if (this.logEntryTable != null) {
            this.logEntryTable.close();
        }
        if (this.engine != null) {
            this.engine.close(sync);
        }
        if (this.errorDialog != null) {
            this.errorDialog.setVisible(false);
            this.errorDialog.dispose();
            this.errorDialog = null;
        }
        if (this.statsDlg != null) {
            this.statsDlg.setVisible(false);
            this.statsDlg.dispose();
            this.statsDlg = null;
        }
        if (this.searchDialog != null) {
            this.searchDialog.setVisible(false);
            this.searchDialog.dispose();
            this.searchDialog = null;
        }
        if (this.engineFiltersDlg != null) {
            this.engineFiltersDlg.setVisible(false);
            this.engineFiltersDlg.dispose();
            this.engineFiltersDlg = null;
        }
        if (this.filterChooserDialog != null) {
            this.filterChooserDialog.setVisible(false);
            this.filterChooserDialog.dispose();
            this.filterChooserDialog = null;
        }
        if (this.errorBrowserDialog != null) {
            this.errorBrowserDialog.close();
            this.errorBrowserDialog = null;
        }
        if (this.databaseDlg != null) {
            this.databaseDlg.close();
            this.databaseDlg = null;
        }
        if (this.manualZoomDlg != null) {
            this.manualZoomDlg.close();
            this.manualZoomDlg = null;
        }
    }

    public void enableFiltersWidgets(boolean enable) {
        this.toolBar.enableFiltersButtonOverwrite(enable);
        this.toolBar.setEnabled(enable);
        this.menuBar.getFiltersMenuItem().setEnabled(enable);
        this.menuBar.getEngineFiltersMenuItem().setEnabled(enable);
    }

    public void errorReceived(String xml) {
        StringBuilder str = new StringBuilder("Error parsing the following log: \n");
        str.append(xml);
        str.append("\n The log has been lost.\n\n");
        this.getJLogErroDialog().appendText(str.toString());
        if (!this.getJLogErroDialog().isVisible()) {
            this.jlogErrorLbl.setVisible(true);
        }
    }

    public StatsDlg getStatisticDialog() {
        if (this.statsDlg == null) {
            this.statsDlg = new StatsDlg(this);
        }
        return this.statsDlg;
    }

    protected void initAudience(Audience.AudienceInfo audienceInfo) {
        Audience.AudienceInfo aInfo = null;
        if (audienceInfo != null) {
            aInfo = audienceInfo;
        } else {
            String audienceProp = System.getProperty(AUDIENCE_PROPERTY);
            if (audienceProp == null || audienceProp.isEmpty()) {
                this.menuBar.getEngineeringMode().doClick();
                return;
            }
            aInfo = Audience.AudienceInfo.fromShortName((String)audienceProp);
            if (aInfo == null) {
                System.err.println(audienceProp + " is not a valid audience: using default audience");
                System.err.println("Available audiences are: ");
                for (String aShortName : Audience.AudienceInfo.getShortNames()) {
                    System.err.println("\t" + aShortName);
                }
                this.menuBar.getEngineeringMode().doClick();
                return;
            }
        }
        switch (aInfo) {
            case ENGINEER: {
                this.menuBar.getEngineeringMode().doClick();
                return;
            }
            case OPERATOR: {
                this.menuBar.getOperatorMode().doClick();
                return;
            }
            case SCILOG: {
                this.menuBar.getSciLogMode().doClick();
                return;
            }
        }
        this.menuBar.getEngineeringMode().doClick();
    }

    private void showEngineFiltersDialog() {
        FiltersVector engineFilters;
        if (this.engineFiltersDlg == null) {
            class EngineFilterable
            implements Filterable {
                EngineFilterable() {
                }

                public FiltersVector getFilters() {
                    return LoggingClient.this.engine.getFilters();
                }

                public void setFilters(FiltersVector newFilters, boolean append) {
                    LoggingClient.this.engine.setFilters(newFilters, append);
                    LoggingClient.this.setEngineFilterLbl();
                }
            }
            this.engineFiltersDlg = new FilterChooserDialog("Engine filters", this, new EngineFilterable());
        }
        if ((engineFilters = this.engine.getFilters()) == null) {
            engineFilters = new FiltersVector();
        }
        this.engineFiltersDlg.setFilters(engineFilters);
        this.engineFiltersDlg.setVisible(true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.toolBar != null) {
            this.toolBar.setEnabled(enabled);
        }
        if (this.navigationToolbar != null) {
            this.navigationToolbar.setEnabled(enabled);
        }
        this.menuBar.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public ErrorBrowserDlg getErrorDialog() {
        if (this.errorBrowserDialog == null) {
            this.errorBrowserDialog = new ErrorBrowserDlg(this);
        }
        return this.errorBrowserDialog;
    }

    private ErrorLogDialog getJLogErroDialog() {
        if (this.errorDialog == null) {
            this.errorDialog = new ErrorLogDialog(this.logFrame, "jlog: Error log", false);
        }
        return this.errorDialog;
    }

    public LogFrame getLogFrame() {
        return this.logFrame;
    }

    public void addErrorTab(final String stackID) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LoggingClient.this.getErrorDialog().addErrorTab(LoggingClient.this.getLCModel1(), stackID);
            }
        };
        Thread t = new Thread(runnable, "LoggingClient.addErrorTab");
        t.setDaemon(true);
        t.start();
    }

    public ZoomManager getZoomManager() {
        return this.zoom;
    }

    public LogToolBar getToolBar() {
        return this.toolBar;
    }

    public ContainerServicesBase getContainerServices() {
        return this.containerServices;
    }

    public boolean inDebugMode() {
        return this.debugMode;
    }

    public void showErrorMessage(String shortDescription, Throwable t) {
        System.err.println("JLOG ERROR: " + shortDescription);
        if (t != null) {
            t.printStackTrace(System.err);
        }
        if (t == null) {
            this.errorWidget.showMessage(MessageWidget.MessageType.Error, shortDescription, null);
        } else {
            this.errorWidget.showMessage(shortDescription, t);
        }
        this.glassPane.setEventComponent(this.errorWidget.getAckButton());
        this.toolBar.setEnabled(false);
        this.navigationToolbar.setEnabled(false);
        this.menuBar.setEnabled(false);
    }

    @Override
    public void errorAcknowledged() {
        this.glassPane.setEventComponent(null);
        this.toolBar.setEnabled(true);
        this.navigationToolbar.setEnabled(true);
        this.menuBar.setEnabled(true);
    }

    public ViewCoordinator getViewCoordinator() {
        if (this.viewCoord == null) {
            this.viewCoord = new ViewCoordinator(this, this.logEntryTable);
        }
        return this.viewCoord;
    }

    private class CustomColumnListener
    implements ComponentListener {
        private CustomColumnListener() {
        }

        @Override
        public void componentShown(ComponentEvent evt) {
        }

        @Override
        public void componentHidden(ComponentEvent evt) {
        }

        @Override
        public void componentMoved(ComponentEvent evt) {
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            Component c = (Component)evt.getSource();
            int tableWidthTobe = c.getSize().width;
            LoggingClient.this.getLogEntryTable().setPreferredScrollableViewportSize(new Dimension(tableWidthTobe, c.getSize().height));
            int numCols = LoggingClient.this.getLogEntryTable().getColumnModel().getColumnCount();
            int columnWidth = LoggingClient.this.getLogEntryTable().getColumnWidth(numCols);
            LoggingClient.this.getLogEntryTable().setAdditionalWidth(numCols, tableWidthTobe - columnWidth);
        }
    }

    class EventHandler
    implements ActionListener,
    MenuListener {
        EventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == LoggingClient.this.menuBar.getConnectMenuItem()) {
                LoggingClient.this.connect(LoggingClient.this.menuBar.getConnectMenuItem().getText().compareTo("Connect") == 0);
            } else if (e.getSource() == LoggingClient.this.menuBar.getLoadMenuItem()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LoggingClient.this.getLCModel1().loadFromFile(null);
                    }
                });
            } else if (e.getSource() == LoggingClient.this.menuBar.getLoadURLMenuItem()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LoggingClient.this.getLCModel1().loadFromURL();
                    }
                });
            } else if (e.getSource() == LoggingClient.this.menuBar.getSaveFileMenuItem()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LoggingClient.this.getLCModel1().saveFile();
                    }
                });
            } else if (e.getSource() == LoggingClient.this.menuBar.getLoadDBMenuItem()) {
                if (LoggingClient.this.archive.getDBStatus() == ArchiveConnectionManager.DBState.DATABASE_OK) {
                    if (LoggingClient.this.databaseDlg == null) {
                        LoggingClient.this.databaseDlg = new QueryDlg(LoggingClient.this.archive, LoggingClient.this, LoggingClient.this, LoggingClient.this);
                    }
                    LoggingClient.this.databaseDlg.setVisible(true);
                }
            } else if (e.getSource() == LoggingClient.this.menuBar.getClearLogsMenuItem() || e.getSource() == LoggingClient.this.toolBar.getClearLogsBtn()) {
                Thread t = new Thread("LoggingClient.clearAll"){

                    @Override
                    public void run() {
                        LoggingClient.this.getLCModel1().clearAll();
                    }
                };
                t.setDaemon(true);
                t.start();
            } else if (e.getSource() == LoggingClient.this.menuBar.getExitMenuItem()) {
                if (LoggingClient.this.logFrame != null) {
                    WindowEvent wEvt = new WindowEvent(LoggingClient.this.logFrame, 201);
                    LoggingClient.this.logFrame.dispatchEvent(wEvt);
                } else {
                    LoggingClient.this.close(false);
                }
            } else if (e.getSource() == LoggingClient.this.menuBar.getFieldsMenuItem()) {
                LoggingClient.this.connFields(e);
            } else if (e.getSource() == LoggingClient.this.menuBar.getFiltersMenuItem() || e.getSource() == LoggingClient.this.toolBar.getFiltersBtn()) {
                LoggingClient.this.showTableFiltersDialog(e);
            } else if (e.getSource() == LoggingClient.this.toolBar.getPauseBtn()) {
                LoggingClient.this.toolBar.clickPauseBtn();
                LoggingClient.this.engine.setPaused(LoggingClient.this.toolBar.isPaused());
            } else if (e.getSource() == LoggingClient.this.toolBar.getLogLevelCB()) {
                LoggingClient.this.getLogEntryTable().setLogLevel((LogTypeHelper)LoggingClient.this.toolBar.getLogLevelCB().getSelectedItem());
            } else if (e.getSource() == LoggingClient.this.toolBar.getDiscardLevelCB()) {
                LoggingClient.this.getEngine().setDiscardLevel(LogTypeHelper.fromLogTypeDescription((String)((String)LoggingClient.this.toolBar.getDiscardLevelCB().getSelectedItem())));
            } else if (e.getSource() == LoggingClient.this.navigationToolbar.getSearchBtn() || e.getSource() == LoggingClient.this.menuBar.getSearchMenuItem()) {
                if (LoggingClient.this.searchDialog == null) {
                    LoggingClient.this.searchDialog = new SearchDialog(LoggingClient.this);
                }
                LoggingClient.this.searchDialog.setVisible(true);
            } else if (e.getSource() == LoggingClient.this.menuBar.getSearchNextMenuItem()) {
                if (LoggingClient.this.searchDialog != null) {
                    LoggingClient.this.searchDialog.search();
                } else {
                    LoggingClient.this.menuBar.getSearchNextMenuItem().setEnabled(false);
                }
            } else if (e.getSource() == LoggingClient.this.menuBar.getViewToolbarMenuItem()) {
                LoggingClient.this.toolBar.setVisible(LoggingClient.this.menuBar.getViewToolbarMenuItem().getState());
            } else if (e.getSource() == LoggingClient.this.menuBar.getStatisticsMenuItem()) {
                class ShowStatisticDlg
                extends Thread {
                    ShowStatisticDlg() {
                    }

                    @Override
                    public void run() {
                        LoggingClient.this.getStatisticDialog().setVisible(true);
                    }
                }
                ShowStatisticDlg showStat = new ShowStatisticDlg();
                SwingUtilities.invokeLater(showStat);
            } else if (e.getSource() == LoggingClient.this.menuBar.getViewErrorLogMenuItem()) {
                LoggingClient.this.getJLogErroDialog().setVisible(true, LoggingClient.this);
                LoggingClient.this.jlogErrorLbl.setVisible(false);
            } else if (e.getSource() == LoggingClient.this.menuBar.getViewErrorBrowserMenuItem()) {
                LoggingClient.this.getErrorDialog().setVisible(true);
            } else if (e.getSource() == LoggingClient.this.menuBar.getViewStatusAreaMenuItem()) {
                LoggingClient.this.getStatusAreaPanel().setVisible(LoggingClient.this.menuBar.getViewStatusAreaMenuItem().getState());
                if (LoggingClient.this.menuBar.getViewStatusAreaMenuItem().getState()) {
                    LoggingClient.this.getStatusAreaHrPane().setDividerLocation(LoggingClient.this.getHeight() - 150);
                } else {
                    LoggingClient.this.getStatusAreaHrPane().setDividerLocation(LoggingClient.this.getHeight());
                }
            } else if (e.getSource() == LoggingClient.this.menuBar.getViewDetailedInfoMenuItem()) {
                LoggingClient.this.getDeatailedInfoPanel().setVisible(LoggingClient.this.menuBar.getViewDetailedInfoMenuItem().getState());
                if (LoggingClient.this.menuBar.getViewDetailedInfoMenuItem().getState()) {
                    int w = LoggingClient.this.getLogEntryTable().getWidth();
                    LoggingClient.this.getTableDetailsVrPane().setDividerLocation(LoggingClient.this.getTableDetailsVrPane().getWidth() - w / 3);
                } else {
                    LoggingClient.this.getTableDetailsVrPane().setDividerLocation(LoggingClient.this.getTableDetailsVrPane().getWidth());
                }
            } else if (e.getSource() == LoggingClient.this.menuBar.getAutoReconnectMenuItem()) {
                if (LoggingClient.this.engine != null) {
                    LoggingClient.this.engine.enableAutoReconnection(LoggingClient.this.menuBar.getAutoReconnectMenuItem().getState());
                }
            } else if (e.getSource() == LoggingClient.this.menuBar.getShortDateViewMenuItem()) {
                LoggingClient.this.logEntryTable.setShortDateFormat(LoggingClient.this.menuBar.getShortDateViewMenuItem().isSelected());
            } else if (e.getSource() == LoggingClient.this.menuBar.getLogTypeDescriptionViewMenuItem()) {
                LoggingClient.this.logEntryTable.setLogTypeDescriptionView(LoggingClient.this.menuBar.getLogTypeDescriptionViewMenuItem().isSelected());
            } else if (e.getSource() == LoggingClient.this.toolBar.getPauseBtn()) {
                LoggingClient.this.toolBar.clickPauseBtn();
            } else if (e.getSource() == LoggingClient.this.menuBar.getSuspendMenuItem()) {
                LoggingClient.this.getEngine().setSupended(LoggingClient.this.menuBar.getSuspendMenuItem().isSelected());
            } else if (e.getSource() == LoggingClient.this.menuBar.getPrefsMenuItem()) {
                ExpertPrefsDlg dlg = new ExpertPrefsDlg(LoggingClient.this, LoggingClient.this.userPreferences);
                if (dlg.okPressed()) {
                    UserPreferences newPrefs = dlg.getPreferences();
                    if (newPrefs.getMaxNumOfLogs() != LoggingClient.this.userPreferences.getMaxNumOfLogs()) {
                        LoggingClient.this.userPreferences.setMaxLogs(newPrefs.getMaxNumOfLogs());
                        LoggingClient.this.getLCModel1().setMaxLog(LoggingClient.this.userPreferences.getMaxNumOfLogs());
                        LoggingClient.this.setNumberOfLogsLbl();
                    }
                    if (newPrefs.getMinuteTimeFrame() != LoggingClient.this.userPreferences.getMinuteTimeFrame()) {
                        LoggingClient.this.userPreferences.setTimeFrame(LoggingClient.this.userPreferences.getMinuteTimeFrame());
                        LoggingClient.this.getLCModel1().setTimeFrame(LoggingClient.this.userPreferences.getMillisecondsTimeFrame());
                    }
                    if (newPrefs.getMaxInputRate() != LoggingClient.this.userPreferences.getMaxInputRate()) {
                        LoggingClient.this.userPreferences.setMaxInputRate(newPrefs.getMaxInputRate());
                        LoggingClient.this.getEngine().setMaxInputRate(LoggingClient.this.userPreferences.getMaxInputRate());
                    }
                    if (newPrefs.getMaxOutputRate() != LoggingClient.this.userPreferences.getMaxOutputRate()) {
                        LoggingClient.this.userPreferences.setMaxOutputRate(newPrefs.getMaxOutputRate());
                        LoggingClient.this.getEngine().setMaxOutputRate(LoggingClient.this.userPreferences.getMaxOutputRate());
                    }
                    if (newPrefs.getDynThreshold() != LoggingClient.this.userPreferences.getDynThreshold()) {
                        LoggingClient.this.userPreferences.setDynThreshold(newPrefs.getDynThreshold());
                        LoggingClient.this.userPreferences.setDynDamping(newPrefs.getDynDamping());
                        LoggingClient.this.userPreferences.setDynTime(newPrefs.getDynTime());
                        LoggingClient.this.getEngine().enableDynamicDiscarding(LoggingClient.this.userPreferences.getDynThreshold(), LoggingClient.this.userPreferences.getDynDamping(), LoggingClient.this.userPreferences.getDynTime());
                    }
                }
            } else if (e.getSource() == LoggingClient.this.menuBar.getOperatorMode()) {
                LoggingClient.this.getEngine().setAudience(Audience.AudienceInfo.OPERATOR.getAudience());
                LoggingClient.this.audienceLbl.setText(" " + Audience.AudienceInfo.OPERATOR.name + " ");
            } else if (e.getSource() == LoggingClient.this.menuBar.getEngineeringMode()) {
                LoggingClient.this.getEngine().setAudience(Audience.AudienceInfo.ENGINEER.getAudience());
                LoggingClient.this.audienceLbl.setText(" " + Audience.AudienceInfo.ENGINEER.name + " ");
            } else if (e.getSource() == LoggingClient.this.menuBar.getSciLogMode()) {
                LoggingClient.this.getEngine().setAudience(Audience.AudienceInfo.SCILOG.getAudience());
                LoggingClient.this.audienceLbl.setText(" " + Audience.AudienceInfo.SCILOG.name + " ");
            } else if (e.getSource() == LoggingClient.this.menuBar.getEngineFiltersMenuItem()) {
                LoggingClient.this.showEngineFiltersDialog();
            } else if (e.getSource() == LoggingClient.this.menuBar.getZoomPrefsMI()) {
                ZoomPrefsDlg dlg = new ZoomPrefsDlg(LoggingClient.this, LoggingClient.this.zoom);
                boolean zoomAvailable = LoggingClient.this.zoom.isAvailable();
                LoggingClient.this.toolBar.setZoomable(zoomAvailable && LoggingClient.this.logEntryTable.getSelectedRowCount() > 1);
                LoggingClient.this.menuBar.getManualZoomMI().setEnabled(zoomAvailable);
            } else if (e.getSource() == LoggingClient.this.menuBar.getManualZoomMI()) {
                class ShowManualZoom
                extends Thread {
                    ShowManualZoom() {
                    }

                    @Override
                    public void run() {
                        if (LoggingClient.this.manualZoomDlg == null) {
                            LoggingClient.this.manualZoomDlg = new ManualZoomDlg(LoggingClient.this, LoggingClient.this.zoom);
                        }
                        LoggingClient.this.manualZoomDlg.setVisible(true);
                    }
                }
                SwingUtilities.invokeLater(new ShowManualZoom());
            } else if (e.getSource() == LoggingClient.this.toolBar.getZoomBtn()) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        LoggingClient.this.logEntryTable.zoom();
                    }
                });
                t.setDaemon(true);
                t.setName("LoggingClient.actionPerformed.Zoom");
                t.start();
            } else {
                System.err.println("Unrecognized ActionEvent " + e);
            }
        }

        @Override
        public void menuCanceled(MenuEvent menuE) {
        }

        @Override
        public void menuDeselected(MenuEvent menuE) {
        }

        @Override
        public void menuSelected(MenuEvent menuE) {
            boolean enableMenu = !LoggingClient.this.getLCModel1().IOInProgress();
            LoggingClient.this.menuBar.getClearLogsMenuItem().setEnabled(enableMenu);
            if (LoggingClient.this.getEngine().isConnected()) {
                LoggingClient.this.menuBar.getConnectMenuItem().setText("Disconnect");
            } else {
                LoggingClient.this.menuBar.getConnectMenuItem().setText("Connect");
            }
            LoggingClient.this.menuBar.getConnectMenuItem().setEnabled(enableMenu);
            LoggingClient.this.menuBar.getLoadMenuItem().setEnabled(enableMenu);
            LoggingClient.this.menuBar.getLoadURLMenuItem().setEnabled(enableMenu);
            LoggingClient.this.menuBar.getSaveFileMenuItem().setEnabled(enableMenu);
            LoggingClient.this.menuBar.getViewStatusAreaMenuItem().setSelected(LoggingClient.this.getStatusAreaPanel().isVisible());
            LoggingClient.this.menuBar.getViewDetailedInfoMenuItem().setSelected(LoggingClient.this.getDeatailedInfoPanel().isVisible());
            LoggingClient.this.menuBar.getViewToolbarMenuItem().setSelected(LoggingClient.this.toolBar.isVisible());
            LoggingClient.this.menuBar.getLoadDBMenuItem().setEnabled(false);
        }
    }
}

