/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class MessageWidget
extends JPanel {
    private final JLabel shortDescriptionLbl = new JLabel();
    private final JTextArea detailedDescritpionTA = new JTextArea();
    private JScrollPane detailedDescPnl;
    private final JLabel iconLbl = new JLabel();
    private final JLabel titleLbl = new JLabel();
    private final JButton ackBtn = new JButton("Ok");
    private Collection<MessageWidgetListener> ackListeners = null;

    public MessageWidget() {
        this.initialize();
        this.setVisible(false);
    }

    private void initialize() {
        BorderLayout layout = new BorderLayout();
        layout.setHgap(10);
        layout.setVgap(10);
        this.setLayout(layout);
        JPanel upperPnl = new JPanel(new BorderLayout());
        upperPnl.add((Component)this.iconLbl, "West");
        upperPnl.add((Component)this.shortDescriptionLbl, "Center");
        upperPnl.add((Component)this.ackBtn, "East");
        JPanel titlePnl = new JPanel(new FlowLayout(1));
        titlePnl.add(this.titleLbl);
        upperPnl.add((Component)titlePnl, "North");
        this.ackBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageWidget.this.removeMessage();
                MessageWidget.this.notifyListeners();
            }
        });
        this.add((Component)upperPnl, "North");
        this.detailedDescPnl = new JScrollPane(this.detailedDescritpionTA, 20, 30);
        this.detailedDescPnl.setBorder(BorderFactory.createTitledBorder("Further details"));
        this.detailedDescritpionTA.setEditable(false);
        this.add((Component)this.detailedDescPnl, "Center");
    }

    public boolean showMessage(final MessageType messageType, final String shortDescription, final String description) {
        if (messageType == null) {
            throw new IllegalArgumentException("The type can't be null");
        }
        if (shortDescription == null || shortDescription.isEmpty()) {
            throw new IllegalArgumentException("Invalid message descritpion");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MessageWidget.this.shortDescriptionLbl.setText(shortDescription);
                MessageWidget.this.iconLbl.setIcon(messageType.icon);
                MessageWidget.this.setVisible(true);
                if (description != null && !description.isEmpty()) {
                    MessageWidget.this.detailedDescritpionTA.setText(description);
                    MessageWidget.this.detailedDescPnl.setVisible(true);
                    MessageWidget.this.titleLbl.setText("<HTML><FONT size=\"+1\">" + (Object)((Object)messageType) + "</FONT></HTML>");
                    MessageWidget.this.titleLbl.setVisible(true);
                } else {
                    MessageWidget.this.detailedDescritpionTA.setText("");
                    MessageWidget.this.detailedDescPnl.setVisible(false);
                    MessageWidget.this.titleLbl.setVisible(false);
                }
            }
        });
        return description != null && !description.isEmpty();
    }

    public boolean showMessage(String shortDescription, Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException("The throwable can't be null");
        }
        StringWriter writer = new StringWriter();
        PrintWriter printW = new PrintWriter(writer);
        printW.flush();
        t.printStackTrace(printW);
        String desc = writer.getBuffer().toString();
        printW.close();
        return this.showMessage(MessageType.Error, shortDescription, desc);
    }

    public void removeMessage() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MessageWidget.this.setVisible(false);
            }
        });
    }

    public JButton getAckButton() {
        return this.ackBtn;
    }

    public void addAckListener(MessageWidgetListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The listener can't be null");
        }
        if (this.ackListeners == null) {
            Vector v = new Vector();
            this.ackListeners = Collections.synchronizedCollection(v);
        }
        if (!this.ackListeners.contains(listener)) {
            this.ackListeners.add(listener);
        }
    }

    public boolean removeAckListener(MessageWidgetListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The listener can't be null");
        }
        if (this.ackListeners == null) {
            return false;
        }
        return this.ackListeners.remove(listener);
    }

    private void notifyListeners() {
        if (this.ackListeners == null) {
            return;
        }
        Iterator<MessageWidgetListener> iter = this.ackListeners.iterator();
        while (iter.hasNext()) {
            iter.next().errorAcknowledged();
        }
    }

    public static interface MessageWidgetListener {
        public void errorAcknowledged();
    }

    public static enum MessageType {
        Error("dialog-error.png"),
        Warning("dialog-warning.png"),
        Info("dialog-information.png");

        public final ImageIcon icon;

        private MessageType(String iconPath) {
            this.icon = new ImageIcon(MessageWidget.class.getResource("/" + iconPath));
        }
    }
}

