/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging.client;

import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.Node;

public class DomTree
extends JTree {
    static final int windowHeight = 460;
    static final int leftWidth = 300;
    static final int rightWidth = 340;
    static final int windowWidth = 640;
    static final String[] typeName = new String[]{"none", "Element", "Attr", "Text", "CDATA", "EntityRef", "Entity", "ProcInstr", "Comment", "Document", "DocType", "DocFragment", "Notation"};
    private TheCellRenderer cellRenderer = new TheCellRenderer();

    public DomTree() {
        this.setModel(new DomToTreeModelAdapter());
        this.setCellRenderer(this.cellRenderer);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public DomTree(Hashtable value) {
        super(value);
        this.setCellRenderer(this.cellRenderer);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public Node getRootNode() {
        return ((DomToTreeModelAdapter)this.getModel()).getDocument();
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            DomTree dt = new DomTree();
            frame.getContentPane().setLayout(new FlowLayout());
            frame.getContentPane().add(dt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setRootNode(Node newDocument) {
        ((DomToTreeModelAdapter)this.getModel()).setDocument(newDocument);
        this.setCellRenderer(this.cellRenderer);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public static class TheCellRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            return this;
        }
    }

    private class DomToTreeModelAdapter
    implements TreeModel {
        private Node document = null;
        private List listenerList = new ArrayList();

        private DomToTreeModelAdapter() {
        }

        @Override
        public Object getRoot() {
            return new AdapterNode(this.document);
        }

        @Override
        public boolean isLeaf(Object aNode) {
            AdapterNode node = (AdapterNode)aNode;
            if (node == null) {
                return true;
            }
            return node.childCount() <= 0;
        }

        @Override
        public int getChildCount(Object parent) {
            AdapterNode node = (AdapterNode)parent;
            return node.childCount();
        }

        @Override
        public Object getChild(Object parent, int index) {
            AdapterNode node = (AdapterNode)parent;
            return node.child(index);
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            AdapterNode node = (AdapterNode)parent;
            return node.index((AdapterNode)child);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public void addTreeModelListener(TreeModelListener listener) {
            if (listener != null && !this.listenerList.contains(listener)) {
                this.listenerList.add(listener);
            }
        }

        @Override
        public void removeTreeModelListener(TreeModelListener listener) {
            if (listener != null) {
                this.listenerList.remove(listener);
            }
        }

        public void setDocument(Node newDocument) {
            this.document = newDocument;
        }

        public Node getDocument() {
            return this.document;
        }

        public void fireTreeNodesChanged(TreeModelEvent e) {
            for (TreeModelListener listener : this.listenerList) {
                listener.treeNodesChanged(e);
            }
        }

        public void fireTreeNodesInserted(TreeModelEvent e) {
            for (TreeModelListener listener : this.listenerList) {
                listener.treeNodesInserted(e);
            }
        }

        public void fireTreeNodesRemoved(TreeModelEvent e) {
            for (TreeModelListener listener : this.listenerList) {
                listener.treeNodesRemoved(e);
            }
        }

        public void fireTreeStructureChanged(TreeModelEvent e) {
            for (TreeModelListener listener : this.listenerList) {
                listener.treeStructureChanged(e);
            }
        }
    }

    private class AdapterNode {
        Node domNode;

        public AdapterNode(Node node) {
            this.domNode = node;
        }

        public String toString() {
            if (this.domNode == null) {
                return "No additional info";
            }
            String s = typeName[this.domNode.getNodeType()];
            String nodeName = this.domNode.getNodeName();
            if (!nodeName.startsWith("#")) {
                s = s + ": " + nodeName;
            }
            if (this.domNode.getNodeValue() != null) {
                s = s.startsWith("ProcInstr") ? s + ", " : s + ": ";
                String t = this.domNode.getNodeValue().trim();
                int x = t.indexOf("\n");
                if (x >= 0) {
                    t = t.substring(0, x);
                }
                s = s + t;
            }
            return s;
        }

        public int index(AdapterNode child) {
            if (this.domNode == null) {
                return 0;
            }
            int count = this.childCount();
            for (int i = 0; i < count; ++i) {
                AdapterNode n = this.child(i);
                if (child.domNode != n.domNode) continue;
                return i;
            }
            return -1;
        }

        public AdapterNode child(int searchIndex) {
            if (this.domNode == null) {
                return null;
            }
            Node node = this.domNode.getChildNodes().item(searchIndex);
            return new AdapterNode(node);
        }

        public int childCount() {
            if (this.domNode == null) {
                return 0;
            }
            return this.domNode.getChildNodes().getLength();
        }
    }
}

