/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging.client.cache;

import com.cosylab.logging.client.cache.ILogMap;
import com.cosylab.logging.client.cache.LogCacheException;
import com.cosylab.logging.client.cache.LogIterator;
import com.cosylab.logging.engine.log.ILogEntry;
import com.cosylab.logging.engine.log.LogEntry;
import com.cosylab.logging.engine.log.LogField;
import com.cosylab.logging.engine.log.LogTypeHelper;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class LogFileCache
implements ILogMap {
    private String logFileName;
    protected RandomAccessFile file = null;
    protected int logID = 0;
    protected TreeMap<Integer, LogCacheInfo> index = new TreeMap();
    private StringBuilder sb = new StringBuilder();
    private static final String SEPARATOR = "\u0000";
    protected HashMap<Integer, ILogEntry> replacedLogs = new HashMap();
    private static final Random rndNumberGenerator = new Random(System.currentTimeMillis());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getSize() {
        int size;
        TreeMap<Integer, LogCacheInfo> treeMap = this.index;
        synchronized (treeMap) {
            size = this.index.size();
        }
        return size;
    }

    public synchronized long getFileSize() throws IOException {
        return this.file == null ? 0L : this.file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initCache() throws IOException {
        if (this.file == null) {
            this.file = new RandomAccessFile(this.getFile(), "rw");
        }
        this.file.setLength(0L);
        AbstractMap abstractMap = this.index;
        synchronized (abstractMap) {
            this.index.clear();
        }
        abstractMap = this.replacedLogs;
        synchronized (abstractMap) {
            this.replacedLogs.clear();
        }
    }

    private String getFile() throws IOException {
        String name = null;
        File f = null;
        try {
            String acsdata = System.getProperty("ACS.tmp");
            if (!acsdata.endsWith(File.separator)) {
                acsdata = acsdata + File.separator;
            }
            File dir = new File(acsdata);
            f = File.createTempFile("jlog", ".tmp", dir);
        }
        catch (IOException ioe) {
            String homeDir = System.getProperty("user.dir");
            File homeFileDir = new File(homeDir);
            if (homeFileDir.isDirectory() && homeFileDir.canWrite()) {
                int random;
                do {
                    random = rndNumberGenerator.nextInt();
                } while ((f = new File(name = homeDir + File.separator + "jlog" + random + ".jlog")).exists());
            }
            f = File.createTempFile("jlog", ".tmp");
            name = f.getAbsolutePath();
        }
        this.logFileName = f.getAbsolutePath();
        f.deleteOnExit();
        f = null;
        return this.logFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clear() throws LogCacheException {
        TreeMap<Integer, LogCacheInfo> treeMap = this.index;
        synchronized (treeMap) {
            this.index.clear();
        }
        this.logID = 0;
        if (this.file == null) {
            return;
        }
        try {
            File f;
            this.file.close();
            if (this.logFileName != null && !(f = new File(this.logFileName)).delete()) {
                throw new LogCacheException("File.delete() could not delete " + this.logFileName);
            }
        }
        catch (IOException e) {
            throw new LogCacheException("Error clearing cache file " + this.logFileName, e);
        }
        finally {
            this.file = null;
            this.logFileName = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLogAsString(int idx) throws IOException, LogCacheException {
        if (idx < 0 || idx >= this.logID) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + idx);
        }
        LogCacheInfo info = null;
        TreeMap<Integer, LogCacheInfo> treeMap = this.index;
        synchronized (treeMap) {
            info = this.index.get(idx);
        }
        byte[] buffer = new byte[info.len];
        RandomAccessFile randomAccessFile = this.file;
        synchronized (randomAccessFile) {
            this.file.seek(info.start);
            int bytesRead = this.file.read(buffer);
            if (bytesRead != info.len) {
                throw new LogCacheException("Error reding from file: got " + bytesRead + " instead of " + info.len);
            }
        }
        return new String(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ILogEntry getLog(Integer key) throws LogCacheException {
        if (key < 0 || key >= this.logID) {
            throw new LogCacheException("Key " + key + " out of range [0," + this.logID + "[");
        }
        if (!this.index.containsKey(key)) {
            throw new LogCacheException("A log with the given key (" + key + ") has not been found in the index");
        }
        HashMap<Integer, ILogEntry> hashMap = this.replacedLogs;
        synchronized (hashMap) {
            if (this.replacedLogs.containsKey(key)) {
                return this.replacedLogs.get(key);
            }
        }
        String logStr = null;
        try {
            logStr = this.getLogAsString(key);
        }
        catch (IOException ioe) {
            throw new LogCacheException("Exception getting log from cache");
        }
        try {
            return this.fromCacheString(logStr);
        }
        catch (Exception e) {
            System.err.println("Exception " + e.getMessage());
            throw new LogCacheException("Exception parsing a log [logStr.len=" + logStr.length() + ", log={" + logStr + "}]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int add(ILogEntry log) throws LogCacheException {
        long startingPos;
        if (log == null) {
            throw new LogCacheException("Trying to add a null log!");
        }
        if (this.file == null) {
            try {
                this.initCache();
            }
            catch (IOException e) {
                throw new LogCacheException("Error initializing the cache", e);
            }
        }
        String cacheLogStr = this.toCacheString(log);
        RandomAccessFile randomAccessFile = this.file;
        synchronized (randomAccessFile) {
            try {
                startingPos = this.file.length();
                this.file.seek(this.file.length());
                this.file.writeBytes(cacheLogStr);
            }
            catch (IOException ioe) {
                throw new LogCacheException("Error adding a log", ioe);
            }
        }
        LogCacheInfo info = new LogCacheInfo(startingPos, cacheLogStr.length());
        TreeMap<Integer, LogCacheInfo> treeMap = this.index;
        synchronized (treeMap) {
            this.index.put(this.logID, info);
        }
        return this.logID++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceLog(Integer key, ILogEntry log) throws LogCacheException {
        if (!this.index.containsKey(key)) {
            throw new LogCacheException("Trying to replace a log not in cache");
        }
        HashMap<Integer, ILogEntry> hashMap = this.replacedLogs;
        synchronized (hashMap) {
            this.replacedLogs.put(key, log);
        }
    }

    protected String toCacheString(ILogEntry log) {
        this.sb.delete(0, this.sb.length());
        for (LogField field : LogField.values()) {
            Object obj = log.getField(field);
            if (obj != null) {
                if (obj instanceof Date) {
                    this.sb.append(((Date)obj).getTime());
                } else if (obj instanceof LogTypeHelper) {
                    this.sb.append(((LogTypeHelper)obj).ordinal());
                } else {
                    this.sb.append(obj.toString());
                }
            }
            this.sb.append('\u0000');
        }
        if (log.hasDatas()) {
            Vector datas = log.getAdditionalData();
            for (int t = 0; t < datas.size(); ++t) {
                ILogEntry.AdditionalData data = (ILogEntry.AdditionalData)datas.get(t);
                this.sb.append(data.name);
                this.sb.append(SEPARATOR);
                this.sb.append(data.value);
                this.sb.append(SEPARATOR);
            }
        }
        return this.sb.toString();
    }

    private ILogEntry fromCacheString(String str) {
        String[] strs = str.split(SEPARATOR);
        Long millis = new Long(strs[0]);
        Integer entrytype = new Integer(strs[1]);
        String srcObject = null;
        if (strs.length > 2) {
            srcObject = strs[2];
        }
        String fileNM = null;
        if (strs.length > 3) {
            fileNM = strs[3];
        }
        Integer line = null;
        if (strs.length > 4 && strs[4].length() != 0) {
            line = new Integer(strs[4]);
        }
        String routine = null;
        if (strs.length > 5) {
            routine = strs[5];
        }
        String host = null;
        if (strs.length > 6) {
            host = strs[6];
        }
        String process = null;
        if (strs.length > 7) {
            process = strs[7];
        }
        String context = null;
        if (strs.length > 8) {
            context = strs[8];
        }
        String thread = null;
        if (strs.length > 9) {
            thread = strs[9];
        }
        String logid = null;
        if (strs.length > 10) {
            logid = strs[10];
        }
        Integer priority = null;
        if (strs.length > 11 && strs[11].length() > 0) {
            priority = new Integer(strs[11]);
        }
        String uri = null;
        if (strs.length > 12) {
            uri = strs[12];
        }
        String stackid = null;
        if (strs.length > 13) {
            stackid = strs[13];
        }
        Integer stacklevel = null;
        if (strs.length > 14 && strs[14].length() > 0) {
            stacklevel = Integer.parseInt(strs[14]);
        }
        String logmessage = null;
        if (strs.length > 15) {
            logmessage = strs[15];
        }
        String audience = null;
        if (strs.length > 16) {
            audience = strs[16];
        }
        String array = null;
        if (strs.length > 17) {
            array = strs[17];
        }
        String antenna = null;
        if (strs.length > 18) {
            antenna = strs[18];
        }
        Vector<ILogEntry.AdditionalData> addDatas = null;
        if (strs.length > LogField.values().length) {
            addDatas = new Vector<ILogEntry.AdditionalData>();
            for (int t = LogField.values().length; t < strs.length; t += 2) {
                addDatas.add(new ILogEntry.AdditionalData(strs[t], strs[t + 1]));
            }
        }
        return new LogEntry(millis, entrytype, fileNM, line, routine, host, process, context, thread, logid, priority, uri, stackid, stacklevel, logmessage, srcObject, audience, array, antenna, addDatas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void deleteLog(Integer key) throws LogCacheException {
        if (key < 0 || key >= this.logID) {
            throw new LogCacheException("Key " + key + " out of range [0," + this.logID + "[");
        }
        if (!this.index.containsKey(key)) {
            throw new LogCacheException("The log " + key + " is not in cache [0," + this.logID + "[");
        }
        AbstractMap abstractMap = this.index;
        synchronized (abstractMap) {
            this.index.remove(key);
        }
        abstractMap = this.replacedLogs;
        synchronized (abstractMap) {
            this.replacedLogs.remove(key);
        }
    }

    @Override
    public synchronized void deleteLogs(Collection<Integer> keys) throws LogCacheException {
        if (keys == null) {
            throw new IllegalArgumentException("Invalid null parameter");
        }
        for (Integer key : keys) {
            this.deleteLog(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getFirstLog() {
        TreeMap<Integer, LogCacheInfo> treeMap = this.index;
        synchronized (treeMap) {
            if (this.index.size() == 0) {
                return null;
            }
            return this.index.firstKey();
        }
    }

    @Override
    public int getFirstLogs(int n, Collection<Integer> keys) {
        int ret;
        if (n <= 0 || keys == null) {
            throw new IllegalArgumentException("Invalid number of requested key or null collection");
        }
        Set<Integer> allTheKeys = this.index.keySet();
        Iterator<Integer> iter = allTheKeys.iterator();
        for (ret = 0; iter.hasNext() && ret < n; ++ret) {
            keys.add(iter.next());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getLastLog() {
        TreeMap<Integer, LogCacheInfo> treeMap = this.index;
        synchronized (treeMap) {
            if (this.index.size() == 0) {
                return null;
            }
            return this.index.lastKey();
        }
    }

    @Override
    public Set<Integer> keySet() {
        return this.index.keySet();
    }

    @Override
    public Iterator<ILogEntry> iterator() {
        return new LogIterator(this);
    }

    protected static class LogCacheInfo {
        public long start;
        public int len;

        public LogCacheInfo(long startPos, int length) {
            if (startPos < 0L || length <= 0) {
                throw new IllegalArgumentException("Invalid positions for log [start=" + startPos + ", len=" + length + "]");
            }
            this.start = startPos;
            this.len = length;
        }

        public LogCacheInfo() {
        }
    }
}

