/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging.settings;

import alma.acs.gui.util.threadsupport.EDTExecutor;
import alma.acs.gui.widgets.CheckList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FieldChooserDialog
extends JDialog {
    private final CheckList fieldList = new CheckList();
    private final JButton buttonOK = new JButton("OK");
    private JButton buttonCancel = new JButton("Cancel");
    private DialogExitAction modalResult;
    private final Component displayHelperComponent;

    public FieldChooserDialog(Component displayOverComponent) {
        if (displayOverComponent == null) {
            throw new IllegalArgumentException("Invalid null Component in constructor");
        }
        this.displayHelperComponent = displayOverComponent;
        EDTExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                FieldChooserDialog.this.initGUI();
            }
        });
    }

    private void initGUI() {
        this.setTitle("Field chooser");
        this.setModal(true);
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        contentPane.add((Component)new JLabel("Select columns to display"), "North");
        contentPane.add((Component)new JScrollPane((Component)this.fieldList), "Center");
        JPanel buttonPnl = new JPanel(new BorderLayout());
        ButtonListener buttonListener = new ButtonListener();
        this.buttonOK.addActionListener(buttonListener);
        buttonPnl.add((Component)this.buttonOK, "East");
        this.buttonCancel.addActionListener(buttonListener);
        buttonPnl.add((Component)this.buttonCancel, "West");
        contentPane.add((Component)buttonPnl, "South");
    }

    public boolean[] getFields() {
        return this.fieldList.getActivationStates();
    }

    public DialogExitAction getModalResult() {
        return this.modalResult;
    }

    public void setupFields(String[] fieldNames, boolean[] checked) {
        this.fieldList.clear();
        int n = fieldNames.length;
        for (int i = 0; i < n; ++i) {
            this.fieldList.addElement(checked[i], (Object)fieldNames[i]);
        }
    }

    @Override
    public void setVisible(final boolean visible) {
        EDTExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                FieldChooserDialog.this.setLocationRelativeTo(FieldChooserDialog.this.displayHelperComponent);
                FieldChooserDialog.this.pack();
                FieldChooserDialog.super.setVisible(visible);
                FieldChooserDialog.this.toFront();
            }
        });
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == FieldChooserDialog.this.buttonOK) {
                FieldChooserDialog.this.modalResult = DialogExitAction.OK;
            } else {
                FieldChooserDialog.this.modalResult = DialogExitAction.CANCEL;
            }
            FieldChooserDialog.this.setVisible(false);
        }
    }

    public static enum DialogExitAction {
        OK,
        CANCEL;

    }
}

