/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging.settings;

import alma.acs.gui.widgets.CheckList;
import com.cosylab.logging.LoggingClient;
import com.cosylab.logging.engine.Filter;
import com.cosylab.logging.engine.Filterable;
import com.cosylab.logging.engine.FiltersVector;
import com.cosylab.logging.settings.FilterParameterDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;

public class FilterChooserDialog
extends JDialog {
    private CheckList filterList;
    private JLabel description = null;
    private JButton buttonClose = null;
    private JButton buttonApply = null;
    private JButton buttonRestore = null;
    private JToolBar toolBar = new JToolBar();
    private JButton buttonAdd = null;
    private JButton buttonRemove = null;
    private JButton buttonModify = null;
    private JMenuBar menuBar = new JMenuBar();
    private JMenuItem loadMI = new JMenuItem("Load");
    private JMenuItem saveMI = new JMenuItem("Save");
    private JMenuItem saveAsMI = new JMenuItem("Save as");
    private JMenuItem closeMI = new JMenuItem("Close");
    private JMenuItem activateAllMI = new JMenuItem("Activate all");
    private JMenuItem deactivateAllMI = new JMenuItem("Deactivate all");
    private JMenuItem clearAllMI = new JMenuItem("Clear all");
    private ButtonListener bl = new ButtonListener();
    private LoggingClient loggingClient;
    private Filterable filterable = null;
    private FiltersVector initialFilters = new FiltersVector();
    private boolean modified = false;
    private String filterFileName = null;

    public FilterChooserDialog(String title, LoggingClient logCli, Filterable filterable) {
        super((Dialog)null, title);
        if (filterable == null) {
            throw new IllegalArgumentException("Invalid null LogTableDataModel in constructor");
        }
        if (logCli == null) {
            throw new IllegalArgumentException("Invalid null LoggingClient in constructor");
        }
        this.loggingClient = logCli;
        this.filterable = filterable;
        this.setModal(false);
        ImageIcon filterIcon = new ImageIcon(FilterChooserDialog.class.getResource("/filters.png"));
        this.setIconImage(filterIcon.getImage());
        this.initialize();
        this.setDefaultCloseOperation(1);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FilterChooserDialog.this.loggingClient.enableFiltersWidgets(true);
            }
        });
    }

    public void setFilters(FiltersVector flts) {
        if (flts == null) {
            throw new IllegalArgumentException("Invalid null filter vector");
        }
        this.initialFilters.setFilters(flts);
        this.setupFields(flts, false);
    }

    private void initialize() {
        this.setLocation(50, 50);
        this.initMenubar();
        this.initToolbar();
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.description = new JLabel("Select filter to apply");
        c = this.newConstraints(0, 0, 0, 4);
        c.gridwidth = 3;
        panel.add((Component)this.description, c);
        c = this.newConstraints(0, 1, 0, 4);
        c.gridwidth = 3;
        c.weighty = 1.0;
        c.fill = 1;
        this.filterList = new CheckList();
        panel.add((Component)new JScrollPane((Component)this.filterList), c);
        JSeparator sep = new JSeparator();
        GridBagConstraints constr = this.newConstraints(0, 2, 4, 4);
        constr.gridwidth = 3;
        panel.add((Component)sep, constr);
        this.buttonApply = new JButton("Apply");
        this.buttonApply.addActionListener(this.bl);
        panel.add((Component)this.buttonApply, this.newConstraints(0, 3, 4, 4));
        this.buttonRestore = new JButton("Restore");
        this.buttonRestore.addActionListener(this.bl);
        panel.add((Component)this.buttonRestore, this.newConstraints(1, 3, 4, 4));
        this.buttonClose = new JButton("Close");
        this.buttonClose.addActionListener(this.bl);
        panel.add((Component)this.buttonClose, this.newConstraints(2, 3, 4, 4));
        this.getContentPane().add((Component)panel, "Center");
        this.pack();
    }

    protected GridBagConstraints newConstraints(int x, int y, int top, int bottom) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.insets = new Insets(top, 4, bottom, 4);
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        return constraints;
    }

    private void setupFields(FiltersVector filters, boolean append) {
        if (filters == null) {
            throw new IllegalArgumentException("The FiltersVector can't be null");
        }
        if (!append) {
            this.filterList.clear();
        }
        for (int i = 0; i < filters.size(); ++i) {
            this.filterList.addElement(filters.isActive(i), filters.get(i));
        }
        this.updateButtons();
    }

    protected void updateButtons() {
        boolean hasEntries = this.filterList.getItemsSize() > 0;
        this.buttonRemove.setEnabled(hasEntries);
        this.buttonModify.setEnabled(hasEntries);
        this.activateAllMI.setEnabled(hasEntries);
        this.deactivateAllMI.setEnabled(hasEntries);
        this.clearAllMI.setEnabled(hasEntries);
        this.saveMI.setEnabled(this.filterFileName != null && hasEntries);
        this.saveAsMI.setEnabled(hasEntries);
    }

    private void loadFilters() {
        File fileToLoad;
        boolean eraseOldFilters;
        if (this.filterList.getItemsSize() > 0) {
            int ret = JOptionPane.showConfirmDialog(this, "Do you want do discard existing filters?", "Merge filters?", 1);
            if (ret == 2) {
                return;
            }
            eraseOldFilters = ret == 0;
        } else {
            eraseOldFilters = false;
        }
        JFileChooser fileChooserDlg = new JFileChooser();
        fileChooserDlg.setMultiSelectionEnabled(false);
        fileChooserDlg.setDialogTitle("Load filters");
        XmlFileFilter fileFilter = new XmlFileFilter();
        fileChooserDlg.setFileFilter(fileFilter);
        if (fileChooserDlg.showOpenDialog(this) == 0 && (fileToLoad = fileChooserDlg.getSelectedFile()) != null) {
            FiltersVector filters = new FiltersVector();
            try {
                filters.loadFilters(fileToLoad, eraseOldFilters, null);
            }
            catch (Throwable t) {
                JOptionPane.showMessageDialog(this, "Error: " + t.getMessage(), "Error loading filters", 0);
            }
            this.setupFields(filters, !eraseOldFilters);
            this.modified = true;
            this.filterFileName = fileToLoad.getAbsolutePath();
        }
    }

    private void saveAsFilters() {
        if (this.filterList.getItemsSize() == 0) {
            JOptionPane.showMessageDialog(this, "No filters to save", "Warning", 1);
            return;
        }
        JFileChooser fileChooserDlg = new JFileChooser();
        fileChooserDlg.setMultiSelectionEnabled(false);
        fileChooserDlg.setDialogTitle("Save filters");
        XmlFileFilter fileFilter = new XmlFileFilter();
        fileChooserDlg.setFileFilter(fileFilter);
        if (fileChooserDlg.showSaveDialog(this) == 0) {
            File fileToSave = fileChooserDlg.getSelectedFile();
            if (!fileToSave.getAbsolutePath().toUpperCase().endsWith(".XML")) {
                fileToSave = new File(fileToSave.getAbsolutePath() + ".xml");
            }
            if (fileToSave != null) {
                this.filterFileName = fileToSave.getAbsolutePath();
                this.saveFilters(fileToSave.getAbsolutePath());
            }
        }
    }

    private void saveFilters(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("Inavlid file name: " + fileName);
        }
        if (!fileName.toUpperCase().endsWith(".XML")) {
            fileName = fileName + ".xml";
        }
        List entries = this.filterList.getEntries();
        FiltersVector filters = new FiltersVector();
        for (CheckList.CheckListTableEntry entry : entries) {
            filters.addFilter((Filter)entry.getItem(), entry.isActive());
        }
        File f = new File(fileName);
        try {
            filters.saveFilters(f);
            this.filterFileName = f.getAbsolutePath();
            System.out.println("Saved " + this.filterFileName);
        }
        catch (IOException e) {
            System.err.println("Error opening " + fileName);
        }
    }

    private void applyFilters() {
        FiltersVector newFilters = new FiltersVector();
        for (CheckList.CheckListTableEntry entry : this.filterList.getEntries()) {
            newFilters.addFilter((Filter)entry.getItem(), entry.isActive());
        }
        this.filterable.setFilters(newFilters, false);
    }

    private void restoreFilters() {
        int ret;
        if (this.modified && (ret = JOptionPane.showConfirmDialog(this, "Do you really want to restore the original filters?", "Restore filters", 0)) != 0) {
            return;
        }
        this.setupFields(this.initialFilters, false);
    }

    private void initToolbar() {
        ImageIcon addIcon = new ImageIcon(FilterChooserDialog.class.getResource("/page_add.png"));
        this.buttonAdd = new JButton("Add", addIcon);
        this.buttonAdd.addActionListener(this.bl);
        this.toolBar.add(this.buttonAdd);
        ImageIcon removeIcon = new ImageIcon(FilterChooserDialog.class.getResource("/page_delete.png"));
        this.buttonRemove = new JButton("Remove", removeIcon);
        this.buttonRemove.addActionListener(this.bl);
        this.toolBar.add(this.buttonRemove);
        ImageIcon editIcon = new ImageIcon(FilterChooserDialog.class.getResource("/page_edit.png"));
        this.buttonModify = new JButton("Modify", editIcon);
        this.buttonModify.addActionListener(this.bl);
        this.toolBar.add(this.buttonModify);
        this.getContentPane().add((Component)this.toolBar, "North");
    }

    private void initMenubar() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(this.loadMI);
        fileMenu.add(this.saveMI);
        fileMenu.add(this.saveAsMI);
        fileMenu.add(new JSeparator());
        fileMenu.add(this.closeMI);
        JMenu editMenu = new JMenu("Edit");
        editMenu.add(this.activateAllMI);
        editMenu.add(this.deactivateAllMI);
        editMenu.add(new JSeparator());
        editMenu.add(this.clearAllMI);
        this.menuBar.add(fileMenu);
        this.menuBar.add(editMenu);
        this.setJMenuBar(this.menuBar);
        this.loadMI.addActionListener(this.bl);
        this.saveMI.addActionListener(this.bl);
        this.saveAsMI.addActionListener(this.bl);
        this.closeMI.addActionListener(this.bl);
        this.activateAllMI.addActionListener(this.bl);
        this.deactivateAllMI.addActionListener(this.bl);
        this.clearAllMI.addActionListener(this.bl);
    }

    @Override
    public void setVisible(boolean visible) {
        this.setLocationRelativeTo(this.loggingClient);
        this.pack();
        super.setVisible(visible);
        this.toFront();
    }

    private static class XmlFileFilter
    extends FileFilter {
        private XmlFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            boolean pass = f.isFile() && f.getName().toUpperCase().endsWith(".XML") && f.canRead();
            pass = pass || f.isDirectory();
            pass = pass && !f.isHidden();
            return pass;
        }

        @Override
        public String getDescription() {
            return "xml file";
        }
    }

    private class ButtonListener
    implements ActionListener {
        private FilterChooserDialog fcd;

        private ButtonListener() {
            this.fcd = FilterChooserDialog.this;
        }

        private Filter editFilter(Filter f) {
            FilterParameterDialog fpd = new FilterParameterDialog(FilterChooserDialog.this);
            fpd.setFilter(f);
            fpd.setVisible(true);
            if (fpd.okPressed()) {
                return fpd.getFilter();
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == FilterChooserDialog.this.buttonClose || e.getSource() == FilterChooserDialog.this.closeMI) {
                int ret;
                if (FilterChooserDialog.this.modified && (ret = JOptionPane.showConfirmDialog(FilterChooserDialog.this, "<HTML>You have modified the filters withouth saving/applying.<BR>Do you really want to close?</HTML>", "Close confimation", 0)) != 0) {
                    return;
                }
                FilterChooserDialog.this.setVisible(false);
                FilterChooserDialog.this.loggingClient.enableFiltersWidgets(true);
                return;
            }
            if (e.getSource() == FilterChooserDialog.this.buttonModify) {
                CheckList.CheckListTableEntry selectedEntry = FilterChooserDialog.this.filterList.getSelectedEntry();
                if (selectedEntry != null) {
                    Filter editedFilter = this.editFilter((Filter)selectedEntry.getItem());
                    if (editedFilter != null) {
                        FilterChooserDialog.this.modified = true;
                        selectedEntry.setItem((Object)editedFilter);
                        FilterChooserDialog.this.filterList.updateSelectedEntry();
                    }
                } else {
                    JOptionPane.showMessageDialog(FilterChooserDialog.this, "Invalid item to modify", "Error", 0);
                }
            } else if (e.getSource() == FilterChooserDialog.this.buttonAdd) {
                Filter f = this.editFilter(null);
                if (f != null) {
                    FilterChooserDialog.this.filterList.addElement(true, (Object)f);
                    FilterChooserDialog.this.modified = true;
                }
            } else if (e.getSource() == FilterChooserDialog.this.buttonRemove) {
                CheckList.CheckListTableEntry removedEntry = FilterChooserDialog.this.filterList.removeSelectedEntry();
                if (removedEntry != null) {
                    FilterChooserDialog.this.modified = true;
                }
            } else if (e.getSource() == FilterChooserDialog.this.activateAllMI) {
                FilterChooserDialog.this.filterList.activateAll(true);
                FilterChooserDialog.this.modified = true;
            } else if (e.getSource() == FilterChooserDialog.this.deactivateAllMI) {
                FilterChooserDialog.this.filterList.activateAll(false);
                FilterChooserDialog.this.modified = true;
            } else if (e.getSource() == FilterChooserDialog.this.clearAllMI) {
                int ret;
                if (FilterChooserDialog.this.filterList.getItemsSize() > 0 && (ret = JOptionPane.showConfirmDialog(FilterChooserDialog.this, "Do you really want to delete all the filters?", "Delete all filters", 0)) == 0) {
                    FilterChooserDialog.this.filterList.clear();
                    FilterChooserDialog.this.modified = true;
                }
            } else if (e.getSource() == FilterChooserDialog.this.buttonApply) {
                FilterChooserDialog.this.applyFilters();
                FilterChooserDialog.this.modified = false;
            } else if (e.getSource() == FilterChooserDialog.this.loadMI) {
                FilterChooserDialog.this.loadFilters();
            } else if (e.getSource() == FilterChooserDialog.this.saveMI) {
                FilterChooserDialog.this.saveFilters(FilterChooserDialog.this.filterFileName);
            } else if (e.getSource() == FilterChooserDialog.this.saveAsMI) {
                FilterChooserDialog.this.saveAsFilters();
            } else if (e.getSource() == FilterChooserDialog.this.buttonRestore) {
                FilterChooserDialog.this.restoreFilters();
            } else {
                System.out.println("Unhandled event: " + e);
            }
            FilterChooserDialog.this.updateButtons();
        }
    }
}

