/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging.stats;

import com.cosylab.logging.LoggingClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class StatsDlg
extends JDialog
implements ActionListener {
    private static final String NotAvailable = "N/A";
    private static final int MONITORING_INTERVAL = 1000;
    private JLabel totNumOfLogsLbl = new JLabel("N/A");
    private JLabel visibleLogsLbl = new JLabel("N/A");
    private JLabel hiddenLogsLbl = new JLabel("N/A");
    private JLabel availMemLbl = new JLabel("N/A");
    private JLabel usedMemLbl = new JLabel("N/A");
    private JLabel timeFrameLbl = new JLabel("N/A");
    private JLabel inRateLbl = new JLabel("N/A");
    private JLabel outRateLbl = new JLabel("N/A");
    private JLabel numOfCacheFiles = new JLabel("N/A");
    private JLabel diskSpace = new JLabel("N/A");
    private JButton closeBtn = new JButton("Close");
    private JButton refreshBtn = new JButton("Refresh");
    private JButton monitorBtn = new JButton("Start monitoring");
    private LoggingClient logging;
    private Timer timer = null;

    public StatsDlg(LoggingClient mainWin) {
        if (mainWin == null) {
            throw new IllegalArgumentException("The LoggingClient can't be null");
        }
        this.logging = mainWin;
        this.setDefaultCloseOperation(1);
        this.initialize();
        this.pack();
    }

    private void initialize() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Statistics");
        this.setBounds(50, 35, 100, 100);
        JPanel mainPnl = new JPanel(new BorderLayout());
        JPanel valuesPnl = new JPanel(new GridLayout(10, 1));
        JPanel numOfLogsPnl = new JPanel(new FlowLayout(0));
        numOfLogsPnl.add(new JLabel("Total logs: "));
        numOfLogsPnl.add(this.totNumOfLogsLbl);
        valuesPnl.add(numOfLogsPnl);
        JPanel visibleLogsPnl = new JPanel(new FlowLayout(0));
        visibleLogsPnl.add(new JLabel("Visible logs: "));
        visibleLogsPnl.add(this.visibleLogsLbl);
        valuesPnl.add(visibleLogsPnl);
        JPanel hiddenLogsPnl = new JPanel(new FlowLayout(0));
        hiddenLogsPnl.add(new JLabel("Hidden logs: "));
        hiddenLogsPnl.add(this.hiddenLogsLbl);
        valuesPnl.add(hiddenLogsPnl);
        JPanel availMemPnl = new JPanel(new FlowLayout(0));
        availMemPnl.add(new JLabel("Memory available: "));
        availMemPnl.add(this.availMemLbl);
        valuesPnl.add(availMemPnl);
        JPanel usedMemPnl = new JPanel(new FlowLayout(0));
        usedMemPnl.add(new JLabel("Used memory: "));
        usedMemPnl.add(this.usedMemLbl);
        valuesPnl.add(usedMemPnl);
        JPanel usedCacheFiles = new JPanel(new FlowLayout(0));
        usedCacheFiles.add(new JLabel("Number of files of cache: "));
        usedCacheFiles.add(this.numOfCacheFiles);
        valuesPnl.add(usedCacheFiles);
        JPanel usedDiskSpace = new JPanel(new FlowLayout(0));
        usedDiskSpace.add(new JLabel("Disk space used by the cache: "));
        usedDiskSpace.add(this.diskSpace);
        valuesPnl.add(usedDiskSpace);
        JPanel timeFramePnl = new JPanel(new FlowLayout(0));
        timeFramePnl.add(new JLabel("Time frame: "));
        timeFramePnl.add(this.timeFrameLbl);
        valuesPnl.add(timeFramePnl);
        JPanel inRatePnl = new JPanel(new FlowLayout(0));
        inRatePnl.add(new JLabel("Rate of logs from NC: "));
        inRatePnl.add(this.inRateLbl);
        valuesPnl.add(inRatePnl);
        JPanel outRatePnl = new JPanel(new FlowLayout(0));
        outRatePnl.add(new JLabel("Rate of logs sent to table: "));
        outRatePnl.add(this.outRateLbl);
        valuesPnl.add(outRatePnl);
        mainPnl.add((Component)valuesPnl, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.monitorBtn.addActionListener(this);
        buttonPanel.add(this.monitorBtn);
        this.refreshBtn.addActionListener(this);
        buttonPanel.add(this.refreshBtn);
        this.closeBtn.addActionListener(this);
        buttonPanel.add(this.closeBtn);
        mainPnl.add((Component)buttonPanel, "South");
        this.setContentPane(mainPnl);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                StatsDlg.this.enableMonitoring(false);
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.isShowing()) {
            Point loggingPos = this.logging.getLocationOnScreen();
            this.setLocation(loggingPos);
            this.toFront();
            this.refreshGUI();
        }
        if (!visible) {
            this.enableMonitoring(false);
        }
    }

    private void refreshGUI() {
        class GuiRefresher
        implements Runnable {
            long totLogs;
            long visLogs;
            long hidLogs;
            long availMem;
            long totMem;
            String diskSize;
            int totCacheFiles;
            String timeFrameStr;
            String inputRateStr;
            String outputRateStr;

            GuiRefresher() {
            }

            @Override
            public void run() {
                StatsDlg.this.totNumOfLogsLbl.setText(Long.valueOf(this.totLogs).toString());
                StatsDlg.this.visibleLogsLbl.setText(Long.valueOf(this.visLogs).toString());
                StatsDlg.this.hiddenLogsLbl.setText(Long.valueOf(this.hidLogs).toString());
                StatsDlg.this.availMemLbl.setText("" + this.availMem / 1024L + "Kb");
                StatsDlg.this.usedMemLbl.setText("" + (this.totMem - this.availMem) / 1024L + "Kb");
                StatsDlg.this.diskSpace.setText(this.diskSize);
                StatsDlg.this.numOfCacheFiles.setText("" + this.totCacheFiles);
                StatsDlg.this.timeFrameLbl.setText(this.timeFrameStr);
                StatsDlg.this.inRateLbl.setText(this.inputRateStr);
                StatsDlg.this.outRateLbl.setText(this.outputRateStr);
                StatsDlg.this.pack();
            }
        }
        GuiRefresher refresher = new GuiRefresher();
        refresher.totLogs = this.logging.getLogEntryTable().getLCModel().totalLogNumber();
        refresher.visLogs = this.logging.getLogEntryTable().getViewRowCount();
        refresher.hidLogs = refresher.totLogs - refresher.visLogs;
        try {
            refresher.diskSize = "" + this.logging.getLogEntryTable().getLCModel().usedDiskSpace();
        }
        catch (Throwable t) {
            System.err.println("Error getting the used disk space: " + t.getMessage());
            t.printStackTrace(System.err);
            refresher.diskSize = NotAvailable;
        }
        refresher.totCacheFiles = this.logging.getLogEntryTable().getLCModel().numberOfUsedFiles();
        Runtime rt = Runtime.getRuntime();
        refresher.availMem = rt.freeMemory();
        refresher.totMem = rt.totalMemory();
        Calendar timeFrame = this.logging.getLogEntryTable().getLCModel().getTimeFrame();
        StringBuilder str = new StringBuilder();
        str.append(timeFrame.get(6) - 1);
        str.append("days - ");
        str.append(timeFrame.get(11));
        str.append(":");
        str.append(timeFrame.get(12));
        str.append(":");
        str.append(timeFrame.get(13));
        str.append(".");
        str.append(timeFrame.get(14));
        refresher.timeFrameStr = str.toString();
        StringBuilder in = new StringBuilder();
        in.append(this.logging.getEngine().getActualInputRate());
        in.append(" (");
        if (this.logging.getEngine().getMaxInputRate() == Integer.MAX_VALUE) {
            in.append("unlimited)");
        } else {
            in.append("limted to ");
            in.append(this.logging.getEngine().getMaxInputRate());
            in.append(')');
        }
        refresher.inputRateStr = in.toString();
        StringBuilder out = new StringBuilder();
        out.append(this.logging.getEngine().getActualOutputRate());
        out.append(" (");
        if (this.logging.getEngine().getMaxOutputRate() == Integer.MAX_VALUE) {
            out.append("unlimited)");
        } else {
            out.append("limted to ");
            out.append(this.logging.getEngine().getMaxOutputRate());
            out.append(')');
        }
        refresher.outputRateStr = out.toString();
        SwingUtilities.invokeLater(refresher);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeBtn) {
            this.setVisible(false);
        }
        if (e.getSource() == this.refreshBtn) {
            Thread t = new Thread("Stats dialog updater"){

                @Override
                public void run() {
                    StatsDlg.this.refreshGUI();
                }
            };
            t.setDaemon(true);
            t.start();
        }
        if (e.getSource() == this.monitorBtn) {
            this.enableMonitoring(this.refreshBtn.isEnabled());
        }
    }

    private void enableMonitoring(boolean start) {
        if (start) {
            if (this.timer != null) {
                throw new IllegalStateException("Timer is already instantiated");
            }
            this.timer = new Timer("Statistics monitoring");
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    StatsDlg.this.refreshGUI();
                }
            };
            this.timer.schedule(task, 50L, 1000L);
            this.refreshBtn.setEnabled(false);
            this.monitorBtn.setText("Stop monitoring");
        } else {
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = null;
            this.refreshBtn.setEnabled(true);
            this.monitorBtn.setText("Start monitoring");
        }
    }
}

