/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.gtk;

import com.l2fprod.gui.plaf.skin.DefaultButton;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkBorder;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkImage;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkStyle;
import com.l2fprod.gui.plaf.skin.impl.gtk.parser.GtkParser;
import com.l2fprod.util.AccessUtils;
import com.l2fprod.util.ImageUtils;
import java.awt.Image;
import java.io.FileNotFoundException;

class GtkUtils {
    public static final boolean DEBUG = "true".equals(AccessUtils.getProperty("debug.gtk"));

    public static DefaultButton newButton(GtkParser parser, String style, String[] keys, String[] values) throws Exception {
        return GtkUtils.newButton(parser, style, keys, values, false, false);
    }

    public static DefaultButton newButton(GtkParser parser, String style, String[] keys, String[] values, boolean useOverlay) throws Exception {
        return GtkUtils.newButton(parser, style, keys, values, useOverlay, false);
    }

    public static DefaultButton newButton(GtkParser parser, String style, String[] keys, String[] values, boolean useOverlay, boolean exactMatch) throws Exception {
        if (DEBUG) {
            System.out.println("Looking in " + style + " for ");
            int i = 0;
            int c = keys.length;
            while (i < c) {
                System.out.println("\t" + keys[i] + " = " + values[i]);
                ++i;
            }
        }
        try {
            GtkStyle[] styles;
            DefaultButton button = null;
            if (parser.getClass(style) == null) {
                GtkStyle[] c = new GtkStyle[]{parser.getStyle(style)};
            } else {
                if (DEBUG) {
                    System.out.println("style " + style + " exists as class");
                }
                styles = parser.getClass(style).getStyles();
            }
            if (DEBUG) {
                System.out.println("Style " + style + " (count:" + styles.length + ")");
            }
            int i = 0;
            int c = styles.length;
            while (i < c) {
                GtkStyle gtkstyle = styles[i];
                if (DEBUG) {
                    System.out.println("\tSub: " + styles[i]);
                }
                if (gtkstyle != null) {
                    GtkImage image = gtkstyle.getEngine().findImage(keys, values, exactMatch);
                    if (DEBUG) {
                        System.out.println("\t\tImage is " + image);
                    }
                    if (image != null) {
                        Image bitmap = null;
                        GtkBorder border = (GtkBorder)image.getProperty(useOverlay ? "overlay_border" : "border");
                        if (useOverlay && border == null) {
                            border = (GtkBorder)image.getProperty("border");
                        }
                        if (!useOverlay && border == null) {
                            border = (GtkBorder)image.getProperty("overlay_border");
                        }
                        if (border == null) {
                            border = new GtkBorder(0, 0, 0, 0);
                        }
                        bitmap = image.getImage(parser.getDirectory(), useOverlay ? "overlay_file" : "file");
                        if (useOverlay && bitmap == null) {
                            bitmap = image.getImage(parser.getDirectory(), "file");
                        }
                        if (!useOverlay && bitmap == null) {
                            bitmap = image.getImage(parser.getDirectory(), "overlay_file");
                        }
                        button = new DefaultButton(bitmap, bitmap.getWidth(ImageUtils.producer), bitmap.getHeight(ImageUtils.producer), border.top, border.right, border.bottom, border.left);
                        button.setCenterFill("TRUE".equals(image.getProperty(useOverlay ? "overlay_stretch" : "stretch")) ? 1 : 2);
                        break;
                    }
                }
                ++i;
            }
            if (button == null && !"default".equals(style)) {
                button = GtkUtils.newButton(parser, "default", keys, values);
                int length = keys.length;
                while (length > 0 && button == null) {
                    String[] subkeys = new String[--length];
                    System.arraycopy(keys, 0, subkeys, 0, length);
                    button = GtkUtils.newButton(parser, "default", subkeys, values);
                }
                if (button == null) {
                    if (DEBUG) {
                        System.out.println("defaulting to exactMatch");
                    }
                    button = GtkUtils.newButton(parser, "default", keys, values, false, true);
                }
            }
            if (DEBUG && button == null) {
                System.out.println("button not found for " + style);
                System.out.println("image {");
                i = 0;
                c = keys.length;
                while (i < c) {
                    System.out.println("\t" + keys[i] + " = " + values[i]);
                    ++i;
                }
                System.out.println("}");
                Thread.dumpStack();
            }
            return button;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    GtkUtils() {
    }
}

