/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sourcecatalog.restful;

import alma.common.sourcecatalog.Catalog;
import alma.common.sourcecatalog.CatalogAccess;
import alma.common.sourcecatalog.CatalogQueryParameters;
import alma.common.sourcecatalog.Measurement;
import alma.common.sourcecatalog.Source;
import alma.common.sourcecatalog.SourceType;
import alma.common.sourcecatalog.restful.CatalogJson;
import alma.common.sourcecatalog.restful.MeasurementJson;
import alma.common.sourcecatalog.restful.SourceJson;
import alma.common.sourcecatalog.restful.SourceTypeJson;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;

public class CatalogAccessRESTful
implements CatalogAccess {
    private static WebResource client;

    public CatalogAccessRESTful() {
        try {
            URL url = new URL("http://localhost:8080/sc/rest");
            this.setEndpoint(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public CatalogAccessRESTful(URL url) {
        this.setEndpoint(url);
    }

    public void setEndpoint(URL url) {
        try {
            client = Client.create().resource(url.toURI());
            client.type("application/json");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> Collection<T> executeRequest(String url, MultivaluedMap<String, String> query, Class<T> t) throws IOException {
        List<Object> collection = null;
        ClientResponse response = (ClientResponse)client.path(url).queryParams(query).get(ClientResponse.class);
        System.out.println(response);
        if (response.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
        }
        ObjectMapper mapper = new ObjectMapper();
        String json = (String)response.getEntity(String.class);
        try {
            collection = (List<Object>)new ObjectMapper().readValue(json, (JavaType)mapper.getTypeFactory().constructCollectionType(Collection.class, t));
        }
        catch (JsonMappingException e) {
            collection = Arrays.asList(new ObjectMapper().readValue(json, t));
        }
        return collection;
    }

    @Override
    public List<Measurement> query(CatalogQueryParameters query) throws IOException, IllegalArgumentException {
        ArrayList<Measurement> collection = new ArrayList<Measurement>();
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        if (query.hasRightAscension()) {
            queryParams.add((Object)"ra", (Object)Double.toString(query.getRightAscension()));
        }
        if (query.hasDeclination()) {
            queryParams.add((Object)"dec", (Object)Double.toString(query.getDeclination()));
        }
        if (query.hasRadius()) {
            queryParams.add((Object)"radius", (Object)Double.toString(query.getRadius()));
        }
        if (query.hasMinFrequency()) {
            queryParams.add((Object)"fLower", (Object)Double.toString(query.getMinFrequency() * 1.0E9));
        }
        if (query.hasMaxFrequency()) {
            queryParams.add((Object)"fUpper", (Object)Double.toString(query.getMaxFrequency() * 1.0E9));
        }
        if (query.hasMinFlux()) {
            queryParams.add((Object)"fluxMin", (Object)Double.toString(query.getMinFlux()));
        }
        if (query.hasMaxFlux()) {
            queryParams.add((Object)"fluxMax", (Object)Double.toString(query.getMaxFlux()));
        }
        if (query.hasName()) {
            queryParams.add((Object)"name", (Object)query.getName());
        }
        queryParams.add((Object)"limit", (Object)Integer.toString(query.getMaxSources()));
        queryParams.add((Object)"sortBy", (Object)((String)this.listSortFields().toArray()[0]));
        queryParams.add((Object)"asc", (Object)Boolean.toString(query.getSortAscending()));
        queryParams.add((Object)"isValid", (Object)Boolean.TRUE.toString());
        queryParams.add((Object)"catalogues", (Object)Arrays.toString(this.listCatalogIds().toArray()).replaceAll("[\\[\\]\\s*]", ""));
        queryParams.add((Object)"types", (Object)Arrays.toString(this.listTypeIds().toArray()).replaceAll("[\\[\\]\\s*]", ""));
        Iterator<MeasurementJson> iterator = this.executeRequest("/measurements", (MultivaluedMap<String, String>)queryParams, MeasurementJson.class).iterator();
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        return collection;
    }

    @Override
    public Source getSource(Integer id) throws IOException {
        SourceJson source = this.executeRequest("/sources/" + id, (MultivaluedMap<String, String>)new MultivaluedMapImpl(), SourceJson.class).iterator().next();
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"name", (Object)source.getNames().get(0));
        for (MeasurementJson measurement : this.executeRequest("/measurements", (MultivaluedMap<String, String>)queryParams, MeasurementJson.class)) {
            source.addMeasurement(measurement);
        }
        return source;
    }

    @Override
    public Collection<Catalog> listCatalogs() throws IOException {
        ArrayList<Catalog> collection = new ArrayList<Catalog>();
        Iterator<CatalogJson> iterator = this.executeRequest("/catalogues", (MultivaluedMap<String, String>)new MultivaluedMapImpl(), CatalogJson.class).iterator();
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        return collection;
    }

    @Override
    public Collection<String> listSortFields() throws IOException {
        return Arrays.asList("source_id", "ra", "dec", "frequency", "flux", "flux_uncertainty", "date_observed");
    }

    @Override
    public Collection<SourceType> listTypes() throws IOException {
        ArrayList<SourceType> collection = new ArrayList<SourceType>();
        Iterator<SourceTypeJson> iterator = this.executeRequest("/types", (MultivaluedMap<String, String>)new MultivaluedMapImpl(), SourceTypeJson.class).iterator();
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        return collection;
    }

    private Collection<Integer> listCatalogIds() throws IOException {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (Catalog c : this.listCatalogs()) {
            ids.add(c.getId());
        }
        return ids;
    }

    private Collection<Integer> listTypeIds() throws IOException {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (SourceType t : this.listTypes()) {
            ids.add(t.getId());
        }
        return ids;
    }

    public static void main(String[] args) throws IOException {
        CatalogAccessRESTful catalogAccessRESTful = new CatalogAccessRESTful(new URL("http://localhost:8080/sc/rest"));
        System.out.println("Catalogues:");
        Collection<Catalog> listCatalogs = catalogAccessRESTful.listCatalogs();
        Iterator<Catalog> iteratorCatalogs = listCatalogs.iterator();
        while (iteratorCatalogs.hasNext()) {
            System.out.println(iteratorCatalogs.next());
        }
        System.out.println();
        System.out.println("Types:");
        Collection<SourceType> listTypes = catalogAccessRESTful.listTypes();
        Iterator<SourceType> iteratorTypes = listTypes.iterator();
        while (iteratorTypes.hasNext()) {
            System.out.println(iteratorTypes.next());
        }
        System.out.println();
        System.out.println("Measurements:");
        CatalogQueryParameters query = new CatalogQueryParameters();
        query.setName("J2157-6941");
        query.setMinFrequency(230.0);
        query.setMaxFrequency(230.0);
        for (Measurement m : catalogAccessRESTful.query(query)) {
            System.out.println(m);
        }
        System.out.println();
        System.out.println("Source:");
        Source s = catalogAccessRESTful.getSource(1788);
        System.out.println(s);
    }
}

