/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sourcecatalog.utilities;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class FileUtilities {
    public static final String jpeg = "jpeg";
    public static final String jpg = "jpg";
    public static final String gif = "gif";
    public static final String tiff = "tiff";
    public static final String tif = "tif";
    public static final String xml = "xml";
    public static final String txt = "txt";
    public static final String aot = "aot";
    private static final int BLKSIZE = 10240;
    private static final int BUFSIZE = 0x100000;
    private static byte[] smallBuf;
    private static byte[] bigBuf;
    private static String curDir;
    private static int bufferUsers;
    private static File tmpdir;

    private FileUtilities() {
    }

    public static void buffersNeeded(boolean yesNo) {
        if (yesNo) {
            if (bufferUsers++ == 0) {
                smallBuf = new byte[10240];
                bigBuf = new byte[0x100000];
            }
        } else if (--bufferUsers == 0) {
            smallBuf = null;
            bigBuf = null;
        }
    }

    public static String getBasename(String filename) {
        int i = filename.length() - 1;
        if (i >= 0 && filename.charAt(i) == '/') {
            filename = filename.substring(0, i);
        }
        if ((i = filename.lastIndexOf(46)) < 0) {
            return filename;
        }
        String name = filename.substring(0, i);
        return name;
    }

    public static String getBasename(File f) {
        String s = f.getName();
        return FileUtilities.getBasename(s);
    }

    public static String getBasename(URL url) {
        String s = url.toExternalForm();
        int i = s.indexOf(":");
        if (i >= 0) {
            s = s.substring(i + 1);
        }
        File f = new File(s);
        return FileUtilities.getBasename(f);
    }

    public static String getExtension(File f) {
        String s = f.getName();
        return FileUtilities.getExtension(s);
    }

    public static String getExtension(String s) {
        int i = s.lastIndexOf(46);
        if (i < 0) {
            return null;
        }
        String ext = s.substring(i + 1).toLowerCase();
        return ext;
    }

    public static File getTmpDir() throws IOException {
        if (tmpdir == null) {
            File tmpfile = File.createTempFile("ObservingToolTmpFile", "");
            tmpdir = tmpfile.getAbsoluteFile().getParentFile();
            tmpfile.delete();
        }
        return tmpdir;
    }

    public static byte[] getZipEntry(ZipFile zipfile, ZipEntry entry) throws IOException {
        InputStream s = zipfile.getInputStream(entry);
        byte[] data = FileUtilities.readEntry(s);
        return data;
    }

    public static ZipNtry getZipEntry(ZipInputStream stream) throws IOException {
        ZipEntry entry = stream.getNextEntry();
        if (entry == null) {
            return null;
        }
        byte[] data = FileUtilities.readEntry(stream);
        entry.setSize(data.length);
        ZipNtry ret = new ZipNtry(entry, data);
        return ret;
    }

    private static void copyBytes(byte[] from, byte[] to, int num, int toOffset) {
        for (int i = 0; i < num; ++i) {
            to[i + toOffset] = from[i];
        }
    }

    public static byte[] readEntry(InputStream stream) throws IOException {
        int n;
        int nTotal = 0;
        FileUtilities.buffersNeeded(true);
        while ((n = stream.read(smallBuf, 0, smallBuf.length)) >= 0) {
            try {
                FileUtilities.copyBytes(smallBuf, bigBuf, n, nTotal);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                byte[] newBigBuf = new byte[bigBuf.length * 2];
                FileUtilities.copyBytes(bigBuf, newBigBuf, nTotal, 0);
                FileUtilities.copyBytes(smallBuf, newBigBuf, n, nTotal);
                bigBuf = newBigBuf;
            }
            nTotal += n;
        }
        byte[] data = new byte[nTotal];
        FileUtilities.copyBytes(bigBuf, data, nTotal, 0);
        FileUtilities.buffersNeeded(false);
        return data;
    }

    static void putZipEntry(ZipOutputStream zipfile, ZipEntry entry, byte[] data) throws IOException {
        int len = (int)entry.getSize();
        zipfile.putNextEntry(entry);
        zipfile.write(data, 0, len);
    }

    public static void putZipEntry(ZipOutputStream zipfile, String path, byte[] data) throws IOException {
        int len = data.length;
        ZipEntry entry = new ZipEntry(path);
        entry.setSize(len);
        FileUtilities.putZipEntry(zipfile, entry, data);
    }

    public static void stringToFile(String s, String pathname) throws IOException {
        File f = new File(pathname);
        FileUtilities.stringToFile(s, f);
    }

    public static void stringToFile(String s, File f) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(f));
        bw.write(s, 0, s.length());
        bw.close();
    }

    public static String fileToString(String filename) throws IOException {
        File f = new File(filename);
        return FileUtilities.fileToString(f);
    }

    public static String fileToString(File f) throws IOException {
        int nread;
        int chunk = 64000;
        StringBuffer sb = new StringBuffer();
        char[] buff = new char[64000];
        BufferedReader br = new BufferedReader(new FileReader(f));
        while (br.ready() && (nread = br.read(buff, 0, buff.length)) > 0) {
            sb.append(buff, 0, nread);
        }
        br.close();
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fileToBytes(File f) throws IOException {
        BufferedInputStream in = null;
        try {
            int nRead;
            byte[] data = new byte[(int)f.length()];
            in = new BufferedInputStream(new FileInputStream(f));
            for (int totalRead = 0; totalRead < data.length && (nRead = in.read(data, totalRead, in.available())) != -1; totalRead += nRead) {
            }
            byte[] byArray = data;
            return byArray;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bytesToFile(byte[] data, File f) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(f);
            out.write(data);
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public static URL makeURL(String s) throws MalformedURLException {
        File f;
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException("Null or empty input.");
        }
        URL url = null;
        String alldrives = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        boolean winabs = false;
        if (s.length() > 1) {
            char c0 = s.charAt(0);
            char c1 = s.charAt(1);
            if (c1 == ':' && "ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(c0) != -1) {
                winabs = true;
            }
        }
        if ((f = new File(s)).exists() || winabs) {
            url = f.toURI().toURL();
            return url;
        }
        if (s.indexOf(58) == -1) {
            s = "file:" + s;
        }
        url = new URL(s);
        return url;
    }

    public static String getCurDirBasename() throws IOException {
        if (curDir == null) {
            String path = null;
            path = new File(".").getCanonicalPath();
            String last = path.replace('\\', '/');
            String[] t = last.split("/");
            curDir = t[t.length - 1];
        }
        return curDir;
    }

    public static boolean isTestDir() {
        try {
            String base = FileUtilities.getCurDirBasename();
            return base.equals("test");
        }
        catch (IOException whoops) {
            return false;
        }
    }

    static {
        curDir = null;
        bufferUsers = 0;
        tmpdir = null;
    }

    public static class ZipNtry
    extends ZipEntry {
        byte[] data;

        public ZipNtry(ZipEntry e, byte[] data) {
            super(e);
            this.data = data;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

