/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sourcecatalog.utilities;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class TextUtils {
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String SPACES = "                               ";
    private static final String ZEROES = "0000000000000000000000000000000";
    public static final char QUOTE = '\'';

    public static String padded(String padding, int numDigits, long n) {
        String unpadded = new Long(n).toString();
        if (numDigits <= unpadded.length()) {
            return unpadded;
        }
        return padding.substring(0, numDigits - unpadded.length()) + unpadded;
    }

    public static String padLeft(String s, int numchars, char ch) {
        int initStrSize = s.length();
        if (initStrSize >= numchars) {
            return s;
        }
        if (numchars < initStrSize) {
            throw new ArrayIndexOutOfBoundsException("Error number of characters to to small");
        }
        int numToInsert = numchars - s.length();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < numToInsert; ++i) {
            buf.append("" + ch);
        }
        return buf.toString() + s;
    }

    public static String padded(String padding, int numChars, String unpadded) {
        if (numChars <= unpadded.length()) {
            return unpadded;
        }
        return padding.substring(0, numChars - unpadded.length()) + unpadded;
    }

    public static String rightpadded(String padding, int numChars, String unpadded) {
        if (numChars <= unpadded.length()) {
            return unpadded;
        }
        return unpadded + padding.substring(0, numChars - unpadded.length());
    }

    public static String quoteSqlString(String str) {
        if (str == null) {
            return str;
        }
        if (str.indexOf(39) == -1) {
            return str;
        }
        String out_str = "";
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char character = str.charAt(i);
            if (character == '\'') {
                out_str = out_str + character;
            }
            out_str = out_str + character;
        }
        return out_str;
    }

    public static String getEmptySqlStringIfNull(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static String spacePadded(int numDigits, long n) {
        return TextUtils.padded(SPACES, numDigits, n);
    }

    public static String zeroPadded(int numDigits, long n) {
        return TextUtils.padded(ZEROES, numDigits, n);
    }

    public static String zeroPadded(int numDigits, String s) {
        return TextUtils.padded(ZEROES, numDigits, s);
    }

    public static String padString(String s, int newLen) {
        if (s.length() >= newLen) {
            return s;
        }
        StringBuffer buf = new StringBuffer(s);
        int padLen = newLen - s.length();
        for (int i = 0; i < padLen; ++i) {
            buf.append(" ");
        }
        return buf.toString();
    }

    public static String escapedString(String original) {
        int len = original.length();
        StringBuffer buf = new StringBuffer();
        block4: for (int k = 0; k < len; ++k) {
            char ch = original.charAt(k);
            switch (ch) {
                case '\"': 
                case '\\': {
                    buf.append("\\");
                    buf.append("" + ch);
                    continue block4;
                }
                case '\n': 
                case '\r': {
                    buf.append("\\n");
                    continue block4;
                }
                default: {
                    buf.append("" + ch);
                }
            }
        }
        return buf.toString();
    }

    public static String revertEscapedString(String original) {
        int len = original.length();
        StringBuffer buf = new StringBuffer();
        for (int k = 0; k < len; ++k) {
            char ch = original.charAt(k);
            if (ch == '\\') {
                if (++k < len) {
                    ch = original.charAt(k);
                }
                switch (ch) {
                    case 'n': {
                        buf.append("\n");
                        break;
                    }
                    case 'r': {
                        buf.append("\r");
                        break;
                    }
                    default: {
                        buf.append("" + ch);
                        break;
                    }
                }
                continue;
            }
            buf.append("" + ch);
        }
        return buf.toString();
    }

    public static String pkgToPath(Class<?> cls) {
        String path = cls.getName();
        int index = path.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        path = path.substring(0, index);
        while ((index = path.indexOf(46)) > 0) {
            path = path.substring(0, index) + File.separator + path.substring(index + 1);
        }
        return path + File.separator;
    }

    public static String convertFileToString(File f) {
        char[] buff = new char[64000];
        StringBuffer sb = new StringBuffer();
        try {
            int nread;
            BufferedReader br = new BufferedReader(new FileReader(f));
            while (br.ready() && (nread = br.read(buff, 0, buff.length)) > 0) {
                sb.append(buff, 0, nread);
            }
            br.close();
        }
        catch (Throwable t) {
            sb.append("Failed to read file contents.");
        }
        return sb.toString();
    }

    public static String[] stringToArray(String s, String sep, boolean trim) {
        StringBuffer buf = new StringBuffer(s);
        int arraysize = 1;
        for (int i = 0; i < buf.length(); ++i) {
            if (sep.indexOf(buf.charAt(i)) == -1) continue;
            ++arraysize;
        }
        String[] elements = new String[arraysize];
        int z = 0;
        if (buf.toString().indexOf(sep) != -1) {
            while (buf.length() > 0) {
                if (buf.toString().indexOf(sep) == -1) continue;
                int y = buf.toString().indexOf(sep);
                if (y != buf.toString().lastIndexOf(sep)) {
                    elements[z] = buf.toString().substring(0, y);
                    ++z;
                    buf.delete(0, y + 1);
                    continue;
                }
                if (buf.toString().lastIndexOf(sep) != y) continue;
                elements[z] = buf.toString().substring(0, buf.toString().indexOf(sep));
                buf.delete(0, buf.toString().indexOf(sep) + 1);
                elements[++z] = buf.toString();
                ++z;
                buf.delete(0, buf.length());
            }
        } else {
            elements[0] = buf.toString();
        }
        buf = null;
        if (trim) {
            elements = TextUtils.trimStringArray(elements);
        }
        return elements;
    }

    private static String[] trimStringArray(String[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = elements[i].trim();
        }
        if (elements.length == 1 && elements[0].length() == 0) {
            elements = new String[]{};
        }
        return elements;
    }

    public static String arrayToString(String[] s, String sep, boolean trim) {
        int k;
        String result = "";
        if (s == null) {
            k = 0;
        } else {
            if (trim) {
                TextUtils.trimStringArray(s);
            }
            k = s.length;
        }
        if (k > 0) {
            result = s[0];
            for (int i = 1; i < k; ++i) {
                result = result + sep + s[i];
            }
        }
        return result;
    }

    public static String[] splitString(String s, int size) {
        Vector<String> strList = new Vector<String>();
        for (int i = 0; i < s.length(); i += size) {
            String substr = i + size > s.length() ? s.substring(i) : s.substring(i, i + size);
            strList.addElement(substr);
        }
        Object[] splitLines = new String[strList.size()];
        strList.copyInto(splitLines);
        return splitLines;
    }

    public static String[] sort(String[] in) {
        int i;
        Vector<String> out = new Vector<String>();
        for (i = 0; i < in.length; ++i) {
            int o;
            String str = in[i];
            for (o = 0; o < i && str.compareTo((String)out.elementAt(o)) > 0; ++o) {
            }
            if (o == i) {
                out.addElement(str);
                continue;
            }
            out.insertElementAt(str, o);
        }
        for (i = 0; i < in.length; ++i) {
            in[i] = (String)out.elementAt(i);
        }
        return in;
    }

    public static Sortable[] sort(Sortable[] in) {
        int i;
        Vector<Sortable> out = new Vector<Sortable>();
        for (i = 0; i < in.length; ++i) {
            int o;
            String str = in[i].getSortKey();
            for (o = 0; o < i && str.compareTo(((Sortable)out.elementAt(o)).getSortKey()) > 0; ++o) {
            }
            if (o == i) {
                out.addElement(in[i]);
                continue;
            }
            out.insertElementAt(in[i], o);
        }
        for (i = 0; i < in.length; ++i) {
            in[i] = (Sortable)out.elementAt(i);
        }
        return in;
    }

    public static SortableNumber[] sort(SortableNumber[] in) {
        int i;
        Vector<SortableNumber> out = new Vector<SortableNumber>();
        for (i = 0; i < in.length; ++i) {
            int o;
            double val = in[i].getSortKey();
            for (o = 0; o < i && !(val <= ((SortableNumber)out.elementAt(o)).getSortKey()); ++o) {
            }
            if (o == i) {
                out.addElement(in[i]);
                continue;
            }
            out.insertElementAt(in[i], o);
        }
        for (i = 0; i < in.length; ++i) {
            in[i] = (SortableNumber)out.elementAt(i);
        }
        return in;
    }

    public static int isASCIIPrintable(String s, int maxn) {
        int testl = Math.min(s.length(), maxn);
        for (int i = 0; i < testl; ++i) {
            if (TextUtils.isASCIIPrintable(s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static int isASCIIPrintable(String s) {
        return TextUtils.isASCIIPrintable(s, s.length());
    }

    public static boolean isASCIIPrintable(char c) {
        char code = c;
        if (code >= ' ' && code < '\u007f') {
            return true;
        }
        return code == '\t' || code == '\n' || code == '\f' || code == '\r';
    }

    public static String breakString(String s, int n) {
        if (s == null) {
            return s;
        }
        int l = s.length();
        if (l <= n) {
            return s;
        }
        int p = s.lastIndexOf(" ", n - 1);
        if (p == -1 && (p = s.indexOf(32)) == -1) {
            return s;
        }
        return s.substring(0, p) + '\n' + TextUtils.breakString(s.substring(p + 1, l), n);
    }

    public static String range(double lo, double hi, boolean incLo, boolean incHi) {
        String sLo = TextUtils.shortformat(lo);
        String sHi = TextUtils.shortformat(hi);
        StringBuffer b = new StringBuffer();
        b.append(incLo ? "[" : "(").append(sLo).append(",").append(sHi).append(incHi ? "]" : ")");
        return b.toString();
    }

    private static String shortformat(double d) {
        String ret = Double.toString(d);
        if (ret.endsWith(".0")) {
            ret = ret.substring(0, ret.length() - 2);
        }
        return ret;
    }

    public static String format(double d, int b, int a) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "" + d;
        }
        if (a < 0 || b < 0) {
            throw new IllegalArgumentException("Negative number of digits");
        }
        String format = String.format("%%%d.%df", b + a + 1, a);
        String result = String.format(format, d);
        return result;
    }

    public static String oldformat(double d, int b, int a) {
        int i;
        String as;
        String bs;
        if (a < 0 || b < 0) {
            throw new IllegalArgumentException("Negative number of digits");
        }
        String s = Double.toString(d);
        int p = s.indexOf(".");
        if (p < 0) {
            bs = s;
            as = "";
        } else {
            bs = s.substring(0, p);
            as = s.substring(p + 1, s.length());
        }
        int adiff = a - as.length();
        if (a == 0) {
            as = "";
        } else if (adiff < 0) {
            as = as.substring(0, a);
        }
        StringBuffer sb = new StringBuffer();
        int bdiff = b - bs.length();
        if (bdiff > 0) {
            for (i = 0; i < bdiff; ++i) {
                sb.append(" ");
            }
        }
        sb.append(bs).append(".").append(as);
        if (a > 0 && adiff > 0) {
            for (i = 0; i < adiff; ++i) {
                sb.append("0");
            }
        }
        return sb.toString();
    }

    public static String format(ValueUnitPair<?> vup, int b, int a) {
        if (a < 0 || b < 0) {
            throw new IllegalArgumentException("Negative number of digits");
        }
        StringBuffer s = new StringBuffer();
        s.append(TextUtils.format(vup.getContent(), b, a));
        s.append(' ');
        s.append(vup.getUnit());
        return s.toString();
    }

    public static String format(ValueUnitPair<?> vup, int a) {
        return TextUtils.format(vup, 3, a);
    }

    public static String format(ValueUnitPair<?> vup) {
        return TextUtils.format(vup, 6);
    }

    public static boolean startsWithIgnoreCase(String string, String prefix) {
        if (string == null || prefix == null || string.length() < prefix.length()) {
            return false;
        }
        return string.substring(0, prefix.length()).equalsIgnoreCase(prefix);
    }

    public static String stripPrefix(String string, String prefix) {
        String result = string.startsWith(prefix) ? string.substring(prefix.length()) : string;
        return result;
    }

    public static String stripSuffix(String string, String suffix) {
        String result = string.endsWith(suffix) ? string.substring(0, string.length() - suffix.length()) : string;
        return result;
    }

    public static String getChoice(String input, String[] list, boolean caseSensitive) {
        if (input == null) {
            return null;
        }
        String src = caseSensitive ? input : input.toLowerCase();
        for (String s : list) {
            String str;
            String string = str = caseSensitive ? s : s.toLowerCase();
            if (!src.equals(str)) continue;
            return s;
        }
        return null;
    }

    public static String stripHtmlTags(String input) {
        StringBuffer result = new StringBuffer();
        boolean skip = false;
        block4: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '<': {
                    skip = true;
                    continue block4;
                }
                case '>': {
                    skip = false;
                    continue block4;
                }
                default: {
                    if (skip) continue block4;
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String[] removeFromArray(String[] orig, String item) {
        return TextUtils.removeFromArray(orig, new String[]{item});
    }

    public static String[] removeFromArray(String[] orig, String[] items) {
        ArrayList<String> v = new ArrayList<String>();
        v.addAll(Arrays.asList(orig));
        for (String item : items) {
            v.remove(item);
        }
        String[] ret = new String[v.size()];
        return v.toArray(ret);
    }

    public static String join(Collection<String> s, String delimiter) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iter = s.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) break;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static interface SortableNumber {
        public double getSortKey();
    }

    public static interface Sortable {
        public String getSortKey();
    }
}

