/*
 * Decompiled with CFR 0.152.
 */
package alma.acacorrelator.ACACorrConfigValidator;

import alma.ACS.stringSeqHolder;
import alma.BasebandNameMod.BasebandName;
import alma.Correlator.BaseBandConfig;
import alma.Correlator.CorrelatorConfiguration;
import alma.acacorrelator.ACACorrConfigValidator.ACA_CorrConfigValidator;
import alma.acacorrelator.ACACorrConfigValidator.ACA_XMLUnmarshaller;
import alma.correlatorSrc.CorrConfigValidator.CorrConfigValidatorBase;
import alma.correlatorSrc.CorrConfigValidator.SBConversionException;
import alma.correlatorSrc.CorrConfigValidator.XMLUnmarshaller;
import alma.entity.xmlbinding.schedblock.SpectralSpecT;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class ACACorrConfigValidator
extends CorrConfigValidatorBase {
    static final Logger logger = Logger.getLogger(ACACorrConfigValidator.class.getName());

    public ACACorrConfigValidator() {
        this("ACACORRELATOR");
    }

    public ACACorrConfigValidator(String correlatorType) {
    }

    public boolean validateConfiguration(CorrelatorConfiguration conf, int numOfAntennas, stringSeqHolder errorStringSeq) {
        return ACA_CorrConfigValidator.isValid(conf, numOfAntennas, errorStringSeq);
    }

    public boolean validateSpectralSpec(String spectralSpec, int numOfAntennas, stringSeqHolder errorStringSeq) {
        CorrelatorConfiguration conf = null;
        try {
            SpectralSpecT ss = XMLUnmarshaller.xml2SpectralSpecEntity((String)spectralSpec);
            conf = ACA_XMLUnmarshaller.convert(ss);
        }
        catch (MarshalException e) {
            logger.log(Level.FINE, e.toString(), e);
            errorStringSeq.value = new String[]{ACA_CorrConfigValidator.getStackTrace(e)};
            return false;
        }
        catch (ValidationException e) {
            logger.log(Level.FINE, e.toString(), e);
            errorStringSeq.value = new String[]{ACA_CorrConfigValidator.getStackTrace(e)};
            return false;
        }
        catch (SBConversionException e) {
            logger.log(Level.FINE, e.toString(), e);
            errorStringSeq.value = new String[]{ACA_CorrConfigValidator.getStackTrace(e)};
            return false;
        }
        return this.validateConfiguration(conf, numOfAntennas, errorStringSeq);
    }

    public Map<BasebandName, CorrConfigValidatorBase.BaseBandDataRate> calculateTotalDataRateForConfig(CorrelatorConfiguration corrConfig, int numOfAntennas) {
        HashMap<BasebandName, CorrConfigValidatorBase.BaseBandDataRate> result = new HashMap<BasebandName, CorrConfigValidatorBase.BaseBandDataRate>();
        for (BaseBandConfig bb : corrConfig.baseBands) {
            ACA_CorrConfigValidator.Pair<CorrConfigValidatorBase.BaseBandDataRate, Double> dataRates = ACA_CorrConfigValidator.calcDataRateForBaseBand(corrConfig, bb, numOfAntennas);
            result.put(bb.basebandName, (CorrConfigValidatorBase.BaseBandDataRate)dataRates.left);
        }
        return result;
    }
}

