/*
 * Decompiled with CFR 0.152.
 */
package spiffy.core.lang;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringHelper {
    public static boolean in(String string, String ... stringArray) {
        if (string == null) {
            return false;
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("argument SearchStringList must have length > 0");
        }
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean inAndNonEmpty(String string, String ... stringArray) {
        if (string == null) {
            return false;
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("argument SearchStringList must have length > 0");
        }
        String string2 = string.trim();
        if (string2.equals("")) {
            return false;
        }
        for (String string3 : stringArray) {
            if (!string3.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static String join(String string, Iterator<?> iterator) {
        if (iterator == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().toString());
            stringBuilder.append(string);
        }
        int n = stringBuilder.length();
        if (n > 0) {
            stringBuilder.delete(n - string.length(), n);
        }
        return stringBuilder.toString();
    }

    public static String join(String string, String ... stringArray) {
        int n;
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = stringArray.length - 1;
        for (n = 0; n < n2; ++n) {
            stringBuilder.append(stringArray[n]);
            stringBuilder.append(string);
        }
        stringBuilder.append(stringArray[n]);
        return stringBuilder.toString();
    }

    public static String removeAll(String string, Character ... characterArray) {
        StringBuffer stringBuffer = new StringBuffer();
        HashMap<Character, Character> hashMap = new HashMap<Character, Character>();
        for (Character c : characterArray) {
            hashMap.put(c, c);
        }
        for (int i = 0; i < string.length(); ++i) {
            int n = string.charAt(i);
            if (hashMap.containsKey(Character.valueOf((char)n))) continue;
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    private static String repeatJoin(String string, int n, boolean bl, String ... stringArray) {
        if (string == null) {
            throw new IllegalArgumentException("Argument baseString is null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("argument joinStrings is null");
        }
        if (stringArray.length == 0) {
            return string;
        }
        if (n < string.length()) {
            throw new IllegalArgumentException("Argument endSize is less than the length of baseString");
        }
        int n2 = n - string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        int n3 = 0;
        while (stringBuilder.length() + stringArray[n3].length() <= n2) {
            stringBuilder.append(stringArray[n3]);
            n3 = (n3 + 1) % stringArray.length;
        }
        if (bl) {
            stringBuilder.append(string);
        } else {
            stringBuilder.insert(0, string);
        }
        return stringBuilder.toString();
    }

    public static String repeatLeftJoin(String string, int n, String ... stringArray) {
        return StringHelper.repeatJoin(string, n, true, stringArray);
    }

    public static String repeatRightJoin(String string, int n, String ... stringArray) {
        return StringHelper.repeatJoin(string, n, false, stringArray);
    }

    public static String toString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return ((Object)stringWriter).toString();
    }
}

