/*
 * Decompiled with CFR 0.152.
 */
package spiffy.junit;

import java.util.Collection;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertHelper
extends Assert {
    public static <T> void assertEmpty(String string, Collection<T> collection) {
        if (collection == null) {
            AssertHelper.fail((String)(string + "[collection is null]"));
        }
        if (collection.size() != 0) {
            AssertHelper.fail((String)("Collection " + collection + " is not empty!"));
        }
    }

    public static void assertEquals(String string, byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return;
        }
        if (byArray == null || byArray2 == null) {
            AssertHelper.fail((String)(string + " [Expected: " + byArray + ", actual " + byArray2 + ']'));
        }
        AssertHelper.assertEquals((String)(string + " [Length]"), (int)byArray.length, (int)byArray2.length);
        for (int i = 0; i < byArray.length; ++i) {
            AssertHelper.assertEquals((String)(string + " [" + i + ']'), (byte)byArray[i], (byte)byArray2[i]);
        }
    }

    public static void assertEquals(String string, int[] nArray, int[] nArray2) {
        if (nArray == null && nArray2 == null) {
            return;
        }
        if (nArray == null || nArray2 == null) {
            AssertHelper.fail((String)(string + " [Expected: " + nArray + ", actual " + nArray2 + ']'));
        }
        AssertHelper.assertEquals((String)(string + " [Length]"), (int)nArray.length, (int)nArray2.length);
        for (int i = 0; i < nArray.length; ++i) {
            AssertHelper.assertEquals((String)(string + " [" + i + ']'), (int)nArray[i], (int)nArray2[i]);
        }
    }

    public static void assertEquals(String string, Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null && objectArray2 == null) {
            return;
        }
        if (objectArray == null || objectArray2 == null) {
            AssertHelper.fail((String)(string + " [Expected: " + objectArray + ", actual " + objectArray2 + ']'));
        }
        AssertHelper.assertEquals((String)(string + " [Length]"), (int)objectArray.length, (int)objectArray2.length);
        for (int i = 0; i < objectArray.length; ++i) {
            AssertHelper.assertEquals((String)(string + " [" + i + ']'), (Object)objectArray[i], (Object)objectArray2[i]);
        }
    }

    public static void assertGreaterThan(String string, double d, double d2) {
        if (d >= d2) {
            AssertHelper.fail((String)(string + ". Actual not greater than expected, " + d + " >= " + d2));
        }
    }

    public static void assertGreaterThan(String string, int n, int n2) {
        if (n >= n2) {
            AssertHelper.fail((String)(string + ". Actual not greater than expected, " + n + " >= " + n2));
        }
    }

    public static void assertNotEquals(int n, int n2) {
        if (n == n2) {
            AssertHelper.fail((String)("The two values are equal! Expected: " + n + " actual: " + n2));
        }
    }

    public static void assertNotEquals(String string, double d, double d2) {
        if (d == d2) {
            AssertHelper.fail((String)(string + ". The two values are equal! Expected: " + d + " actual: " + d2));
        }
    }

    public static void assertNotEquals(String string, int n, int n2) {
        if (n == n2) {
            AssertHelper.fail((String)(string + ". The two values are equal! Expected: " + n + " actual: " + n2));
        }
    }
}

