/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jsky.catalog.Catalog;
import jsky.catalog.QueryArgs;
import jsky.catalog.QueryResult;
import jsky.catalog.gui.CatalogQueryPanel;
import jsky.catalog.gui.QueryResultDisplay;
import jsky.util.I18N;
import jsky.util.Interruptable;
import jsky.util.Storeable;
import jsky.util.SwingWorker;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.GridBagUtil;
import jsky.util.gui.ProgressException;

public class CatalogQueryTool
extends JPanel
implements Interruptable,
Storeable {
    private static final I18N _I18N = I18N.getInstance(CatalogQueryTool.class);
    private Catalog _catalog;
    private CatalogQueryPanel _catalogQueryPanel;
    private QueryResultDisplay _queryResultDisplay;
    private SwingWorker _worker;
    private ActionListener _searchListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            CatalogQueryTool.this.search();
        }
    };

    public CatalogQueryTool(Catalog catalog, boolean scrollable) {
        this._catalog = catalog;
        JLabel catalogTitleLabel = this.makeCatalogPanelLabel(catalog);
        this._catalogQueryPanel = this.makeCatalogQueryPanel(catalog);
        this._catalogQueryPanel.addActionListener(this._searchListener);
        GridBagUtil layout = new GridBagUtil((Container)this);
        layout.add((Component)catalogTitleLabel, 0, 0, 1, 1, 0.0, 0.0, 0, 10, new Insets(3, 0, 3, 0));
        if (scrollable) {
            layout.add((Component)new JScrollPane(this._catalogQueryPanel), 0, 1, 1, 1, 1.0, 1.0, 1, 10, new Insets(0, 0, 0, 0));
        } else {
            layout.add((Component)this._catalogQueryPanel, 0, 1, 1, 1, 1.0, 1.0, 1, 10, new Insets(0, 0, 0, 0));
        }
        layout.add((Component)this.makeButtonPanel(), 0, 2, 1, 1, 0.0, 0.0, 2, 10, new Insets(5, 0, 0, 5));
    }

    public CatalogQueryTool(Catalog catalog, QueryResultDisplay queryResultDisplay, boolean scrollable) {
        this(catalog, scrollable);
        this._queryResultDisplay = queryResultDisplay;
    }

    public CatalogQueryTool(Catalog catalog, QueryResultDisplay queryResultDisplay) {
        this(catalog, queryResultDisplay, true);
    }

    protected JLabel makeCatalogPanelLabel(Catalog catalog) {
        String title = catalog.toString();
        this.setName(title);
        return new JLabel(title, 0);
    }

    protected CatalogQueryPanel makeCatalogQueryPanel(Catalog catalog) {
        return new CatalogQueryPanel(catalog, 2);
    }

    protected JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        JButton goButton = new JButton(_I18N.getString("query"));
        goButton.setToolTipText(_I18N.getString("startQuery"));
        goButton.addActionListener(this._searchListener);
        buttonPanel.add(goButton);
        if (this._catalog.getDocURL() != null) {
            JButton docButton = new JButton(_I18N.getString("doc"));
            docButton.setToolTipText(_I18N.getString("docHelp"));
            docButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CatalogQueryTool.this.displayDocumentation();
                }
            });
            buttonPanel.add(docButton);
        }
        return buttonPanel;
    }

    private void displayDocumentation() {
        try {
            Desktop.getDesktop().browse(this._catalog.getDocURL().toURI());
        }
        catch (Exception e) {
            DialogUtil.error((Exception)e);
        }
    }

    public void setQueryResultDisplay(QueryResultDisplay q) {
        this._queryResultDisplay = q;
    }

    public QueryResultDisplay getQueryResultDisplay() {
        return this._queryResultDisplay;
    }

    public void interrupt() {
        if (this._worker != null) {
            this._worker.interrupt();
        }
        this._worker = null;
    }

    @Override
    public String getName() {
        if (this._catalog != null) {
            return this._catalog.getName();
        }
        return _I18N.getString("catalog");
    }

    public Catalog getCatalog() {
        return this._catalog;
    }

    public CatalogQueryPanel getCatalogQueryPanel() {
        return this._catalogQueryPanel;
    }

    public void search() {
        if (this._queryResultDisplay == null) {
            return;
        }
        this._worker = new SwingWorker(){
            private QueryArgs _queryArgs;

            public Object construct() {
                try {
                    this._queryArgs = CatalogQueryTool.this._catalogQueryPanel.getQueryArgs();
                    return CatalogQueryTool.this._catalog.query(this._queryArgs);
                }
                catch (Exception e) {
                    return e;
                }
            }

            public void finished() {
                CatalogQueryTool.this._worker = null;
                Object o = this.getValue();
                if (o instanceof ProgressException) {
                    return;
                }
                if (o instanceof Exception) {
                    DialogUtil.error((Exception)((Exception)o));
                    return;
                }
                CatalogQueryTool.this.setQueryResult((QueryResult)o);
                CatalogQueryTool.this._catalogQueryPanel.setQueryArgs(this._queryArgs);
            }
        };
        this._worker.start();
    }

    public void setQueryResult(QueryResult queryResult) {
        this._queryResultDisplay.setQueryResult(queryResult);
    }

    public Object storeSettings() {
        return this._catalogQueryPanel.storeSettings();
    }

    public boolean restoreSettings(Object obj) {
        if (this._catalogQueryPanel.restoreSettings(obj)) {
            this.search();
            return true;
        }
        return false;
    }
}

