/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter;

import alma.acs.commandcenter.app.CommandCenterLogic;
import alma.acs.commandcenter.util.MiscUtils;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class CommandCenter {
    private static Logger log = MiscUtils.getPackageLogger(CommandCenter.class);
    private static CommandCenterLogic commandCenterLogic;

    public static void main(String[] args) {
        for (Handler h : Logger.getLogger("").getHandlers()) {
            if (!(h instanceof ConsoleHandler)) continue;
            h.setFormatter(new Formatter(){
                DateFormat df = new SimpleDateFormat("HH:mm:ss ");

                @Override
                public String format(LogRecord record) {
                    String s = this.df.format(new Date(record.getMillis()));
                    s = s + record.getMessage() + "\n";
                    return s;
                }
            });
        }
        CommandCenterLogic.StartupOptions startupOptions = new CommandCenterLogic.StartupOptions();
        for (int i = 0; i < args.length; ++i) {
            if (i == 0 && CommandCenter.equalsOneOf(args[i], new String[]{"-h", "-help", "--help"})) {
                CommandCenter.printUsage(System.out);
                return;
            }
            try {
                if (CommandCenter.equalsOneOf(args[i], new String[]{"-r", "-retrieve", "--retrieve"})) {
                    startupOptions.project = new File(args[++i]);
                    continue;
                }
                if (CommandCenter.equalsOneOf(args[i], new String[]{"-g", "-geometry", "--geometry"})) {
                    StringTokenizer toky = new StringTokenizer(args[++i], "x+");
                    int w = Integer.parseInt(toky.nextToken());
                    int h = Integer.parseInt(toky.nextToken());
                    int x = Integer.parseInt(toky.nextToken());
                    int y = Integer.parseInt(toky.nextToken());
                    startupOptions.geometry = new Rectangle(x, y, w, h);
                    continue;
                }
                if (CommandCenter.equalsOneOf(args[i], new String[]{"-x", "-noexit", "--noexit"})) {
                    startupOptions.doExitOnClose = false;
                    continue;
                }
                if (CommandCenter.equalsOneOf(args[i], new String[]{"-useNativeSSH", "--useNativeSSH"})) {
                    log.warning("command line option '-useNativeSSH' no longer supported.");
                    continue;
                }
                if (CommandCenter.equalsOneOf(args[i], new String[]{"-killNativeSSH", "--killNativeSSH"})) {
                    log.warning("command line option '-killNativeSSH' no longer supported.");
                    continue;
                }
                String standalone = args[i];
                if (standalone.length() > 8 && standalone.substring(0, 8).equalsIgnoreCase("corbaloc")) {
                    startupOptions.manager = standalone;
                    continue;
                }
                String mgrArg = MiscUtils.convertShortNotationToCorbaloc(standalone);
                if (mgrArg != null) {
                    startupOptions.manager = mgrArg;
                    continue;
                }
                startupOptions.project = new File(standalone);
                continue;
            }
            catch (Exception exc) {
                startupOptions = new CommandCenterLogic.StartupOptions();
                log.warning("command line argument(s) invalid, some arguments may be ignored: " + Arrays.asList(args));
                CommandCenter.printUsage(System.err);
            }
        }
        commandCenterLogic = new CommandCenterLogic();
        commandCenterLogic.prepare(startupOptions);
        if (startupOptions.project != null) {
            commandCenterLogic.loadProject(startupOptions.project);
        }
        commandCenterLogic.go();
    }

    private static boolean equalsOneOf(String a, String[] bb) {
        for (int i = 0; i < bb.length; ++i) {
            if (!bb[i].equalsIgnoreCase(a)) continue;
            return true;
        }
        return false;
    }

    private static void printUsage(PrintStream s) {
        String msg = "Usage: (this) [ARGUMENTS] [OPTIONS]\nArguments:\n CORBALOC                                              instantly connect to existing Acs\n HOST:INSTANCE                                         instantly connect to existing Acs\n PROJ                                                  load a project file on startup\nOptions:\n -r | -retrieve | --retrieve PROJ                      load a project file on startup\n -g | -geometry | --geometry WIDTHxHEIGHT+XPOS+YPOS    size and location of window\n -x | -noexit   | --noexit                             don't exit the JVM when quitting\n";
        s.println(msg);
    }

    public static void dbg_printProps(Properties p) {
        CommandCenter.dbg_printProps(p, System.err);
    }

    public static void dbg_printProps(Properties p, String filesuffix) {
        PrintStream s = null;
        try {
            File f = File.createTempFile(filesuffix, ".tmp");
            s = new PrintStream(new FileOutputStream(f));
            System.err.println("CommandCenter.dbg_printProps: writing props to " + f.getAbsolutePath());
        }
        catch (IOException exc) {
            System.err.println("CommandCenter.dbg_printProps: could not open print stream to a tmp file; writing to stderr");
            s = System.err;
        }
        CommandCenter.dbg_printProps(p, s);
        s.close();
    }

    public static void dbg_printProps(Properties p, PrintStream s) {
        Set<Map.Entry<Object, Object>> e1 = p.entrySet();
        Map.Entry[] e2 = e1.toArray(new Map.Entry[e1.size()]);
        Comparator<Map.Entry> c = new Comparator<Map.Entry>(){

            @Override
            public int compare(Map.Entry a, Map.Entry b) {
                return ((String)a.getKey()).compareTo((String)b.getKey());
            }
        };
        Arrays.sort(e2, c);
        s.println("------------ (time now is: " + System.currentTimeMillis() + ")");
        for (int i = 0; i < e2.length; ++i) {
            Map.Entry next = e2[i];
            s.println(next.getKey() + "=" + next.getValue());
        }
        s.println("------------");
        s.flush();
    }
}

