/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.app;

import alma.entity.xmlbinding.acscommandcenterproject.AcsCommandCenterProject;
import alma.entity.xmlbinding.acscommandcenterproject.ContainerT;
import alma.entity.xmlbinding.acscommandcenterproject.ContainersT;
import alma.entity.xmlbinding.acscommandcenterproject.types.ModeType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class ProjectMaker {
    protected String projectCreatorId;

    public ProjectMaker(String projectCreatorId) {
        this.projectCreatorId = projectCreatorId;
    }

    public AcsCommandCenterProject createProject() {
        String acsdata;
        AcsCommandCenterProject ret = new AcsCommandCenterProject();
        String cdbroot = null;
        cdbroot = System.getProperty("ACS.cdbroot");
        if ((cdbroot == null || cdbroot.equals("")) && (acsdata = System.getProperty("ACS.data")) != null) {
            acsdata = acsdata + (acsdata.endsWith("/") ? "" : "/");
            cdbroot = acsdata + "config/defaultCDB";
        }
        if (cdbroot == null || cdbroot.equals("")) {
            cdbroot = "/alma/ACS-8.0/acsdata/config/defaultCDB";
        }
        ret.setMode(ModeType.LOCAL);
        ret.setScriptBase(System.getProperty("ACS.baseport", "9"));
        ret.setServicesLocalJavaRoot(cdbroot);
        ret.setRemoteHost("");
        ret.setToolAgainstManagerHost("");
        ret.setToolAgainstManagerPort("");
        ret.setToolAgainstNameService("");
        ret.setToolAgainstInterfaceRepository("");
        ret.setContainers(new ContainersT());
        ret.getContainers().setAgainstManagerHost("");
        ret.getContainers().setAgainstManagerPort("");
        ret.getContainers().setAgainstCDB("");
        ret.getContainers().setAgainstInterfaceRepository("");
        ret.getContainers().addContainer(this.createContainer());
        ret.setCreator(this.projectCreatorId);
        return ret;
    }

    protected ContainerT createContainer() {
        ContainerT ret = new ContainerT();
        ret.setType("java");
        return ret;
    }

    public void writeProject(AcsCommandCenterProject p, File f) throws IOException, MarshalException, ValidationException {
        p.setRemotePassword("");
        for (int i = 0; i < p.getContainers().getContainerCount(); ++i) {
            p.getContainers().getContainer(i).setRemotePassword(null);
        }
        BufferedWriter w = new BufferedWriter(new FileWriter(f));
        p.marshal((Writer)w);
        w.flush();
        w.close();
    }

    public AcsCommandCenterProject loadProject(File f) throws MarshalException, ValidationException, FileNotFoundException, IOException {
        AcsCommandCenterProject project = this.readProject(f);
        this.sanitizeProject(project);
        return project;
    }

    protected AcsCommandCenterProject readProject(File f) throws FileNotFoundException, MarshalException, ValidationException, IOException {
        BufferedReader r = new BufferedReader(new FileReader(f));
        AcsCommandCenterProject p = AcsCommandCenterProject.unmarshalAcsCommandCenterProject((Reader)r);
        r.close();
        return p;
    }

    protected void sanitizeProject(AcsCommandCenterProject p) {
        boolean sanitized = false;
        if (p.getContainers() == null) {
            p.setContainers(new ContainersT());
            sanitized = true;
        }
        if (p.getMode() == null) {
            p.setMode(ModeType.LOCAL);
            sanitized = true;
        }
        if (!p.hasToolRunAgainstDedicatedSettings()) {
            p.setToolRunAgainstDedicatedSettings(false);
            sanitized = true;
        }
        for (ContainerT c : p.getContainers().getContainer()) {
            if (!c.getType().equals("archive")) continue;
            c.setType("java");
            c.addTypeModifier("archiveContainer");
            sanitized = true;
        }
        if (sanitized) {
            p.setCreator(this.projectCreatorId);
        }
    }
}

