/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.engine;

import alma.acs.commandcenter.engine.DefaultProperties;
import alma.acs.commandcenter.engine.Executor;
import alma.acs.commandcenter.engine.NativeCommand;
import alma.acs.commandcenter.engine.RunModel;
import alma.acs.commandcenter.engine.ToolManager;
import alma.acs.commandcenter.util.PreparedString;
import alma.entity.xmlbinding.acscommandcentertools.Tool;
import com.cosylab.cdb.jdal.Server;
import java.util.StringTokenizer;

public class ExecuteServices {
    protected RunModel runModel;
    protected Server cdbServer;
    public String startLocalJavaPexpect = "ready and waiting ...";
    public PreparedString startLocalJavaArgs = new PreparedString("-n -jacorb -root ? -OAport ?");

    public ExecuteServices(RunModel runModel) {
        this.runModel = runModel;
    }

    public void startLocalJava(NativeCommand.Listener listener) {
        String argLine = this.startLocalJavaArgs.toString(new String[]{this.runModel.getServicesLocalJavaRoot(), this.runModel.getServicesLocalJavaPort()});
        StringTokenizer toky = new StringTokenizer(argLine);
        final String[] args = new String[toky.countTokens()];
        int i = 0;
        while (toky.hasMoreTokens()) {
            args[i] = toky.nextToken();
            ++i;
        }
        DefaultProperties props = new DefaultProperties();
        System.getProperties().remove("ORBInitRef.NameService");
        Executor.localInProc(props, this.startLocalJavaPexpect, listener, new Executor.RunMain(){

            @Override
            public void runMain() throws Exception {
                ExecuteServices.this.cdbServer = new Server();
                ExecuteServices.this.cdbServer.run(args);
            }
        });
    }

    public void stopLocalJava() {
        Executor.local(new Executor.RunMain(){

            @Override
            public void runMain() {
                if (ExecuteServices.this.cdbServer != null) {
                    ExecuteServices.this.cdbServer.shutdown();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
    }

    public void startLocalScript(NativeCommand.Listener listener) throws Throwable {
        Tool t = ToolManager.getBuiltinTool("Services_startLocalScript");
        String command = ToolManager.generateCommand(t, this.runModel);
        Executor.localOutProc(command, true, t.getMaxStartupSeconds() * 1000, t.getExpectedOutput(), listener);
    }

    public void stopLocalScript(NativeCommand.Listener listener) throws Throwable {
        Tool t = ToolManager.getBuiltinTool("Services_stopLocalScript");
        String command = ToolManager.generateCommand(t, this.runModel);
        Executor.localOutProc(command, true, t.getMaxStartupSeconds() * 1000, t.getExpectedOutput(), listener);
    }

    public void startRemote(boolean nativeSSH, NativeCommand.Listener listener) throws Throwable {
        String host = this.runModel.getRemoteHost();
        String username = this.runModel.getRemoteAccount();
        String password = this.runModel.getRemotePassword();
        Tool t = ToolManager.getBuiltinTool("Services_startRemote");
        String command = ToolManager.generateCommand(t, this.runModel);
        Executor.remote(nativeSSH, username, password, command, t.getExpectedOutput(), listener, host);
    }

    public void stopRemote(boolean nativeSSH, NativeCommand.Listener listener) throws Throwable {
        String host = this.runModel.getRemoteHost();
        String username = this.runModel.getRemoteAccount();
        String password = this.runModel.getRemotePassword();
        Tool t = ToolManager.getBuiltinTool("Services_stopRemote");
        String command = ToolManager.generateCommand(t, this.runModel);
        Executor.remote(nativeSSH, username, password, command, t.getExpectedOutput(), listener, host);
    }
}

