/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.gui;

import alma.acs.commandcenter.engine.NativeCommand;
import alma.acs.commandcenter.gui.CommandCenterGui;
import alma.acs.commandcenter.gui.FeedbackArea;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import javax.swing.JFileChooser;
import javax.swing.JTabbedPane;

public class FeedbackTabs
extends JTabbedPane {
    protected CommandCenterGui master;
    protected HashMap<String, NativeCommand.Listener> tabTitle2Listener = new HashMap();
    protected JFileChooser fileChooser;

    public FeedbackTabs(CommandCenterGui master, int orientation) {
        super(orientation);
        this.master = master;
    }

    public NativeCommand.Listener viewTab(String tabTitle) {
        int tabIndex = super.indexOfTab(tabTitle);
        if (tabIndex < 0) {
            FeedbackArea feedbackArea = new FeedbackArea(this.master, this, tabTitle);
            super.addTab(tabTitle, feedbackArea);
            CommandCenterGui commandCenterGui = this.master;
            commandCenterGui.getClass();
            this.tabTitle2Listener.put(tabTitle, commandCenterGui.new CommandCenterGui.WriteToFeedbackAreaTaskListener(feedbackArea));
            tabIndex = super.getTabCount() - 1;
        }
        super.setSelectedIndex(tabIndex);
        return this.tabTitle2Listener.get(tabTitle);
    }

    public void removeTab(String tabTitle) {
        try {
            this.tabTitle2Listener.remove(tabTitle);
            super.remove(super.indexOfTab(tabTitle));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void clearAllTabs() {
        Component[] tabs = super.getComponents();
        for (int i = 0; i < tabs.length; ++i) {
            try {
                ((FeedbackArea)tabs[i]).clear();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTab(FeedbackArea x) {
        int answer;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        if ((answer = this.fileChooser.showSaveDialog(this)) == 0) {
            File f = null;
            OutputStreamWriter fw = null;
            try {
                f = this.fileChooser.getSelectedFile();
                fw = new FileWriter(f);
                fw.write(x.outputArea.getText());
                fw.flush();
            }
            catch (IOException exc) {
                this.master.log.fine("couldn't save log '" + x.surroundingTabTitle + "' to file '" + f + "' due to " + exc);
            }
            finally {
                try {
                    if (fw != null) {
                        fw.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }
}

