/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.meta;

import alma.acs.commandcenter.meta.MaciInfo;
import alma.maciErrType.NoPermissionEx;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;

public interface IMaciSupervisor {
    public static final short MSG_INFORMATION = 20;
    public static final short MSG_ERROR = 0;

    public void start() throws CannotRetrieveManagerException, NoPermissionEx, CorbaTransientException, CorbaNotExistException, UnknownErrorException;

    public void stop();

    public void dismissManager();

    public boolean isConnected();

    public String getManagerLocation();

    public int myMaciHandle() throws NotConnectedToManagerException;

    public MaciInfo getMaciInfo() throws NoPermissionEx, NotConnectedToManagerException, CorbaTransientException, CorbaNotExistException, UnknownErrorException;

    public static class UnknownErrorException
    extends MaciSupervisorException {
        protected UnknownErrorException(RuntimeException exc) {
            super("unknown error", exc);
        }
    }

    public static class CannotRetrieveManagerException
    extends MaciSupervisorException {
        public CannotRetrieveManagerException(String s) {
            super(s);
        }

        protected CannotRetrieveManagerException(String s, Throwable t) {
            super(s, t);
        }
    }

    public static class CorbaNotExistException
    extends MaciSupervisorException {
        protected CorbaNotExistException(OBJECT_NOT_EXIST exc) {
            super("remote object doesn't exist", (Throwable)exc);
        }
    }

    public static class CorbaUnknownException
    extends MaciSupervisorException {
        protected CorbaUnknownException(UNKNOWN exc) {
            super("no such remote object known", (Throwable)exc);
        }
    }

    public static class CorbaNoPermissionException
    extends MaciSupervisorException {
        protected CorbaNoPermissionException(NO_PERMISSION exc) {
            super("remote object refuses communication", (Throwable)exc);
        }
    }

    public static class CorbaTransientException
    extends MaciSupervisorException {
        protected CorbaTransientException(TRANSIENT exc) {
            super("remote object has disappeared", (Throwable)exc);
        }
    }

    public static class NotConnectedToManagerException
    extends MaciSupervisorException {
        protected NotConnectedToManagerException(String s) {
            super(s);
        }
    }

    public static class MaciSupervisorException
    extends Exception {
        protected MaciSupervisorException(String s) {
            super(s);
        }

        protected MaciSupervisorException(String s, Throwable t) {
            super(s, t);
        }
    }
}

