/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.trace;

import alma.acs.commandcenter.trace.Flow;
import alma.acs.commandcenter.trace.FlowListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeNode;

public class DefaultChecklistPanel
extends JPanel
implements FlowListener {
    protected Flow flow;
    protected JTextArea infoF = new JTextArea(4, 30);
    protected String tryText;
    protected Icon tryIcon;
    protected String okText;
    protected Icon okIcon;
    protected String errText;
    protected Icon errIcon;
    Map<String, Stripe> name2stripe = new HashMap<String, Stripe>();

    public DefaultChecklistPanel(Flow flowDefinition) {
        this(flowDefinition, "trying", null, "ok", null, "err", null);
    }

    public DefaultChecklistPanel(Flow flowDefinition, String tryText, Icon tryIcon, String okText, Icon okIcon, String errText, Icon errIcon) {
        this.tryText = tryText;
        this.tryIcon = tryIcon;
        this.okText = okText;
        this.okIcon = okIcon;
        this.errText = errText;
        this.errIcon = errIcon;
        this.setFlow(flowDefinition);
        this.setBorder(new EmptyBorder(1, 0, 1, 0));
        JPanel stripes = new JPanel(new GridLayout(0, 1));
        Enumeration<TreeNode> en = flowDefinition.name2node.get(null).preorderEnumeration();
        en.nextElement();
        Vector<String> vec = new Vector<String>();
        while (en.hasMoreElements()) {
            Flow.Node n = (Flow.Node)en.nextElement();
            Stripe s = this.createStripe(n.getName());
            stripes.add(s);
            this.name2stripe.put(s.name, s);
            StringBuffer buf = new StringBuffer(32);
            for (int i = 0; i < n.getLevel(); ++i) {
                buf.append("   ");
            }
            buf.append(String.valueOf(n.getName()));
            vec.add(buf.toString());
        }
        this.infoF.setEditable(false);
        this.infoF.setLineWrap(true);
        this.setLayout(new BorderLayout());
        this.add((Component)stripes, "North");
        this.add((Component)this.infoF, "Center");
    }

    public void setFlow(Flow newFlow) {
        if (this.flow != null) {
            this.flow.removeListener(this);
        }
        this.flow = newFlow;
        this.flow.addListener(this);
    }

    public Flow getFlow() {
        return this.flow;
    }

    @Override
    public void reset(Flow f, Object info) {
        for (Stripe s : this.name2stripe.values()) {
            s.statusF.setText("");
            s.statusF.setIcon(null);
        }
        this.infoF.setText("");
    }

    @Override
    public void completion(Flow f) {
    }

    @Override
    public void trying(Flow f, String name) {
        Stripe s = this.name2stripe.get(name);
        if (s != null) {
            s.statusF.setText(this.tryText);
            s.statusF.setIcon(this.tryIcon);
        }
    }

    @Override
    public void success(Flow f, String name) {
        Stripe s = this.name2stripe.get(name);
        if (s != null) {
            s.statusF.setText(this.okText);
            s.statusF.setIcon(this.okIcon);
        }
    }

    @Override
    public void failure(Flow f, String name, Object info) {
        Stripe s = this.name2stripe.get(name);
        if (s != null) {
            s.statusF.setText(this.errText);
            s.statusF.setIcon(this.errIcon);
        }
        if (info instanceof Throwable) {
            String text = "";
            Throwable t = (Throwable)info;
            do {
                text = text + t.toString() + "\n";
            } while ((t = t.getCause()) != null);
            info = text;
        }
        this.infoF.setText(String.valueOf(info));
    }

    protected Stripe createStripe(String name) {
        return new Stripe(name);
    }

    protected class Stripe
    extends JPanel {
        protected String name;
        protected JLabel nameF = new JLabel();
        protected JLabel statusF = new JLabel();

        protected Stripe(String name) {
            this.name = name;
            this.nameF.setText(name);
            this.setBorder(new EmptyBorder(0, 5, 1, 10));
            this.setLayout(new BorderLayout());
            this.add((Component)this.nameF, "Center");
            this.add((Component)this.statusF, "East");
        }
    }
}

