/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.util;

import java.util.Map;

public class VariableString {
    protected boolean lenient;
    protected String source;

    public VariableString(String source) {
        this(source, true);
    }

    public VariableString(String source, boolean lenient) {
        this.source = source;
        this.lenient = lenient;
    }

    public String getSource() {
        return this.source;
    }

    public String toString() throws UnresolvableException {
        return this.toString(System.getProperties());
    }

    public String toString(Map<?, Object> map) throws UnresolvableException {
        final Map<?, Object> m = map;
        IResolver res = new IResolver(){

            @Override
            public String resolve(String name) {
                Object value = m.get(name);
                return value instanceof String ? (String)value : null;
            }
        };
        return this.resolveVariables(res, this.source);
    }

    public String toString(IResolver map) throws UnresolvableException {
        return this.resolveVariables(map, this.source);
    }

    protected String resolveVariables(IResolver res, String value) throws UnresolvableException {
        int markerEnd;
        if (value == null) {
            return null;
        }
        int markerStart = value.indexOf("${");
        if (markerStart != -1 && (markerEnd = value.indexOf("}", markerStart)) != -1) {
            String preVarName = value.substring(0, markerStart);
            String embeddedVarName = value.substring(markerStart + 2, markerEnd);
            String postVarName = value.substring(markerEnd + 1);
            String embeddedVarValue = res.resolve(embeddedVarName);
            if (embeddedVarValue == null) {
                if (this.lenient) {
                    embeddedVarValue = "";
                } else {
                    throw new UnresolvableException(embeddedVarName);
                }
            }
            value = preVarName + embeddedVarValue + postVarName;
            return this.resolveVariables(res, value);
        }
        return value;
    }

    public static class UnresolvableException
    extends RuntimeException {
        protected String variableName;

        protected UnresolvableException(String varname) {
            this.variableName = varname;
        }

        public String getVariableName() {
            return this.variableName;
        }
    }

    public static interface IResolver {
        public String resolve(String var1);
    }
}

