/*
 * Decompiled with CFR 0.152.
 */
package alma.tools.entitybuilder;

import alma.tools.entitybuilder.AlmaURIResolver;
import alma.tools.entitybuilder.BindingException;
import alma.tools.entitybuilder.EntitybuilderConfig;
import alma.tools.entitybuilder.XsdFileFinder;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.exolab.castor.builder.FieldInfoFactory;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.net.URIResolver;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;

public class CastorBuilder {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("usage: java " + CastorBuilder.class.getName() + " configFile javaOutputDir [-I schemaIncludeDir]");
            System.exit(1);
        }
        try {
            String configFileConcat = System.getProperty("ACS.schemaconfigfiles");
            CastorBuilder castorBuilder = new CastorBuilder();
            castorBuilder.run0(args, configFileConcat);
        }
        catch (Exception ex) {
            System.err.println("schema compilation failed!");
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public void run0(String[] args, String configFileConcat) throws BindingException, FileNotFoundException {
        File primaryConfigFile = new File(args[0]);
        File schemaDir = primaryConfigFile.getParentFile();
        File javaOutputDir = new File(args[1]);
        ArrayList<String> otherConfigFileNames = new ArrayList<String>();
        if (configFileConcat != null) {
            StringTokenizer includeSchemasConfigFilesTok = new StringTokenizer(configFileConcat, " ");
            while (includeSchemasConfigFilesTok.hasMoreTokens()) {
                String configFileName = includeSchemasConfigFilesTok.nextToken().trim();
                if (configFileName.length() <= 0) continue;
                if (!configFileName.endsWith(".xml")) {
                    configFileName = configFileName + ".xml";
                }
                otherConfigFileNames.add(configFileName);
            }
        }
        ArrayList<File> includeDirs = new ArrayList<File>();
        boolean pendingInclude = false;
        for (int argInd = 2; argInd < args.length; ++argInd) {
            String arg = args[argInd].trim();
            arg = arg.charAt(0) == '\"' ? arg.substring(1) : arg;
            String string = arg = arg.charAt(arg.length() - 1) == '\"' ? arg.substring(0, arg.length() - 1) : arg;
            if (pendingInclude) {
                includeDirs.add(new File(arg));
                pendingInclude = false;
                continue;
            }
            if (!arg.startsWith("-I")) continue;
            if (arg.length() == 2) {
                pendingInclude = true;
                continue;
            }
            includeDirs.add(new File(arg.substring(2)));
            pendingInclude = false;
        }
        this.run(schemaDir, primaryConfigFile, otherConfigFileNames, includeDirs, javaOutputDir);
    }

    public void run(File schemaDir, File primaryConfigFile, List<String> otherConfigFileNames, List<File> includeDirs, File javaOutputDir) throws BindingException, FileNotFoundException {
        if (!primaryConfigFile.exists()) {
            throw new FileNotFoundException("invalid configuration file: " + primaryConfigFile.getAbsolutePath());
        }
        ArrayList<String> allConfigFileNames = new ArrayList<String>();
        allConfigFileNames.add(primaryConfigFile.getName());
        allConfigFileNames.addAll(otherConfigFileNames);
        ArrayList<File> allIncludeDirs = new ArrayList<File>();
        allIncludeDirs.add(schemaDir);
        allIncludeDirs.add(primaryConfigFile.getParentFile());
        allIncludeDirs.addAll(includeDirs);
        if (!javaOutputDir.exists()) {
            System.out.println("will create output directory " + javaOutputDir.getAbsolutePath());
        }
        XsdFileFinder xsdFileFinder = new XsdFileFinder(allIncludeDirs, allConfigFileNames);
        xsdFileFinder.setVerbose(false);
        EntitybuilderConfig ebc = new EntitybuilderConfig();
        ebc.load(primaryConfigFile, xsdFileFinder.getAllXsdConfigFiles());
        AlmaURIResolver uriResolver = new AlmaURIResolver(ebc.getSchemaName2File());
        SchemaUnmarshaller.setDefaultURIResolver((URIResolver)uriResolver);
        FieldInfoFactory fieldInfoFactory = new FieldInfoFactory("arraylist");
        SourceGenerator sgen = new SourceGenerator(fieldInfoFactory);
        String[] allNamespaces = ebc.getAllNamespaces();
        for (int i = 0; i < allNamespaces.length; ++i) {
            String jPackage = ebc.getJPackageForNamespace(allNamespaces[i]);
            sgen.setNamespacePackageMapping(allNamespaces[i], jPackage);
        }
        for (File schemaFile : ebc.getAllSchemaFiles()) {
            String schemaName = schemaFile.getName();
            String jPackage = ebc.getJPackageForSchema(schemaName);
            sgen.setLocationPackageMapping(schemaFile.getAbsolutePath(), jPackage);
        }
        sgen.setDestDir(javaOutputDir.getAbsolutePath());
        sgen.setLineSeparator(System.getProperty("line.separator"));
        sgen.setSuppressNonFatalWarnings(true);
        sgen.setVerbose(false);
        sgen.setDescriptorCreation(true);
        sgen.setCreateMarshalMethods(true);
        sgen.setTestable(false);
        sgen.setEqualsMethod(false);
        sgen.setClassDescFieldNames(false);
        sgen.setPrimitiveWrapper(false);
        List<File> schemaFiles = ebc.getPrimarySchemaFiles();
        for (File schemaFile : schemaFiles) {
            String schemaPackage = ebc.getJPackageForSchema(schemaFile.getName());
            this.generate(sgen, schemaFile, schemaPackage);
        }
        System.out.println("schema compile done!\n");
    }

    private void generate(SourceGenerator sgen, File schemaFile, String packageName) throws FileNotFoundException {
        if (!schemaFile.exists() || !schemaFile.isFile()) {
            throw new FileNotFoundException("unable to open XML schema file " + schemaFile.getAbsolutePath());
        }
        System.out.println("\n-- generating classes for " + schemaFile.getAbsolutePath() + " into " + packageName + " --");
        sgen.generateSource(schemaFile.getAbsolutePath(), packageName);
    }
}

