/*
 * Decompiled with CFR 0.152.
 */
package alma.tools.entitybuilder;

import alma.tools.entitybuilder.BindingException;
import alma.tools.entitybuilder.generated.EntitySchema;
import alma.tools.entitybuilder.generated.EntitybuilderSettings;
import alma.tools.entitybuilder.generated.XmlNamespace2JPackage;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exolab.castor.xml.Unmarshaller;
import org.xml.sax.InputSource;

public class EntitybuilderConfig {
    private EntitybuilderSettings m_entitybuilderSettings;
    private Map<String, String> m_schema2pckMap = new HashMap<String, String>();
    private Map<String, String> m_ns2pckMap = new HashMap<String, String>();
    private Map<String, File> m_schemaName2File = new HashMap<String, File>();

    public void load(File configFile, File[] includeConfigFiles) throws BindingException {
        this.m_entitybuilderSettings = this.parseConfigFile(configFile);
        this.storePckgMappings(this.m_entitybuilderSettings, configFile.getParentFile());
        for (File includeConfigFile : includeConfigFiles) {
            EntitybuilderSettings ebs = this.parseConfigFile(includeConfigFile);
            this.storePckgMappings(ebs, includeConfigFile.getParentFile());
        }
    }

    private void storePckgMappings(EntitybuilderSettings ebs, File schemaBaseDir) {
        for (XmlNamespace2JPackage xmlNamespace2JPackage : ebs.getXmlNamespace2JPackage()) {
            String namespace = xmlNamespace2JPackage.getXmlNamespace();
            String jPackage = xmlNamespace2JPackage.getJPackage();
            this.m_ns2pckMap.put(namespace, jPackage);
        }
        for (Serializable serializable : ebs.getEntitySchema()) {
            String schemaName = ((EntitySchema)serializable).getSchemaName();
            String namespace = ((EntitySchema)serializable).getXmlNamespace();
            String jPackage = this.m_ns2pckMap.get(namespace);
            this.m_schema2pckMap.put(schemaName, jPackage);
            String relPath = ((EntitySchema)serializable).getRelativePathSchemafile();
            relPath = relPath.trim().length() == 0 || relPath.equals(".") ? File.separator : File.separator + relPath + File.separator;
            String absPathName = schemaBaseDir.getAbsolutePath() + relPath + ((EntitySchema)serializable).getSchemaName();
            File schemaFile = new File(absPathName);
            if (schemaFile.exists()) {
                this.m_schemaName2File.put(schemaName, schemaFile);
                continue;
            }
            System.err.println("specified schema file '" + absPathName + "' does not exist; will be ignored.");
        }
    }

    public String[] getAllNamespaces() {
        return this.m_ns2pckMap.keySet().toArray(new String[1]);
    }

    public String getJPackageForNamespace(String ns) {
        String jPackage = this.m_ns2pckMap.get(ns);
        return jPackage;
    }

    public String[] getAllSchemaNames() {
        return this.m_schema2pckMap.keySet().toArray(new String[1]);
    }

    public String getJPackageForSchema(String schemaName) {
        String jPackage = this.m_schema2pckMap.get(schemaName);
        return jPackage;
    }

    public List<File> getPrimarySchemaFiles() throws BindingException {
        ArrayList<File> schemaList = new ArrayList<File>();
        for (EntitySchema schema : this.m_entitybuilderSettings.getEntitySchema()) {
            File schemaFile = this.m_schemaName2File.get(schema.getSchemaName());
            if (schemaFile != null) {
                schemaList.add(schemaFile);
                continue;
            }
            String msg = "specified schema file " + schema.getSchemaName() + " does not exist.";
            System.err.println(msg + " Will be ignored.");
        }
        return schemaList;
    }

    public List<File> getAllSchemaFiles() {
        return new ArrayList<File>(this.m_schemaName2File.values());
    }

    public Map<String, File> getSchemaName2File() {
        return Collections.unmodifiableMap(this.m_schemaName2File);
    }

    private EntitybuilderSettings parseConfigFile(File configFile) throws BindingException {
        EntitybuilderSettings ebs = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(configFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (is == null) {
            throw new BindingException("xml config file '" + configFile.getAbsolutePath() + "' not found.");
        }
        try {
            ebs = (EntitybuilderSettings)Unmarshaller.unmarshal(EntitybuilderSettings.class, (InputSource)new InputSource(is));
        }
        catch (Exception e) {
            String msg = "parsing of schema config file failed. ";
            throw new BindingException(msg, e);
        }
        return ebs;
    }
}

